/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.attachments.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.zts.hussar.attachments.dao.AttachmentMapper;
import com.zts.hussar.attachments.entity.AttachmentDesign;
import com.zts.hussar.attachments.entity.AttachmentDesignDTO;
import com.zts.hussar.attachments.entity.AttachmentDesignVO;
import com.zts.hussar.attachments.entity.ProcInfo;
import com.zts.hussar.attachments.entity.ProcInfoVO;
import com.zts.hussar.attachments.service.AttachmentService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.RepositoryService;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="attachments.AttachmentServiceImpl")
@HussarDs(value="master")
public class AttachmentServiceImpl
implements AttachmentService {
    @Resource
    private AttachmentMapper attachmentMapper;
    @Lazy
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    @Override
    @DSTransactional
    public ApiResponse<String> add(AttachmentDesignVO attachmentDesignVO) {
        for (AttachmentDesign attachmentDesign : attachmentDesignVO.getData()) {
            this.attachmentMapper.insertAttDesign(attachmentDesign);
        }
        return ApiResponse.success((String)"\u65b0\u589e\u9644\u4ef6\u5206\u7ec4\u4fe1\u606f\u6210\u529f");
    }

    @Override
    @DSTransactional
    public ApiResponse<String> alter(AttachmentDesignVO attachmentDesignVO) {
        for (AttachmentDesign attachmentDesign : attachmentDesignVO.getData()) {
            this.attachmentMapper.alterAttDesign(attachmentDesign);
        }
        return ApiResponse.success((String)"\u66f4\u6539\u9644\u4ef6\u5206\u7ec4\u4fe1\u606f\u6210\u529f");
    }

    @Override
    @DSTransactional
    public ApiResponse<String> del(AttachmentDesign attachmentDesign) {
        this.attachmentMapper.delAttDesign(attachmentDesign);
        return ApiResponse.success((String)"\u5220\u9664\u9644\u4ef6\u5206\u7ec4\u4fe1\u606f\u6210\u529f");
    }

    @Override
    @DSTransactional
    public AttachmentDesignVO getAttachmentByProcDefId(String procDefId) {
        AttachmentDesignVO attachmentDesignVO = new AttachmentDesignVO();
        List<AttachmentDesign> attachmentDesigns = this.attachmentMapper.getAttDesignByProcDefId(procDefId);
        attachmentDesignVO.setData(attachmentDesigns);
        attachmentDesignVO.setCode(200);
        if (attachmentDesigns.isEmpty()) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
            Process process = bpmnModel.getMainProcess();
            Collection elements = process.getFlowElements();
            List<Map<String, String>> procList = this.attachmentMapper.getProcInfo(procDefId);
            for (Map<String, String> map : procList) {
                for (FlowElement element : elements) {
                    if (!StringUtil.isNotEmpty((Object)element.getName())) continue;
                    if (element instanceof SubProcess) {
                        SubProcess subProcess = (SubProcess)element;
                        if (subProcess.getFlowElements().isEmpty()) continue;
                        for (FlowElement subFlowElement : subProcess.getFlowElements()) {
                            if (!StringUtil.isNotEmpty((Object)subFlowElement.getName())) continue;
                            AttachmentDesign attachmentDesign = new AttachmentDesign();
                            attachmentDesign.setProcDefId(map.get("id"));
                            attachmentDesign.setProcKey(map.get("procDefKey"));
                            attachmentDesign.setProcName(map.get("procName"));
                            attachmentDesign.setNodeId(subFlowElement.getId());
                            attachmentDesign.setNodeName(subFlowElement.getName());
                            attachmentDesign.setAttTypeCode("\u672a\u77e5");
                            attachmentDesign.setAttName("\u672a\u77e5");
                            attachmentDesign.setCanDelete(0);
                            attachmentDesign.setCanDownload(1);
                            attachmentDesign.setCanShow(1);
                            attachmentDesign.setCanUpload(0);
                            attachmentDesign.setCode("0");
                            attachmentDesigns.add(attachmentDesign);
                        }
                        continue;
                    }
                    AttachmentDesign attachmentDesign = new AttachmentDesign();
                    attachmentDesign.setProcDefId(map.get("id"));
                    attachmentDesign.setProcKey(map.get("procDefKey"));
                    attachmentDesign.setProcName(map.get("procName"));
                    attachmentDesign.setNodeId(element.getId());
                    attachmentDesign.setNodeName(element.getName());
                    attachmentDesign.setAttTypeCode("\u672a\u77e5");
                    attachmentDesign.setAttName("\u672a\u77e5");
                    attachmentDesign.setCanDelete(0);
                    attachmentDesign.setCanDownload(1);
                    attachmentDesign.setCanShow(1);
                    attachmentDesign.setCanUpload(0);
                    attachmentDesign.setCode("0");
                    attachmentDesigns.add(attachmentDesign);
                }
            }
            attachmentDesignVO.setData(attachmentDesigns);
            attachmentDesignVO.setCode(200);
        }
        return attachmentDesignVO;
    }

    @Override
    @DSTransactional
    public AttachmentDesign getAttachment(AttachmentDesignDTO attachmentDesignDto) {
        String attDesign = this.sysBaseConfigService.getSysBaseConfig("att_design").getConfigValue();
        AttachmentDesign attachmentDesign = new AttachmentDesign();
        if ("1".equals(attDesign) || StringUtils.isEmpty((Object)attachmentDesignDto.getTaskId())) {
            if (!StringUtils.isEmpty((Object)attachmentDesignDto.getDoneTag())) {
                if ("1".equals(attachmentDesignDto.getDoneTag())) {
                    attachmentDesign.setTag("\u5df2\u529e\u4efb\u52a1");
                } else if ("3".equals(attachmentDesignDto.getDoneTag())) {
                    attachmentDesign.setTag("\u6284\u9001\u4efb\u52a1");
                }
                attachmentDesign.setCanDelete(0);
                attachmentDesign.setCanDownload(1);
                attachmentDesign.setCanShow(1);
                attachmentDesign.setCanUpload(0);
                attachmentDesign.setCode("0");
                return attachmentDesign;
            }
            attachmentDesign.setTag("\u4e0d\u63a7\u5236\u9644\u4ef6\u6743\u9650");
            attachmentDesign.setCanDelete(1);
            attachmentDesign.setCanDownload(1);
            attachmentDesign.setCanShow(1);
            attachmentDesign.setCanUpload(1);
            attachmentDesign.setCode("0");
            return attachmentDesign;
        }
        List<Map<String, String>> procInstList = this.attachmentMapper.getTaskInst(attachmentDesignDto.getTaskId());
        if (procInstList.isEmpty()) {
            attachmentDesign.setTag("\u5df2\u529e\u4efb\u52a1");
            attachmentDesign.setCanDelete(0);
            attachmentDesign.setCanDownload(1);
            attachmentDesign.setCanShow(1);
            attachmentDesign.setCanUpload(0);
            attachmentDesign.setCode("0");
            return attachmentDesign;
        }
        Map<String, String> procInstInfo = procInstList.get(0);
        List<AttachmentDesign> attachmentDesignList = this.attachmentMapper.getAttDesign(procInstInfo.get("procDefId"), procInstInfo.get("taskDefKey"), attachmentDesignDto.getAttTypeCode());
        if (attachmentDesignList.isEmpty()) {
            attachmentDesign.setTag("\u5f85\u529e\u4efb\u52a1\u672a\u6307\u5b9a");
            attachmentDesign.setCanDelete(0);
            attachmentDesign.setCanDownload(1);
            attachmentDesign.setCanShow(1);
            attachmentDesign.setCanUpload(0);
            attachmentDesign.setCode("0");
            return attachmentDesign;
        }
        attachmentDesign = attachmentDesignList.get(0);
        attachmentDesign.setTag("\u5f85\u529e\u4efb\u52a1");
        attachmentDesign.setCode("1");
        return attachmentDesign;
    }

    @Override
    public ProcInfoVO getProcList(String procKey) {
        ProcInfoVO procInfoVO = new ProcInfoVO();
        List<ProcInfo> procInfos = this.attachmentMapper.getProcHistoryInfo(procKey);
        procInfoVO.setCode(200);
        procInfoVO.setData(procInfos);
        if (procInfos.size() == 0) {
            procInfoVO.setCode(-1);
        }
        return procInfoVO;
    }

    @Override
    public ProcInfoVO getModel() {
        ProcInfoVO procInfoVO = new ProcInfoVO();
        List<ProcInfo> procInfos = this.attachmentMapper.getModel();
        procInfoVO.setCode(200);
        procInfoVO.setData(procInfos);
        if (procInfos.size() == 0) {
            procInfoVO.setCode(-1);
        }
        return procInfoVO;
    }
}

