/*
 * Decompiled with CFR 0.152.
 */
package com.zts.hussar.attachments.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.zts.hussar.attachments.entity.AttachmentDesign;
import com.zts.hussar.attachments.entity.AttachmentDesignDTO;
import com.zts.hussar.attachments.entity.AttachmentDesignVO;
import com.zts.hussar.attachments.entity.ProcInfoVO;
import com.zts.hussar.attachments.service.AttachmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="attachments.AttachmentController")
@AuditLog(moduleName="attachments")
@RequestMapping(value={"/attachments"})
public class AttachmentController {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentController.class);
    @Autowired
    private AttachmentService attachmentService;

    @AuditLog(moduleName="add", eventDesc="\u9644\u4ef6\u5e03\u5c40", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/add"})
    public ApiResponse<String> add(@RequestBody AttachmentDesignVO attachmentDesignVO) {
        return this.attachmentService.add(attachmentDesignVO);
    }

    @AuditLog(moduleName="model", eventDesc="\u9644\u4ef6\u5e03\u5c40", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/model"})
    public ProcInfoVO getModel() {
        return this.attachmentService.getModel();
    }

    @AuditLog(moduleName="procList", eventDesc="\u9644\u4ef6\u5e03\u5c40", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/procList"})
    public ProcInfoVO getProcList(@RequestBody String procKey) {
        return this.attachmentService.getProcList(procKey);
    }

    @AuditLog(moduleName="alter", eventDesc="\u9644\u4ef6\u5e03\u5c40", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/alter"})
    public ApiResponse<String> alter(@RequestBody AttachmentDesignVO attachmentDesignVO) {
        return this.attachmentService.alter(attachmentDesignVO);
    }

    @AuditLog(moduleName="del", eventDesc="\u9644\u4ef6\u5e03\u5c40", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/del"})
    public ApiResponse<String> del(@RequestBody AttachmentDesign attachmentDesign) {
        return this.attachmentService.del(attachmentDesign);
    }

    @AuditLog(moduleName="attachmentByProcDefId", eventDesc="\u9644\u4ef6\u5e03\u5c40", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/attachmentByProcDefId"})
    public AttachmentDesignVO getAttachmentByProcDefId(@RequestBody String procDefKey) {
        return this.attachmentService.getAttachmentByProcDefId(procDefKey);
    }

    @AuditLog(moduleName="attachment", eventDesc="\u9644\u4ef6\u5e03\u5c40", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/attachment"})
    public AttachmentDesign getAttachment(@RequestBody AttachmentDesignDTO attachmentDesignDto) {
        return this.attachmentService.getAttachment(attachmentDesignDto);
    }
}

