/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workstation.config.dao.SysAdIgnoreShowMapper;
import com.jxdinfo.hussar.workstation.config.dao.SysBannerAdvertisementMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysBannerAdvertisementDto;
import com.jxdinfo.hussar.workstation.config.enums.WorkStationConfigTipEnum;
import com.jxdinfo.hussar.workstation.config.model.SysAdIgnoreShow;
import com.jxdinfo.hussar.workstation.config.model.SysBannerAdvertisement;
import com.jxdinfo.hussar.workstation.config.service.ISysBannerAdvertisementService;
import com.jxdinfo.hussar.workstation.config.utils.AdvertisementUtils;
import com.jxdinfo.hussar.workstation.config.vo.SysBannerAdvertisementVo;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@HussarTransactional
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysBannerAdvertisementServiceImpl")
public class SysBannerAdvertisementServiceImpl
extends HussarServiceImpl<SysBannerAdvertisementMapper, SysBannerAdvertisement>
implements ISysBannerAdvertisementService {
    @Resource
    private SysBannerAdvertisementMapper sysBannerAdvertisementMapper;
    @Resource
    private SysAdIgnoreShowMapper sysAdIgnoreShowMapper;

    public ApiResponse<IPage<SysBannerAdvertisementVo>> listBanners(SysBannerAdvertisementDto dto) {
        if (dto.getCurrent() == 0L || dto.getSize() == 0L) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_PAGE_ERROR.getMessage()));
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBannerAdvertisement::getAdStatus, (Object)"0");
        wrapper.isNotNull(SysBannerAdvertisement::getAdDueTime);
        SysBannerAdvertisement sysBannerAdvertisement = (SysBannerAdvertisement)this.getOne((Wrapper)wrapper, false);
        if (sysBannerAdvertisement != null && sysBannerAdvertisement.getAdDueTime().compareTo(LocalDateTime.now()) <= 0) {
            sysBannerAdvertisement.setAdStatus("1");
            this.updateById(sysBannerAdvertisement);
        }
        dto.setCreateEndTime(AdvertisementUtils.dealLe(dto.getCreateEndTime()));
        dto.setAdDueEndTime(AdvertisementUtils.dealLe(dto.getAdDueEndTime()));
        Page page = new Page(dto.getCurrent(), dto.getSize());
        dto.setAdTitle(dto.getAdTitle().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        IPage<SysBannerAdvertisementVo> sysBannerAdvertisementVoIPage = this.sysBannerAdvertisementMapper.listBanners(page, dto);
        return ApiResponse.success(sysBannerAdvertisementVoIPage);
    }

    public ApiResponse<?> insertOrUpdate(SysBannerAdvertisementDto dto) {
        this.checkField(dto);
        if (null == dto.getId()) {
            dto.setCreator(BaseSecurityUtil.getUser().getId());
            dto.setCreateTime(LocalDateTime.now());
            dto.setLastEditor(BaseSecurityUtil.getUser().getId());
            dto.setLastTime(LocalDateTime.now());
        } else {
            dto.setLastEditor(BaseSecurityUtil.getUser().getId());
            dto.setLastTime(LocalDateTime.now());
        }
        if (null != dto.getUsingDataId()) {
            SysBannerAdvertisement sysBannerAdvertisement = (SysBannerAdvertisement)this.getById(dto.getUsingDataId());
            sysBannerAdvertisement.setAdStatus("1");
            this.updateById(sysBannerAdvertisement);
        }
        this.saveOrUpdate((SysBannerAdvertisement)dto);
        return ApiResponse.success();
    }

    public ApiResponse<?> deleteBanner(SysBannerAdvertisementDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_DELETE_BANNER_ID_EMPTY.getMessage()));
        }
        String[] ids = dto.getIds().split(",");
        List<Long> longList = AdvertisementUtils.stringByteToList(ids);
        this.removeByIds(longList);
        return ApiResponse.success();
    }

    public ApiResponse<?> stopOrStart(SysBannerAdvertisementDto dto) {
        SysBannerAdvertisement sysBannerAdvertisement;
        if (null == dto.getId()) {
            throw new BaseException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_DTO_ID_EMPTY.getMessage()));
        }
        if ("1".equals(dto.getAdStatus())) {
            SysBannerAdvertisement sysBannerAdvertisement2;
            String checkResult = AdvertisementUtils.checkAdDueTime(dto.getAdDueTime());
            if ("1".equals(checkResult)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_BANNER_EXPIRE.getMessage()));
            }
            if (null != dto.getUsingDataId() && null != (sysBannerAdvertisement2 = (SysBannerAdvertisement)this.getById(dto.getUsingDataId()))) {
                sysBannerAdvertisement2.setAdStatus("1");
                this.updateById(sysBannerAdvertisement2);
            }
        }
        if (null != (sysBannerAdvertisement = (SysBannerAdvertisement)this.getById(dto.getId()))) {
            if ("0".equals(dto.getAdStatus())) {
                sysBannerAdvertisement.setAdStatus("1");
            } else {
                sysBannerAdvertisement.setAdStatus("0");
            }
            this.updateById(sysBannerAdvertisement);
        }
        return ApiResponse.success();
    }

    public ApiResponse<SysBannerAdvertisement> getBannerData() {
        Long nowPeople = BaseSecurityUtil.getUser().getId();
        List<SysAdIgnoreShow> sysAdIgnoreShowList = this.sysAdIgnoreShowMapper.listIgnoreData(nowPeople);
        if (sysAdIgnoreShowList.size() > 0) {
            return ApiResponse.success();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBannerAdvertisement::getAdStatus, (Object)"0");
        SysBannerAdvertisement sysBannerAdvertisement = (SysBannerAdvertisement)this.getOne((Wrapper)wrapper, false);
        if (sysBannerAdvertisement != null) {
            if (null != sysBannerAdvertisement.getAdDueTime()) {
                if (sysBannerAdvertisement.getAdDueTime().compareTo(LocalDateTime.now()) > 0) {
                    return ApiResponse.success((Object)sysBannerAdvertisement);
                }
            } else {
                return ApiResponse.success((Object)sysBannerAdvertisement);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<SysBannerAdvertisement> getUsedBannerByAdStatus(Long id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBannerAdvertisement::getAdStatus, (Object)"0");
        if (null != id) {
            wrapper.ne(SysBannerAdvertisement::getId, (Object)id);
        }
        return ApiResponse.success((Object)this.getOne((Wrapper)wrapper, false));
    }

    public ApiResponse<Boolean> getBannerByAdTitle(SysBannerAdvertisementDto dto) {
        SysBannerAdvertisement sysBannerAdvertisement;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBannerAdvertisement::getAdTitle, (Object)dto.getAdTitle());
        if (null != dto.getId()) {
            wrapper.ne(SysBannerAdvertisement::getId, (Object)dto.getId());
        }
        if ((sysBannerAdvertisement = (SysBannerAdvertisement)this.getOne((Wrapper)wrapper, false)) != null) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<?> insertOneIgnoreData(SysBannerAdvertisementDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_AD_ID_EMPTY.getMessage()));
        }
        SysAdIgnoreShow adIgnoreShow = new SysAdIgnoreShow();
        adIgnoreShow.setAdId(Long.valueOf(dto.getIds()));
        adIgnoreShow.setCreator(BaseSecurityUtil.getUser().getId());
        adIgnoreShow.setCreateTime(LocalDateTime.now());
        adIgnoreShow.setLastEditor(BaseSecurityUtil.getUser().getId());
        adIgnoreShow.setLastTime(LocalDateTime.now());
        this.sysAdIgnoreShowMapper.insert(adIgnoreShow);
        return ApiResponse.success();
    }

    public void checkField(SysBannerAdvertisementDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getAdTitle())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_AD_TITLE_EMPTY.getMessage()));
        }
        if (HussarUtils.isBlank((CharSequence)dto.getAdOutside())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_AD_OUTSIDE_EMPTY.getMessage()));
        }
        if (HussarUtils.isBlank((CharSequence)dto.getAdStatus())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_AD_STATUS_EMPTY.getMessage()));
        }
        if (HussarUtils.isNotBlank((CharSequence)dto.getAdLink())) {
            String url_agreement = dto.getAdLink().split(":")[0];
            if (!"http".equalsIgnoreCase(url_agreement) && !"https".equalsIgnoreCase(url_agreement)) {
                throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_AD_URL_FORMAT_ERROR.getMessage()));
            }
        } else {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_AD_URL_EMPTY_ERROR.getMessage()));
        }
        if (null == dto.getPictureId()) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_PIC_ID_EMPTY.getMessage()));
        }
    }

    public boolean updateById(SysBannerAdvertisement advertisement) {
        return this.sysBannerAdvertisementMapper.updateAdvertisement(advertisement) > 1;
    }

    public boolean saveOrUpdate(SysBannerAdvertisement advertisement) {
        boolean res = HussarUtils.isNotEmpty((Object)advertisement.getId()) ? this.updateById(advertisement) : this.save((BaseEntity)advertisement);
        return res;
    }
}

