/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workstation.config.dao.SysAdBrowsingHistoryMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysAdBrowsingHistoryDto;
import com.jxdinfo.hussar.workstation.config.enums.WorkStationConfigTipEnum;
import com.jxdinfo.hussar.workstation.config.model.SysAdBrowsingHistory;
import com.jxdinfo.hussar.workstation.config.service.ISysAdBrowsingHistoryService;
import com.jxdinfo.hussar.workstation.config.utils.AdvertisementUtils;
import com.jxdinfo.hussar.workstation.config.vo.AdBrowsEchartsVo;
import com.jxdinfo.hussar.workstation.config.vo.SysAdBrowsingHistoryVo;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@HussarTransactional
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysAdBrowsingHistoryServiceImpl")
public class SysAdBrowsingHistoryServiceImpl
extends HussarServiceImpl<SysAdBrowsingHistoryMapper, SysAdBrowsingHistory>
implements ISysAdBrowsingHistoryService {
    @Resource
    private SysAdBrowsingHistoryMapper sysAdBrowsingHistoryMapper;
    @Autowired
    private IHussarBaseUserBoService hussarBaseUserBoService;

    public ApiResponse<?> insertAdBrowsingHistory(SysAdBrowsingHistoryDto dto) {
        this.checkField(dto);
        SecurityUser user = BaseSecurityUtil.getUser();
        dto.setBrowseDay(LocalDateTime.now());
        dto.setBrowsers(user.getId());
        dto.setBrowseTime(LocalDateTime.now());
        dto.setBrowsersDept(user.getDeptId());
        dto.setCreateTime(LocalDateTime.now());
        dto.setCreator(user.getId());
        this.save((BaseEntity)dto);
        return ApiResponse.success();
    }

    public ApiResponse<List<AdBrowsEchartsVo>> listBannerEcharts() {
        Date previousDate = this.getPreviousDate();
        List<SysAdBrowsingHistory> historyList = this.sysAdBrowsingHistoryMapper.listBannerEcharts(previousDate, LocalDateTime.now());
        List dateList = this.getDateList();
        ArrayList<AdBrowsEchartsVo> adBrowsEchartsVoList = new ArrayList<AdBrowsEchartsVo>();
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (String date : dateList) {
            AdBrowsEchartsVo adBrowsEchartsVo = new AdBrowsEchartsVo();
            adBrowsEchartsVo.setxData(date);
            int i = 0;
            for (SysAdBrowsingHistory history : historyList) {
                String xdDate = sdf.format(history.getBrowseTime());
                if (!date.equals(xdDate)) continue;
                ++i;
            }
            adBrowsEchartsVo.setvCount(Integer.valueOf(i));
            adBrowsEchartsVoList.add(adBrowsEchartsVo);
        }
        return ApiResponse.success(adBrowsEchartsVoList);
    }

    public ApiResponse<List<AdBrowsEchartsVo>> listAdvertisementEcharts() {
        Date previousDate = this.getPreviousDate();
        List<AdBrowsEchartsVo> advertisementEchartsList = this.sysAdBrowsingHistoryMapper.listAdvertisementEcharts(previousDate, LocalDateTime.now());
        return ApiResponse.success(advertisementEchartsList);
    }

    public ApiResponse<IPage<SysAdBrowsingHistoryVo>> listAllBrows(SysAdBrowsingHistoryDto dto) {
        if (dto.getCurrent() == 0L || dto.getSize() == 0L) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_PAGE_ERROR.getMessage()));
        }
        dto.setBrowseEndTime(AdvertisementUtils.dealLe(dto.getBrowseEndTime()));
        Page page = new Page(dto.getCurrent(), dto.getSize());
        dto.setAdTitle(dto.getAdTitle().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        IPage<SysAdBrowsingHistoryVo> allBrowsList = this.sysAdBrowsingHistoryMapper.listAllBrows(page, dto);
        if (allBrowsList.getRecords().size() > 0) {
            List userIdList = allBrowsList.getRecords().stream().map(SysAdBrowsingHistory::getBrowsers).collect(Collectors.toList());
            Map userMap = this.hussarBaseUserBoService.getUserInfo(userIdList);
            for (SysAdBrowsingHistoryVo item : allBrowsList.getRecords()) {
                SysUsers sysUsers = (SysUsers)userMap.get(item.getBrowsers());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                item.setBrowsersName(sysUsers.getUserName());
            }
        }
        return ApiResponse.success(allBrowsList);
    }

    public void checkField(SysAdBrowsingHistoryDto dto) {
        Object msg = null;
        if (HussarUtils.isBlank((CharSequence)dto.getAdType())) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_AD_TYPE_EMPTY.getMessage()));
        }
        if (null == dto.getBusinessId()) {
            throw new HussarException(TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_BIZ_ID_EMPTY.getMessage()));
        }
    }

    private Date getPreviousDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(7, -7);
        Date previousDate = cal.getTime();
        return previousDate;
    }

    private List getDateList() {
        ArrayList<String> dateList = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.add(7, -6);
        dateList.add(sdf.format(cal.getTime()));
        cal.add(7, 1);
        dateList.add(sdf.format(cal.getTime()));
        cal.add(7, 1);
        dateList.add(sdf.format(cal.getTime()));
        cal.add(7, 1);
        dateList.add(sdf.format(cal.getTime()));
        cal.add(7, 1);
        dateList.add(sdf.format(cal.getTime()));
        cal.add(7, 1);
        dateList.add(sdf.format(cal.getTime()));
        cal.add(7, 1);
        dateList.add(sdf.format(cal.getTime()));
        return dateList;
    }
}

