/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.news.syseimnews.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.constant.enums.HussarWebConstantsEnum;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.util.CheckUploadFileUtils;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.dao.SysEimNewsMapper;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.dto.SysEimNewsDatasetDto;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.model.SysEimNews;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.model.SysEimNewsFile;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.model.SysEimNewsMaster;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.service.SysEimNewsFileService;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.service.SysEimNewsMasterService;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.service.SysEimNewsService;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.util.FfmpegUtil;
import com.jxdinfo.hussar.workstation.config.news.syseimnews.vo.SysEimNewsPageVo;
import com.jxdinfo.hussar.workstation.config.news.syseimnewsread.model.SysEimNewsRead;
import com.jxdinfo.hussar.workstation.config.news.syseimnewsread.service.SysEimNewsReadService;
import it.sauronsoftware.jave.Encoder;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="news.syseimnews.SysEimNewsServiceImpl")
@HussarTokenDs
public class SysEimNewsServiceImpl
implements SysEimNewsService {
    private static final Logger logger = LoggerFactory.getLogger(SysEimNewsServiceImpl.class);
    private static final String RETURN_CODE = "0";
    public static final Encoder ENCODER = new Encoder();
    @Autowired
    private SysEimNewsFileService sysEimNewsFileService;
    @Autowired
    private SysEimNewsMapper sysEimNewsMapper;
    @Autowired
    private SysEimNewsMasterService sysEimNewsMasterService;
    @Autowired
    private SysEimNewsReadService sysEimNewsReadService;
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private OssProperties ossProperties;
    @Resource
    private HussarConfig hussarConfig;

    public ApiResponse<SysEimNewsPageVo> hussarQueryPage(Page<SysEimNews> page) {
        try {
            Page pager = new Page(page.getCurrent(), page.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            String[] orderParameter = new String[1];
            if (page.orders() != null) {
                for (OrderItem orderItem : page.orders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                        continue;
                    }
                    orderParameter[0] = orderItem.getColumn() + ",desc;";
                }
            }
            parameterMap.put("orderRule", orderParameter);
            SysEimNewsPageVo sysEimNewsPageVO = new SysEimNewsPageVo();
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new SysEimNews(), parameterMap);
            List<SysEimNews> list = this.sysEimNewsMapper.hussarQueryPage((Page<SysEimNews>)pager, (QueryWrapper<SysEimNews>)queryWrapper);
            sysEimNewsPageVO.setData(list);
            sysEimNewsPageVO.setCount(Long.valueOf(pager.getTotal()));
            sysEimNewsPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)sysEimNewsPageVO);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_TABLE_QUERY_ERROR.getMessage()));
        }
    }

    public ApiResponse<SysEimNewsPageVo> hussarQueryPage_order_custom(Page<SysEimNews> page) {
        try {
            Page pager = new Page(page.getCurrent(), page.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            String[] orderParameter = new String[1];
            if (page.orders() != null) {
                for (OrderItem orderItem : page.orders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                        continue;
                    }
                    orderParameter[0] = orderItem.getColumn() + ",desc;";
                }
            }
            parameterMap.put("orderRule", orderParameter);
            SysEimNewsPageVo sysEimNewsPageVO = new SysEimNewsPageVo();
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new SysEimNews(), parameterMap);
            List<SysEimNews> list = this.sysEimNewsMapper.hussarQueryPage_order_custom((Page<SysEimNews>)pager, (QueryWrapper<SysEimNews>)queryWrapper);
            sysEimNewsPageVO.setData(list);
            sysEimNewsPageVO.setCount(Long.valueOf(pager.getTotal()));
            sysEimNewsPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)sysEimNewsPageVO);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_TABLE_QUERY_ERROR.getMessage()));
        }
    }

    public ApiResponse<SysEimNewsPageVo> hussarQuerysysEimNewsCondition_1Page(SysEimNewsDatasetDto syseimnewsdataset1) {
        try {
            SysEimNewsPageVo sysEimNewsPageVO = new SysEimNewsPageVo();
            Page pager = new Page((long)syseimnewsdataset1.getCurrent(), (long)syseimnewsdataset1.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            String[] orderParameter = new String[1];
            if (syseimnewsdataset1.getOrders() != null) {
                for (OrderItem orderItem : syseimnewsdataset1.getOrders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                        continue;
                    }
                    orderParameter[0] = orderItem.getColumn() + ",desc;";
                }
            }
            parameterMap.put("orderRule", orderParameter);
            syseimnewsdataset1.setSysEimNewsnewsTitleFullLike(syseimnewsdataset1.getSysEimNewsnewsTitleFullLike().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new SysEimNews(), parameterMap);
            List<SysEimNews> list = this.sysEimNewsMapper.hussarQuerysysEimNewsCondition_1Page((Page<SysEimNews>)pager, syseimnewsdataset1, (QueryWrapper<SysEimNews>)queryWrapper);
            sysEimNewsPageVO.setData(list);
            sysEimNewsPageVO.setCount(Long.valueOf(pager.getTotal()));
            sysEimNewsPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)sysEimNewsPageVO);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_TABLE_QUERY_ERROR.getMessage()));
        }
    }

    public ApiResponse<SysEimNewsPageVo> hussarQuerysysEimNewsCondition_1Page_order_custom(SysEimNewsDatasetDto syseimnewsdataset1) {
        try {
            SysEimNewsPageVo sysEimNewsPageVO = new SysEimNewsPageVo();
            Page pager = new Page((long)syseimnewsdataset1.getCurrent(), (long)syseimnewsdataset1.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            String[] orderParameter = new String[1];
            if (syseimnewsdataset1.getOrders() != null) {
                for (OrderItem orderItem : syseimnewsdataset1.getOrders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                        continue;
                    }
                    orderParameter[0] = orderItem.getColumn() + ",desc;";
                }
            }
            parameterMap.put("orderRule", orderParameter);
            syseimnewsdataset1.setSysEimNewsnewsTitleFullLike(syseimnewsdataset1.getSysEimNewsnewsTitleFullLike().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new SysEimNews(), parameterMap);
            List<SysEimNews> list = this.sysEimNewsMapper.hussarQuerysysEimNewsCondition_1Page_order_custom((Page<SysEimNews>)pager, syseimnewsdataset1, (QueryWrapper<SysEimNews>)queryWrapper);
            sysEimNewsPageVO.setData(list);
            sysEimNewsPageVO.setCount(Long.valueOf(pager.getTotal()));
            sysEimNewsPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)sysEimNewsPageVO);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_TABLE_QUERY_ERROR.getMessage()));
        }
    }

    public ApiResponse<SysEimNewsPageVo> hussarQuerysysEimNewsCondition_1sysEimNewsSort_1Page(SysEimNewsDatasetDto syseimnewsdataset1) {
        try {
            if (!BaseSecurityUtil.getUser().isSuperAdmin()) {
                syseimnewsdataset1.setCreator(BaseSecurityUtil.getUser().getId());
            }
            String title = syseimnewsdataset1.getSysEimNewsnewsTitleFullLike();
            title = title.replaceAll("\\\\", "\\\\\\\\").replace("'", "\\'").replace("_", "\\_").replace("%", "\\%").replace("*", "\\*");
            syseimnewsdataset1.setSysEimNewsnewsTitleFullLike(title);
            SysEimNewsPageVo sysEimNewsPageVO = new SysEimNewsPageVo();
            Page pager = new Page((long)syseimnewsdataset1.getCurrent(), (long)syseimnewsdataset1.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            String[] orderParameter = new String[1];
            if (syseimnewsdataset1.getOrders() != null) {
                for (OrderItem orderItem : syseimnewsdataset1.getOrders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                        continue;
                    }
                    orderParameter[0] = orderItem.getColumn() + ",desc;";
                }
            }
            parameterMap.put("orderRule", orderParameter);
            String[] defaultOrderParameter = new String[1];
            String defaultOrder = "";
            defaultOrder = defaultOrder + "seq,asc;";
            defaultOrderParameter[0] = defaultOrder = defaultOrder + "createTime,desc;";
            parameterMap.put("defaultOrderRule", defaultOrderParameter);
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new SysEimNews(), parameterMap);
            List<SysEimNews> list = this.sysEimNewsMapper.hussarQuerysysEimNewsCondition_1sysEimNewsSort_1Page((Page<SysEimNews>)pager, syseimnewsdataset1, (QueryWrapper<SysEimNews>)queryWrapper);
            list.forEach(a -> {
                if ("1".equals(a.getPublishStatus())) {
                    a.setPublishStatus(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_DEPLOYED.getMessage()));
                } else {
                    a.setPublishStatus(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_DRAFT.getMessage()));
                }
                if (null == a.getReadCount()) {
                    a.setReadCount(Integer.valueOf(0));
                }
            });
            sysEimNewsPageVO.setData(list);
            sysEimNewsPageVO.setCount(Long.valueOf(pager.getTotal()));
            sysEimNewsPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)sysEimNewsPageVO);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_TABLE_QUERY_ERROR.getMessage()));
        }
    }

    public ApiResponse<SysEimNewsPageVo> hussarQuerysysEimNewsCondition_1sysEimNewsSort_1Page_order_custom(SysEimNewsDatasetDto syseimnewsdataset1) {
        try {
            SysEimNewsPageVo sysEimNewsPageVO = new SysEimNewsPageVo();
            Page pager = new Page((long)syseimnewsdataset1.getCurrent(), (long)syseimnewsdataset1.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            String[] orderParameter = new String[1];
            if (syseimnewsdataset1.getOrders() != null) {
                for (OrderItem orderItem : syseimnewsdataset1.getOrders()) {
                    if (orderItem.isAsc()) {
                        orderParameter[0] = orderItem.getColumn() + ",asc;";
                        continue;
                    }
                    orderParameter[0] = orderItem.getColumn() + ",desc;";
                }
            }
            parameterMap.put("orderRule", orderParameter);
            String[] defaultOrderParameter = new String[1];
            String defaultOrder = "";
            defaultOrder = defaultOrder + "seq,asc;";
            defaultOrderParameter[0] = defaultOrder = defaultOrder + "createTime,asc;";
            parameterMap.put("defaultOrderRule", defaultOrderParameter);
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new SysEimNews(), parameterMap);
            List<SysEimNews> list = this.sysEimNewsMapper.hussarQuerysysEimNewsCondition_1sysEimNewsSort_1Page_order_custom((Page<SysEimNews>)pager, syseimnewsdataset1, (QueryWrapper<SysEimNews>)queryWrapper);
            sysEimNewsPageVO.setData(list);
            sysEimNewsPageVO.setCount(Long.valueOf(pager.getTotal()));
            sysEimNewsPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)sysEimNewsPageVO);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_TABLE_QUERY_ERROR.getMessage()));
        }
    }

    @HussarTransactional
    public ApiResponse<Boolean> flagDelete(List<String> ids) {
        try {
            if (null != ids && !ids.isEmpty()) {
                List<Long> idsLong = ids.stream().map(Long::valueOf).collect(Collectors.toList());
                if (!this.sysEimNewsMapper.flagDelete(idsLong).booleanValue()) {
                    return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_DELETE_FAIL.getMessage()));
                }
                this.sysEimNewsFileService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SysEimNewsFile::getDelFlag, (Object)"1")).in(SysEimNewsFile::getNewsId, idsLong));
                return ApiResponse.success((Object)true);
            }
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_DELETE_FAIL.getMessage()));
        }
        return ApiResponse.fail((String)TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_DELETE_FAIL.getMessage()));
    }

    public ApiResponse<SysEimNews> formQuery(String id) {
        try {
            return ApiResponse.success((Object)this.sysEimNewsMapper.formQuery(Long.valueOf(id)));
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_FORM_QUERY_ERROR.getMessage()));
        }
    }

    public ApiResponse<SysEimNews> getNews(String id) {
        try {
            SysEimNewsMaster sysEimNewsMaster = (SysEimNewsMaster)this.sysEimNewsMasterService.getById((Serializable)Long.valueOf(id));
            if (null == sysEimNewsMaster) {
                return ApiResponse.success((Object)new SysEimNews());
            }
            SysEimNewsRead sysEimNewsRead = new SysEimNewsRead();
            sysEimNewsRead.setNewsId(sysEimNewsMaster.getNewsId());
            sysEimNewsRead.setCreator(BaseSecurityUtil.getUser() != null ? BaseSecurityUtil.getUser().getId() : null);
            sysEimNewsRead.setCreateTime(LocalDateTime.now());
            sysEimNewsRead.setDelFlag(RETURN_CODE);
            sysEimNewsRead.setCreatorName(BaseSecurityUtil.getUser() != null ? BaseSecurityUtil.getUser().getUserName() : null);
            this.sysEimNewsReadService.saveOrUpdate((Object)sysEimNewsRead);
            int count = null != sysEimNewsMaster.getReadCount() ? sysEimNewsMaster.getReadCount() : 0;
            sysEimNewsMaster.setReadCount(Integer.valueOf(++count));
            this.sysEimNewsMasterService.saveOrUpdate((Object)sysEimNewsMaster);
            SysEimNews sysEimNews = this.sysEimNewsMapper.formQuery(Long.valueOf(id));
            TranslateUtil.translate((Object)sysEimNews, SysEimNews::getTypeLangKey, SysEimNews::setType);
            TranslateUtil.translate((Object)sysEimNews, SysEimNews::getSourceLangKey, SysEimNews::setSource);
            return ApiResponse.success((Object)sysEimNews);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_FORM_QUERY_ERROR.getMessage()));
        }
    }

    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(SysEimNews sysEimNews) {
        try {
            SysEimNewsMaster sysEimNewsMaster = sysEimNews.gainSysEimNewsMaster();
            if (sysEimNewsMaster.getNewsId() == null || this.sysEimNewsMasterService.getById((Serializable)sysEimNewsMaster.getNewsId()) == null) {
                sysEimNewsMaster.setCreator(BaseSecurityUtil.getUser().getId());
                sysEimNewsMaster.setCreatorName(BaseSecurityUtil.getUser().getUserName());
                sysEimNewsMaster.setCreateTime(LocalDateTime.now());
                sysEimNewsMaster.setLastEditor(BaseSecurityUtil.getUser().getId());
                sysEimNewsMaster.setLastTime(LocalDateTime.now());
                sysEimNewsMaster.setDelFlag(RETURN_CODE);
            } else {
                sysEimNewsMaster.setLastEditor(BaseSecurityUtil.getUser().getId());
                sysEimNewsMaster.setLastTime(LocalDateTime.now());
            }
            this.sysEimNewsMasterService.saveOrUpdate((Object)sysEimNewsMaster);
            LambdaQueryWrapper ew0 = new LambdaQueryWrapper();
            ew0.eq(SysEimNewsFile::getNewsId, (Object)sysEimNewsMaster.getNewsId());
            this.sysEimNewsFileService.remove((Wrapper)ew0);
            List sysEimNewsFiles = sysEimNews.gainSysEimNewsFileArray();
            if (null != sysEimNewsFiles) {
                for (SysEimNewsFile sysEimNewsFile : sysEimNewsFiles) {
                    sysEimNewsFile.setNewsId(sysEimNewsMaster.getNewsId());
                    if (sysEimNewsFile.getFileId() != null && this.sysEimNewsFileService.getById((Serializable)sysEimNewsFile.getFileId()) != null) continue;
                    sysEimNewsFile.setDelFlag(RETURN_CODE);
                }
                this.sysEimNewsFileService.saveOrUpdateBatch((Collection)sysEimNewsFiles);
            }
            return ApiResponse.success((Object)String.valueOf(sysEimNewsMaster.getNewsId()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_SAVE_OR_UPDATE_FAIL.getMessage()));
        }
    }

    public ApiResponse<SysEimNewsPageVo> getHomeNewsList(SysEimNewsDatasetDto syseimnewsdataset1) {
        try {
            SysEimNewsPageVo sysEimNewsPageVO = new SysEimNewsPageVo();
            String title = syseimnewsdataset1.getSysEimNewsnewsTitleFullLike();
            title = title.replaceAll("\\\\", "\\\\\\\\").replace("'", "\\'").replace("_", "\\_").replace("%", "\\%").replace("*", "\\*");
            syseimnewsdataset1.setSysEimNewsnewsTitleFullLike(title);
            Page pager = new Page((long)syseimnewsdataset1.getCurrent(), (long)syseimnewsdataset1.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            String[] defaultOrderParameter = new String[1];
            String defaultOrder = "";
            defaultOrder = defaultOrder + "top,desc;";
            defaultOrderParameter[0] = defaultOrder = defaultOrder + "publishTime,desc;";
            parameterMap.put("defaultOrderRule", defaultOrderParameter);
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new SysEimNews(), parameterMap);
            List<SysEimNews> list = this.sysEimNewsMapper.getHomeNewsList((Page<SysEimNews>)pager, syseimnewsdataset1, (QueryWrapper<SysEimNews>)queryWrapper);
            TranslateUtil.translate(list, SysEimNews::getTypeLangKey, SysEimNews::setType);
            TranslateUtil.translate(list, SysEimNews::getSourceLangKey, SysEimNews::setSource);
            list.forEach(a -> {
                if (null == a.getReadCount()) {
                    a.setReadCount(Integer.valueOf(0));
                }
            });
            sysEimNewsPageVO.setData(list);
            sysEimNewsPageVO.setCount(Long.valueOf(pager.getTotal()));
            sysEimNewsPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)sysEimNewsPageVO);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_TABLE_QUERY_ERROR.getMessage()));
        }
    }

    public ApiResponse<SysEimNewsPageVo> getNewsList(SysEimNewsDatasetDto syseimnewsdataset1) {
        try {
            if (!BaseSecurityUtil.getUser().isSuperAdmin()) {
                syseimnewsdataset1.setCreator(BaseSecurityUtil.getUser().getId());
            }
            SysEimNewsPageVo sysEimNewsPageVO = new SysEimNewsPageVo();
            String title = syseimnewsdataset1.getSysEimNewsnewsTitleFullLike();
            title = title.replaceAll("\\\\", "\\\\\\\\").replace("'", "\\'").replace("_", "\\_").replace("%", "\\%").replace("*", "\\*");
            syseimnewsdataset1.setSysEimNewsnewsTitleFullLike(title);
            Page pager = new Page((long)syseimnewsdataset1.getCurrent(), (long)syseimnewsdataset1.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            String[] defaultOrderParameter = new String[1];
            String defaultOrder = "";
            defaultOrder = defaultOrder + "top,desc;";
            defaultOrderParameter[0] = defaultOrder = defaultOrder + "createTime,desc;";
            parameterMap.put("defaultOrderRule", defaultOrderParameter);
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new SysEimNews(), parameterMap);
            List<SysEimNews> list = this.sysEimNewsMapper.getNewsList((Page<SysEimNews>)pager, syseimnewsdataset1, (QueryWrapper<SysEimNews>)queryWrapper);
            list.forEach(a -> {
                if (a.getTop() == 1) {
                    a.setIsTop(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_YES.getMessage()));
                } else {
                    a.setIsTop(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_NO.getMessage()));
                }
                if ("1".equals(a.getPublishStatus())) {
                    a.setPublishStatus(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_DEPLOYED.getMessage()));
                } else {
                    a.setPublishStatus(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_DRAFT.getMessage()));
                }
                if (null == a.getReadCount()) {
                    a.setReadCount(Integer.valueOf(0));
                }
            });
            sysEimNewsPageVO.setData(list);
            sysEimNewsPageVO.setCount(Long.valueOf(pager.getTotal()));
            sysEimNewsPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)sysEimNewsPageVO);
        }
        catch (Exception e) {
            throw new HussarException(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_TABLE_QUERY_ERROR.getMessage()));
        }
    }

    public ApiResponse<AttachmentManagerModelVo> uploadVideo(MultipartHttpServletRequest multipartRequest) throws Exception {
        if (HussarUtils.isEmpty((Object)multipartRequest)) {
            throw new HussarException(OssExceptionEnum.FILE_NOT_EMPTY.getExceptionCode(), TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_FILE_INFO_EMPTY.getMessage()));
        }
        AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
        multipartRequest.setCharacterEncoding("UTF-8");
        MultipartFile multipartFile = null;
        Map map = multipartRequest.getFileMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MultipartFile multipartFile2 = multipartFile = (MultipartFile)iterator.next();
        }
        if (HussarUtils.isNotEmpty(multipartFile)) {
            CheckUploadFileUtils.checkFileType((MultipartFile)multipartFile, (OssProperties)this.ossProperties);
            String fileSavePath = this.hussarConfig.getFileUploadPath();
            String originalFilename = multipartFile.getOriginalFilename();
            String prefix = originalFilename.substring(originalFilename.lastIndexOf(".")).toLowerCase();
            Long fileId = Math.abs(UUID.randomUUID().getLeastSignificantBits());
            Long newFileId = Math.abs(UUID.randomUUID().getLeastSignificantBits());
            File file = new File(fileSavePath + fileId + prefix);
            multipartFile.transferTo(file);
            String decoder = ENCODER.getInfo(file).getVideo().getDecoder();
            if (!"h264".equals(decoder) && !"vp8".equals(decoder) && !"theora".equals(decoder) && FfmpegUtil.formatToMp4((String)(fileSavePath + fileId + prefix), (String)(fileSavePath + newFileId + ".mp4"))) {
                prefix = ".mp4";
                fileId = newFileId;
            }
            AttachmentManagerModel attachment = new AttachmentManagerModel();
            attachment.setId(fileId);
            attachment.setAttachmentName(originalFilename);
            attachment.setAttachmentType(prefix.replace(".", ""));
            attachment.setUploadPer(BaseSecurityUtil.getUser().getId());
            attachment.setAttachmentDir(fileSavePath);
            attachment.setUploadDate(LocalDateTime.now());
            this.attachmentManagerService.save((Object)attachment);
            BeanUtil.copy((Object)attachment, (Object)attachmentManagerModelVo);
            attachmentManagerModelVo.setFileName(originalFilename);
            attachmentManagerModelVo.setPath(fileSavePath);
            attachmentManagerModelVo.setBytes(String.valueOf(multipartFile.getSize()));
        }
        return ApiResponse.success((Object)attachmentManagerModelVo);
    }
}

