/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.workstation.config.dao.SysMobileFrameworkResourceMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysMobileFrameworkResourceDto;
import com.jxdinfo.hussar.workstation.config.enums.WorkStationConfigTipEnum;
import com.jxdinfo.hussar.workstation.config.model.SysMobileFrameworkParam;
import com.jxdinfo.hussar.workstation.config.model.SysMobileFrameworkResource;
import com.jxdinfo.hussar.workstation.config.service.ISysMobileFrameworkParamService;
import com.jxdinfo.hussar.workstation.config.service.ISysMobileFrameworkResourceService;
import com.jxdinfo.hussar.workstation.config.vo.SysMobileFrameworkResourceVo;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysMobileFrameworkResourceServiceImpl")
public class SysMobileFrameworkResourceServiceImpl
extends HussarServiceImpl<SysMobileFrameworkResourceMapper, SysMobileFrameworkResource>
implements ISysMobileFrameworkResourceService {
    @Autowired
    private ISysMobileFrameworkParamService sysMobileFrameworkParamService;

    public ApiResponse insertOrUpdate(SysMobileFrameworkResourceDto sysMobileFrameworkResourceDto) {
        if (null == sysMobileFrameworkResourceDto.getId()) {
            sysMobileFrameworkResourceDto.setCreator(BaseSecurityUtil.getUser().getId());
            sysMobileFrameworkResourceDto.setCreateTime(LocalDateTime.now());
            sysMobileFrameworkResourceDto.setLastEditor(BaseSecurityUtil.getUser().getId());
            sysMobileFrameworkResourceDto.setLastTime(LocalDateTime.now());
        } else {
            sysMobileFrameworkResourceDto.setLastEditor(BaseSecurityUtil.getUser().getId());
            sysMobileFrameworkResourceDto.setLastTime(LocalDateTime.now());
        }
        this.saveOrUpdate((BaseEntity)sysMobileFrameworkResourceDto);
        List paramsList = sysMobileFrameworkResourceDto.getpList();
        if (null != paramsList) {
            this.sysMobileFrameworkParamService.deleteParamsByFrameworkId(sysMobileFrameworkResourceDto.getId());
            for (SysMobileFrameworkParam param : paramsList) {
                if (null == param.getId()) {
                    param.setCreator(BaseSecurityUtil.getUser().getId());
                    param.setCreateTime(LocalDateTime.now());
                    param.setLastEditor(BaseSecurityUtil.getUser().getId());
                    param.setLastTime(LocalDateTime.now());
                }
                param.setFrameworkResourceId(sysMobileFrameworkResourceDto.getId());
                this.sysMobileFrameworkParamService.insertOrUpdate(param);
            }
            sysMobileFrameworkResourceDto.setpList(paramsList);
        }
        return ApiResponse.success((Object)sysMobileFrameworkResourceDto);
    }

    public ApiResponse getMobileFrameworkResource(Long frameworkMenuId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysMobileFrameworkResource::getFrameworkMenuId, (Object)frameworkMenuId);
        List list = this.list((Wrapper)queryWrapper);
        SysMobileFrameworkResourceVo sysMobileFrameworkResourceVo = new SysMobileFrameworkResourceVo();
        if (list.size() > 0) {
            SysMobileFrameworkResource sysMobileFrameworkResource = (SysMobileFrameworkResource)list.get(0);
            BeanUtils.copyProperties((Object)sysMobileFrameworkResource, (Object)sysMobileFrameworkResourceVo);
            ApiResponse response = this.sysMobileFrameworkParamService.getParamsByResourceId(sysMobileFrameworkResource.getId());
            sysMobileFrameworkResourceVo.setpList((List)response.getData());
        }
        return ApiResponse.success((Object)sysMobileFrameworkResourceVo);
    }

    public ApiResponse deleteResourceByMenuId() {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        List list = this.list((Wrapper)queryWrapper);
        for (int i = 0; i < list.size(); ++i) {
            this.removeById(((SysMobileFrameworkResource)list.get(i)).getId());
            this.sysMobileFrameworkParamService.deleteParamsByFrameworkId(((SysMobileFrameworkResource)list.get(i)).getId());
        }
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)WorkStationConfigTipEnum.WS_CON_DELETE_SUCCESS.getMessage()));
    }
}

