/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.WorkTempRoleSearchVo;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.authorization.post.vo.OrganPostTreeVo;
import com.jxdinfo.hussar.authorization.post.vo.PostBasicVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workstation.config.dto.SysOrganUserDto;
import com.jxdinfo.hussar.workstation.config.vo.SearchUserNewVo;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationRoleVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.jxdinfo.hussar.workstation.config.controller.hussarBasePowerController")
@RequestMapping(value={"/workstationConfig/power"})
public class HussarBasePowerController {
    @Autowired
    private ISysRolesExternalService sysRolesExternalService;
    @Autowired
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Autowired
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Autowired
    private IHussarBasePostBoService hussarBasePostBoService;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e")
    @GetMapping(value={"/searchUsers"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchUserNewVo>> searchUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u673a\u6784id") @RequestParam String depStruId, @ApiParam(value="\u7528\u6237\u540d") @RequestParam String name) {
        Long orgId = Long.parseLong(depStruId);
        QueryUserDto queryUserDto = new QueryUserDto();
        queryUserDto.setDepStruId(orgId);
        queryUserDto.setUserName(name);
        Page searchUserVoPage = this.hussarBaseUserBoService.searchUsers(pageInfo, queryUserDto);
        Page searchUserNewVoPage = new Page();
        List records = searchUserVoPage.getRecords();
        ArrayList<SearchUserNewVo> newRecords = new ArrayList<SearchUserNewVo>();
        for (SearchUserVo u : records) {
            SearchUserNewVo u1 = new SearchUserNewVo();
            BeanUtils.copyProperties((Object)u, (Object)u1);
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.convertValue((Object)u1, Map.class);
            map.put("label", u.getUserName());
            u1 = (SearchUserNewVo)mapper.convertValue((Object)map, u1.getClass());
            newRecords.add(u1);
        }
        searchUserNewVoPage.setRecords(newRecords);
        searchUserNewVoPage.setTotal(searchUserVoPage.getTotal());
        searchUserNewVoPage.setSize(searchUserVoPage.getSize());
        searchUserNewVoPage.setCurrent(searchUserVoPage.getCurrent());
        searchUserNewVoPage.setOptimizeCountSql(searchUserVoPage.optimizeCountSql());
        searchUserNewVoPage.setSearchCount(searchUserVoPage.searchCount());
        searchUserNewVoPage.setOptimizeJoinOfCountSql(searchUserVoPage.optimizeJoinOfCountSql());
        searchUserNewVoPage.setCountId(searchUserVoPage.countId());
        searchUserNewVoPage.setMaxLimit(searchUserVoPage.maxLimit());
        return ApiResponse.success((Object)searchUserNewVoPage);
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811")
    @PostMapping(value={"/lazyOrganUserTree"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganUserTreeVo>> lazyOrganUserTree(@RequestBody SysOrganUserDto sysOrganUserDto) {
        List parentOrganIds = sysOrganUserDto.getParentOrganIds();
        Integer resultType = sysOrganUserDto.getResultType();
        return ApiResponse.success((Object)this.hussarBaseUserBoService.lazyOrganUserTree(parentOrganIds, Boolean.valueOf(false), resultType));
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u67e5\u7528\u6237", notes="\u6839\u636e\u7528\u6237id\u67e5\u7528\u6237")
    @GetMapping(value={"/getUserAndStaffInfo"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u6839\u636e\u7528\u6237id\u67e5\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse getUserAndStaffInfo(@ApiParam(value="\u7528\u6237id") @RequestParam Long userId) {
        UserStaffVo userAndStaffInfo = this.hussarBaseUserBoService.getUserAndStaffInfo(userId);
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.convertValue((Object)userAndStaffInfo, Map.class);
        map.put("label", userAndStaffInfo.getUserName());
        Object o = mapper.convertValue((Object)map, Object.class);
        return ApiResponse.success((Object)o);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", notes="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d")
    @GetMapping(value={"/lazyLoadOrganTreeWithProperty"})
    @ResponseBody
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> lazyLoadOrganTreeWithProperty(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId, @ApiParam(value="\u673a\u6784\u7c7b\u578b") String organProperty) {
        return ApiResponse.success((Object)this.hussarBaseOrganizationBoService.lazyLoadOrganizationTree(parentId, organProperty));
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868", notes="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868")
    @GetMapping(value={"/searchOrganization"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u6a21\u7cca\u67e5\u8be2\u673a\u6784\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchOrganizationVo>> searchOrganization(@ApiParam(value="\u5206\u9875\u53c2\u6570") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u5173\u952e\u5b57") String name) {
        return ApiResponse.success((Object)this.hussarBaseOrganizationBoService.searchOrganization(pageInfo, name));
    }

    @ApiOperation(value="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811")
    @GetMapping(value={"/backOrganizationTree"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> backOrganizationTree(@ApiParam(value="\u9009\u4e2d\u8282\u70b9") @RequestParam(value="id") Long id) {
        return ApiResponse.success((Object)this.hussarBaseOrganizationBoService.backOrganizationTree(id));
    }

    @ApiOperation(value="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d", notes="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d")
    @GetMapping(value={"/roleGroupTreeNew"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u83b7\u53d6\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u7ed3\u6784", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Object>> loadRoleGruopTreeNew(@ApiParam(value="\u5e94\u7528id") Long appId) {
        List jsTreeModels = this.sysRolesExternalService.loadRoleGruopTree(appId);
        ArrayList<Object> jsTreeModelsNew = new ArrayList<Object>();
        for (JSTreeModel treeModel : jsTreeModels) {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.convertValue((Object)treeModel, Map.class);
            map.put("label", treeModel.getText());
            List childrenList = (List)map.get("childrenList");
            ArrayList<Object> childrenNewList = new ArrayList<Object>();
            for (int i = 0; i < childrenList.size(); ++i) {
                boolean flag2 = false;
                Object cTree = childrenList.get(i);
                ObjectMapper mapper1 = new ObjectMapper();
                Map map1 = (Map)mapper.convertValue(cTree, Map.class);
                map1.put("label", map1.get("text"));
                Long id = Long.parseLong(map1.get("id").toString());
                map1.put("hasChildren", flag2);
                Object treeModel1 = mapper1.convertValue((Object)map1, Object.class);
                childrenNewList.add(treeModel1);
            }
            map.put("childrenList", childrenNewList);
            map.put("children", childrenNewList);
            Object treeModel1 = mapper.convertValue((Object)map, Object.class);
            jsTreeModelsNew.add(treeModel1);
        }
        return ApiResponse.success(jsTreeModelsNew);
    }

    @ApiOperation(value="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d", notes="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d")
    @GetMapping(value={"/roleGroupTree"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u83b7\u53d6\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u7ed3\u6784", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Object>> loadRoleGruopTree(@ApiParam(value="\u5e94\u7528id") Long appId) {
        List jsTreeModels = this.sysRolesExternalService.loadRoleGruopTree(appId);
        ArrayList<Object> jsTreeModelsNew = new ArrayList<Object>();
        for (JSTreeModel treeModel : jsTreeModels) {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.convertValue((Object)treeModel, Map.class);
            map.put("label", treeModel.getText());
            List childrenList = (List)map.get("childrenList");
            ArrayList<Object> childrenNewList = new ArrayList<Object>();
            boolean flag = false;
            if (HussarUtils.isNotEmpty((Object)childrenList)) {
                flag = true;
            }
            for (int i = 0; i < childrenList.size(); ++i) {
                boolean flag2 = false;
                Object cTree = childrenList.get(i);
                ObjectMapper mapper1 = new ObjectMapper();
                Map map1 = (Map)mapper.convertValue(cTree, Map.class);
                map1.put("label", map1.get("text"));
                Long id = Long.parseLong(map1.get("id").toString());
                List rolesList = this.sysRolesExternalService.searchRoleToGroup(id, null);
                if (HussarUtils.isNotEmpty((Object)rolesList)) {
                    flag2 = true;
                }
                map1.put("hasChildren", flag2);
                Object treeModel1 = mapper1.convertValue((Object)map1, Object.class);
                childrenNewList.add(treeModel1);
            }
            map.put("childrenList", childrenNewList);
            map.put("hasChildren", flag);
            map.put("children", childrenNewList);
            Object treeModel1 = mapper.convertValue((Object)map, Object.class);
            jsTreeModelsNew.add(treeModel1);
        }
        return ApiResponse.success(jsTreeModelsNew);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272", notes="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272")
    @GetMapping(value={"/searchRoleToGroup"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u6839\u636e\u5206\u7ec4ID\u67e5\u8be2\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysWorkstationRoleVo>> searchRoleToGroup(@ApiParam(value="\u89d2\u8272\u5206\u7ec4id") @RequestParam Long id, @ApiParam(value="\u89d2\u8272\u540d\u79f0") @RequestParam String roleName) {
        List sysRoles = this.sysRolesExternalService.searchRoleToGroup(id, roleName);
        ArrayList<SysWorkstationRoleVo> sysRolesNew = new ArrayList<SysWorkstationRoleVo>();
        for (SysRoles role : sysRoles) {
            SysWorkstationRoleVo sysWorkstationRoleVo = (SysWorkstationRoleVo)HussarUtils.copy((Object)role, SysWorkstationRoleVo.class);
            sysWorkstationRoleVo.setLabel(role.getRoleName());
            sysWorkstationRoleVo.setParentId(id);
            sysWorkstationRoleVo.setLabel(role.getRoleName());
            sysWorkstationRoleVo.setHasChildren(Boolean.FALSE.booleanValue());
            sysRolesNew.add(sysWorkstationRoleVo);
        }
        return ApiResponse.success(sysRolesNew);
    }

    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u4e0b\u7684\u5c97\u4f4d", notes="\u67e5\u8be2\u673a\u6784\u4e0b\u7684\u5c97\u4f4d")
    @GetMapping(value={"/getPostsByStruId"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u67e5\u8be2\u673a\u6784\u4e0b\u7684\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page> getPostsByStruId(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u673a\u6784id") @RequestParam Long struId, @ApiParam(value="\u5c97\u4f4d\u540d\u79f0") @RequestParam String name) {
        Page page = new Page();
        List posList = this.hussarBasePostBoService.getPostsByStruId(struId, name);
        ArrayList<Object> posListNew = new ArrayList<Object>();
        for (PostBasicVo pos : posList) {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.convertValue((Object)pos, Map.class);
            map.put("id", map.get("postId"));
            map.put("label", map.get("postName"));
            map.put("parentId", struId);
            map.put("hasChildren", false);
            Object posNew = mapper.convertValue((Object)map, Object.class);
            posListNew.add(posNew);
        }
        if (posListNew.size() > 0) {
            int current;
            int size = posListNew.size();
            int len = (int)pageInfo.getSize();
            List objects = posListNew.subList(current * len, ((current = (int)pageInfo.getCurrent() - 1) + 1) * len > size ? size : len * (current + 1));
            page.setTotal((long)size);
            page.setSize((long)len);
            page.setCurrent((long)(current + 1));
            page.setRecords(objects);
        }
        return ApiResponse.success((Object)page);
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u5c97\u4f4d\u6811", notes="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u5c97\u4f4d\u6811")
    @GetMapping(value={"/lazyLoadOrganPostTree"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u5c97\u4f4d\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse lazyLoadOrganPostTree(Long parentId) {
        List postTreeList = this.hussarBasePostBoService.lazyLoadOrganPostTree(parentId);
        ArrayList<Object> postTreeListNew = new ArrayList<Object>();
        for (int i = 0; i < postTreeList.size(); ++i) {
            ObjectMapper mapper = new ObjectMapper();
            OrganPostTreeVo organPostTreeVo = (OrganPostTreeVo)postTreeList.get(i);
            Map map = (Map)mapper.convertValue((Object)organPostTreeVo, Map.class);
            long id = Long.parseLong(map.get("id").toString());
            List organPostTreeVos = this.hussarBasePostBoService.lazyLoadOrganPostTree(Long.valueOf(id));
            if (HussarUtils.isNotEmpty((Object)organPostTreeVos)) {
                map.put("hasChildren", true);
            } else {
                map.put("hasChildren", false);
            }
            Object posNew = mapper.convertValue((Object)map, Object.class);
            postTreeListNew.add(posNew);
        }
        return ApiResponse.success(postTreeListNew);
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811")
    @GetMapping(value={"/organSearch"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u6a21\u677f\u53ef\u89c1\u6743\u9650\u7ec4\u7ec7\u67b6\u6784\u641c\u7d22", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganizationTreeVo>> organSearch(@ApiParam(value="\u540d\u5b57") @RequestParam String name) {
        return ApiResponse.success((Object)this.hussarBaseOrganizationBoService.organSearch(name));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811")
    @GetMapping(value={"/roleSearch"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u6a21\u677f\u53ef\u89c1\u6743\u9650\u89d2\u8272\u641c\u7d22", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<WorkTempRoleSearchVo>> roleSearch(@ApiParam(value="\u540d\u5b57") @RequestParam String name) {
        return ApiResponse.success((Object)this.sysRolesExternalService.roleSearch(name, null));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811")
    @GetMapping(value={"/organPostSearch"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u6a21\u677f\u53ef\u89c1\u6743\u9650\u5c97\u4f4d\u641c\u7d22", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganPostTreeVo>> organPostSearch(@ApiParam(value="\u540d\u5b57") @RequestParam String name) {
        return ApiResponse.success((Object)this.hussarBasePostBoService.organPostSearch(name));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7528\u6237\u6811")
    @GetMapping(value={"/organUserSearch"})
    @AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406", eventDesc="\u6a21\u677f\u53ef\u89c1\u6743\u9650\u7528\u6237\u641c\u7d22", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganUserTreeVo>> organUserSearch(@ApiParam(value="\u540d\u5b57") @RequestParam String name) {
        return ApiResponse.success((Object)this.hussarBaseUserBoService.organUserSearch(name));
    }
}

