/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workstation.config.dao.SysToolbarAdvertisementMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysToolbarAdvertisementDto;
import com.jxdinfo.hussar.workstation.config.model.SysToolbarAdvertisement;
import com.jxdinfo.hussar.workstation.config.service.ISysToolbarAdvertisementService;
import com.jxdinfo.hussar.workstation.config.utils.AdvertisementUtils;
import com.jxdinfo.hussar.workstation.config.vo.SysToolbarAdvertisementVo;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@HussarTransactional
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysToolbarAdvertisementServiceImpl")
public class SysToolbarAdvertisementServiceImpl
extends HussarServiceImpl<SysToolbarAdvertisementMapper, SysToolbarAdvertisement>
implements ISysToolbarAdvertisementService {
    @Resource
    private SysToolbarAdvertisementMapper sysToolbarAdvertisementMapper;

    public ApiResponse<IPage<SysToolbarAdvertisementVo>> listAdvertisements(SysToolbarAdvertisementDto dto) {
        if (dto.getCurrent() == 0L || dto.getSize() == 0L) {
            throw new HussarException("\u5206\u9875\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysToolbarAdvertisement::getAdStatus, (Object)"0");
        wrapper.isNotNull(SysToolbarAdvertisement::getAdDueTime);
        List needUpdateDataList = this.list((Wrapper)wrapper);
        int i = 0;
        for (SysToolbarAdvertisement sysToolbarAdvertisement : needUpdateDataList) {
            if (sysToolbarAdvertisement.getAdDueTime().compareTo(LocalDateTime.now()) > 0) continue;
            sysToolbarAdvertisement.setAdStatus("1");
            ++i;
        }
        if (i > 0) {
            this.updateBatchById(needUpdateDataList);
        }
        dto.setCreateEndTime(AdvertisementUtils.dealLe(dto.getCreateEndTime()));
        dto.setAdDueEndTime(AdvertisementUtils.dealLe(dto.getAdDueEndTime()));
        Page page = new Page(dto.getCurrent(), dto.getSize());
        dto.setAdTitle(dto.getAdTitle().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        IPage<SysToolbarAdvertisementVo> sysBannerAdvertisementVoIPage = this.sysToolbarAdvertisementMapper.listAdvertisements(page, dto);
        return ApiResponse.success(sysBannerAdvertisementVoIPage);
    }

    public ApiResponse<?> insertOrUpdate(SysToolbarAdvertisementDto dto) {
        this.checkField(dto);
        if (null == dto.getId()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.orderByDesc(SysToolbarAdvertisement::getAdSort);
            List sysToolbarAdvertisementList = this.list((Wrapper)wrapper);
            int maxAdSort = 0;
            if (sysToolbarAdvertisementList.size() > 0) {
                maxAdSort = ((SysToolbarAdvertisement)sysToolbarAdvertisementList.get(0)).getAdSort();
            }
            dto.setAdSort(Integer.valueOf(maxAdSort + 1));
            dto.setCreator(BaseSecurityUtil.getUser().getId());
            dto.setCreateTime(LocalDateTime.now());
            dto.setLastEditor(BaseSecurityUtil.getUser().getId());
            dto.setLastTime(LocalDateTime.now());
        } else {
            dto.setLastEditor(BaseSecurityUtil.getUser().getId());
            dto.setLastTime(LocalDateTime.now());
        }
        this.saveOrUpdate((BaseEntity)dto);
        return ApiResponse.success();
    }

    public ApiResponse<?> deleteAdvertisements(SysToolbarAdvertisementDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException("\u9700\u8981\u5220\u9664\u7684\u6570\u636eid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u9009\u4e2d\u6570\u636e");
        }
        String[] ids = dto.getIds().split(",");
        List<Long> longList = AdvertisementUtils.stringByteToList(ids);
        this.removeByIds(longList);
        return ApiResponse.success();
    }

    public ApiResponse<?> stopUseAdvertisements(SysToolbarAdvertisementDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException("\u6570\u636e\u9009\u62e9\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        String[] ids = dto.getIds().split(",");
        List<Long> longList = AdvertisementUtils.stringByteToList(ids);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(SysToolbarAdvertisement::getId, longList);
        List sysToolbarAdvertisementList = this.list((Wrapper)wrapper);
        for (SysToolbarAdvertisement sysToolbarAdvertisement : sysToolbarAdvertisementList) {
            sysToolbarAdvertisement.setAdStatus("1");
        }
        this.updateBatchById(sysToolbarAdvertisementList);
        return ApiResponse.success();
    }

    public ApiResponse<?> startUseAdvertisements(SysToolbarAdvertisementDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException("\u6570\u636e\u9009\u62e9\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        String[] ids = dto.getIds().split(",");
        List<Long> longList = AdvertisementUtils.stringByteToList(ids);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(SysToolbarAdvertisement::getId, longList);
        List sysToolbarAdvertisementList = this.list((Wrapper)wrapper);
        for (SysToolbarAdvertisement sysToolbarAdvertisement : sysToolbarAdvertisementList) {
            String checkResult = AdvertisementUtils.checkAdDueTime(sysToolbarAdvertisement.getAdDueTime());
            if ("1".equals(checkResult)) {
                throw new HussarException("\u9009\u62e9\u7684\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u5728\u4fee\u6539\u9875\u9762\u914d\u7f6e\u8fc7\u671f\u65f6\u95f4");
            }
            sysToolbarAdvertisement.setAdStatus("0");
        }
        this.updateBatchById(sysToolbarAdvertisementList);
        return ApiResponse.success();
    }

    public ApiResponse<List<SysToolbarAdvertisement>> listToolbarAdvertisements() {
        List<SysToolbarAdvertisement> advertisementList = this.sysToolbarAdvertisementMapper.listPictureIds(LocalDateTime.now());
        return ApiResponse.success(advertisementList);
    }

    public ApiResponse<?> moveAdvertisements(SysToolbarAdvertisementDto dto) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        Integer adSort = dto.getAdSort();
        if ("0".equals(dto.getMoveFlag())) {
            wrapper.gt(SysToolbarAdvertisement::getAdSort, (Object)adSort);
            wrapper.orderByAsc(SysToolbarAdvertisement::getAdSort);
        } else if ("1".equals(dto.getMoveFlag())) {
            wrapper.lt(SysToolbarAdvertisement::getAdSort, (Object)adSort);
            wrapper.orderByDesc(SysToolbarAdvertisement::getAdSort);
        }
        wrapper.eq(SysToolbarAdvertisement::getAdStatus, (Object)dto.getAdStatus());
        List advertisementList = this.sysToolbarAdvertisementMapper.selectList((Wrapper)wrapper);
        if (advertisementList.size() > 0) {
            SysToolbarAdvertisement sysToolbarAdvertisement = (SysToolbarAdvertisement)advertisementList.get(0);
            wrapper.clear();
            wrapper.eq(SysToolbarAdvertisement::getAdSort, (Object)dto.getAdSort());
            SysToolbarAdvertisement sysToolbarAdvertisementDto = (SysToolbarAdvertisement)this.getOne((Wrapper)wrapper, false);
            sysToolbarAdvertisementDto.setAdSort(sysToolbarAdvertisement.getAdSort());
            sysToolbarAdvertisement.setAdSort(adSort);
            this.updateById((BaseEntity)sysToolbarAdvertisement);
            this.updateById((BaseEntity)sysToolbarAdvertisementDto);
        } else {
            if ("0".equals(dto.getMoveFlag())) {
                throw new HussarException("\u8be5\u6761\u6570\u636e\u5df2\u662f\u7b2c\u4e00\u6761\uff0c\u4e0d\u80fd\u4e0a\u79fb");
            }
            if ("1".equals(dto.getMoveFlag())) {
                throw new HussarException("\u8be5\u6761\u6570\u636e\u5df2\u662f\u6700\u540e\u4e00\u6761\uff0c\u4e0d\u80fd\u4e0b\u79fb");
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<Boolean> getAdvertisementByAdTitle(SysToolbarAdvertisementDto dto) {
        SysToolbarAdvertisement sysToolbarAdvertisement;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysToolbarAdvertisement::getAdTitle, (Object)dto.getAdTitle());
        if (null != dto.getId()) {
            wrapper.ne(SysToolbarAdvertisement::getId, (Object)dto.getId());
        }
        if ((sysToolbarAdvertisement = (SysToolbarAdvertisement)this.getOne((Wrapper)wrapper, false)) != null) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public void checkField(SysToolbarAdvertisementDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getAdTitle())) {
            throw new HussarException("\u5e7f\u544a\u6807\u9898\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8f93\u5165");
        }
        if (HussarUtils.isBlank((CharSequence)dto.getAdOutside())) {
            throw new HussarException("\u662f\u5426\u5916\u94fe\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8f93\u5165");
        }
        if (HussarUtils.isBlank((CharSequence)dto.getAdStatus())) {
            throw new HussarException("\u6570\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u72b6\u6001");
        }
        if (HussarUtils.isNotBlank((CharSequence)dto.getAdLink())) {
            String url_agreement = dto.getAdLink().split(":")[0];
            if (!"http".equalsIgnoreCase(url_agreement) && !"https".equalsIgnoreCase(url_agreement)) {
                throw new HussarException("\u8d85\u94fe\u63a5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u8d85\u94fe\u63a5\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e");
            }
        } else {
            throw new HussarException("\u8d85\u94fe\u63a5\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8f93\u5165");
        }
        if (null == dto.getPictureId()) {
            throw new HussarException("\u56fe\u7247\u4e0a\u4f20\u8fd4\u56de\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
    }
}

