/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workstation.config.dao.SysAdIgnoreShowMapper;
import com.jxdinfo.hussar.workstation.config.dao.SysBannerAdvertisementMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysBannerAdvertisementDto;
import com.jxdinfo.hussar.workstation.config.model.SysAdIgnoreShow;
import com.jxdinfo.hussar.workstation.config.model.SysBannerAdvertisement;
import com.jxdinfo.hussar.workstation.config.service.ISysBannerAdvertisementService;
import com.jxdinfo.hussar.workstation.config.utils.AdvertisementUtils;
import com.jxdinfo.hussar.workstation.config.vo.SysBannerAdvertisementVo;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@HussarTransactional
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysBannerAdvertisementServiceImpl")
public class SysBannerAdvertisementServiceImpl
extends HussarServiceImpl<SysBannerAdvertisementMapper, SysBannerAdvertisement>
implements ISysBannerAdvertisementService {
    @Resource
    private SysBannerAdvertisementMapper sysBannerAdvertisementMapper;
    @Resource
    private SysAdIgnoreShowMapper sysAdIgnoreShowMapper;

    public ApiResponse<IPage<SysBannerAdvertisementVo>> listBanners(SysBannerAdvertisementDto dto) {
        if (dto.getCurrent() == 0L || dto.getSize() == 0L) {
            throw new HussarException("\u5206\u9875\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBannerAdvertisement::getAdStatus, (Object)"0");
        wrapper.isNotNull(SysBannerAdvertisement::getAdDueTime);
        SysBannerAdvertisement sysBannerAdvertisement = (SysBannerAdvertisement)this.getOne((Wrapper)wrapper, false);
        if (sysBannerAdvertisement != null && sysBannerAdvertisement.getAdDueTime().compareTo(LocalDateTime.now()) <= 0) {
            sysBannerAdvertisement.setAdStatus("1");
            this.updateById((BaseEntity)sysBannerAdvertisement);
        }
        dto.setCreateEndTime(AdvertisementUtils.dealLe(dto.getCreateEndTime()));
        dto.setAdDueEndTime(AdvertisementUtils.dealLe(dto.getAdDueEndTime()));
        Page page = new Page(dto.getCurrent(), dto.getSize());
        dto.setAdTitle(dto.getAdTitle().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        IPage<SysBannerAdvertisementVo> sysBannerAdvertisementVoIPage = this.sysBannerAdvertisementMapper.listBanners(page, dto);
        return ApiResponse.success(sysBannerAdvertisementVoIPage);
    }

    public ApiResponse<?> insertOrUpdate(SysBannerAdvertisementDto dto) {
        this.checkField(dto);
        if (null == dto.getId()) {
            dto.setCreator(BaseSecurityUtil.getUser().getId());
            dto.setCreateTime(LocalDateTime.now());
            dto.setLastEditor(BaseSecurityUtil.getUser().getId());
            dto.setLastTime(LocalDateTime.now());
        } else {
            dto.setLastEditor(BaseSecurityUtil.getUser().getId());
            dto.setLastTime(LocalDateTime.now());
        }
        if (null != dto.getUsingDataId()) {
            SysBannerAdvertisement sysBannerAdvertisement = (SysBannerAdvertisement)this.getById(dto.getUsingDataId());
            sysBannerAdvertisement.setAdStatus("1");
            this.updateById((BaseEntity)sysBannerAdvertisement);
        }
        this.saveOrUpdate((BaseEntity)dto);
        return ApiResponse.success();
    }

    public ApiResponse<?> deleteBanner(SysBannerAdvertisementDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException("\u9700\u8981\u5220\u9664\u7684\u6570\u636eid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u9009\u4e2d\u6570\u636e");
        }
        String[] ids = dto.getIds().split(",");
        List<Long> longList = AdvertisementUtils.stringByteToList(ids);
        this.removeByIds(longList);
        return ApiResponse.success();
    }

    public ApiResponse<?> stopOrStart(SysBannerAdvertisementDto dto) {
        SysBannerAdvertisement sysBannerAdvertisement;
        if (null == dto.getId()) {
            throw new HussarException("\u6570\u636e\u9009\u62e9\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if ("1".equals(dto.getAdStatus())) {
            SysBannerAdvertisement sysBannerAdvertisement2;
            String checkResult = AdvertisementUtils.checkAdDueTime(dto.getAdDueTime());
            if ("1".equals(checkResult)) {
                throw new HussarException("\u9009\u62e9\u7684\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u5728\u4fee\u6539\u9875\u9762\u914d\u7f6e\u8fc7\u671f\u65f6\u95f4");
            }
            if (null != dto.getUsingDataId() && null != (sysBannerAdvertisement2 = (SysBannerAdvertisement)this.getById(dto.getUsingDataId()))) {
                sysBannerAdvertisement2.setAdStatus("1");
                this.updateById((BaseEntity)sysBannerAdvertisement2);
            }
        }
        if (null != (sysBannerAdvertisement = (SysBannerAdvertisement)this.getById(dto.getId()))) {
            if ("0".equals(dto.getAdStatus())) {
                sysBannerAdvertisement.setAdStatus("1");
            } else {
                sysBannerAdvertisement.setAdStatus("0");
            }
            this.updateById((BaseEntity)sysBannerAdvertisement);
        }
        return ApiResponse.success();
    }

    public ApiResponse<SysBannerAdvertisement> getBannerData() {
        Long nowPeople = BaseSecurityUtil.getUser().getId();
        List<SysAdIgnoreShow> sysAdIgnoreShowList = this.sysAdIgnoreShowMapper.listIgnoreData(nowPeople);
        if (sysAdIgnoreShowList.size() > 0) {
            return ApiResponse.success();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBannerAdvertisement::getAdStatus, (Object)"0");
        SysBannerAdvertisement sysBannerAdvertisement = (SysBannerAdvertisement)this.getOne((Wrapper)wrapper, false);
        if (sysBannerAdvertisement != null) {
            if (null != sysBannerAdvertisement.getAdDueTime()) {
                if (sysBannerAdvertisement.getAdDueTime().compareTo(LocalDateTime.now()) > 0) {
                    return ApiResponse.success((Object)sysBannerAdvertisement);
                }
            } else {
                return ApiResponse.success((Object)sysBannerAdvertisement);
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<SysBannerAdvertisement> getUsedBannerByAdStatus(Long id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBannerAdvertisement::getAdStatus, (Object)"0");
        if (null != id) {
            wrapper.ne(SysBannerAdvertisement::getId, (Object)id);
        }
        return ApiResponse.success((Object)this.getOne((Wrapper)wrapper, false));
    }

    public ApiResponse<Boolean> getBannerByAdTitle(SysBannerAdvertisementDto dto) {
        SysBannerAdvertisement sysBannerAdvertisement;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysBannerAdvertisement::getAdTitle, (Object)dto.getAdTitle());
        if (null != dto.getId()) {
            wrapper.ne(SysBannerAdvertisement::getId, (Object)dto.getId());
        }
        if ((sysBannerAdvertisement = (SysBannerAdvertisement)this.getOne((Wrapper)wrapper, false)) != null) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<?> insertOneIgnoreData(SysBannerAdvertisementDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getIds())) {
            throw new HussarException("\u6a2a\u5e45id\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8f93\u5165");
        }
        SysAdIgnoreShow adIgnoreShow = new SysAdIgnoreShow();
        adIgnoreShow.setAdId(Long.valueOf(dto.getIds()));
        adIgnoreShow.setCreator(BaseSecurityUtil.getUser().getId());
        adIgnoreShow.setCreateTime(LocalDateTime.now());
        adIgnoreShow.setLastEditor(BaseSecurityUtil.getUser().getId());
        adIgnoreShow.setLastTime(LocalDateTime.now());
        this.sysAdIgnoreShowMapper.insert(adIgnoreShow);
        return ApiResponse.success();
    }

    public void checkField(SysBannerAdvertisementDto dto) {
        if (HussarUtils.isBlank((CharSequence)dto.getAdTitle())) {
            throw new HussarException("\u6a2a\u5e45\u6807\u9898\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8f93\u5165");
        }
        if (HussarUtils.isBlank((CharSequence)dto.getAdOutside())) {
            throw new HussarException("\u662f\u5426\u5916\u94fe\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u8f93\u5165");
        }
        if (HussarUtils.isBlank((CharSequence)dto.getAdStatus())) {
            throw new HussarException("\u6570\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u72b6\u6001");
        }
        if (HussarUtils.isNotBlank((CharSequence)dto.getAdLink())) {
            String url_agreement = dto.getAdLink().split(":")[0];
            if (!"http".equalsIgnoreCase(url_agreement) && !"https".equalsIgnoreCase(url_agreement)) {
                throw new HussarException("\u8d85\u94fe\u63a5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u8d85\u94fe\u63a5\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e");
            }
        } else {
            throw new HussarException("\u8d85\u94fe\u63a5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8d85\u94fe\u63a5\u662f\u5426\u8f93\u5165");
        }
        if (null == dto.getPictureId()) {
            throw new HussarException("\u56fe\u7247\u4e0a\u4f20\u8fd4\u56de\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
    }
}

