/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationTemLayoutMapper;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationTemplateMapper;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationTemplateRoleMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysWorkstationTemplateDto;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemLayout;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemplate;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemplateRole;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationTemplateUser;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemLayoutService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateRoleService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateUserService;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationTemplateNewVo;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationTemplateVo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysWorkstationTemplateServiceImpl")
public class SysWorkstationTemplateServiceImpl
extends HussarServiceImpl<SysWorkstationTemplateMapper, SysWorkstationTemplate>
implements ISysWorkstationTemplateService {
    @Resource
    private SysWorkstationTemplateMapper sysWorkstationTemplateMapper;
    @Resource
    private SysWorkstationTemplateRoleMapper sysWorkstationTemplateRoleMapper;
    @Resource
    private SysWorkstationTemLayoutMapper sysWorkstationTemLayoutMapper;
    @Autowired
    private ISysWorkstationTemplateRoleService sysWorkstationTemplateRoleService;
    @Autowired
    private ISysWorkstationTemLayoutService sysWorkstationTemLayoutService;
    @Autowired
    private ISysWorkstationTemplateUserService sysWorkstationTemplateUserService;
    @Autowired
    private ISysWorkstationAssemblyService sysWorkstationAssemblyService;
    private static final String personalTemplateType = "0";
    private static final String commTemplateType = "1";
    private static final String myselfSeeRange = "0";
    private static final String personalSeeRange = "1";
    private static final String commonSeeRange = "2";
    private static final Long powerAdminRole = 736624401344372736L;
    private static final Long tenantAdminRole = 1450785135866925168L;

    public SysWorkstationTemplateVo saveTemplate(SysWorkstationTemplateDto sysWorkstationTemplateDto) {
        SysWorkstationTemplateVo sysWorkstationTemplateVo = new SysWorkstationTemplateVo();
        SysWorkstationTemplate sysWorkstationTemplate = new SysWorkstationTemplate();
        BeanUtils.copyProperties((Object)sysWorkstationTemplateDto, (Object)sysWorkstationTemplate);
        SecurityUser user = BaseSecurityUtil.getUser();
        sysWorkstationTemplate.setCreator(user.getUserId());
        sysWorkstationTemplate.setCreateTime(LocalDateTime.now());
        sysWorkstationTemplate.setLastEditor(user.getUserId());
        sysWorkstationTemplate.setLastTime(LocalDateTime.now());
        this.sysWorkstationTemplateMapper.insert(sysWorkstationTemplate);
        List wtlList = sysWorkstationTemplateDto.getWtlList();
        if (null != wtlList) {
            ArrayList<SysWorkstationTemLayout> wtlListNew = new ArrayList<SysWorkstationTemLayout>();
            for (SysWorkstationTemLayout wtl : wtlList) {
                wtl.setWorkstationTemplateId(sysWorkstationTemplate.getId());
                wtlListNew.add(wtl);
            }
            this.sysWorkstationTemLayoutService.insertOrUpdate(wtlListNew);
        }
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)sysWorkstationTemplateVo);
        sysWorkstationTemplateVo.setWtlList(wtlList);
        return sysWorkstationTemplateVo;
    }

    public SysWorkstationTemplateVo updateTemplate(SysWorkstationTemplateDto sysWorkstationTemplateDto) {
        SysWorkstationTemplateVo sysWorkstationTemplateVo = new SysWorkstationTemplateVo();
        SysWorkstationTemplate sysWorkstationTemplate = new SysWorkstationTemplate();
        BeanUtils.copyProperties((Object)sysWorkstationTemplateDto, (Object)sysWorkstationTemplate);
        this.sysWorkstationTemplateMapper.updateById(sysWorkstationTemplate);
        List wtlList = sysWorkstationTemplateDto.getWtlList();
        if (null != wtlList) {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)sysWorkstationTemplateDto.getId());
            this.sysWorkstationTemLayoutService.remove((Wrapper)queryWrapper);
            ArrayList<SysWorkstationTemLayout> wtlListNew = new ArrayList<SysWorkstationTemLayout>();
            for (SysWorkstationTemLayout wtl : wtlList) {
                wtl.setId(null);
                wtl.setWorkstationTemplateId(sysWorkstationTemplateDto.getId());
                wtlListNew.add(wtl);
            }
            this.sysWorkstationTemLayoutService.insertOrUpdate(wtlListNew);
        }
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)sysWorkstationTemplateVo);
        sysWorkstationTemplateVo.setWtlList(wtlList);
        return sysWorkstationTemplateVo;
    }

    public ApiResponse insertOrUpdate(SysWorkstationTemplateDto sysWorkstationTemplateDto) {
        SysWorkstationTemplate sysWorkstationTemplate = new SysWorkstationTemplate();
        BeanUtils.copyProperties((Object)sysWorkstationTemplateDto, (Object)sysWorkstationTemplate);
        this.sysWorkstationTemplateMapper.updateById(sysWorkstationTemplate);
        List wtrList = sysWorkstationTemplateDto.getWtrList();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)sysWorkstationTemplateDto.getId());
        this.sysWorkstationTemplateRoleService.remove((Wrapper)queryWrapper);
        if (null != wtrList && sysWorkstationTemplateDto.getSeeRange().equals("1")) {
            for (SysWorkstationTemplateRole wtr : wtrList) {
                wtr.setWorkstationTemplateId(sysWorkstationTemplateDto.getId());
                wtr.setCreator(BaseSecurityUtil.getUser().getId());
                wtr.setCreateTime(LocalDateTime.now());
                wtr.setLastEditor(BaseSecurityUtil.getUser().getId());
                wtr.setLastTime(LocalDateTime.now());
                this.sysWorkstationTemplateRoleService.insertOrUpdate(wtr);
            }
            sysWorkstationTemplateDto.setWtrList(wtrList);
        }
        return ApiResponse.success((Object)sysWorkstationTemplateDto);
    }

    public SysWorkstationTemplateNewVo listUserTemplateData(String applicationScenario) {
        long l = System.currentTimeMillis();
        SysWorkstationTemplateNewVo newVo = new SysWorkstationTemplateNewVo();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray roleList = null;
        roleList = HussarUtils.isNotEmpty(role) ? JSONArray.parseArray((String)role.toString()) : new JSONArray();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper layoutQueryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper roleQueryWrapper = Wrappers.lambdaQuery();
        if (!user.getAccount().equals("superadmin") && !roleList.contains((Object)powerAdminRole)) {
            List<SysWorkstationTemplateVo> personalTemplate = this.getPersonalTemplate(applicationScenario);
            newVo.setPersonalVoList(personalTemplate);
            List<SysWorkstationTemplateVo> commonTemplate = this.getCommonTemplate(applicationScenario);
            newVo.setCommonVoList(commonTemplate);
        } else {
            queryWrapper.clear();
            ((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getCreator, (Object)userId);
            List sysWorkstationTemplates = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
            ArrayList<SysWorkstationTemplateVo> listCommTemplate = new ArrayList<SysWorkstationTemplateVo>();
            for (SysWorkstationTemplate t : sysWorkstationTemplates) {
                SysWorkstationTemplateVo vo = new SysWorkstationTemplateVo();
                BeanUtils.copyProperties((Object)t, (Object)vo);
                listCommTemplate.add(vo);
            }
            Map<String, List<SysWorkstationTemplateVo>> collect = listCommTemplate.stream().collect(Collectors.groupingBy(SysWorkstationTemplateVo::getTemplateType));
            List<SysWorkstationTemplateVo> personalTemplate = collect.get("0");
            List<SysWorkstationTemplateVo> commonTemplate = collect.get("1");
            System.out.println(System.currentTimeMillis());
            newVo.setPersonalVoList(personalTemplate);
            newVo.setCommonVoList(commonTemplate);
        }
        long l1 = System.currentTimeMillis();
        SysWorkstationTemplateVo startUserTemplate = this.sysWorkstationTemplateUserService.loadStartUseTemplateByIdentity(applicationScenario);
        newVo.setStartUseVo(startUserTemplate);
        long l2 = System.currentTimeMillis();
        System.out.println("\u83b7\u53d6\u6a21\u677f\u6570\u636e\u8017\u65f6\uff1a" + (l1 - l));
        System.out.println("\u83b7\u53d6\u542f\u7528\u6a21\u677f\u6570\u636e\u8017\u65f6\uff1a" + (l2 - l1));
        return newVo;
    }

    public SysWorkstationTemplateVo getStartUserTemplate(String applicationScenario) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray roleList = null;
        roleList = HussarUtils.isNotEmpty(role) ? JSONArray.parseArray((String)role.toString()) : new JSONArray();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper layoutQueryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper roleQueryWrapper = Wrappers.lambdaQuery();
        SysWorkstationTemplateVo startUserTemplate = new SysWorkstationTemplateVo();
        if (!user.getAccount().equals("superadmin") && !roleList.contains((Object)powerAdminRole)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getTemplateType, (Object)"0")).eq(SysWorkstationTemplate::getCreator, (Object)userId);
            List personalTemplate = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)personalTemplate)) {
                List collect = personalTemplate.stream().sorted(Comparator.comparing(SysWorkstationTemplate::getCreateTime)).collect(Collectors.toList());
                BeanUtils.copyProperties(collect.get(0), (Object)startUserTemplate);
            } else {
                startUserTemplate = this.getCommonStartUserTemplate(applicationScenario);
            }
        } else {
            queryWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getCreator, (Object)userId)).orderByDesc(SysWorkstationTemplate::getCreateTime);
            List sysWorkstationTemplates = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)sysWorkstationTemplates)) {
                BeanUtils.copyProperties(sysWorkstationTemplates.get(0), (Object)startUserTemplate);
            }
        }
        if (HussarUtils.isNotEmpty((Object)startUserTemplate)) {
            layoutQueryWrapper.eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)startUserTemplate.getId());
            List layoutList = this.sysWorkstationTemLayoutMapper.selectList((Wrapper)layoutQueryWrapper);
            try {
                for (SysWorkstationTemLayout tl : layoutList) {
                    String templateConfiguration = tl.getTemplateConfiguration();
                    JSONArray arr = new JSONArray();
                    JSONArray objects = JSONObject.parseArray((String)templateConfiguration);
                    objects.forEach(o -> {
                        ObjectMapper mapper = new ObjectMapper();
                        Map map = (Map)mapper.convertValue(o, Map.class);
                        Object moduleId = map.get("moduleId");
                        if (null != moduleId) {
                            Long id = Long.parseLong(map.get("moduleId").toString());
                            boolean flag = this.sysWorkstationAssemblyService.loadUserAssemblyPower(id);
                            map.put("flag", flag);
                            Object o1 = mapper.convertValue((Object)map, o.getClass());
                            arr.add(o1);
                        }
                    });
                    String jsonString = JSON.toJSONString((Object)arr);
                    tl.setTemplateConfiguration(jsonString);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            roleQueryWrapper.clear();
            roleQueryWrapper.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)startUserTemplate.getId());
            List roleLists = this.sysWorkstationTemplateRoleMapper.selectList((Wrapper)roleQueryWrapper);
            startUserTemplate.setWtlList(layoutList);
            startUserTemplate.setWtrList(roleLists);
        }
        return startUserTemplate;
    }

    public SysWorkstationTemplateVo getTemplateById(Long workstationTemplateId) {
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateMapper.selectById(workstationTemplateId);
        SysWorkstationTemplateVo vo = new SysWorkstationTemplateVo();
        if (!HussarUtils.isNotEmpty((Object)sysWorkstationTemplate)) {
            return vo;
        }
        String applicationScenario = sysWorkstationTemplate.getApplicationScenario();
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)vo);
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)sysWorkstationTemplate.getId());
        List roleList = this.sysWorkstationTemplateRoleService.list((Wrapper)queryWrapper1);
        vo.setWtrList(roleList);
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        boolean flag1 = this.checkHaveTempRole(sysWorkstationTemplate);
        if (!flag1) {
            LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)queryWrapper2.eq(SysWorkstationTemplateUser::getWorkstationTemplateId, (Object)workstationTemplateId)).eq(SysWorkstationTemplateUser::getUserId, (Object)userId);
            this.sysWorkstationTemplateUserService.remove((Wrapper)queryWrapper2);
            return this.getStartUserTemplate(applicationScenario);
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)sysWorkstationTemplate.getId());
        List layoutList = this.sysWorkstationTemLayoutService.list((Wrapper)queryWrapper);
        try {
            for (SysWorkstationTemLayout tl : layoutList) {
                String templateConfiguration = tl.getTemplateConfiguration();
                JSONArray arr = new JSONArray();
                JSONArray objects = JSONObject.parseArray((String)templateConfiguration);
                objects.forEach(o -> {
                    ObjectMapper mapper = new ObjectMapper();
                    Map map = (Map)mapper.convertValue(o, Map.class);
                    Object moduleId = map.get("moduleId");
                    if (null != moduleId) {
                        Long id = Long.parseLong(map.get("moduleId").toString());
                        boolean flag = this.sysWorkstationAssemblyService.loadUserAssemblyPower(id);
                        map.put("flag", flag);
                        Object o1 = mapper.convertValue((Object)map, o.getClass());
                        arr.add(o1);
                    }
                });
                String jsonString = JSON.toJSONString((Object)arr);
                tl.setTemplateConfiguration(jsonString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setWtlList(layoutList);
        return vo;
    }

    public SysWorkstationTemplateVo copyTemplateById(String workstationTemplateId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray roleList = null;
        roleList = HussarUtils.isNotEmpty(role) ? JSONArray.parseArray((String)role.toString()) : new JSONArray();
        SysWorkstationTemplate sysWorkstationTemplate = (SysWorkstationTemplate)this.sysWorkstationTemplateMapper.selectById((Serializable)((Object)workstationTemplateId));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)workstationTemplateId);
        List layoutList = this.sysWorkstationTemLayoutMapper.selectList((Wrapper)queryWrapper);
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)workstationTemplateId);
        List rolesList = this.sysWorkstationTemplateRoleService.list((Wrapper)queryWrapper1);
        sysWorkstationTemplate.setId(null);
        sysWorkstationTemplate.setCreator(user.getUserId());
        sysWorkstationTemplate.setCreateTime(LocalDateTime.now());
        sysWorkstationTemplate.setLastEditor(user.getUserId());
        sysWorkstationTemplate.setLastTime(LocalDateTime.now());
        sysWorkstationTemplate.setWorkstationTemplateName(sysWorkstationTemplate.getWorkstationTemplateName() + "-\u526f\u672c");
        if (!(user.getAccount().equals("superadmin") || roleList.contains((Object)powerAdminRole) || roleList.contains((Object)tenantAdminRole))) {
            sysWorkstationTemplate.setSeeRange("0");
            sysWorkstationTemplate.setTemplateType("0");
            this.save((BaseEntity)sysWorkstationTemplate);
            for (SysWorkstationTemLayout layout : layoutList) {
                layout.setId(null);
                layout.setWorkstationTemplateId(sysWorkstationTemplate.getId());
            }
            this.sysWorkstationTemLayoutService.saveBatch((Collection)layoutList);
        } else {
            this.save((BaseEntity)sysWorkstationTemplate);
            for (SysWorkstationTemLayout layout : layoutList) {
                layout.setId(null);
                layout.setWorkstationTemplateId(sysWorkstationTemplate.getId());
            }
            this.sysWorkstationTemLayoutService.saveBatch((Collection)layoutList);
            for (SysWorkstationTemplateRole roles : rolesList) {
                roles.setId(null);
                roles.setWorkstationTemplateId(sysWorkstationTemplate.getId());
            }
            this.sysWorkstationTemplateRoleService.saveBatch((Collection)rolesList);
        }
        SysWorkstationTemplateVo sysWorkstationTemplateVo = new SysWorkstationTemplateVo();
        BeanUtils.copyProperties((Object)sysWorkstationTemplate, (Object)sysWorkstationTemplateVo);
        return sysWorkstationTemplateVo;
    }

    private boolean checkHaveTempRole(SysWorkstationTemplate sysWorkstationTemplate) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        Object dept = user.getExtendUserMap().get("deptId");
        Long deptId = 1L;
        if (HussarUtils.isNotEmpty(dept)) {
            deptId = Long.parseLong(dept.toString());
        }
        Object post = user.getExtendUserMap().get("postId");
        Long postId = 1L;
        if (HussarUtils.isNotEmpty(post)) {
            postId = Long.parseLong(post.toString());
        }
        Object roles = user.getExtendUserMap().get("rolesList");
        JSONArray rolesList = null;
        if (HussarUtils.isNotEmpty(roles)) {
            rolesList = JSONArray.parseArray((String)roles.toString());
        }
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)sysWorkstationTemplate.getId());
        List roleList = this.sysWorkstationTemplateRoleService.list((Wrapper)queryWrapper1);
        boolean flag1 = false;
        if (user.getAccount().equals("superadmin") || commonSeeRange.equals(sysWorkstationTemplate.getSeeRange()) || "0".equals(sysWorkstationTemplate.getSeeRange()) && "0".equals(sysWorkstationTemplate.getTemplateType())) {
            flag1 = true;
        } else {
            for (SysWorkstationTemplateRole role : roleList) {
                String permissionType = role.getPermissionTypes();
                Long permissionId = role.getPermissionId();
                block6 : switch (permissionType) {
                    case "0": {
                        if (permissionId.compareTo(deptId) != 0) break;
                        flag1 = true;
                        break;
                    }
                    case "1": {
                        for (Object r : rolesList) {
                            Long r1 = Long.parseLong(r.toString());
                            if (permissionId.compareTo(r1) != 0) continue;
                            flag1 = true;
                            break block6;
                        }
                        break;
                    }
                    case "2": {
                        if (permissionId.compareTo(postId) != 0) break;
                        flag1 = true;
                        break;
                    }
                    case "3": {
                        if (permissionId.compareTo(userId) != 0) break;
                        flag1 = true;
                    }
                }
                if (!flag1) continue;
                break;
            }
        }
        return flag1;
    }

    public ApiResponse deleteTemplateById(String workstationTemplateId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationTemplate::getId, (Object)workstationTemplateId);
        int count = this.sysWorkstationTemplateMapper.delete((Wrapper)queryWrapper);
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        queryWrapper1.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)workstationTemplateId);
        this.sysWorkstationTemplateRoleMapper.delete((Wrapper)queryWrapper1);
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysWorkstationTemLayout::getWorkstationTemplateId, (Object)workstationTemplateId);
        this.sysWorkstationTemLayoutMapper.delete((Wrapper)queryWrapper2);
        LambdaQueryWrapper queryWrapper3 = Wrappers.lambdaQuery();
        queryWrapper3.eq(SysWorkstationTemplateUser::getWorkstationTemplateId, (Object)workstationTemplateId);
        this.sysWorkstationTemplateUserService.remove((Wrapper)queryWrapper3);
        if (count > 0) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    private List<SysWorkstationTemplateVo> getPersonalTemplate(String applicationScenario) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper layoutQueryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper roleQueryWrapper = Wrappers.lambdaQuery();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getTemplateType, (Object)"0")).eq(SysWorkstationTemplate::getCreator, (Object)userId);
        List personalTemplate = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
        ArrayList<SysWorkstationTemplateVo> listPersonalTemplate = new ArrayList<SysWorkstationTemplateVo>();
        for (SysWorkstationTemplate t : personalTemplate) {
            SysWorkstationTemplateVo vo = new SysWorkstationTemplateVo();
            BeanUtils.copyProperties((Object)t, (Object)vo);
            listPersonalTemplate.add(vo);
        }
        return listPersonalTemplate;
    }

    private List<SysWorkstationTemplateVo> getCommonTemplate(String applicationScenario) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        Object dept = user.getExtendUserMap().get("deptId");
        Long deptId = 1L;
        if (HussarUtils.isNotEmpty(dept)) {
            deptId = Long.parseLong(dept.toString());
        }
        Object post = user.getExtendUserMap().get("postId");
        Long postId = 1L;
        if (HussarUtils.isNotEmpty(post)) {
            postId = Long.parseLong(post.toString());
        }
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray rolesList = null;
        if (HussarUtils.isNotEmpty(role)) {
            rolesList = JSONArray.parseArray((String)role.toString());
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper layoutQueryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper roleQueryWrapper = Wrappers.lambdaQuery();
        queryWrapper.clear();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getTemplateType, (Object)"1")).eq(SysWorkstationTemplate::getSeeRange, (Object)commonSeeRange);
        List templates2 = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
        queryWrapper.clear();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)roleQueryWrapper.eq(SysWorkstationTemplateRole::getPermissionId, (Object)userId)).or()).eq(SysWorkstationTemplateRole::getPermissionId, (Object)deptId)).or()).in(SysWorkstationTemplateRole::getPermissionId, (Collection)rolesList)).or()).eq(SysWorkstationTemplateRole::getPermissionId, (Object)postId);
        List commTemplateIds = this.sysWorkstationTemplateRoleMapper.selectList((Wrapper)roleQueryWrapper).stream().map(SysWorkstationTemplateRole::getWorkstationTemplateId).collect(Collectors.toList());
        List collect = commTemplateIds.stream().distinct().collect(Collectors.toList());
        ArrayList<SysWorkstationTemplateVo> listCommTemplate = new ArrayList<SysWorkstationTemplateVo>();
        ArrayList commTemplateNew = new ArrayList();
        commTemplateNew.addAll(templates2);
        if (!collect.isEmpty()) {
            List commTemplate = this.sysWorkstationTemplateMapper.selectBatchIds(collect).stream().filter(t -> t.getApplicationScenario().equals("0")).collect(Collectors.toList());
            commTemplateNew.addAll(commTemplate);
        }
        for (SysWorkstationTemplate t2 : commTemplateNew) {
            SysWorkstationTemplateVo vo = new SysWorkstationTemplateVo();
            BeanUtils.copyProperties((Object)t2, (Object)vo);
            listCommTemplate.add(vo);
        }
        return listCommTemplate;
    }

    public SysWorkstationTemplateVo getCommonStartUserTemplate(String applicationScenario) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        Object dept = user.getExtendUserMap().get("deptId");
        Long deptId = 1L;
        if (HussarUtils.isNotEmpty(dept)) {
            deptId = Long.parseLong(dept.toString());
        }
        Object post = user.getExtendUserMap().get("postId");
        Long postId = 1L;
        if (HussarUtils.isNotEmpty(post)) {
            postId = Long.parseLong(post.toString());
        }
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray rolesList = null;
        if (HussarUtils.isNotEmpty(role)) {
            rolesList = JSONArray.parseArray((String)role.toString());
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper roleQueryWrapper = Wrappers.lambdaQuery();
        SysWorkstationTemplateVo commonStartUserTemplate = new SysWorkstationTemplateVo();
        queryWrapper.clear();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getTemplateType, (Object)"1")).eq(SysWorkstationTemplate::getSeeRange, (Object)commonSeeRange);
        List commonTemplates = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)commonTemplates)) {
            List collect = commonTemplates.stream().sorted(Comparator.comparing(SysWorkstationTemplate::getCreateTime)).collect(Collectors.toList());
            BeanUtils.copyProperties(collect.get(0), (Object)commonStartUserTemplate);
        } else {
            queryWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysWorkstationTemplate::getApplicationScenario, (Object)applicationScenario)).eq(SysWorkstationTemplate::getTemplateType, (Object)"1")).eq(SysWorkstationTemplate::getSeeRange, (Object)"1");
            List templates = this.sysWorkstationTemplateMapper.selectList((Wrapper)queryWrapper);
            if (templates.size() > 0) {
                List collect = templates.stream().sorted(Comparator.comparing(SysWorkstationTemplate::getCreateTime)).collect(Collectors.toList());
                for (SysWorkstationTemplate t : collect) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)roleQueryWrapper.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)t.getId())).eq(SysWorkstationTemplateRole::getPermissionId, (Object)userId)).orderByDesc(SysWorkstationTemplateRole::getCreateTime);
                    List roleTemplates1 = this.sysWorkstationTemplateRoleMapper.selectList((Wrapper)roleQueryWrapper).stream().map(SysWorkstationTemplateRole::getWorkstationTemplateId).collect(Collectors.toList());
                    if (!HussarUtils.isNotEmpty(roleTemplates1)) continue;
                    BeanUtils.copyProperties((Object)t, (Object)commonStartUserTemplate);
                }
                if (!HussarUtils.isNotEmpty((Object)commonStartUserTemplate)) {
                    for (SysWorkstationTemplate t : collect) {
                        roleQueryWrapper.clear();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)roleQueryWrapper.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)t.getId())).eq(SysWorkstationTemplateRole::getPermissionId, (Object)deptId)).orderByDesc(SysWorkstationTemplateRole::getCreateTime);
                        List roleTemplates2 = this.sysWorkstationTemplateRoleMapper.selectList((Wrapper)roleQueryWrapper).stream().map(SysWorkstationTemplateRole::getWorkstationTemplateId).collect(Collectors.toList());
                        if (roleTemplates2.size() <= 0) continue;
                        BeanUtils.copyProperties((Object)t, (Object)commonStartUserTemplate);
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)commonStartUserTemplate)) {
                    for (SysWorkstationTemplate t : collect) {
                        roleQueryWrapper.clear();
                        for (Object r : rolesList) {
                            r = Long.parseLong(r.toString());
                            roleQueryWrapper.clear();
                            ((LambdaQueryWrapper)((LambdaQueryWrapper)roleQueryWrapper.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)t.getId())).eq(SysWorkstationTemplateRole::getPermissionId, r)).orderByDesc(SysWorkstationTemplateRole::getCreateTime);
                            List roleTemplates3 = this.sysWorkstationTemplateRoleMapper.selectList((Wrapper)roleQueryWrapper).stream().map(SysWorkstationTemplateRole::getWorkstationTemplateId).collect(Collectors.toList());
                            if (roleTemplates3.size() <= 0) continue;
                            BeanUtils.copyProperties((Object)t, (Object)commonStartUserTemplate);
                        }
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)commonStartUserTemplate)) {
                    for (SysWorkstationTemplate t : collect) {
                        roleQueryWrapper.clear();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)roleQueryWrapper.eq(SysWorkstationTemplateRole::getWorkstationTemplateId, (Object)t.getId())).eq(SysWorkstationTemplateRole::getPermissionId, (Object)postId)).orderByDesc(SysWorkstationTemplateRole::getCreateTime);
                        List roleTemplates4 = this.sysWorkstationTemplateRoleMapper.selectList((Wrapper)roleQueryWrapper).stream().map(SysWorkstationTemplateRole::getWorkstationTemplateId).collect(Collectors.toList());
                        if (roleTemplates4.size() <= 0) continue;
                        BeanUtils.copyProperties((Object)t, (Object)commonStartUserTemplate);
                    }
                }
            }
        }
        return commonStartUserTemplate;
    }
}

