/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationAssemblyAttrMapper;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationAssemblyMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysWorkstationAssemblyDto;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationAssembly;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationAssemblyAttr;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationAssemblyGroup;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyAttrService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyGroupService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyRoleService;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyService;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationAssemblyGroupVo;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationAssemblyVo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysWorkstationAssemblyServiceImpl")
public class SysWorkstationAssemblyServiceImpl
extends HussarServiceImpl<SysWorkstationAssemblyMapper, SysWorkstationAssembly>
implements ISysWorkstationAssemblyService {
    @Autowired
    private ISysWorkstationAssemblyGroupService sysWorkstationAssemblyGroupService;
    @Resource
    private SysWorkstationAssemblyAttrMapper sysWorkstationAssemblyAttrMapper;
    @Resource
    private SysWorkstationAssemblyMapper sysWorkstationAssemblyMapper;
    @Autowired
    private ISysWorkstationAssemblyAttrService sysWorkstationAssemblyAttrService;
    @Autowired
    private ISysWorkstationAssemblyRoleService sysWorkstationAssemblyRoleService;
    private static final Long powerAdminRole = 736624401344372736L;
    private static final Long tenantAdminRole = 1450785135866925168L;

    public SysWorkstationAssemblyVo saveAssembly(SysWorkstationAssemblyDto sysWorkstationAssemblyDto) {
        SysWorkstationAssembly sysWorkstationAssembly = new SysWorkstationAssembly();
        BeanUtils.copyProperties((Object)sysWorkstationAssemblyDto, (Object)sysWorkstationAssembly);
        SecurityUser user = BaseSecurityUtil.getUser();
        sysWorkstationAssembly.setCreator(user.getUserId());
        sysWorkstationAssembly.setCreateTime(LocalDateTime.now());
        sysWorkstationAssembly.setLastEditor(user.getUserId());
        sysWorkstationAssembly.setLastTime(LocalDateTime.now());
        this.sysWorkstationAssemblyMapper.insert(sysWorkstationAssembly);
        List waaList = sysWorkstationAssemblyDto.getWaaList();
        ArrayList<SysWorkstationAssemblyAttr> waaListNew = new ArrayList<SysWorkstationAssemblyAttr>();
        if (HussarUtils.isNotEmpty((Object)waaList)) {
            for (SysWorkstationAssemblyAttr waa : waaList) {
                waa.setAssemblyId(sysWorkstationAssembly.getId());
                waaListNew.add(waa);
            }
            this.sysWorkstationAssemblyAttrService.saveBatch(waaListNew);
        }
        SysWorkstationAssemblyVo sysWorkstationAssemblyVo = new SysWorkstationAssemblyVo();
        BeanUtils.copyProperties((Object)sysWorkstationAssembly, (Object)sysWorkstationAssemblyVo);
        sysWorkstationAssemblyVo.setWaaList(waaListNew);
        return sysWorkstationAssemblyVo;
    }

    public SysWorkstationAssemblyVo updateAssembly(SysWorkstationAssemblyDto sysWorkstationAssemblyDto) {
        SysWorkstationAssembly sysWorkstationAssembly = new SysWorkstationAssembly();
        BeanUtils.copyProperties((Object)sysWorkstationAssemblyDto, (Object)sysWorkstationAssembly);
        this.sysWorkstationAssemblyMapper.updateById(sysWorkstationAssembly);
        List waaList = sysWorkstationAssemblyDto.getWaaList();
        ArrayList<SysWorkstationAssemblyAttr> waaListNew = new ArrayList<SysWorkstationAssemblyAttr>();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (HussarUtils.isNotEmpty((Object)waaList)) {
            queryWrapper.eq(SysWorkstationAssemblyAttr::getAssemblyId, (Object)sysWorkstationAssemblyDto.getId());
            this.sysWorkstationAssemblyAttrService.remove((Wrapper)queryWrapper);
            for (SysWorkstationAssemblyAttr waa : waaList) {
                waa.setId(null);
                waa.setAssemblyId(sysWorkstationAssembly.getId());
                waaListNew.add(waa);
            }
            this.sysWorkstationAssemblyAttrService.saveBatch(waaListNew);
        }
        SysWorkstationAssemblyVo sysWorkstationAssemblyVo = new SysWorkstationAssemblyVo();
        BeanUtils.copyProperties((Object)sysWorkstationAssembly, (Object)sysWorkstationAssemblyVo);
        sysWorkstationAssemblyVo.setWaaList(waaListNew);
        return sysWorkstationAssemblyVo;
    }

    public IPage<SysWorkstationAssemblyVo> listAssembly(Page<SysWorkstationAssemblyVo> page, Long groupId, String assemblyName, String applicationScenario) {
        String replaceName = assemblyName.replaceAll("\\\\", "\\\\\\\\").replace("'", "\\'").replace("_", "\\_").replace("%", "\\%").replace("*", "\\*");
        List<SysWorkstationAssemblyVo> waVoList = this.sysWorkstationAssemblyMapper.listAssembly(page, groupId, replaceName, applicationScenario);
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        for (SysWorkstationAssemblyVo wa : waVoList) {
            queryWrapper1.eq(SysWorkstationAssemblyAttr::getAssemblyId, (Object)wa.getId());
            List list = this.sysWorkstationAssemblyAttrService.list((Wrapper)queryWrapper1);
            wa.setWaaList(list);
        }
        return page.setRecords(waVoList);
    }

    /*
     * WARNING - void declaration
     */
    public List<SysWorkstationAssemblyVo> listAssemblyNew(String applicationScenario) {
        ArrayList<SysWorkstationAssemblyVo> waVoList = new ArrayList<SysWorkstationAssemblyVo>();
        SecurityUser user = BaseSecurityUtil.getUser();
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray rolesList = null;
        rolesList = HussarUtils.isNotEmpty(role) ? JSONArray.parseArray((String)role.toString()) : new JSONArray();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        LambdaQueryWrapper queryWrapper1 = Wrappers.lambdaQuery();
        List groupList = this.sysWorkstationAssemblyGroupService.listAssemblyGroupByType(applicationScenario);
        List groupIds = groupList.stream().map(SysWorkstationAssemblyGroup::getId).collect(Collectors.toList());
        if (HussarUtils.isEmpty((Object)groupList)) {
            return new ArrayList<SysWorkstationAssemblyVo>();
        }
        ((LambdaQueryWrapper)queryWrapper.in(SysWorkstationAssembly::getGroupId, groupIds)).eq(SysWorkstationAssembly::getApplyFlag, (Object)"1");
        List assemblyList = this.list((Wrapper)queryWrapper);
        if (!(user.getAccount().equals("superadmin") || rolesList.contains((Object)powerAdminRole) || rolesList.contains((Object)tenantAdminRole))) {
            List<SysWorkstationAssembly> commonAssemblyList;
            Map<String, List<SysWorkstationAssembly>> assemblyMap;
            List<SysWorkstationAssembly> exclusiveAssemblyList;
            Object dept = user.getExtendUserMap().get("deptId");
            String string = "";
            if (HussarUtils.isNotEmpty(dept)) {
                String string2 = dept.toString();
            }
            Object post = user.getExtendUserMap().get("postId");
            String postId = "";
            if (HussarUtils.isNotEmpty(post)) {
                postId = post.toString();
            }
            if (null != (exclusiveAssemblyList = (assemblyMap = assemblyList.stream().sorted(Comparator.comparing(SysWorkstationAssembly::getCreateTime)).collect(Collectors.groupingBy(SysWorkstationAssembly::getSeeRange))).get("0"))) {
                for (SysWorkstationAssembly wa : exclusiveAssemblyList) {
                    SysWorkstationAssemblyVo vo = new SysWorkstationAssemblyVo();
                    BeanUtils.copyProperties((Object)wa, (Object)vo);
                    waVoList.add(vo);
                }
            }
            if (null != (commonAssemblyList = assemblyMap.get("1"))) {
                for (SysWorkstationAssembly wa : commonAssemblyList) {
                    void var12_14;
                    List roleList = this.sysWorkstationAssemblyRoleService.loadAssemblyRoleByAssemblyId(wa.getId());
                    if (roleList.size() == 0) continue;
                    long count = roleList.stream().filter(r -> r.getTypes().equals("0") && r.getPermissionId().equals(user.getId().toString())).count();
                    if (count > 0L) {
                        SysWorkstationAssemblyVo vo = new SysWorkstationAssemblyVo();
                        BeanUtils.copyProperties((Object)wa, (Object)vo);
                        waVoList.add(vo);
                        continue;
                    }
                    void finalDeptId = var12_14;
                    long count1 = roleList.stream().filter(arg_0 -> SysWorkstationAssemblyServiceImpl.lambda$listAssemblyNew$1((String)finalDeptId, arg_0)).count();
                    if (count1 > 0L) {
                        SysWorkstationAssemblyVo vo = new SysWorkstationAssemblyVo();
                        BeanUtils.copyProperties((Object)wa, (Object)vo);
                        waVoList.add(vo);
                        continue;
                    }
                    if (null != rolesList) {
                        boolean flag = false;
                        for (Object rr : rolesList) {
                            long count2 = roleList.stream().filter(r -> r.getTypes().equals("1") && r.getPermissionId().equals(rr.toString())).count();
                            if (count2 <= 0L) continue;
                            SysWorkstationAssemblyVo vo = new SysWorkstationAssemblyVo();
                            BeanUtils.copyProperties((Object)wa, (Object)vo);
                            waVoList.add(vo);
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                    }
                    String finalPostId = postId;
                    long count3 = roleList.stream().filter(r -> r.getTypes().equals("3") && r.getPermissionId().equals(finalPostId)).count();
                    if (count3 <= 0L) continue;
                    SysWorkstationAssemblyVo vo = new SysWorkstationAssemblyVo();
                    BeanUtils.copyProperties((Object)wa, (Object)vo);
                    waVoList.add(vo);
                }
            }
        } else {
            for (SysWorkstationAssembly sysWorkstationAssembly : assemblyList) {
                SysWorkstationAssemblyVo vo = new SysWorkstationAssemblyVo();
                BeanUtils.copyProperties((Object)sysWorkstationAssembly, (Object)vo);
                waVoList.add(vo);
            }
        }
        for (SysWorkstationAssemblyVo sysWorkstationAssemblyVo : waVoList) {
            queryWrapper1.clear();
            queryWrapper1.eq(SysWorkstationAssemblyAttr::getAssemblyId, (Object)sysWorkstationAssemblyVo.getId());
            List list = this.sysWorkstationAssemblyAttrService.list((Wrapper)queryWrapper1);
            sysWorkstationAssemblyVo.setWaaList(list);
        }
        return waVoList;
    }

    public ApiResponse fuzzyQueryAssembly(String applicationScenario, String assemblyName) {
        List groupList = this.sysWorkstationAssemblyGroupService.listAssemblyGroupByType(applicationScenario);
        List<SysWorkstationAssemblyVo> list = this.listAssemblyNew(applicationScenario);
        ArrayList<SysWorkstationAssemblyGroupVo> groupListNew = new ArrayList<SysWorkstationAssemblyGroupVo>();
        if (HussarUtils.isNotEmpty((Object)groupList)) {
            for (SysWorkstationAssemblyGroup group : groupList) {
                SysWorkstationAssemblyGroupVo groupVo = new SysWorkstationAssemblyGroupVo();
                BeanUtils.copyProperties((Object)group, (Object)groupVo);
                List collect = list.stream().filter(r -> r.getAssemblyName().contains(assemblyName) && r.getGroupId().equals(group.getId())).collect(Collectors.toList());
                groupVo.setWa(collect);
                groupListNew.add(groupVo);
            }
        }
        return ApiResponse.success(groupListNew);
    }

    public ApiResponse getAssemblyById(Long assemblyId) {
        SysWorkstationAssemblyVo assemblyVo = new SysWorkstationAssemblyVo();
        SysWorkstationAssembly assembly = (SysWorkstationAssembly)this.getById(assemblyId);
        BeanUtils.copyProperties((Object)assembly, (Object)assemblyVo);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationAssemblyAttr::getAssemblyId, (Object)assemblyId);
        List attributes = this.sysWorkstationAssemblyAttrMapper.selectList((Wrapper)queryWrapper);
        assemblyVo.setWaaList(attributes);
        return ApiResponse.success((Object)assemblyVo);
    }

    public ApiResponse deleteAssemblyById(String assemblyId) {
        this.removeById((Serializable)((Object)assemblyId));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationAssemblyAttr::getAssemblyId, (Object)Long.parseLong(assemblyId));
        this.sysWorkstationAssemblyAttrMapper.delete((Wrapper)queryWrapper);
        return ApiResponse.success();
    }

    public boolean loadUserAssemblyPower(Long assemblyId) {
        boolean flag = false;
        SecurityUser user = BaseSecurityUtil.getUser();
        Object role = user.getExtendUserMap().get("rolesList");
        JSONArray rolesList = null;
        rolesList = HussarUtils.isNotEmpty(role) ? JSONArray.parseArray((String)role.toString()) : new JSONArray();
        SysWorkstationAssembly sysWorkstationAssembly = (SysWorkstationAssembly)this.getById(assemblyId);
        if (HussarUtils.isNotEmpty((Object)sysWorkstationAssembly)) {
            if ("0".equals(sysWorkstationAssembly.getApplyFlag())) {
                flag = false;
            } else {
                String seeRange = sysWorkstationAssembly.getSeeRange();
                if (!(user.getAccount().equals("superadmin") || rolesList.contains((Object)powerAdminRole) || rolesList.contains((Object)tenantAdminRole))) {
                    List roleList;
                    Object dept = user.getExtendUserMap().get("deptId");
                    String deptId = "";
                    if (HussarUtils.isNotEmpty(dept)) {
                        deptId = dept.toString();
                    }
                    Object post = user.getExtendUserMap().get("postId");
                    String postId = "";
                    if (HussarUtils.isNotEmpty(post)) {
                        postId = post.toString();
                    }
                    if (seeRange.equals("0")) {
                        flag = true;
                    } else if (seeRange.equals("1") && (roleList = this.sysWorkstationAssemblyRoleService.loadAssemblyRoleByAssemblyId(assemblyId)).size() > 0) {
                        long count;
                        if (!flag && (count = roleList.stream().filter(r -> r.getTypes().equals("0") && r.getPermissionId().equals(user.getId().toString())).count()) > 0L) {
                            flag = true;
                        }
                        if (!flag) {
                            String finalDeptId = deptId;
                            long count1 = roleList.stream().filter(r -> r.getTypes().equals("2") && r.getPermissionId().equals(finalDeptId)).count();
                            if (count1 > 0L) {
                                flag = true;
                            }
                        }
                        if (!flag && null != rolesList) {
                            for (Object rr : rolesList) {
                                long count2 = roleList.stream().filter(r -> r.getTypes().equals("1") && r.getPermissionId().equals(rr.toString())).count();
                                if (count2 <= 0L) continue;
                                flag = true;
                                break;
                            }
                        }
                        if (!flag) {
                            String finalPostId = postId;
                            long count3 = roleList.stream().filter(r -> r.getTypes().equals("3") && r.getPermissionId().equals(finalPostId)).count();
                            if (count3 > 0L) {
                                flag = true;
                            }
                        }
                    }
                } else {
                    flag = true;
                }
            }
        }
        return flag;
    }
}

