/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.post.vo.OrganPostTreeVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationTemplateSearchMapper;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationTemplateSearchService;
import com.jxdinfo.hussar.workstation.config.vo.SysWorkstationTemplateRoleSearchVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysWorkstationTemplateSearchServiceImpl")
public class SysWorkstationTemplateSearchServiceImpl
implements ISysWorkstationTemplateSearchService {
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private SysWorkstationTemplateSearchMapper templateSearchMapper;
    @Autowired
    private IHussarBasePostService hussarBasePostService;
    @Autowired
    private ISysStruPostService sysStruPostService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysRoleGroupService sysRoleGroupService;

    public List<OrganizationTreeVo> organSearch(String name) {
        List<OrganUserTreeVo> organUserTreeOnlyOrgan = this.templateSearchMapper.getOrganUserTreeOnlyOrgan(null, name);
        List organizationTreeVos = HussarUtils.copy(organUserTreeOnlyOrgan, OrganizationTreeVo.class);
        return HussarTreeParser.getTreeList((Collection)organizationTreeVos);
    }

    public List<SysWorkstationTemplateRoleSearchVo> roleSearch(String name) {
        ArrayList<SysWorkstationTemplateRoleSearchVo> roleSearchVoList = new ArrayList<SysWorkstationTemplateRoleSearchVo>();
        List sysRoles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().like(SysRoles::getRoleName, (Object)name));
        if (HussarUtils.isNotEmpty((Object)sysRoles)) {
            Set<Long> roleGroupIds = this.wrapRoleInfo(sysRoles, roleSearchVoList);
            this.wrapRoleGroup(roleGroupIds, roleSearchVoList);
        }
        List roleSearchVos = HussarTreeParser.getTreeList(roleSearchVoList);
        for (SysWorkstationTemplateRoleSearchVo roleSearchVo : roleSearchVos) {
            this.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)roleSearchVo);
        }
        return roleSearchVos;
    }

    public List<OrganPostTreeVo> organPostSearch(String name) {
        ArrayList<OrganPostTreeVo> organPostTreeVoList = new ArrayList<OrganPostTreeVo>();
        List sysPosts = this.hussarBasePostService.list((Wrapper)new LambdaQueryWrapper().like(SysPost::getPostName, (Object)name));
        if (HussarUtils.isNotEmpty((Object)sysPosts)) {
            Map<Long, String> postMaps = sysPosts.stream().collect(Collectors.toMap(SysPost::getId, SysPost::getPostName));
            List<Long> postIds = this.wrapPostInfo(postMaps, organPostTreeVoList);
            this.wrapOrganPostInfo(postIds, organPostTreeVoList);
        }
        List organPostTreeVos = HussarTreeParser.getTreeList(organPostTreeVoList);
        for (OrganPostTreeVo organPostTreeVo : organPostTreeVos) {
            this.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)organPostTreeVo);
        }
        return organPostTreeVos;
    }

    public List<OrganUserTreeVo> organUserSearch(String name) {
        ArrayList<OrganUserTreeVo> organUserTreeVoList = new ArrayList<OrganUserTreeVo>();
        List sysUsers = this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(SysUsers::getUserName, (Object)name)).eq(SysUsers::getAccountStatus, (Object)"1")).ne(SysUsers::getIsSys, (Object)"1"));
        if (HussarUtils.isNotEmpty((Object)sysUsers)) {
            Map<Long, String> userMaps = sysUsers.stream().collect(Collectors.toMap(SysUsers::getId, SysUsers::getUserName));
            List<Long> userIds = this.wrapUserInfo(userMaps, organUserTreeVoList);
            this.wrapOrganUserInfo(userIds, organUserTreeVoList);
        }
        List organUserTreeVos = HussarTreeParser.getTreeList(organUserTreeVoList);
        for (OrganUserTreeVo organUserTreeVo : organUserTreeVos) {
            this.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)organUserTreeVo);
        }
        return organUserTreeVos;
    }

    public Set<Long> wrapRoleInfo(List<SysRoles> sysRoles, List<SysWorkstationTemplateRoleSearchVo> roleSearchVoList) {
        HashSet<Long> roleGroupIds = new HashSet<Long>();
        for (SysRoles sysRole : sysRoles) {
            SysWorkstationTemplateRoleSearchVo roleSearchVo = new SysWorkstationTemplateRoleSearchVo();
            roleSearchVo.setId((Serializable)sysRole.getId());
            roleSearchVo.setParentId((Serializable)sysRole.getGroupId());
            roleSearchVo.setLabel(sysRole.getRoleName());
            roleSearchVo.setHasChildren(Boolean.FALSE);
            roleSearchVoList.add(roleSearchVo);
            roleGroupIds.add(sysRole.getGroupId());
        }
        return roleGroupIds;
    }

    public void wrapRoleGroup(Set<Long> roleGroupIds, List<SysWorkstationTemplateRoleSearchVo> roleSearchVoList) {
        List sysRoleGroups = this.sysRoleGroupService.list((Wrapper)new LambdaQueryWrapper().in(SysRoleGroup::getId, roleGroupIds));
        for (SysRoleGroup sysRoleGroup : sysRoleGroups) {
            SysWorkstationTemplateRoleSearchVo roleGroupSearchVo = new SysWorkstationTemplateRoleSearchVo();
            roleGroupSearchVo.setId((Serializable)sysRoleGroup.getId());
            roleGroupSearchVo.setLabel(sysRoleGroup.getGroupName());
            roleGroupSearchVo.setHasChildren(Boolean.TRUE);
            roleSearchVoList.add(roleGroupSearchVo);
        }
    }

    public List<Long> wrapPostInfo(Map<Long, String> postMaps, List<OrganPostTreeVo> organPostTreeVoList) {
        ArrayList<Long> postIds = new ArrayList<Long>();
        for (Map.Entry<Long, String> postMap : postMaps.entrySet()) {
            List sysStruPosts = this.sysStruPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postMap.getKey()));
            if (HussarUtils.isNotEmpty((Object)sysStruPosts)) {
                List struIds = sysStruPosts.stream().map(SysStruPost::getStruId).collect(Collectors.toList());
                for (Long struId : struIds) {
                    OrganPostTreeVo organPostTreeVo = new OrganPostTreeVo();
                    organPostTreeVo.setId((Serializable)postMap.getKey());
                    organPostTreeVo.setLabel(postMap.getValue());
                    organPostTreeVo.setParentId((Serializable)struId);
                    organPostTreeVo.setTypes("post");
                    organPostTreeVo.setHasChildren(Boolean.valueOf(false));
                    organPostTreeVoList.add(organPostTreeVo);
                }
            } else {
                OrganPostTreeVo organPostTreeVo = new OrganPostTreeVo();
                organPostTreeVo.setId((Serializable)postMap.getKey());
                organPostTreeVo.setLabel(postMap.getValue());
                organPostTreeVo.setParentId((Serializable)Long.valueOf(13L));
                organPostTreeVo.setTypes("post");
                organPostTreeVo.setHasChildren(Boolean.valueOf(false));
                organPostTreeVoList.add(organPostTreeVo);
                OrganPostTreeVo organPostTreeVo3 = new OrganPostTreeVo();
                organPostTreeVo3.setId((Serializable)Long.valueOf(13L));
                organPostTreeVo3.setLabel("\u672a\u5173\u8054\u7ec4\u7ec7\u5c97\u4f4d");
                organPostTreeVo3.setTypes("organ");
                organPostTreeVoList.add(organPostTreeVo3);
            }
            postIds.add(postMap.getKey());
        }
        return postIds;
    }

    public void wrapOrganPostInfo(List<Long> postIds, List<OrganPostTreeVo> organPostTreeVoList) {
        List sysStruPosts = this.sysStruPostService.list((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getPostId, postIds));
        if (HussarUtils.isNotEmpty((Object)sysStruPosts)) {
            List<Long> struIds = sysStruPosts.stream().map(SysStruPost::getStruId).distinct().collect(Collectors.toList());
            List<OrganUserTreeVo> organUserTreeOnlyOrgan = this.templateSearchMapper.getOrganUserTreeOnlyOrgan(struIds, null);
            List organPostTreeVos = HussarUtils.copy(organUserTreeOnlyOrgan, OrganPostTreeVo.class);
            List interiorOrganList = organUserTreeOnlyOrgan.stream().filter(o -> HussarUtils.equals((Object)o.getParentId(), (Object)11L)).collect(Collectors.toList());
            List outerOrganList = organUserTreeOnlyOrgan.stream().filter(o -> HussarUtils.equals((Object)o.getParentId(), (Object)12L)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(interiorOrganList)) {
                OrganPostTreeVo organPostTreeVo1 = new OrganPostTreeVo();
                organPostTreeVo1.setId((Serializable)Long.valueOf(11L));
                organPostTreeVo1.setLabel("\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7");
                organPostTreeVo1.setTypes("organ");
                organPostTreeVoList.add(organPostTreeVo1);
            }
            if (HussarUtils.isNotEmpty(outerOrganList)) {
                OrganPostTreeVo organPostTreeVo2 = new OrganPostTreeVo();
                organPostTreeVo2.setId((Serializable)Long.valueOf(12L));
                organPostTreeVo2.setLabel("\u516c\u53f8\u5916\u90e8\u7ec4\u7ec7");
                organPostTreeVo2.setTypes("organ");
                organPostTreeVoList.add(organPostTreeVo2);
            }
            organPostTreeVoList.addAll(organPostTreeVos);
        }
    }

    public List<Long> wrapUserInfo(Map<Long, String> userMaps, List<OrganUserTreeVo> organUserTreeVoList) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (Map.Entry<Long, String> userMap : userMaps.entrySet()) {
            List struIds = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userMap.getKey())).stream().map(SysStruUser::getStruId).collect(Collectors.toList());
            for (Long struId : struIds) {
                OrganUserTreeVo organUserTreeVo = new OrganUserTreeVo();
                organUserTreeVo.setId((Serializable)userMap.getKey());
                organUserTreeVo.setLabel(userMap.getValue());
                organUserTreeVo.setParentId((Serializable)struId);
                organUserTreeVo.setTypes("user");
                organUserTreeVo.setHasChildren(Boolean.valueOf(false));
                organUserTreeVoList.add(organUserTreeVo);
            }
            userIds.add(userMap.getKey());
        }
        return userIds;
    }

    public void wrapOrganUserInfo(List<Long> userIds, List<OrganUserTreeVo> organUserTreeVoList) {
        List<Long> struIds = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds)).stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        List<OrganUserTreeVo> organUserTreeOnlyOrgan = this.templateSearchMapper.getOrganUserTreeOnlyOrgan(struIds, null);
        List interiorOrganList = organUserTreeOnlyOrgan.stream().filter(o -> HussarUtils.equals((Object)o.getParentId(), (Object)11L)).collect(Collectors.toList());
        List outerOrganList = organUserTreeOnlyOrgan.stream().filter(o -> HussarUtils.equals((Object)o.getParentId(), (Object)12L)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(interiorOrganList)) {
            OrganUserTreeVo organUserTreeVo1 = new OrganUserTreeVo();
            organUserTreeVo1.setId((Serializable)Long.valueOf(11L));
            organUserTreeVo1.setLabel("\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7");
            organUserTreeVo1.setTypes("organ");
            organUserTreeVoList.add(organUserTreeVo1);
        }
        if (HussarUtils.isNotEmpty(outerOrganList)) {
            OrganUserTreeVo organUserTreeVo2 = new OrganUserTreeVo();
            organUserTreeVo2.setId((Serializable)Long.valueOf(12L));
            organUserTreeVo2.setLabel("\u516c\u53f8\u5916\u90e8\u7ec4\u7ec7");
            organUserTreeVo2.setTypes("organ");
            organUserTreeVoList.add(organUserTreeVo2);
        }
        organUserTreeVoList.addAll(organUserTreeOnlyOrgan);
    }

    public void fillHasChildren(AbstractNoIconHussarLazyTreeDefinition hussarLazyTreeDefinition) {
        if (HussarUtils.isNotEmpty((Object)hussarLazyTreeDefinition.getChildren())) {
            hussarLazyTreeDefinition.setHasChildren(Boolean.TRUE);
            for (Object child : hussarLazyTreeDefinition.getChildren()) {
                this.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)child);
            }
        } else {
            hussarLazyTreeDefinition.setHasChildren(Boolean.FALSE);
        }
    }
}

