/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostBoService;
import com.jxdinfo.hussar.authorization.post.vo.PostBasicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workstation.config.dao.SysWorkstationAssemblyRoleMapper;
import com.jxdinfo.hussar.workstation.config.model.SysWorkstationAssemblyRole;
import com.jxdinfo.hussar.workstation.config.service.ISysWorkstationAssemblyRoleService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysWorkstationAssemblyRoleServiceImpl")
public class SysWorkstationAssemblyRoleServiceImpl
extends HussarServiceImpl<SysWorkstationAssemblyRoleMapper, SysWorkstationAssemblyRole>
implements ISysWorkstationAssemblyRoleService {
    @Autowired
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Autowired
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Autowired
    private ISysRolesExternalService sysRolesExternalService;
    @Autowired
    private IHussarBasePostBoService hussarBasePostBoService;

    public ApiResponse insertOrUpdate(List<SysWorkstationAssemblyRole> roleList) {
        if (HussarUtils.isNotEmpty(roleList)) {
            Long assemblyId = roleList.get(0).getAssemblyId();
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysWorkstationAssemblyRole::getAssemblyId, (Object)assemblyId);
            this.remove((Wrapper)queryWrapper);
        }
        ArrayList<SysWorkstationAssemblyRole> roleListNew = new ArrayList<SysWorkstationAssemblyRole>();
        for (SysWorkstationAssemblyRole role : roleList) {
            if (!HussarUtils.isNotEmpty((Object)role.getPermissionId())) continue;
            roleListNew.add(role);
        }
        this.saveBatch(roleListNew);
        return ApiResponse.success();
    }

    public List<SysWorkstationAssemblyRole> loadAssemblyRoleByAssemblyId(Long assemblyId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysWorkstationAssemblyRole::getAssemblyId, (Object)assemblyId);
        List roleList = this.list((Wrapper)queryWrapper);
        ArrayList powerList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)roleList)) {
            List<SysWorkstationAssemblyRole> sysWorkstationAssemblyRoles;
            Map<String, List<SysWorkstationAssemblyRole>> roleMap = roleList.stream().collect(Collectors.groupingBy(SysWorkstationAssemblyRole::getTypes));
            roleList.clear();
            if (HussarUtils.isNotEmpty(roleMap.get("0"))) {
                try {
                    List userIds = roleMap.get("0").stream().map(SysWorkstationAssemblyRole::getPermissionId).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(userIds)) {
                        Map map = this.hussarBaseUserBoService.getUserInfo(userIds);
                        sysWorkstationAssemblyRoles = this.comparePersonList(roleMap.get("0"), map);
                        roleList.addAll(sysWorkstationAssemblyRoles);
                    }
                }
                catch (Exception e) {
                    System.out.println("\u7ec4\u4ef6\u6388\u6743\u7528\u6237\u67e5\u8be2\u5931\u8d25\uff01");
                }
            }
            if (HussarUtils.isNotEmpty(roleMap.get("1"))) {
                try {
                    List identitys = roleMap.get("1").stream().map(SysWorkstationAssemblyRole::getPermissionId).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(identitys)) {
                        List roleInfoByIds = this.sysRolesExternalService.getRoleInfoByIds(identitys);
                        sysWorkstationAssemblyRoles = this.compareRoleList(roleMap.get("1"), roleInfoByIds);
                        roleList.addAll(sysWorkstationAssemblyRoles);
                    }
                }
                catch (Exception e) {
                    System.out.println("\u7ec4\u4ef6\u6388\u6743\u89d2\u8272\u67e5\u8be2\u5931\u8d25\uff01");
                }
            }
            if (HussarUtils.isNotEmpty(roleMap.get("2"))) {
                try {
                    List organIds = roleMap.get("2").stream().map(SysWorkstationAssemblyRole::getPermissionId).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(organIds)) {
                        List organList = this.hussarBaseOrganizationBoService.getSimpleOrganByIds(organIds);
                        sysWorkstationAssemblyRoles = this.compareOrganList(roleMap.get("2"), organList);
                        roleList.addAll(sysWorkstationAssemblyRoles);
                    }
                }
                catch (Exception e) {
                    System.out.println("\u7ec4\u4ef6\u6388\u6743\u673a\u6784\u67e5\u8be2\u5931\u8d25\uff01");
                }
            }
            if (HussarUtils.isNotEmpty(roleMap.get("3"))) {
                try {
                    List postIds = roleMap.get("3").stream().map(SysWorkstationAssemblyRole::getPermissionId).collect(Collectors.toList());
                    if (HussarUtils.isNotEmpty(postIds)) {
                        List postInfoByIds = this.hussarBasePostBoService.getPostInfoByIds(postIds);
                        sysWorkstationAssemblyRoles = this.comparePostList(roleMap.get("3"), postInfoByIds);
                        roleList.addAll(sysWorkstationAssemblyRoles);
                    }
                }
                catch (Exception e) {
                    System.out.println("\u7ec4\u4ef6\u6388\u6743\u5c97\u4f4d\u67e5\u8be2\u5931\u8d25\uff01");
                }
            }
        }
        return roleList;
    }

    private List<SysWorkstationAssemblyRole> compareOrganList(List<SysWorkstationAssemblyRole> roleList, List<OrganVo> organList) {
        if (HussarUtils.isEmpty(organList)) {
            return new ArrayList<SysWorkstationAssemblyRole>();
        }
        Map roleMap = roleList.stream().collect(Collectors.toMap(SysWorkstationAssemblyRole::getPermissionId, Function.identity()));
        Map organMap = organList.stream().collect(Collectors.toMap(OrganVo::getId, Function.identity()));
        for (Long next : roleMap.keySet()) {
            OrganVo organizationBo = (OrganVo)organMap.get(String.valueOf(next));
            if (HussarUtils.isNotEmpty((Object)organizationBo)) {
                ((SysWorkstationAssemblyRole)roleMap.get(next)).setPermissionName(organizationBo.getLabel());
                continue;
            }
            roleMap.remove(next);
        }
        List<SysWorkstationAssemblyRole> collect = roleMap.values().stream().collect(Collectors.toList());
        return collect;
    }

    private List<SysWorkstationAssemblyRole> compareRoleList(List<SysWorkstationAssemblyRole> roleList, List<RoleVo> roleInfoByIds) {
        if (HussarUtils.isEmpty(roleInfoByIds)) {
            return new ArrayList<SysWorkstationAssemblyRole>();
        }
        Map roleMap = roleList.stream().collect(Collectors.toMap(SysWorkstationAssemblyRole::getPermissionId, Function.identity()));
        Map roleInfoMap = roleInfoByIds.stream().collect(Collectors.toMap(RoleVo::getId, Function.identity()));
        for (Long next1 : roleMap.keySet()) {
            RoleVo roleVo = (RoleVo)roleInfoMap.get(next1);
            if (HussarUtils.isNotEmpty((Object)roleVo)) {
                ((SysWorkstationAssemblyRole)roleMap.get(next1)).setPermissionName(roleVo.getRoleName());
                continue;
            }
            roleMap.remove(next1);
        }
        List<SysWorkstationAssemblyRole> collect = roleMap.values().stream().collect(Collectors.toList());
        return collect;
    }

    private List<SysWorkstationAssemblyRole> comparePostList(List<SysWorkstationAssemblyRole> roleList, List<PostBasicVo> postInfoByIds) {
        if (HussarUtils.isEmpty(postInfoByIds)) {
            return new ArrayList<SysWorkstationAssemblyRole>();
        }
        Map roleMap = roleList.stream().collect(Collectors.toMap(SysWorkstationAssemblyRole::getPermissionId, Function.identity()));
        Map postMap = postInfoByIds.stream().collect(Collectors.toMap(PostBasicVo::getPostId, Function.identity()));
        for (Long next2 : roleMap.keySet()) {
            PostBasicVo postBasicVo = (PostBasicVo)postMap.get(next2);
            if (HussarUtils.isNotEmpty((Object)postBasicVo)) {
                ((SysWorkstationAssemblyRole)roleMap.get(next2)).setPermissionName(postBasicVo.getPostName());
                continue;
            }
            roleMap.remove(next2);
        }
        List<SysWorkstationAssemblyRole> collect = roleMap.values().stream().collect(Collectors.toList());
        return collect;
    }

    private List<SysWorkstationAssemblyRole> comparePersonList(List<SysWorkstationAssemblyRole> roleList, Map<Long, SysUsers> map) {
        if (HussarUtils.isEmpty(map)) {
            return new ArrayList<SysWorkstationAssemblyRole>();
        }
        Map roleMap = roleList.stream().collect(Collectors.toMap(SysWorkstationAssemblyRole::getPermissionId, Function.identity()));
        for (Long next3 : roleMap.keySet()) {
            SysUsers sysUsers = map.get(next3);
            if (HussarUtils.isNotEmpty((Object)sysUsers)) {
                ((SysWorkstationAssemblyRole)roleMap.get(next3)).setPermissionName(sysUsers.getUserName());
                continue;
            }
            roleMap.remove(next3);
        }
        List<SysWorkstationAssemblyRole> collect = roleMap.values().stream().collect(Collectors.toList());
        return collect;
    }
}

