/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workstation.config.dao.SysMobileFrameworkMapper;
import com.jxdinfo.hussar.workstation.config.dto.SysMobileFrameworkDto;
import com.jxdinfo.hussar.workstation.config.dto.SysMobileFrameworkMenuDto;
import com.jxdinfo.hussar.workstation.config.model.SysMobileFramework;
import com.jxdinfo.hussar.workstation.config.model.SysMobileFrameworkMenu;
import com.jxdinfo.hussar.workstation.config.service.ISysMobileFrameworkMenuService;
import com.jxdinfo.hussar.workstation.config.service.ISysMobileFrameworkResourceService;
import com.jxdinfo.hussar.workstation.config.service.ISysMobileFrameworkService;
import com.jxdinfo.hussar.workstation.config.vo.SysMobileFrameworkMenuVo;
import com.jxdinfo.hussar.workstation.config.vo.SysMobileFrameworkResourceVo;
import com.jxdinfo.hussar.workstation.config.vo.SysMobileFrameworkVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.workstation.config.service.impl.SysMobileFrameworkServiceImpl")
public class SysMobileFrameworkServiceImpl
extends HussarServiceImpl<SysMobileFrameworkMapper, SysMobileFramework>
implements ISysMobileFrameworkService {
    @Autowired
    private ISysMobileFrameworkMenuService sysMobileFrameworkMenuService;
    @Autowired
    private ISysMobileFrameworkResourceService sysMobileFrameworkResourceService;

    public ApiResponse insertOrUpdate(SysMobileFrameworkDto sysMobileFrameworkDto) {
        if (null == sysMobileFrameworkDto.getId()) {
            sysMobileFrameworkDto.setCreator(BaseSecurityUtil.getUser().getId());
            sysMobileFrameworkDto.setCreateTime(LocalDateTime.now());
            sysMobileFrameworkDto.setLastEditor(BaseSecurityUtil.getUser().getId());
            sysMobileFrameworkDto.setLastTime(LocalDateTime.now());
        } else {
            sysMobileFrameworkDto.setLastEditor(BaseSecurityUtil.getUser().getId());
            sysMobileFrameworkDto.setLastTime(LocalDateTime.now());
        }
        this.saveOrUpdate((BaseEntity)sysMobileFrameworkDto);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMobileFrameworkMenu::getMobileFrameworkId, (Object)sysMobileFrameworkDto.getId());
        this.sysMobileFrameworkMenuService.remove((Wrapper)wrapper);
        this.sysMobileFrameworkResourceService.deleteResourceByMenuId();
        List menuList = sysMobileFrameworkDto.getmList();
        ArrayList<SysMobileFrameworkMenuDto> menuNewList = new ArrayList<SysMobileFrameworkMenuDto>();
        if (null != menuList) {
            for (SysMobileFrameworkMenuDto menu : menuList) {
                if (null == menu.getId()) {
                    menu.setCreator(BaseSecurityUtil.getUser().getId());
                    menu.setCreateTime(LocalDateTime.now());
                    menu.setLastEditor(BaseSecurityUtil.getUser().getId());
                    menu.setLastTime(LocalDateTime.now());
                } else {
                    menu.setLastEditor(BaseSecurityUtil.getUser().getId());
                    menu.setLastTime(LocalDateTime.now());
                }
                menu.setMobileFrameworkId(sysMobileFrameworkDto.getId());
                ApiResponse apiResponse = this.sysMobileFrameworkMenuService.insertOrUpdate(menu);
                menuNewList.add((SysMobileFrameworkMenuDto)apiResponse.getData());
            }
            sysMobileFrameworkDto.setmList(menuNewList);
        }
        return ApiResponse.success((Object)sysMobileFrameworkDto);
    }

    public ApiResponse getMobileFramework() {
        List list = this.list();
        if (list.size() > 0) {
            SysMobileFramework sysMobileFramework = (SysMobileFramework)list.get(0);
            SysMobileFrameworkVo sysMobileFrameworkVo = new SysMobileFrameworkVo();
            BeanUtils.copyProperties((Object)sysMobileFramework, (Object)sysMobileFrameworkVo);
            ApiResponse response = this.sysMobileFrameworkMenuService.getMenusByFrameworkId(sysMobileFramework.getId());
            List menuList = (List)response.getData();
            ArrayList<SysMobileFrameworkMenuVo> menuVoList = new ArrayList<SysMobileFrameworkMenuVo>();
            if (HussarUtils.isNotEmpty((Object)menuList)) {
                for (SysMobileFrameworkMenu menu : menuList) {
                    SysMobileFrameworkMenuVo menuVo = new SysMobileFrameworkMenuVo();
                    BeanUtils.copyProperties((Object)menu, (Object)menuVo);
                    ApiResponse ResourceResponse = this.sysMobileFrameworkResourceService.getMobileFrameworkResource(menuVo.getId());
                    SysMobileFrameworkResourceVo resource = (SysMobileFrameworkResourceVo)ResourceResponse.getData();
                    menuVo.setSmfr(resource);
                    menuVoList.add(menuVo);
                }
            }
            sysMobileFrameworkVo.setmList(menuVoList);
            return ApiResponse.success((Object)sysMobileFrameworkVo);
        }
        return ApiResponse.success();
    }

    public ApiResponse deleteFrameworkById(Long mobileFrameworkId) {
        this.removeById(mobileFrameworkId);
        this.sysMobileFrameworkMenuService.deleteMenusByFrameworkId(mobileFrameworkId);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

