/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workstation.config.news.syseimnews.util;

import com.jxdinfo.hussar.common.constant.enums.HussarWebConstantsEnum;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.springframework.stereotype.Component;
import ws.schild.jave.Encoder;
import ws.schild.jave.EncoderException;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.AudioAttributes;
import ws.schild.jave.encode.EncodingAttributes;
import ws.schild.jave.encode.VideoAttributes;
import ws.schild.jave.encode.enums.X264_PROFILE;
import ws.schild.jave.info.MultimediaInfo;
import ws.schild.jave.process.ProcessWrapper;
import ws.schild.jave.process.ffmpeg.DefaultFFMPEGLocator;

@Component
public class FfmpegUtil {
    private static final int SAMPLING_RATE = 16000;
    private static final int SINGLE_CHANNEL = 1;

    public static MultimediaInfo getMultimediaInfo(String localPath) {
        MultimediaInfo multimediaInfo = null;
        try {
            multimediaInfo = new MultimediaObject(new File(localPath)).getInfo();
        }
        catch (EncoderException e) {
            System.out.println(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_OBTAIN_MULTI_MEDIA_FILE_INFO_ERROR.getMessage()));
            e.printStackTrace();
        }
        return multimediaInfo;
    }

    public static MultimediaInfo getMultimediaInfoFromUrl(String url) {
        MultimediaInfo multimediaInfo = null;
        try {
            multimediaInfo = new MultimediaObject(new URL(url)).getInfo();
        }
        catch (Exception e) {
            System.out.println(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_OBTAIN_MULTI_MEDIA_FILE_INFO_ERROR.getMessage()));
            e.printStackTrace();
        }
        return multimediaInfo;
    }

    public static boolean formatAudio(String url, String targetPath) {
        File target = new File(targetPath);
        try {
            MultimediaObject multimediaObject = new MultimediaObject(new URL(url));
            AudioAttributes audio = new AudioAttributes();
            audio.setSamplingRate(Integer.valueOf(16000));
            audio.setChannels(Integer.valueOf(1));
            Encoder encoder = new Encoder();
            EncodingAttributes attrs = new EncodingAttributes();
            attrs.setOutputFormat("wav");
            attrs.setAudioAttributes(audio);
            encoder.encode(multimediaObject, target, attrs);
            return true;
        }
        catch (Exception e) {
            System.out.println(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_FORMAT_AUDIO_ERROR.getMessage()));
            return false;
        }
    }

    public static boolean formatToMp4(String videoInputPath, String videoOutputPath) {
        File target = new File(videoOutputPath);
        try {
            MultimediaObject multimediaObject = new MultimediaObject(new File(videoInputPath));
            EncodingAttributes attributes = new EncodingAttributes();
            AudioAttributes audioAttributes = new AudioAttributes();
            attributes.setAudioAttributes(audioAttributes);
            VideoAttributes videoAttributes = new VideoAttributes();
            videoAttributes.setCodec("h264");
            videoAttributes.setX264Profile(X264_PROFILE.MAIN);
            attributes.setVideoAttributes(videoAttributes);
            attributes.setDecodingThreads(Runtime.getRuntime().availableProcessors() / 2);
            attributes.setEncodingThreads(Integer.valueOf(Runtime.getRuntime().availableProcessors() / 2));
            attributes.setOutputFormat("mp4");
            Encoder encoder = new Encoder();
            encoder.encode(multimediaObject, target, attributes);
            return true;
        }
        catch (Exception e) {
            System.out.println(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_FORMAT_AUDIO_ERROR.getMessage()));
            e.printStackTrace();
            return false;
        }
    }

    public static boolean getTargetThumbnail(String localPath, String targetPath) {
        try {
            ProcessWrapper ffmpeg = new DefaultFFMPEGLocator().createExecutor();
            ffmpeg.addArgument("-i");
            ffmpeg.addArgument(localPath);
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument("0");
            ffmpeg.addArgument(targetPath);
            ffmpeg.execute();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));){
                FfmpegUtil.blockFfmpeg(br);
            }
        }
        catch (IOException e) {
            System.out.println(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_OBTAIN_VIDEO_THUMB_NAIL_ERROR.getMessage()));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void blockFfmpeg(BufferedReader br) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            FfmpegUtil.doNothing(line);
        }
    }

    private static void doNothing(String line) {
        System.out.println(line);
    }

    public static boolean addSubtitle(String originVideoPath, String srtPath, String targetVideoPath) {
        try {
            ProcessWrapper ffmpeg = new DefaultFFMPEGLocator().createExecutor();
            ffmpeg.addArgument("-i");
            ffmpeg.addArgument(originVideoPath);
            ffmpeg.addArgument("-i");
            ffmpeg.addArgument(srtPath);
            ffmpeg.addArgument("-c");
            ffmpeg.addArgument("copy");
            ffmpeg.addArgument(targetVideoPath);
            ffmpeg.execute();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));){
                FfmpegUtil.blockFfmpeg(br);
            }
        }
        catch (IOException e) {
            System.out.println(TranslateUtil.getTranslateName((String)HussarWebConstantsEnum.WEB_NEWS_SUBTITLE_ADD_ERROR.getMessage()));
            e.printStackTrace();
        }
        return true;
    }

    public static void cmd() {
    }
}

