/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.upgrade.service.impl;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.config.WorkflowSnowflakeIDGenerator;
import com.jxdinfo.hussar.workflow.upgrade.cmd.WorkflowUpdateCmd;
import com.jxdinfo.hussar.workflow.upgrade.dao.WorkflowUpgradeMapper;
import com.jxdinfo.hussar.workflow.upgrade.service.WorkflowUpgradeAsyncService;
import com.jxdinfo.hussar.workflow.upgrade.service.WorkflowUpgradeService;
import com.jxdinfo.hussar.workflow.upgrade.vo.WorkflowUpgradeCountVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class WorkflowUpgradeServiceImpl
implements WorkflowUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowUpgradeServiceImpl.class);
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private WorkflowSnowflakeIDGenerator workflowSnowflakeIDGenerator;
    private WorkflowUpgradeMapper upgradeMapper;
    private WorkflowUpgradeAsyncService upgradeAsyncService;
    private ThreadPoolTaskExecutor threadPool;
    private static final int MAX_TOTAL = 50000;
    private static final int MAX_THREAD = 50;
    private static final int MAX_PROC = 100;
    private static final String RUNNING_UPGRADE_STATE = "run";
    private static final String FINISH_UPGRADE_STATE = "finish";
    protected static final Map<String, List<String>> upgradeLogInfoMap = new HashMap<String, List<String>>();

    @Autowired
    public void setWorkflowSnowflakeIDGenerator(WorkflowSnowflakeIDGenerator workflowSnowflakeIDGenerator) {
        this.workflowSnowflakeIDGenerator = workflowSnowflakeIDGenerator;
    }

    @Autowired
    public void setUpgradeMapper(WorkflowUpgradeMapper upgradeMapper) {
        this.upgradeMapper = upgradeMapper;
    }

    @Autowired
    public void setUpgradeAsyncService(WorkflowUpgradeAsyncService upgradeAsyncService) {
        this.upgradeAsyncService = upgradeAsyncService;
    }

    @Autowired
    @Qualifier(value="hussarAsyncPoolTaskExecutor")
    public void setThreadPoolTaskExecutor(ThreadPoolTaskExecutor threadPool) {
        this.threadPool = threadPool;
    }

    private void log(String upgradeLogInfoId, String message) {
        upgradeLogInfoMap.computeIfAbsent(upgradeLogInfoId, o -> new ArrayList()).add(message);
        LOGGER.info(message);
    }

    private void log(String upgradeLogInfoId, String message, Object ... arguments) {
        String logInfo = String.format(message, arguments);
        upgradeLogInfoMap.computeIfAbsent(upgradeLogInfoId, o -> new ArrayList()).add(logInfo);
        LOGGER.info(logInfo);
    }

    @Override
    public ApiResponse<?> upgradeAll(final Integer total, int threadNum, int procNum, final Integer state) {
        threadNum = Math.min(threadNum, 50);
        procNum = Math.min(procNum, 100);
        final int finalThreadNum = threadNum;
        final int finalProcNum = procNum;
        final String upgradeLogInfoId = this.workflowSnowflakeIDGenerator.getNextId();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                WorkflowUpgradeServiceImpl.this.log(upgradeLogInfoId, "\u5f00\u59cb\u83b7\u53d6\u9700\u66f4\u65b0\u6d41\u7a0b\u5b9e\u4f8b");
                String[] ids = WorkflowUpgradeServiceImpl.this.upgradeMapper.getAllBusinessId(total, state);
                long end = System.currentTimeMillis();
                WorkflowUpgradeServiceImpl.this.log(upgradeLogInfoId, "\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u6267\u884c\u5b8c\u6bd5, \u8017\u65f6: %dms, \u5171 %d \u6761\u6d41\u7a0b\u5b9e\u4f8b", new Object[]{end - start, ids.length});
                if (ids.length == 0) {
                    upgradeLogInfoMap.computeIfAbsent(upgradeLogInfoId, o -> new ArrayList()).add(null);
                    return;
                }
                WorkflowUpgradeServiceImpl.this.upgrade(upgradeLogInfoId, ids, finalThreadNum, finalProcNum);
            }
        });
        return ApiResponse.success((Object)upgradeLogInfoId, (String)ResultCode.SUCCESS.getMessage());
    }

    private void cacheAllProcess(String upgradeLogInfoId) {
        long start = System.currentTimeMillis();
        this.log(upgradeLogInfoId, "\u5f00\u59cb\u7f13\u5b58\u6d41\u7a0b\u5b9a\u4e49");
        List<String> proDefIds = this.upgradeMapper.getAllProDefId();
        for (String proDefId : proDefIds) {
            WorkflowUpdateCmd.getProcessDefinition(proDefId);
        }
        long end = System.currentTimeMillis();
        this.log(upgradeLogInfoId, "\u7f13\u5b58\u6267\u884c\u5b8c\u6bd5\uff0c\u8017\u65f6: %dms", end - start);
    }

    @HussarTokenDs
    private ApiResponse<?> upgrade(String upgradeLogInfoId, String[] ids, int threadNum, int procNum) {
        long start = System.currentTimeMillis();
        this.log(upgradeLogInfoId, "********* \u5f00\u59cb\u5347\u7ea7: \u5e76\u53d1\u6570: %d, \u6bcf\u7ebf\u7a0b\u4fee\u6539: %d\u6761\u6d41\u7a0b, \u8ba1\u5212\u5347\u7ea7: %d\u6761\u6d41\u7a0b\u5b9e\u4f8b *********", threadNum, procNum, ids.length);
        this.cacheAllProcess(upgradeLogInfoId);
        int groupNum = (int)Math.ceil((float)ids.length / (float)procNum);
        String[] businessArray = new String[groupNum];
        for (int i = 0; i < groupNum - 1; ++i) {
            businessArray[i] = String.join((CharSequence)",", Arrays.copyOfRange(ids, i * procNum, i * procNum + procNum));
        }
        businessArray[groupNum - 1] = String.join((CharSequence)",", Arrays.copyOfRange(ids, (groupNum - 1) * procNum, ids.length));
        String[][] threadArray = this.convertTo2DArray(businessArray, threadNum);
        String connName = HussarContextHolder.getConnName();
        String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        ServletRequestAttributes newServletRequestAttributes = HussarContextHolder.getNewServletRequestAttributes((String)tenantCode);
        for (int i = 0; i < threadArray.length; ++i) {
            long start1 = System.currentTimeMillis();
            this.log(upgradeLogInfoId, "\u6267\u884c\u65b0\u7ebf\u7a0b\u7ec4 %d\uff0c\u5f53\u524d\u7ebf\u7a0b\u7ec4\u5171 %d \u6761\u7ebf\u7a0b, \u5171 %d \u7ec4\u7ebf\u7a0b", i + 1, threadArray[i].length, threadArray.length);
            for (int j = 0; j < threadArray[i].length; ++j) {
                if (threadArray[i][j] == null) continue;
                this.upgradeAsyncService.updateAsync(threadArray[i][j], j + 1, procNum, connName, tenantCode, (RequestAttributes)newServletRequestAttributes);
            }
            ThreadPoolExecutor threadPoolExecutor = this.threadPool.getThreadPoolExecutor();
            while (threadPoolExecutor.getCompletedTaskCount() != threadPoolExecutor.getTaskCount()) {
            }
            long end1 = System.currentTimeMillis();
            this.log(upgradeLogInfoId, "\u7ebf\u7a0b\u7ec4 %d \u6267\u884c\u5b8c\u6210, \u8017\u65f6: %ds, \u5171 %d \u7ec4\u7ebf\u7a0b, \u5df2\u5347\u7ea7 %d \u6761\u6d41\u7a0b", i + 1, (end1 - start1) / 1000L, threadArray.length, Math.min((i + 1) * threadNum * procNum, ids.length));
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        String result = String.format("********* \u5347\u7ea7\u5b8c\u6210: \u5e76\u53d1\u6570: %d, \u6bcf\u7ebf\u7a0b\u4fee\u6539: %d\u6761\u6d41\u7a0b, \u5df2\u5347\u7ea7: %d\u6761\u6d41\u7a0b\u5b9e\u4f8b, \u8017\u65f6: %ds *********", threadNum, procNum, ids.length, time / 1000L);
        this.log(upgradeLogInfoId, result);
        this.log(upgradeLogInfoId, "\u5347\u7ea7\u7528\u65f6%dms, \u7ea6\u4e3a%ds, \u7ea6\u4e3a%d\u5206\u949f, \u7ea6\u4e3a%d\u5c0f\u65f6", time, time / 1000L, time / 1000L / 60L, time / 1000L / 60L / 60L);
        upgradeLogInfoMap.computeIfAbsent(upgradeLogInfoId, o -> new ArrayList()).add(null);
        return ApiResponse.success((String)result);
    }

    String[][] convertTo2DArray(String[] originalArray, int numColumns) {
        int numRows = (int)Math.ceil((double)originalArray.length / (double)numColumns);
        String[][] convertedArray = new String[numRows][numColumns];
        int index = 0;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numColumns && index < originalArray.length; ++col) {
                convertedArray[row][col] = originalArray[index++];
            }
        }
        if (originalArray.length % numColumns != 0) {
            convertedArray[numRows - 1] = Arrays.copyOfRange(convertedArray[numRows - 1], 0, originalArray.length % numColumns);
        }
        return convertedArray;
    }

    @Override
    public ApiResponse<?> upgradeCount() {
        WorkflowUpgradeCountVo upgradeCountVo = this.upgradeMapper.countAll();
        upgradeCountVo.prepare();
        return ApiResponse.success((Object)upgradeCountVo);
    }

    @Override
    public ApiResponse<?> upgradeLog(String upgradeLogInfoId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> logList = new ArrayList<String>();
        result.put("state", RUNNING_UPGRADE_STATE);
        List<String> list = upgradeLogInfoMap.get(upgradeLogInfoId);
        if (list == null) {
            result.put("state", FINISH_UPGRADE_STATE);
        } else {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                String logInfo = list.remove(0);
                if (logInfo == null) {
                    result.put("state", FINISH_UPGRADE_STATE);
                    upgradeLogInfoMap.remove(upgradeLogInfoId);
                    break;
                }
                logList.add(logInfo);
            }
        }
        result.put("logList", logList);
        return ApiResponse.success(result);
    }
}

