/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.upgrade.service.impl;

import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.upgrade.cmd.WorkflowUpdateCmd;
import com.jxdinfo.hussar.workflow.upgrade.service.WorkflowUpgradeAsyncService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.impl.interceptor.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class WorkflowUpgradeAsyncServiceImpl
implements WorkflowUpgradeAsyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowUpgradeAsyncServiceImpl.class);
    private final ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getBean(ProcessEngine.class);

    @Override
    @Async(value="upgradeThreadPool")
    @HussarDs(value="#connName")
    @HussarTransactional
    public void updateAsync(String businessIds, int threadNum, int procNum, String connName, String tenantCode, RequestAttributes requestAttributes) {
        HussarContextHolder.setTenant((String)connName, (String)tenantCode);
        RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
        long start = System.currentTimeMillis();
        this.processEngine.getManagementService().executeCommand((Command)new WorkflowUpdateCmd(businessIds, null));
        long end = System.currentTimeMillis();
        LOGGER.info("\u7ebf\u7a0b {} \u5347\u7ea7\u4e00\u7ec4\u6d41\u7a0b\u5b9e\u4f8b\u5b8c\u6210\uff0c\u5171\u5347\u7ea7 {} \u6761\u6d41\u7a0b, \u8017\u65f6: {}s", new Object[]{threadNum, procNum, (end - start) / 1000L});
    }
}

