/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datapushtodo.result;

import com.jxdinfo.hussar.datapushtodo.result.DataPushResultCode;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.util.ObjectUtils;

public class DataPushResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int code;
    private boolean success;
    private T data;
    private String msg;

    private DataPushResponse(DataPushResultCode dataPushResultCode) {
        this(dataPushResultCode, null, dataPushResultCode.getMessage());
    }

    private DataPushResponse(DataPushResultCode dataPushResultCode, String msg) {
        this(dataPushResultCode, null, msg);
    }

    private DataPushResponse(DataPushResultCode dataPushResultCode, T data, String msg) {
        this(dataPushResultCode.getCode(), data, msg);
    }

    public DataPushResponse() {
    }

    private DataPushResponse(int code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.success = DataPushResultCode.SUCCESS.code == code;
    }

    private static <T> DataPushResponse<T> createInstance(T data, int code, String msg) {
        DataPushResponse<T> dataPushResponse = new DataPushResponse<T>();
        dataPushResponse.setCode(code);
        dataPushResponse.setData(data);
        dataPushResponse.setMsg(msg);
        dataPushResponse.setSuccess(DataPushResultCode.SUCCESS.code == code);
        return dataPushResponse;
    }

    private static <T> DataPushResponse<T> createInstance(T data, DataPushResultCode dataPushResultCode) {
        DataPushResponse<T> dataPushResponse = new DataPushResponse<T>();
        dataPushResponse.setCode(dataPushResultCode.getCode());
        dataPushResponse.setData(data);
        dataPushResponse.setMsg(dataPushResultCode.getMessage());
        dataPushResponse.setSuccess(DataPushResultCode.SUCCESS.code == dataPushResultCode.getCode());
        return dataPushResponse;
    }

    public static boolean isSuccess(DataPushResponse<?> result) {
        return Optional.ofNullable(result).map(x -> ObjectUtils.nullSafeEquals((Object)DataPushResultCode.SUCCESS.code, (Object)x.code)).orElse(Boolean.FALSE);
    }

    public static boolean isNotSuccess(DataPushResponse<?> result) {
        return !DataPushResponse.isSuccess(result);
    }

    public static <T> DataPushResponse<T> success(T data, String msg) {
        return DataPushResponse.createInstance(data, DataPushResultCode.SUCCESS.getCode(), msg);
    }

    public static <T> DataPushResponse<T> success(T data) {
        return DataPushResponse.createInstance(data, DataPushResultCode.SUCCESS);
    }

    public static <T> DataPushResponse<T> success(int code, T data, String msg) {
        return DataPushResponse.createInstance(data, code, msg);
    }

    public static <T> DataPushResponse<T> success(String msg) {
        return DataPushResponse.createInstance(null, DataPushResultCode.SUCCESS.getCode(), msg);
    }

    public static <T> DataPushResponse<T> success() {
        return DataPushResponse.createInstance(null, DataPushResultCode.SUCCESS.getCode(), DataPushResultCode.SUCCESS.message);
    }

    public static <T> DataPushResponse<T> success(int code, String msg) {
        return DataPushResponse.createInstance(null, code, msg);
    }

    public static <T> DataPushResponse<T> success(DataPushResultCode dataPushResultCode) {
        return DataPushResponse.createInstance(null, dataPushResultCode);
    }

    public static <T> DataPushResponse<T> success(DataPushResultCode dataPushResultCode, String msg) {
        return DataPushResponse.createInstance(null, dataPushResultCode.getCode(), msg);
    }

    public static <T> DataPushResponse<T> fail(String msg) {
        return DataPushResponse.createInstance(null, DataPushResultCode.FAILURE.getCode(), msg);
    }

    public static <T> DataPushResponse<T> fail(int code, T data, String msg) {
        return DataPushResponse.createInstance(data, code, msg);
    }

    public static <T> DataPushResponse<T> fail(int code, String msg) {
        return DataPushResponse.createInstance(null, code, msg);
    }

    public static <T> DataPushResponse<T> fail(DataPushResultCode dataPushResultCode) {
        return DataPushResponse.createInstance(null, dataPushResultCode);
    }

    public static <T> DataPushResponse<T> fail(DataPushResultCode dataPushResultCode, String msg) {
        return DataPushResponse.createInstance(null, dataPushResultCode.getCode(), msg);
    }

    public static <T> DataPushResponse<T> status(boolean flag) {
        return flag ? DataPushResponse.success(DataPushResultCode.SUCCESS.getMessage()) : DataPushResponse.fail(DataPushResultCode.FAILURE.getMessage());
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

