/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.task.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.task.controller.TaskQueryController;
import com.jxdinfo.hussar.task.dao.TaskQueryMapper;
import com.jxdinfo.hussar.task.model.TaskQueryFlowProcess;
import com.jxdinfo.hussar.task.service.TaskQueryService;
import com.jxdinfo.hussar.task.vo.TaskQueryTaskVO;
import com.jxdinfo.hussar.workflow.assignee.dao.WorkflowAssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonCacheService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskQueryServiceImpl
implements TaskQueryService {
    private final Logger logger = LoggerFactory.getLogger(TaskQueryController.class);
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private static IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private ISysActExtendPropertiesService extendPropertiesService;
    @Autowired
    private WorkflowCommonCacheService workflowCommonCacheService;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private IBpmConfigService bpmConfigService;
    @Autowired
    private WorkflowAssigneeChooseMapper workflowAssigneeChooseMapper;
    @Autowired
    private TaskQueryMapper taskQueryMapper;
    @Autowired
    private IHussarBaseStaffBoService hussarBaseStaffBoService;
    private static final String TABLE_PREFIX = "table_prefix";

    public ApiResponse<Page<?>> list(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = HussarUtils.isEmpty((Object)taskManageQueryDto.getUserId()) ? String.valueOf(BaseSecurityUtil.getUser().getId()) : taskManageQueryDto.getUserId();
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskDto flowTaskDto = new FlowTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        BpmResponseResult bpmResponseResult = this.doneTaskList(flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject1 = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject1.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject1.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    private BpmResponseResult doneTaskList(FlowTaskDto flowTaskDto) {
        if (HussarUtils.isNotEmpty((Object)flowTaskDto.getTodoConfiguration())) {
            flowTaskDto.setTodoConfiguration(flowTaskDto.getTodoConfiguration().replace("%", "//%").replace("_", "//_"));
        }
        Page pages = flowTaskDto.getPage() != null && flowTaskDto.getSize() != null ? new Page(flowTaskDto.getPage().longValue(), flowTaskDto.getSize().longValue()) : new Page(1L, 10L);
        FlowTaskQueryModel flowTaskQueryModel = this.buildFlowTaskQueryModel(flowTaskDto);
        IPage doneList = (IPage)this.doneList((Page<FlowTask>)pages, flowTaskQueryModel).getData();
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)doneList.getRecords());
        jsonObject.put("count", (Object)doneList.getTotal());
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }

    public ApiResponse<Page<?>> todoList(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        String userId = taskManageQueryDto.getUserId();
        if (HussarUtils.isEmpty((Object)userId)) {
            userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        }
        String processKey = taskManageQueryDto.getProcessKey();
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        String taskType = taskManageQueryDto.getTaskType();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskDto flowTaskDto = new FlowTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setTaskType(taskType);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        BpmResponseResult bpmResponseResult = this.todoQuery(flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    private BpmResponseResult todoQuery(FlowTaskDto flowTaskDto) {
        if (HussarUtils.isNotEmpty((Object)flowTaskDto.getTodoConfiguration())) {
            flowTaskDto.setTodoConfiguration(flowTaskDto.getTodoConfiguration().replace("%", "//%").replace("_", "//_"));
        }
        Page pages = flowTaskDto.getPage() != null && flowTaskDto.getSize() != null ? new Page(flowTaskDto.getPage().longValue(), flowTaskDto.getSize().longValue()) : new Page(1L, 10L);
        if (HussarUtils.isNotEmpty((Object)flowTaskDto.getEndTime())) {
            long endTime = flowTaskDto.getEndTime().getTime() + 999L;
            Date endTimeDate = new Date(endTime);
            flowTaskDto.setEndTime(endTimeDate);
        }
        FlowTaskQueryModel flowTaskQueryModel = this.buildFlowTaskQueryModel(flowTaskDto);
        IPage todoList = (IPage)this.todoTaskList((Page<FlowTask>)pages, flowTaskQueryModel).getData();
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)todoList.getRecords());
        jsonObject.put("count", (Object)todoList.getTotal());
        jsonArray.add((Object)jsonObject);
        return InstallResult.success((JSONArray)jsonArray);
    }

    private FlowTaskQueryModel buildFlowTaskQueryModel(FlowTaskDto flowTaskDto) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
        flowTaskQueryModel.setUserId(flowTaskDto.getUserId()).setProcessKey(flowTaskDto.getProcessKey()).setDefinitionKey(flowTaskDto.getDefinitionKey()).setProcessKeys(flowTaskDto.getProcessKeys()).setBusinessIds(flowTaskDto.getBusinessIds()).setTodoConfiguration(flowTaskDto.getTodoConfiguration()).setSendUserId(flowTaskDto.getSendUserId()).setStartTime(flowTaskDto.getStartTime()).setEndTime(flowTaskDto.getEndTime()).setTaskState(flowTaskDto.getTaskState()).setTaskType(flowTaskDto.getTaskType()).setAssistInitiator(flowTaskDto.getAssistInitiator()).setMandator(flowTaskDto.getMandator()).setProcessTitle(flowTaskDto.getProcessTitle());
        return flowTaskQueryModel;
    }

    private ApiResponse<Page<TaskQueryTaskVO>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            String userId = flowTaskQueryModel.getUserId();
            if (HussarUtils.isEmpty((Object)userId)) {
                userId = flowTaskQueryModel.getMandator();
            }
            if (HussarUtils.isNotEmpty((Object)userId)) {
                securityLevel = iAssigneeChooseService.getSecurityLevel(userId, null);
            }
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        long todoTotal = this.flowTaskMapper.countDoneTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty((Object)pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty((Object)pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List doneList = this.flowTaskMapper.doneList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        HashSet<String> procDefIds = new HashSet<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
            procDefIds.add(flowTask.getProcessDefinitionId());
        }
        List allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        List extendProperties = new ArrayList();
        if (!doneList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.taskQueryMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowTaskMapper.getAllVariables(null, processInsIds);
            allVariables.addAll(this.flowTaskMapper.getAllVariables(taskIds, null));
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(SysActExtendProperties::getProcDefId, procDefIds);
            extendProperties = this.extendPropertiesService.list((Wrapper)lambdaQueryWrapper);
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, Object> extendPropertiesMap = new HashMap<String, Object>();
        for (Object sysActExtendProperties : extendProperties) {
            extendPropertiesMap.put(sysActExtendProperties.getProcDefId() + ":" + sysActExtendProperties.getTaskDefKey(), sysActExtendProperties);
        }
        HashMap<String, TaskQueryFlowProcess> processMap = new HashMap<String, TaskQueryFlowProcess>();
        for (TaskQueryFlowProcess taskQueryFlowProcess : processList) {
            processMap.put(taskQueryFlowProcess.getProcessInsId(), taskQueryFlowProcess);
        }
        for (FlowTask flowTask : doneList) {
            SysActExtendProperties formDetailKeyMsg = (SysActExtendProperties)extendPropertiesMap.get(flowTask.getProcessDefinitionId() + ":" + flowTask.getTaskDefinitionKey());
            if (formDetailKeyMsg != null) {
                if ("2".equals(flowTask.getTaskType())) {
                    flowTask.setFormDetail(formDetailKeyMsg.getAssistFormDetailKey());
                } else {
                    flowTask.setFormDetail(formDetailKeyMsg.getFormDetailKey());
                }
            }
            flowTask.setTaskVariables(taskVariablesMap.get(flowTask.getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            TaskQueryFlowProcess flowProcess = (TaskQueryFlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
            if (!HussarUtils.isEmpty((Object)flowTask.getProcessTitle())) continue;
            flowTask.setProcessTitle(flowProcess.getProcessTitle());
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, processMap));
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)page.getRecords(), TaskQueryTaskVO.class).translate(TaskQueryTaskVO::getTaskNameTranslateKey, TaskQueryTaskVO::setTaskDefinitionName).translate(TaskQueryTaskVO::getProcNameTranslateKey, TaskQueryTaskVO::setProcessName).execute();
        return ApiResponse.success((Object)page);
    }

    private List<TaskQueryTaskVO> hisTasksToVo(List<FlowTask> lists, Map<String, TaskQueryFlowProcess> processMap) {
        ArrayList<String> userList = new ArrayList<String>();
        userList.add("1450756958461300737");
        userList.add("1450757481235202050");
        userList.add("1450757527330615298");
        userList.add("1450757567465828354");
        userList.add("1450757604556025858");
        userList.add("1450757642371981314");
        userList.add("8934723032766293740");
        ArrayList<OrganVo> organVoList = new ArrayList<OrganVo>();
        OrganVo organVo = new OrganVo();
        organVo.setId("11");
        organVo.setOrganFname("\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7");
        organVoList.add(organVo);
        ArrayList<TaskQueryTaskVO> list = new ArrayList<TaskQueryTaskVO>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (HussarUtils.isNotEmpty((Object)flowTask.getSendUser())) {
                    userIds.add(flowTask.getSendUser());
                }
                userIds.add(flowTask.getUserId());
                userIds.add(flowTask.getProcessStartUserId());
                ids.add(flowTask.getTaskDefinitionKey());
            }
            finalUsers = iAssigneeChooseService.getUserListByUserId(userIds);
        }
        if (HussarUtils.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                String modelType;
                TaskQueryTaskVO taskManagerQueryVo = new TaskQueryTaskVO();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setSecurityLevel(processMap.get(flowTask.getProcessInsId()).getSecurityLevel());
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setOwner(flowTask.getOwner());
                taskManagerQueryVo.setTaskState(flowTask.getTaskState());
                taskManagerQueryVo.setFormId(flowTask.getFormId());
                taskManagerQueryVo.setTaskNameTranslateKey(flowTask.getTaskNameTranslateKey());
                taskManagerQueryVo.setProcNameTranslateKey(flowTask.getProcNameTranslateKey());
                taskVariables.putAll(this.resetVariable(flowTask, processMap.get(flowTask.getProcessInsId())));
                taskManagerQueryVo.setTaskVariables(taskVariables);
                String taskSourceFlag = flowTask.getTaskSourceFlag();
                taskManagerQueryVo.setTaskSourceFlag(taskSourceFlag);
                String scope = taskSourceFlag;
                taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
                taskManagerQueryVo.setTaskType(flowTask.getTaskType());
                scope = TaskSourceFlag.isReject((String)scope) ? "\u5df2\u9a73\u56de" : "\u5df2\u5b8c\u6210";
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser(flowTask.getSendUser());
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(flowTask.getSendUser()));
                taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
                taskManagerQueryVo.setProcessStartUserName((String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
                taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                taskManagerQueryVo.setProcessTitle(flowTask.getProcessTitle());
                String formDetail = flowTask.getFormDetail();
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                    taskManagerQueryVo.setUni(object.getString("uni"));
                }
                taskManagerQueryVo.setFormId(taskManagerQueryVo.getFormId());
                String appId = this.workflowCommonCacheService.getProcessAppId(flowTask.getProcessKey());
                if (HussarUtils.isNotEmpty((Object)appId)) {
                    taskManagerQueryVo.setAppId(appId);
                }
                if ("0".equals(modelType = this.workflowCommonCacheService.getProcessModelType(flowTask.getProcessKey()))) {
                    taskManagerQueryVo.setProcessType("0");
                } else {
                    taskManagerQueryVo.setProcessType("1");
                }
                String startUserId = processMap.get(flowTask.getProcessInsId()).getProcessStartUserId();
                if (HussarUtils.isNotEmpty((Object)startUserId)) {
                    if (userList.contains(startUserId)) {
                        taskManagerQueryVo.setOrganVoList(organVoList);
                    } else {
                        StaffBo staffBo = this.hussarBaseStaffBoService.findStaffByUserId(Long.valueOf(Long.parseLong(processMap.get(flowTask.getProcessInsId()).getProcessStartUserId())));
                        taskManagerQueryVo.setOrganVoList(staffBo.getOrganList());
                    }
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }

    private String getTablePrefix() {
        return this.bpmConfigService.getStringByKeyUseCache(TABLE_PREFIX);
    }

    public ApiResponse<Page<TaskQueryTaskVO>> todoTaskList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel) {
        Object variables2;
        ArrayList<String> userList = new ArrayList<String>();
        userList.add("1450756958461300737");
        userList.add("1450757481235202050");
        userList.add("1450757527330615298");
        userList.add("1450757567465828354");
        userList.add("1450757604556025858");
        userList.add("1450757642371981314");
        userList.add("8934723032766293740");
        ArrayList<OrganVo> organVoList = new ArrayList<OrganVo>();
        OrganVo organVo = new OrganVo();
        organVo.setId("11");
        organVo.setOrganFname("\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7");
        organVoList.add(organVo);
        if (HussarUtils.isEmpty((Object)flowTaskQueryModel.getDateTime())) {
            flowTaskQueryModel.setDateTime(new Date());
        }
        long todoTotal = this.flowTaskMapper.countTodoTotal(flowTaskQueryModel);
        if (HussarUtils.isEmpty(pages)) {
            pages = new Page();
        } else if (HussarUtils.isNotEmpty(pages) && (HussarUtils.isEmpty((Object)pages.getCurrent()) || HussarUtils.isEmpty((Object)pages.getSize()))) {
            pages = new Page(1L, 10L);
        }
        pages.setSearchCount(false);
        pages.setOptimizeCountSql(false);
        pages.setTotal(todoTotal);
        if (todoTotal == 0L) {
            return ApiResponse.success((Object)new Page(pages.getCurrent(), pages.getSize(), 0L));
        }
        List todoList = this.flowTaskMapper.todoList(pages, flowTaskQueryModel);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        ArrayList<Long> processInsIds = new ArrayList<Long>();
        for (FlowTask flowTask : todoList) {
            taskIds.add(Long.parseLong(flowTask.getTaskId()));
            processInsIds.add(Long.parseLong(flowTask.getProcessInsId()));
        }
        List allVariables = new ArrayList();
        List<Object> processList = new ArrayList();
        if (!todoList.isEmpty()) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.taskQueryMapper.getProcInstMsg(processInsIds);
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
            allVariables.addAll(this.flowTaskMapper.getAllToDoVariables(null, processInsIds));
        }
        HashMap<String, ArrayList<Object>> taskVariablesMap = new HashMap<String, ArrayList<Object>>();
        HashMap<String, ArrayList<Object>> processVariablesMap = new HashMap<String, ArrayList<Object>>();
        for (Object variables2 : allVariables) {
            List<Object> list;
            if (variables2.getTaskId() == null) {
                list = (ArrayList<Object>)processVariablesMap.get(variables2.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Object>();
                }
                list.add(variables2);
                processVariablesMap.put(variables2.getProcessInsId(), (ArrayList<Object>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables2.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables2);
            taskVariablesMap.put(variables2.getTaskId(), (ArrayList<Object>)list);
        }
        HashMap<String, TaskQueryFlowProcess> processMap = new HashMap<String, TaskQueryFlowProcess>();
        for (TaskQueryFlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        variables2 = todoList.iterator();
        while (variables2.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)variables2.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
            TaskQueryFlowProcess flowProcess = (TaskQueryFlowProcess)processMap.get(flowTask.getProcessInsId());
            flowTask.setBusinessId(flowProcess.getBusinessId());
            flowTask.setProcessStartUserId(flowProcess.getProcessStartUserId());
            flowTask.setProcessStartTime(flowProcess.getProcessStartTime());
            flowTask.setProcessEndTime(flowProcess.getProcessEndTime());
            if (!HussarUtils.isEmpty((Object)flowTask.getProcessTitle())) continue;
            flowTask.setProcessTitle(flowProcess.getProcessTitle());
        }
        ArrayList<TaskQueryTaskVO> resultData = new ArrayList<TaskQueryTaskVO>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            String modelType;
            TaskQueryTaskVO taskManagerQueryVo = new TaskQueryTaskVO();
            taskManagerQueryVo.setSecurityLevel(((TaskQueryFlowProcess)processMap.get(flowTask.getProcessInsId())).getSecurityLevel());
            taskManagerQueryVo.setTaskId(HussarUtils.isNotEmpty((Object)flowTask.getTaskState()) ? flowTask.getTaskId() + ":" + flowTask.getOwner() : flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setTaskState(flowTask.getTaskState());
            taskManagerQueryVo.setOwner(flowTask.getOwner());
            taskManagerQueryVo.setTaskNameTranslateKey(flowTask.getTaskNameTranslateKey());
            taskManagerQueryVo.setProcNameTranslateKey(flowTask.getProcNameTranslateKey());
            taskManagerQueryVo.setProcessStartUserId(flowTask.getProcessStartUserId());
            taskManagerQueryVo.setFormAddress((Map)JSON.parse((String)flowTask.getFormKey()));
            taskManagerQueryVo.setTimeoutState(flowTask.getTimeoutState());
            taskManagerQueryVo.setSuspensionState(String.valueOf(flowTask.getSuspensionState()));
            taskManagerQueryVo.setAssistInitiator(flowTask.getAssistInitiator());
            taskManagerQueryVo.setTaskType(flowTask.getTaskType());
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb((String)taskManagerQueryVo.getFormAddress().get("web"));
                taskManagerQueryVo.setMobile((String)taskManagerQueryVo.getFormAddress().get("mobile"));
                taskManagerQueryVo.setUni((String)taskManagerQueryVo.getFormAddress().get("uni"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            Map taskVariables = flowTask.getTaskVariableMap();
            taskVariables.putAll(this.resetVariable(flowTask, (TaskQueryFlowProcess)processMap.get(flowTask.getProcessInsId())));
            taskManagerQueryVo.setTaskVariables(taskVariables);
            taskManagerQueryVo.setMessage(flowTask.getTodoConfiguration());
            taskManagerQueryVo.setTaskSourceFlag(flowTask.getTaskSourceFlag());
            taskManagerQueryVo.setSendUser(flowTask.getSendUser());
            taskManagerQueryVo.setProcessTitle(flowTask.getProcessTitle());
            taskManagerQueryVo.setIdentityLinkId(String.valueOf(flowTask.getIdentityLinkId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            userIds.add(String.valueOf(taskManagerQueryVo.getAssigneeId()));
            userIds.add(String.valueOf(taskManagerQueryVo.getOwner()));
            userIds.add(String.valueOf(taskManagerQueryVo.getProcessStartUserId()));
            taskManagerQueryVo.setFormId(flowTask.getFormId());
            String appId = this.workflowCommonCacheService.getProcessAppId(flowTask.getProcessKey());
            if (HussarUtils.isNotEmpty((Object)appId)) {
                taskManagerQueryVo.setAppId(appId);
            }
            if ("0".equals(modelType = this.workflowCommonCacheService.getProcessModelType(flowTask.getProcessKey()))) {
                taskManagerQueryVo.setProcessType("0");
            } else {
                taskManagerQueryVo.setProcessType("1");
            }
            String startUserId = ((TaskQueryFlowProcess)processMap.get(flowTask.getProcessInsId())).getProcessStartUserId();
            if (HussarUtils.isNotEmpty((Object)startUserId)) {
                if (userList.contains(startUserId)) {
                    taskManagerQueryVo.setOrganVoList(organVoList);
                } else {
                    StaffBo staffBo = this.hussarBaseStaffBoService.findStaffByUserId(Long.valueOf(Long.parseLong(((TaskQueryFlowProcess)processMap.get(flowTask.getProcessInsId())).getProcessStartUserId())));
                    taskManagerQueryVo.setOrganVoList(staffBo.getOrganList());
                }
            }
            resultData.add(taskManagerQueryVo);
        }
        Map finalUsers = iAssigneeChooseService.getUserListByUserId(userIds);
        Iterator iterator = resultData.iterator();
        while (iterator.hasNext()) {
            TaskQueryTaskVO taskManagerQueryVo;
            taskManagerQueryVo.setSendUserName(finalUsers.get((taskManagerQueryVo = (TaskQueryTaskVO)iterator.next()).getSendUser()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getSendUser()));
            taskManagerQueryVo.setAssigneeName(finalUsers.get(taskManagerQueryVo.getAssigneeId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getAssigneeId()));
            taskManagerQueryVo.setOwnerName(finalUsers.get(taskManagerQueryVo.getOwner()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getOwner()));
            taskManagerQueryVo.setProcessStartUserName(finalUsers.get(taskManagerQueryVo.getProcessStartUserId()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getProcessStartUserId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(resultData, TaskQueryTaskVO.class).translate(TaskQueryTaskVO::getTaskNameTranslateKey, TaskQueryTaskVO::setTaskDefinitionName).translate(TaskQueryTaskVO::getProcNameTranslateKey, TaskQueryTaskVO::setProcessName).execute();
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    private Map<String, Object> resetVariable(FlowTask flowTask, TaskQueryFlowProcess flowProcess) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sendUser", flowTask.getSendUser());
        map.put("todoConfiguration", flowTask.getTodoConfiguration());
        map.put("old_appoint_assignee", flowTask.getAppointAssignee());
        map.put("complete_type", flowTask.getCompleteType());
        map.put("all_prev_node", flowTask.getAllPrevNode());
        map.put("sub_process_key", flowTask.getSubProcessKey());
        map.put("cycle_count", flowTask.getCycleCount());
        if (flowProcess != null) {
            map.put("call_complete_from", flowProcess.getCompleteFrom());
        }
        map.put("taskSourceFlag", flowTask.getTaskSourceFlag());
        map.put("jump_info", flowTask.getJumpInfo());
        return map;
    }
}

