/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeManageDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskUrgeDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.SysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5df2\u529e\u7ba1\u7406"})
@RequestMapping(value={"/bpmPublic/doneManage"})
public class DoneManageController {
    private final Logger logger = LoggerFactory.getLogger(DoneManageController.class);

    @GetMapping(value={"/list"})
    @ResponseBody
    @ApiOperation(value="\u5df2\u529e\u67e5\u8be2", notes="\u5df2\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5df2\u529e\u7ba1\u7406", eventDesc="\u5df2\u529e\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<?>> list(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = HussarUtils.isEmpty((Object)taskManageQueryDto.getUserId()) ? String.valueOf(BaseSecurityUtil.getUser().getId()) : taskManageQueryDto.getUserId();
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        String processStartUserId = taskManageQueryDto.getProcessStartUserId();
        String processStartTime = taskManageQueryDto.getProcessStartTime();
        String processEndTime = taskManageQueryDto.getProcessEndTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        Date processStart = null;
        Date processEnd = null;
        try {
            processStart = HussarUtils.isNotEmpty((Object)processStartTime) ? formatter.parse(processStartTime) : null;
            processEnd = HussarUtils.isNotEmpty((Object)processEndTime) ? formatter.parse(processEndTime) : null;
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskDto flowTaskDto = new FlowTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setProcessStartUserId(processStartUserId);
        flowTaskDto.setProcessStartTime(processStart);
        flowTaskDto.setProcessEndTime(processEnd);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        BpmResponseResult bpmResponseResult = TaskEngineService.queryDoneList((FlowTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/revoke"})
    @ApiOperation(value="\u64a4\u56de", notes="\u64a4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u64a4\u56de", eventDesc="\u64a4\u56de", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> revoke(@RequestBody String taskId) {
        TaskRevokeManageDto taskRevokeManageDto = new TaskRevokeManageDto();
        taskRevokeManageDto.setTaskId(taskId);
        if (HussarUtils.isEmpty((Object)taskRevokeManageDto.getUserId())) {
            taskRevokeManageDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if (HussarUtils.isAnyBlank((CharSequence[])new CharSequence[]{taskRevokeManageDto.getTaskId(), taskRevokeManageDto.getUserId()})) {
            return ApiResponse.fail((String)"taskId or userId is null");
        }
        BpmResponseResult check = TaskEngineService.withdrawState((String)taskRevokeManageDto.getTaskId());
        if (check.getCode().equals("0")) {
            return ApiResponse.fail((String)check.getMsg());
        }
        if (!((Boolean)check.getResult().get(0)).booleanValue()) {
            return ApiResponse.fail((String)((String)check.getResult().get(1)));
        }
        BpmResponseResult bpmResponseResult = TaskEngineService.revokeTask((String)taskRevokeManageDto.getTaskId(), (String)taskRevokeManageDto.getUserId(), (String)"", (boolean)true, null);
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/urge"})
    @ApiOperation(value="\u50ac\u529e", notes="\u50ac\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u50ac\u529e", eventDesc="\u6dfb\u52a0\u50ac\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> urge(@RequestBody TaskUrgeDto taskUrgeDto) {
        if (HussarUtils.isEmpty((Object)taskUrgeDto.getUserId())) {
            taskUrgeDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if (taskUrgeDto.getProcessInsId() == null || taskUrgeDto.getUserId() == null) {
            return ApiResponse.fail((String)"");
        }
        BpmResponseResult bpmResponseResult = SysActUrgeTaskService.save((String)taskUrgeDto.getProcessInsId(), (String)taskUrgeDto.getTaskId(), (String)taskUrgeDto.getUserId());
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }
}

