/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmanage.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ReTransferTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveBatchEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.UpdateEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.UpdateStateEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.AssigneeService;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.SysActEntrustService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u59d4\u6258\u7ba1\u7406"})
@RequestMapping(value={"/bpmPublic/entrust"})
public class EntrustListController {
    private static final Logger logger = LoggerFactory.getLogger(EntrustListController.class);

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u59d4\u6258\u67e5\u8be2", notes="\u59d4\u6258\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u59d4\u6258\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<?>> initList(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        BpmResponseResult bpmResponseResult;
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = taskManageQueryDto.getUserId();
        if (HussarUtils.isEmpty((Object)userId)) {
            userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        }
        if ((bpmResponseResult = SysActEntrustService.list((String)userId, (String)processKey, (String)taskManageQueryDto.getState(), (Integer)((int)pages.getCurrent()), (Integer)((int)pages.getSize()))).isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/entrustHistoryList"})
    @ApiOperation(value="\u83b7\u53d6\u59d4\u6258\u5386\u53f2", notes="\u83b7\u53d6\u59d4\u6258\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u59d4\u6258\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<?>> entrustHistoryList(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        BpmResponseResult bpmResponseResult;
        String userId = taskManageQueryDto.getUserId();
        if (HussarUtils.isEmpty((Object)userId)) {
            userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        }
        if ((bpmResponseResult = SysActEntrustService.entrustHistoryList((String)userId, (Integer)((int)pages.getCurrent()), (Integer)((int)pages.getSize()))).isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u59d4\u6258", notes="\u6dfb\u52a0\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u6dfb\u52a0\u59d4\u6258", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> saveEntrust(@RequestBody SaveBatchEntrustDto saveEntrustDto) {
        List processKey = saveEntrustDto.getProcessKey();
        String mandator = saveEntrustDto.getMandator();
        if (HussarUtils.isEmpty((Object)mandator)) {
            mandator = String.valueOf(BaseSecurityUtil.getUser().getId());
        }
        String mandatary = saveEntrustDto.getMandatary();
        String state = "1";
        String startTime = String.valueOf(saveEntrustDto.getStartTime()).concat(" 00:00:00");
        String endTime = String.valueOf(saveEntrustDto.getEndTime()).concat(" 23:59:59");
        String companyCode = saveEntrustDto.getCompanyCode();
        String companyName = saveEntrustDto.getCompanyName();
        BpmResponseResult bpmResponseResult = SysActEntrustService.addBatch((List)processKey, (String)mandator, (String)mandatary, (String)state, (String)startTime, (String)endTime, (boolean)saveEntrustDto.getIsTransferTask(), (String)saveEntrustDto.getMessageType(), (String)companyCode, (String)companyName, (String)saveEntrustDto.getMandatorName(), (String)saveEntrustDto.getMandataryName());
        if (bpmResponseResult.getCode().equals("1")) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/saveTaskEntrust"})
    @ApiOperation(value="\u6dfb\u52a0\u59d4\u6258", notes="\u6dfb\u52a0\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u6dfb\u52a0\u59d4\u6258", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<String> saveTaskEntrust(@RequestBody SaveEntrustDto saveEntrustDto) {
        BpmResponseResult bpmResponseResult;
        if (HussarUtils.isEmpty((Object)saveEntrustDto.getMandator())) {
            saveEntrustDto.setMandator(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if ((bpmResponseResult = SysActEntrustService.addBatchEntrust((SaveEntrustDto)saveEntrustDto)).getCode().equals("1")) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u59d4\u6258", notes="\u5220\u9664\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u5220\u9664\u59d4\u6258", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteEntrust(@RequestBody String tEntrustId) {
        SysActEntrustService.delete((String)tEntrustId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u67e5\u770b\u59d4\u6258\u8be6\u60c5", notes="\u67e5\u770b\u59d4\u6258\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u67e5\u770b\u59d4\u6258\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Object> detailEntrust(Long tEntrustId) {
        BpmResponseResult bpmResponseResult = SysActEntrustService.detail((String)String.valueOf(tEntrustId));
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            return ApiResponse.success((Object)jsonObject);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u59d4\u6258", notes="\u66f4\u65b0\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u66f4\u65b0\u59d4\u6258", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateEntrust(@RequestBody UpdateEntrustDto updateEntrustDto) {
        BpmResponseResult bpmResponseResult = SysActEntrustService.update((Long)updateEntrustDto.getId(), (String)updateEntrustDto.getMandatary(), (String)updateEntrustDto.getStartTime(), (String)updateEntrustDto.getEndTime(), (String)updateEntrustDto.getMessageType());
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/updateState"})
    @ApiOperation(value="\u66f4\u65b0\u59d4\u6258\u72b6\u6001", notes="\u66f4\u65b0\u59d4\u6258\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u66f4\u65b0\u59d4\u6258\u72b6\u6001", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> updateStateEntrust(@RequestBody UpdateStateEntrustDto updateStateEntrustDto) {
        String state = "";
        state = "1".equals(String.valueOf(updateStateEntrustDto.getState())) ? "0" : "1";
        BpmResponseResult bpmResponseResult = SysActEntrustService.updateState((String)updateStateEntrustDto.getId(), (String)state);
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/user"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u7528\u6237\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> userTree(@RequestParam String id) {
        return AssigneeService.userTree((String)id, (boolean)true);
    }

    @GetMapping(value={"/queryUserTreeByUserName"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", notes="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u6a21\u7cca\u67e5\u8be2\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<BpmTreeModel>> queryUserTreeByUserName(@RequestParam String userName) {
        return AssigneeService.queryUserListByUserName((String)userName);
    }

    @GetMapping(value={"/queryProcess"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b", notes="\u67e5\u8be2\u6d41\u7a0b")
    @AuditLog(moduleName="\u59d4\u6258\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<BpmResponseResult> queryProcess() {
        BpmResponseResult bpmResponseResult = DefinitionEngineService.queryProcess();
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((Object)bpmResponseResult);
        }
        return ApiResponse.success((String)"");
    }

    @GetMapping(value={"/queryFinishedEntrustTaskList"})
    @ApiOperation(value="\u83b7\u53d6\u59d4\u6258\u5df2\u529e", notes="\u83b7\u53d6\u59d4\u6258\u5df2\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u59d4\u6258\u5df2\u529e", eventDesc="\u83b7\u53d6\u59d4\u6258\u5df2\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedEntrustTaskList(Page<TaskManagerQueryVo> pages, TaskManageQueryDto taskManageQueryDto) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getStartTime()) ? formatter.parse(taskManageQueryDto.getStartTime()) : null;
            end = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getEndTime()) ? formatter.parse(taskManageQueryDto.getEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskDto flowTaskDto = new FlowTaskDto();
        flowTaskDto.setMandator(HussarUtils.isEmpty((Object)taskManageQueryDto.getUserId()) ? String.valueOf(BaseSecurityUtil.getUser().getId()) : taskManageQueryDto.getUserId());
        flowTaskDto.setDefinitionKey(taskManageQueryDto.getTaskDefinitionKey());
        flowTaskDto.setUserId(taskManageQueryDto.getMandatary());
        flowTaskDto.setProcessKey(taskManageQueryDto.getProcessKey());
        flowTaskDto.setTodoConfiguration(taskManageQueryDto.getMessage());
        flowTaskDto.setSendUserId(taskManageQueryDto.getSendUserId());
        flowTaskDto.setTaskState("1");
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        BpmResponseResult bpmResponseResult = TaskEngineService.queryDoneList((FlowTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/queryUnFinishedEntrustTaskList"})
    @ApiOperation(value="\u83b7\u53d6\u59d4\u6258\u5f85\u529e", notes="\u83b7\u53d6\u59d4\u6258\u5f85\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    @AuditLog(moduleName="\u83b7\u53d6\u59d4\u6258\u5f85\u529e", eventDesc="\u83b7\u53d6\u59d4\u6258\u5f85\u529e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<TaskManagerQueryVo>> queryUnFinishedEntrustTaskList(Page<TaskManagerQueryVo> pages, TaskManageQueryDto taskManageQueryDto) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getStartTime()) ? formatter.parse(taskManageQueryDto.getStartTime()) : null;
            end = HussarUtils.isNotEmpty((Object)taskManageQueryDto.getEndTime()) ? formatter.parse(taskManageQueryDto.getEndTime()) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskDto flowTaskDto = new FlowTaskDto();
        flowTaskDto.setUserId(taskManageQueryDto.getMandatary());
        flowTaskDto.setMandator(HussarUtils.isEmpty((Object)taskManageQueryDto.getUserId()) ? String.valueOf(BaseSecurityUtil.getUser().getId()) : taskManageQueryDto.getUserId());
        flowTaskDto.setProcessKey(taskManageQueryDto.getProcessKey());
        flowTaskDto.setDefinitionKey(taskManageQueryDto.getTaskDefinitionKey());
        flowTaskDto.setTodoConfiguration(taskManageQueryDto.getMessage());
        flowTaskDto.setTaskState("1");
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        BpmResponseResult bpmResponseResult = TaskEngineService.queryToDoList((FlowTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/reTransferTask"})
    @ApiOperation(value="\u6536\u56de\u79fb\u4ea4\u51fa\u53bb\u7684\u5f85\u529e", notes="\u6536\u56de\u79fb\u4ea4\u51fa\u53bb\u7684\u5f85\u529e")
    public ApiResponse<String> reTransferTask(@RequestBody ReTransferTaskDto reTransferTaskDto) {
        BpmResponseResult bpmResponseResult;
        if (HussarUtils.isEmpty((Object)reTransferTaskDto.getUserId())) {
            reTransferTaskDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if ((bpmResponseResult = SysActEntrustService.reTransferTask((ReTransferTaskDto)reTransferTaskDto)).isSuccess()) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }
}

