/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmanage.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.io.IORuntimeException;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5f85\u529e\u7ba1\u7406"})
@RequestMapping(value={"/bpmPublic/toDoManage"})
public class ToDoManageController {
    @GetMapping(value={"/queryProcess"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", notes="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b")
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONArray> queryProcess() {
        BpmResponseResult bpmResponseResult = DefinitionEngineService.queryProcess();
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((Object)bpmResponseResult.getResult());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/getProcNodeName"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u540d\u79f0", notes="\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u540d\u79f0")
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u540d\u79f0", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONArray> getProcNodeName(@RequestParam String processDefinitionKey) {
        BpmResponseResult bpmResponseResult = TaskEngineService.getProcNodeName((String)processDefinitionKey);
        try {
            return ApiResponse.success((Object)bpmResponseResult.getResult());
        }
        catch (IORuntimeException c) {
            return ApiResponse.fail((String)bpmResponseResult.getMsg());
        }
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5f85\u529e\u67e5\u8be2", notes="\u5f85\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u5f85\u529e\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<?>> list(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        String userId = taskManageQueryDto.getUserId();
        if (HussarUtils.isEmpty((Object)userId)) {
            userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        }
        String processKey = taskManageQueryDto.getProcessKey();
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String taskDefKey = taskManageQueryDto.getTaskDefKey();
        String classify = taskManageQueryDto.getClassify();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        String finishStartTime = taskManageQueryDto.getFinishStartTime();
        String finishEndTime = taskManageQueryDto.getFinishEndTime();
        String processStartUserId = taskManageQueryDto.getProcessStartUserId();
        String processStartUserName = taskManageQueryDto.getProcessStartUserName();
        String bakOne = taskManageQueryDto.getBakOne();
        String bakTwo = taskManageQueryDto.getBakTwo();
        String bakThree = taskManageQueryDto.getBakThree();
        String bakFour = taskManageQueryDto.getBakFour();
        String bakFive = taskManageQueryDto.getBakFive();
        String bakSix = taskManageQueryDto.getBakSix();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        Date finishStart = null;
        Date finishEnd = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
            finishStart = HussarUtils.isNotEmpty((Object)finishStartTime) ? formatter.parse(finishStartTime) : null;
            finishEnd = HussarUtils.isNotEmpty((Object)finishEndTime) ? formatter.parse(finishEndTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        FlowTaskDto flowTaskDto = new FlowTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setTaskDefKey(taskDefKey);
        flowTaskDto.setClassify(classify);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        flowTaskDto.setProcessStartUserId(processStartUserId);
        flowTaskDto.setProcessStartUserName(processStartUserName);
        flowTaskDto.setFinishStartTime(finishStart);
        flowTaskDto.setFinishEndTime(finishEnd);
        flowTaskDto.setBakOne(bakOne);
        flowTaskDto.setBakTwo(bakTwo);
        flowTaskDto.setBakThree(bakThree);
        flowTaskDto.setBakFour(bakFour);
        flowTaskDto.setBakFive(bakFive);
        flowTaskDto.setBakSix(bakSix);
        BpmResponseResult bpmResponseResult = TaskEngineService.queryToDoList((FlowTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }
}

