/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmanage.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.QueryProcessTaskCountDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dto.TransferDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.vo.TransferProgressInfo;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5f85\u529e\u7ba1\u7406"})
@RequestMapping(value={"/bpmPublic/toDoManage"})
public class ToDoManageController {
    @GetMapping(value={"/queryProcess"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", notes="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b")
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONArray> queryProcess() {
        BpmResponseResult bpmResponseResult = DefinitionEngineService.queryProcess();
        if (bpmResponseResult.isSuccess()) {
            return ApiResponse.success((Object)bpmResponseResult.getResult());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5f85\u529e\u67e5\u8be2", notes="\u5f85\u529e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u5f85\u529e\u7ba1\u7406", eventDesc="\u5f85\u529e\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<?>> list(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        String userId = taskManageQueryDto.getUserId();
        if (HussarUtils.isEmpty((Object)userId)) {
            userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        }
        String processKey = taskManageQueryDto.getProcessKey();
        String sendUserId = taskManageQueryDto.getSendUserId();
        String message = taskManageQueryDto.getMessage();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        String taskType = taskManageQueryDto.getTaskType();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        FlowTaskDto flowTaskDto = new FlowTaskDto();
        flowTaskDto.setUserId(userId);
        flowTaskDto.setProcessKey(processKey);
        flowTaskDto.setTodoConfiguration(message);
        flowTaskDto.setSendUserId(sendUserId);
        flowTaskDto.setStartTime(start);
        flowTaskDto.setEndTime(end);
        flowTaskDto.setTaskType(taskType);
        flowTaskDto.setPage(Long.valueOf(pages.getCurrent()));
        flowTaskDto.setSize(Long.valueOf(pages.getSize()));
        BpmResponseResult bpmResponseResult = TaskEngineService.queryToDoList((FlowTaskDto)flowTaskDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            pages.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            pages.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(pages);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/transferTaskList"})
    public ApiResponse<Page<?>> transferTaskList(Page<?> pages, TaskManageQueryDto taskManageQueryDto) {
        taskManageQueryDto.setTaskType("1");
        return this.list(pages, taskManageQueryDto);
    }

    @GetMapping(value={"/queryProcessTaskCount"})
    public ApiResponse<Page<?>> queryProcessTaskCount(Page<?> page, QueryProcessTaskCountDto queryProcessTaskCountDto) {
        if (HussarUtils.isEmpty((Object)queryProcessTaskCountDto.getUserId())) {
            queryProcessTaskCountDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        queryProcessTaskCountDto.setCurrent(Long.valueOf(page.getCurrent()));
        queryProcessTaskCountDto.setSize(Long.valueOf(page.getSize()));
        BpmResponseResult bpmResponseResult = TaskEngineService.queryProcessTaskCount((QueryProcessTaskCountDto)queryProcessTaskCountDto);
        if (bpmResponseResult.isSuccess()) {
            JSONObject jsonObject = bpmResponseResult.getResult().getJSONObject(0);
            page.setTotal(((Long)jsonObject.getObject("count", Long.class)).longValue());
            page.setRecords((List)jsonObject.getObject("data", List.class));
            return ApiResponse.success(page);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    @PostMapping(value={"/transferTask"})
    public ApiResponse<Long> transferTask(@RequestBody TransferDto transferDto) {
        if (HussarUtils.isEmpty((Object)transferDto.getUserId())) {
            transferDto.setUserId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        return this.transferTaskReturn(TaskEngineService.transferTask((TransferDto)transferDto));
    }

    @GetMapping(value={"/getTransferProgressInfo"})
    public ApiResponse<TransferProgressInfo> getTransferProgressInfo(Long transferId) {
        return this.transferTaskReturn(TaskEngineService.getTransferProgressInfo((Long)transferId));
    }

    private <T> ApiResponse<T> transferTaskReturn(BpmResponseResult bpmResponseResult) {
        if (bpmResponseResult.isSuccess()) {
            Object t = HussarUtils.isNotEmpty((Object)bpmResponseResult.getResult()) ? bpmResponseResult.getResult().get(0) : null;
            return ApiResponse.success((Object)t);
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }
}

