/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.taskmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.dto.SysActCcTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.vo.SysActCcTaskVo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.manage.engine.SysActCcTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6284\u9001\u7ba1\u7406"})
@RequestMapping(value={"/bpmPublic/ccManage"})
public class CcManageController {
    @GetMapping(value={"/list"})
    @ApiOperation(value="\u6284\u9001\u67e5\u8be2", notes="\u6284\u9001\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="body")})
    @AuditLog(moduleName="\u6284\u9001\u7ba1\u7406", eventDesc="\u6284\u9001\u67e5\u8be2", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysActCcTaskVo>> list(Page<SysActCcTaskVo> pages, TaskManageQueryDto taskManageQueryDto) {
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = HussarUtils.isEmpty((Object)taskManageQueryDto.getUserId()) ? String.valueOf(BaseSecurityUtil.getUser().getId()) : taskManageQueryDto.getUserId();
        String sendUserId = taskManageQueryDto.getSendUserId();
        String startTime = taskManageQueryDto.getStartTime();
        String endTime = taskManageQueryDto.getEndTime();
        String state = taskManageQueryDto.getState();
        SysActCcTaskQueryDto sysActCcTaskQueryDto = new SysActCcTaskQueryDto(processKey, sendUserId, startTime, endTime, userId, state, Integer.valueOf((int)pages.getCurrent()), Integer.valueOf((int)pages.getSize()));
        return SysActCcTaskService.list((SysActCcTaskQueryDto)sysActCcTaskQueryDto);
    }

    @PostMapping(value={"/read"})
    @ApiOperation(value="\u9605\u8bfb", notes="\u9605\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ccTaskId", value="\u4f20\u9605\u4efb\u52a1ID", required=true, paramType="query")})
    @AuditLog(moduleName="\u9605\u8bfb", eventDesc="\u9605\u8bfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> read(@RequestBody Long ccTaskId) {
        return SysActCcTaskService.read((Long)ccTaskId);
    }

    @PostMapping(value={"/readByTaskId"})
    @ApiOperation(value="\u9605\u8bfb", notes="\u9605\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    @AuditLog(moduleName="\u9605\u8bfb", eventDesc="\u9605\u8bfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> readByTaskId(@RequestBody String taskId) {
        if (taskId == null) {
            return ApiResponse.fail((String)"taskId is null");
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String userId = String.valueOf(securityUser.getId());
        SysActCcTaskDto sysActCcTaskDto = new SysActCcTaskDto();
        sysActCcTaskDto.setTaskId(taskId.split(":")[0]);
        sysActCcTaskDto.setComment(taskId.split(":")[1]);
        sysActCcTaskDto.setUserId(userId);
        return SysActCcTaskService.readByTaskId((SysActCcTaskDto)sysActCcTaskDto);
    }

    @PostMapping(value={"/readBatch"})
    @ApiOperation(value="\u6279\u91cf\u5df2\u8bfb", notes="\u6279\u91cf\u5df2\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ccTaskIds", value="\u4f20\u9605\u4efb\u52a1ID", required=true, paramType="query")})
    @AuditLog(moduleName="\u5df2\u8bfb", eventDesc="\u5df2\u8bfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> revoke(@RequestBody List<Long> ccTaskIds) {
        return SysActCcTaskService.readBatch(ccTaskIds);
    }

    @PostMapping(value={"/getPage"})
    @ApiOperation(value="\u83b7\u53d6\u6284\u9001\u5217\u8868", notes="\u83b7\u53d6\u6284\u9001\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="startTime", value="\u6700\u65e9\u53d1\u9001\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="endTime", value="\u6700\u665a\u53d1\u9001\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="readStatus", value="\u5df2\u8bfb\u72b6\u6001", required=true, paramType="query")})
    public ApiResponse<Page<SysActCcTask>> getPage(@RequestBody SysActCcTaskDto sysActCcTaskDto) {
        return SysActCcTaskService.getPage((SysActCcTaskDto)sysActCcTaskDto);
    }

    @PostMapping(value={"saveCcTask"})
    @ApiOperation(value="\u65b0\u589e\u6284\u9001\u6570\u636e\u4fe1\u606f", notes="\u65b0\u589e\u6284\u9001\u6570\u636e\u4fe1\u606f")
    @AuditLog(moduleName="\u65b0\u589e\u6284\u9001\u6570\u636e\u4fe1\u606f", eventDesc="\u65b0\u589e\u6284\u9001\u6570\u636e\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<SysActCcTask> saveCcTask(@RequestBody SysActCcDto sysActCcTask) {
        return SysActCcTaskService.saveCcTask((SysActCcDto)sysActCcTask);
    }

    @PostMapping(value={"/readNew"})
    @ApiOperation(value="\u5df2\u8bfb\u6284\u9001", notes="\u5df2\u8bfb\u6284\u9001")
    @AuditLog(moduleName="\u5df2\u8bfb\u6284\u9001", eventDesc="\u5df2\u8bfb\u6284\u9001", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> read(@RequestBody SysActCcDto sysActCcTask) {
        return SysActCcTaskService.read((SysActCcDto)sysActCcTask);
    }

    @PostMapping(value={"/reply"})
    @ApiOperation(value="\u6284\u9001\u56de\u590d", notes="\u6284\u9001\u56de\u590d")
    @AuditLog(moduleName="\u6284\u9001\u56de\u590d", eventDesc="\u6284\u9001\u56de\u590d", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> reply(@RequestBody SysActCcDto sysActCcTask) {
        return SysActCcTaskService.reply((SysActCcDto)sysActCcTask);
    }

    @PostMapping(value={"/deleteCcTask"})
    @ApiOperation(value="\u5220\u9664\u6284\u9001\u6570\u636e\u4fe1\u606f", notes="\u5220\u9664\u6284\u9001\u6570\u636e\u4fe1\u606f")
    @AuditLog(moduleName="\u5220\u9664\u6284\u9001\u6570\u636e\u4fe1\u606f", eventDesc="\u5220\u9664\u6284\u9001\u6570\u636e\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteCcTask(@RequestBody SysActCcDto sysActCcTask) {
        return SysActCcTaskService.deleteCcTask((SysActCcDto)sysActCcTask);
    }

    @PostMapping(value={"/getCcTaskUserList"})
    @ApiOperation(value="\u6284\u9001\u4eba\u5458", notes="\u6284\u9001\u4eba\u5458")
    @AuditLog(moduleName="\u6284\u9001\u4eba\u5458", eventDesc="\u6284\u9001\u4eba\u5458", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysActCcTask>> getCcTaskUserList(@RequestBody SysActCcDto sysActCcTask) {
        return SysActCcTaskService.getCcTaskUserList((SysActCcDto)sysActCcTask);
    }
}

