/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.outside.dynamicfeign;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DynamicFeignClientFactory<T> {
    private FeignClientBuilder feignClientBuilder;
    @Value(value="${hussar-remote-server.workflow-callback.url:}")
    private String url;

    public DynamicFeignClientFactory(ApplicationContext appContext) {
        this.feignClientBuilder = new FeignClientBuilder(appContext);
    }

    public T getFeignClient(Class<T> type, String serviceId) {
        if (HussarUtils.isEmpty((Object)serviceId)) {
            throw new RuntimeException("\u5fae\u670d\u52a1\u8c03\u7528\u5f02\u5e38: \u6d41\u7a0b\u6240\u5c5e\u670d\u52a1\u4e3a\u7a7a");
        }
        FeignClientBuilder.Builder builder = this.feignClientBuilder.forType(type, serviceId);
        if (HussarUtils.isNotEmpty((Object)this.url)) {
            builder.url(this.url);
        }
        return (T)builder.build();
    }
}

