/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.assignee.service;

import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.AssigneeQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl.AssigneeChooseServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.godaxe.assignee.service.INocodeAssigneeChooseService;
import com.jxdinfo.hussar.workflow.godaxe.assignee.service.INocodeAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.assignee.service.AssigneeChooseService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class NocodeAssigneeChooseServiceImpl
implements INocodeAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private INocodeAssigneeModeChooseService nocodeAssigneeModeChooseService;
    private final IBpmConfigService bpmConfigService;
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final String MICRO = "micro";
    private static final String WORKFLOW_PLATFORM = "workflow-platform";
    private static final String SINGLE = "single";
    private static final String TABLE_PREFIX = "table_prefix";

    public NocodeAssigneeChooseServiceImpl(IBpmConfigService bpmConfigService) {
        this.bpmConfigService = bpmConfigService;
    }

    private String getDeploymentModel() {
        return this.lcdpBpmProperties.getDeploymentModel();
    }

    private String getTablePrefix() {
        return this.bpmConfigService.getStringByKeyUseCache(TABLE_PREFIX);
    }

    public List<BpmTreeModel> roleTreeByAppId(String id, String appId) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.nocodeAssigneeModeChooseService.roleTreeByAppId(id, appId, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService remoteAssigneeChooseService = (AssigneeChooseService)BpmSpringContextHolder.getSpringContext().getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setId(id);
                    assigneeQueryModel.setAppId(appId);
                    return remoteAssigneeChooseService.roleTree(assigneeQueryModel);
                }
            }
            return this.nocodeAssigneeModeChooseService.roleTreeByAppId(id, appId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }
}

