/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.nocode.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActHandleAuthMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.godaxe.nocode.service.INocodeBpmApiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NocodeBpmEngineServiceImpl
implements INocodeBpmApiService {
    @Resource
    private HistoryService historyService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private SysActHandleAuthMapper sysActHandleAuthMapper;
    private static final List<String> CHECK_VARIABLE_NODE_TYPE_LIST = new ArrayList<String>();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject queryFormField(String processKey, String version, String processInstanceId, String taskId, String taskDefinitionKey) {
        void var11_12;
        DefinitionModel definitionModel;
        HistoricTaskInstance historicTaskInstance;
        WorkFlow workFlow = null;
        if (HussarUtils.isNotEmpty((Object)processInstanceId)) {
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (!HussarUtils.isNotEmpty((Object)processInstance)) return new JSONObject();
            workFlow = this.sysActProcessFileService.getFileByProcessDefId(processInstance.getProcessDefinitionId());
        } else {
            if (!HussarUtils.isNotEmpty((Object)processKey)) throw new BpmException(BpmExceptionCodeEnum.PARAM_IS_NULL);
            String procDefId = this.processDefinitionsService.getStartProcessDefinitionId(processKey, version);
            workFlow = this.sysActProcessFileService.getFileByProcessDefId(procDefId);
        }
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        if (HussarUtils.isNotEmpty((Object)taskId) && HussarUtils.isNotEmpty((Object)(historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).queryChildTask()).singleResult()))) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
            taskDefinitionKey = CommonCodeUtil.getVisitorNodeId((String)historicTaskInstance.getTaskDefinitionKey(), (BpmnModel)bpmnModel);
        }
        HashSet<String> nodeVariableNames = new HashSet<String>();
        List elements = flowModel.getSlots().getElement();
        JSONObject jsonObject = new JSONObject();
        ArrayList arrayList = new ArrayList();
        JSONArray commentSettings = new JSONArray();
        List paths = flowModel.getSlots().getPath();
        String startPath = null;
        for (FlowObject flowObject : elements) {
            if (CHECK_VARIABLE_NODE_TYPE_LIST.contains(flowObject.getName())) {
                ArrayList functionUserVariables = new ArrayList();
                FormBpmnUtil.getFunctionMessage((FlowProps)flowObject.getProps(), new HashMap(), functionUserVariables);
                Iterator nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList();
                }
                nodeVariables.addAll(functionUserVariables);
                Iterator iterator = nodeVariables.iterator();
                while (iterator.hasNext()) {
                    FlowVariables flowVariables = (FlowVariables)iterator.next();
                    nodeVariableNames.add(flowVariables.getVariable());
                }
                if (!HussarUtils.isNotEmpty((Object)taskDefinitionKey) || !taskDefinitionKey.equals(flowObject.getInstanceKey())) continue;
                List list = flowObject.getProps().getNodeCheckRuleList();
                continue;
            }
            if (!HussarUtils.isEmpty((Object)taskDefinitionKey) || !BpmNodeTypeUtil.isStart((String)flowObject.getName())) continue;
            List list = flowObject.getProps().getNodeCheckRuleList();
            startPath = (String)flowObject.getGoOutPathes().get(0);
        }
        if (HussarUtils.isEmpty((Object)version) && HussarUtils.isNotEmpty((Object)(definitionModel = this.processDefinitionsService.getMainOrNew(processKey, null))) && HussarUtils.isEmpty((Object)version)) {
            version = definitionModel.getVersion();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(SysActHandleAuth::getProcessKey, (Object)processKey)).eq(SysActHandleAuth::getProcessVersion, (Object)version)).isNotNull(SysActHandleAuth::getExtendConfiguration);
        if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
            queryWrapper.eq(SysActHandleAuth::getTaskDefinitionKey, (Object)taskDefinitionKey);
        } else {
            queryWrapper.isNull(SysActHandleAuth::getTaskDefinitionKey);
        }
        List sysActHandleAuthList = this.sysActHandleAuthMapper.selectList((Wrapper)queryWrapper);
        String rejectExtendConfiguration = null;
        for (SysActHandleAuth sysActHandleAuth : sysActHandleAuthList) {
            if (sysActHandleAuth.getHandleType().contains("Reject")) {
                rejectExtendConfiguration = sysActHandleAuth.getExtendConfiguration();
                continue;
            }
            commentSettings.add((Object)JSON.parseObject((String)sysActHandleAuth.getExtendConfiguration()));
        }
        if (HussarUtils.isNotEmpty(rejectExtendConfiguration)) {
            commentSettings.add((Object)JSON.parseObject(rejectExtendConfiguration));
        }
        if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
            for (FlowSequence flowSequence : paths) {
                if (!flowSequence.getInstanceKey().equals(startPath)) continue;
                taskDefinitionKey = flowSequence.getEnd().getKey();
                break;
            }
        }
        JSONObject workflowData = JSON.parseObject((String)workFlow.getData());
        JSONObject props = workflowData.getJSONObject("props");
        jsonObject.put("signatureAuditAuthority", props.get((Object)"signatureAuditAuthority"));
        jsonObject.put("field", nodeVariableNames);
        jsonObject.put("nodeCheckRuleList", (Object)var11_12);
        jsonObject.put("commentSettings", (Object)commentSettings);
        jsonObject.put("nodeId", (Object)taskDefinitionKey);
        return jsonObject;
    }

    static {
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getVisitType());
    }
}

