/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.migration.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl.SysActExtendPropertiesServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.service.WorkflowMigrationServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActAssigneeMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActFormAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActHandleAuth;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActFormAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActHandleAuthService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.service.Bpm2XMLService;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import com.jxdinfo.hussar.workflow.godaxe.migration.dao.GodAxeWorkflowMigrationMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class GodAxeWorkflowMigrationServiceImpl
implements GodAxeMigrationService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowMigrationServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private SysActFormAuthService sysActFormAuthService;
    @Autowired
    private SysActHandleAuthService sysActHandleAuthService;
    @Autowired
    private SysActExtendPropertiesServiceImpl sysActExtendPropertiesService;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private Bpm2XMLService bpm2XMLService;
    @Resource
    private ProcessEngine processEngine;
    @Resource
    private SysActAssigneeMapper sysActAssigneeMapper;
    @Resource
    private GodAxeWorkflowMigrationMapper godAxeWorkflowMigrationMapper;
    @Resource
    private ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private ModelMapper modelMapper;
    private static final Pattern RoleRegex = Pattern.compile("R.GRANTED_ROLE (NOT )?IN \\(([^)])*\\)");

    @Override
    public List<Long> queryRoleIdList(Long appId, List<String> processKeys) {
        Map<String, WorkflowQueryVo> processKeyVersionMap = this.queryProcessKeyVersionMap(appId, null);
        if (HussarUtils.isNotEmpty(processKeys)) {
            processKeyVersionMap.keySet().removeIf(key -> !processKeys.contains(key));
        }
        ArrayList<String> contentTypeList = new ArrayList<String>();
        contentTypeList.add("defaultAssign");
        contentTypeList.add("defaultCcAssign");
        ArrayList contentList = new ArrayList();
        for (String processKey : processKeyVersionMap.keySet()) {
            List list = this.sysActAssigneeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)processKey)).in(SysActAssignee::getContentType, contentTypeList)).eq(SysActAssignee::getProcessVersion, (Object)processKeyVersionMap.get(processKey).getVersion()));
            list.forEach(sysActAssignee -> contentList.add(sysActAssignee.getContent() == null ? "" : new String(sysActAssignee.getContent(), StandardCharsets.UTF_8)));
        }
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        for (String content : contentList) {
            if (!content.contains("R.GRANTED_ROLE")) continue;
            Matcher matcher = RoleRegex.matcher(content);
            while (matcher.find()) {
                String roleId = matcher.group().substring(matcher.group().indexOf("(") + 2, matcher.group().length() - 2);
                if (roleIdList.contains(Long.valueOf(roleId))) continue;
                roleIdList.add(Long.valueOf(roleId));
            }
        }
        return roleIdList;
    }

    @Override
    public Map<String, List<WorkflowDumpVo>> exportWorkflow(Long appId) {
        return this.export(appId, null);
    }

    @Override
    public Map<String, List<WorkflowDumpVo>> exportFormWorkflow(String processDefinitionKey) {
        return this.export(null, processDefinitionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<WorkflowDumpVo>> export(Long appId, String processDefinitionKey) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{appId, processDefinitionKey})) {
            throw new BpmException(BpmExceptionCodeEnum.PARAM_IS_NULL);
        }
        Map<Object, Object> processKeyVersionMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            processKeyVersionMap = this.queryProcessKeyVersionMap(appId, null);
        } else if (HussarUtils.isNotEmpty((Object)processDefinitionKey)) {
            processKeyVersionMap = this.queryProcessKeyVersionMap(null, processDefinitionKey);
        }
        if (HussarUtils.isEmpty(processKeyVersionMap)) {
            return new HashMap<String, List<WorkflowDumpVo>>();
        }
        HashMap<String, List<WorkflowDumpVo>> workflowDumpVoListMap = new HashMap<String, List<WorkflowDumpVo>>();
        for (String string : processKeyVersionMap.keySet()) {
            ArrayList<WorkflowDumpVo> workflowDumpVoList = new ArrayList<WorkflowDumpVo>();
            WorkflowQueryVo workflowQueryVo = (WorkflowQueryVo)processKeyVersionMap.get(string);
            String processName = workflowQueryVo.getName();
            String processDefinitionId = workflowQueryVo.getProcessDefinitionId();
            Integer version = Integer.valueOf(((WorkflowQueryVo)processKeyVersionMap.get(string)).getVersion());
            List sysActAssignees = this.sysActAssigneeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActAssignee::getProcDefKey, (Object)string)).eq(SysActAssignee::getProcessVersion, (Object)version));
            WorkflowDumpVo workflowDumpVoAssignee = new WorkflowDumpVo(processName, string, processDefinitionId, version.intValue(), "\u53c2\u4e0e\u8005.json", IdempotentJsonUtils.toString((Object)sysActAssignees), string + "/" + "\u53c2\u4e0e\u8005.json");
            workflowDumpVoList.add(workflowDumpVoAssignee);
            List sysActFormAuths = this.sysActFormAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActFormAuth::getProcessKey, (Object)string)).and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysActFormAuth::getProcessVersion, (Object)version)).or()).isNull(SysActFormAuth::getProcessVersion);
            }));
            ArrayList<SysActFormAuth> result = new ArrayList<SysActFormAuth>();
            for (SysActFormAuth sysActFormAuth : sysActFormAuths) {
                if (sysActFormAuth.getProcessVersion() == null) continue;
                result.add(sysActFormAuth);
            }
            if (result.isEmpty()) {
                result.addAll(sysActFormAuths);
            }
            WorkflowDumpVo workflowDumpVoFormAuth = new WorkflowDumpVo(processName, string, processDefinitionId, version.intValue(), "\u8868\u5355\u6743\u9650.json", IdempotentJsonUtils.toString(result), string + "/" + "\u8868\u5355\u6743\u9650.json");
            workflowDumpVoList.add(workflowDumpVoFormAuth);
            List sysActHandleAuths = this.sysActHandleAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActHandleAuth::getProcessKey, (Object)string)).eq(SysActHandleAuth::getProcessVersion, (Object)version));
            WorkflowDumpVo workflowDumpVoHandleAuth = new WorkflowDumpVo(processName, string, processDefinitionId, version.intValue(), "\u64cd\u4f5c\u6743\u9650.json", IdempotentJsonUtils.toString((Object)sysActHandleAuths), string + "/" + "\u64cd\u4f5c\u6743\u9650.json");
            workflowDumpVoList.add(workflowDumpVoHandleAuth);
            List sysActExtendProperties = this.sysActExtendPropertiesService.list((Wrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)processDefinitionId));
            WorkflowDumpVo extendPropertiesDumpVo = new WorkflowDumpVo(processName, string, processDefinitionId, version.intValue(), "\u62d3\u5c55.json", IdempotentJsonUtils.toString((Object)sysActExtendProperties), string + "/" + "\u62d3\u5c55.json");
            workflowDumpVoList.add(extendPropertiesDumpVo);
            List sysActProcessFiles = this.sysActProcessFileService.list((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)processDefinitionId));
            WorkflowDumpVo sysActProcessFilesDumpVo = new WorkflowDumpVo(processName, string, processDefinitionId, version.intValue(), "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm", IdempotentJsonUtils.toString((Object)sysActProcessFiles), string + "/" + "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm");
            workflowDumpVoList.add(sysActProcessFilesDumpVo);
            InputStream resourceAsStream = null;
            ByteArrayOutputStream outputStream = null;
            String xmlByteString = null;
            try {
                int temp;
                resourceAsStream = this.processEngine.getProcessEngineConfiguration().getRepositoryService().getProcessModel(processDefinitionId);
                outputStream = new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                while ((temp = resourceAsStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, temp);
                }
                byte[] finalBytes = outputStream.toByteArray();
                xmlByteString = new String(finalBytes);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (resourceAsStream != null) {
                    try {
                        resourceAsStream.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            WorkflowDumpVo xmlDumpVo = new WorkflowDumpVo(processName, string, processDefinitionId, version.intValue(), "bpmn20.xml", xmlByteString, string + "/" + "bpmn20.xml");
            workflowDumpVoList.add(xmlDumpVo);
            workflowDumpVoListMap.put(string, workflowDumpVoList);
        }
        return workflowDumpVoListMap;
    }

    @Override
    public void importWorkflow(Map<String, List<WorkflowDumpVo>> workflowDumpVoListMap, ImportMappingDto importMappingDto) {
        for (String processKey : workflowDumpVoListMap.keySet()) {
            String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(processKey);
            if (HussarUtils.isEmpty((Object)newProcessKey)) continue;
            List<WorkflowDumpVo> workflowDumpVos = workflowDumpVoListMap.get(processKey);
            String lcdpContent = null;
            String xmlContent = null;
            String assigneeContent = null;
            String formAuthContent = null;
            String handleAuthContent = null;
            String extendPropertiesContent = null;
            for (WorkflowDumpVo workflowDumpVo : workflowDumpVos) {
                switch (workflowDumpVo.getFileSuffix()) {
                    case "\u6d41\u7a0b\u6587\u4ef6.lcdpbpm": {
                        lcdpContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "bpmn20.xml": {
                        xmlContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "\u53c2\u4e0e\u8005.json": {
                        assigneeContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "\u8868\u5355\u6743\u9650.json": {
                        formAuthContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "\u64cd\u4f5c\u6743\u9650.json": {
                        handleAuthContent = workflowDumpVo.getContent();
                        break;
                    }
                    case "\u62d3\u5c55.json": {
                        extendPropertiesContent = workflowDumpVo.getContent();
                    }
                }
            }
            ArrayList<String> processKeys = new ArrayList<String>();
            processKeys.add(newProcessKey);
            Integer highestVersion = 0;
            List processMsgByProcessKeys = this.processDefinitionsMapper.getProcessMsgByProcessKeys(processKeys, null);
            if (HussarUtils.isNotEmpty((Object)processMsgByProcessKeys)) {
                highestVersion = Integer.valueOf(((DefinitionModel)processMsgByProcessKeys.get(0)).getVersion());
            }
            Integer finalVersion = highestVersion + 1;
            this.importModel(xmlContent, lcdpContent, importMappingDto, finalVersion);
            this.importAssignee(assigneeContent, importMappingDto, finalVersion);
            this.importFormAuth(formAuthContent, importMappingDto, finalVersion);
            this.importHandleAuth(handleAuthContent, importMappingDto, finalVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importModel(String xmlContent, String lcdpContent, ImportMappingDto importMappingDto, Integer finalVersion) {
        BpmnModel bpmnModel = null;
        XMLStreamReader xtr = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(xmlContent.getBytes());){
            XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
            xtr = xif.createXMLStreamReader(in);
            bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (xtr != null) {
                try {
                    xtr.close();
                }
                catch (XMLStreamException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        String processName = ((Process)bpmnModel.getProcesses().get(0)).getName();
        String oldprocessKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
        String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(oldprocessKey);
        if (HussarUtils.isEmpty((Object)newProcessKey)) {
            return;
        }
        List sysActProcessFiles = JSON.parseArray((String)lcdpContent, SysActProcessFile.class);
        ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
        ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
        List oldSysActProcessFiles = this.sysActProcessFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)newProcessKey));
        for (SysActProcessFile file : sysActProcessFiles) {
            if (HussarUtils.isNotEmpty((Object)oldSysActProcessFiles)) {
                for (SysActProcessFile oldSysActProcessFile : oldSysActProcessFiles) {
                    if (!oldSysActProcessFile.getType().equals(file.getType())) continue;
                    file.setId(oldSysActProcessFile.getId());
                    file.setVersion(Integer.valueOf(0));
                    file.setProcessId(null);
                    if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                        wfdList.add(file);
                        continue;
                    }
                    metaList.add(file);
                }
                continue;
            }
            file.setId(null);
            file.setVersion(Integer.valueOf(0));
            file.setProcessId(null);
            if ("temp-wfd".equals(file.getType()) || "wfd".equals(file.getType())) {
                wfdList.add(file);
                continue;
            }
            metaList.add(file);
        }
        String modelId = this.modelMapper.getIdByIdentity(newProcessKey, null);
        if (HussarUtils.isEmpty((Object)modelId)) {
            Model modelData = this.repositoryService.newModel();
            ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
            modelObjectNode.put("name", processName);
            modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
            modelObjectNode.put("revision", 1);
            modelData.setMetaInfo(modelObjectNode.toString());
            modelData.setName(processName);
            modelData.setKey(newProcessKey);
            modelData.setAppId(importMappingDto.getNewAppId());
            this.repositoryService.saveModel(modelData);
            modelId = modelData.getId();
        }
        WorkFlow workFlow = null;
        for (SysActProcessFile sysActProcessFile : metaList) {
            workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
            workFlow.setAppId(String.valueOf(importMappingDto.getNewAppId()));
            workFlow.setIdentity(newProcessKey);
            workFlow.setModelId(Long.valueOf(modelId));
            workFlow.setVersion(String.valueOf(finalVersion));
            sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
            sysActProcessFile.setModelId(Long.valueOf(modelId));
            sysActProcessFile.setProcessKey(newProcessKey);
        }
        if (workFlow == null) {
            logger.error("workflow is null");
            throw new BpmException("workflow is null");
        }
        for (SysActProcessFile sysActProcessFile : wfdList) {
            String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            wfdFile = this.updateWfdFile(wfdFile, importMappingDto);
            sysActProcessFile.setProcessKey(newProcessKey);
            sysActProcessFile.setModelId(Long.valueOf(modelId));
            sysActProcessFile.setContent(wfdFile.getBytes(StandardCharsets.UTF_8));
            workFlow.setData(wfdFile);
        }
        ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
        addList.addAll(wfdList);
        addList.addAll(metaList);
        this.sysActProcessFileService.saveOrUpdateBatch(addList);
        if (HussarUtils.isNotEmpty((Object)workFlow)) {
            bpmnModel = this.bpm2XMLService.getBpmnModel(workFlow, newProcessKey);
        }
        ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
        jsonConverter.updateConvertersToBpmnMap();
        jsonConverter.updateConvertersToJsonMap();
        ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
        this.repositoryService.addModelEditorSource(modelId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
        this.modelService.deployModel(null, Long.valueOf(Long.parseLong(modelId)), workFlow.getWorkflowStyle(), null, null, false);
    }

    private String updateWfdFile(String wfdFile, ImportMappingDto importMappingDto) {
        Map subTableNameMap = importMappingDto.getSubTableNameMap();
        JSONObject jsonObject = JSON.parseObject((String)wfdFile);
        JSONObject props = jsonObject.getJSONObject("props");
        Object identity = props.get((Object)"identity");
        Object isBackFill = props.get((Object)"isBackfill");
        if (HussarUtils.isNotEmpty((Object)identity)) {
            props.put("identity", importMappingDto.getProcessKeyMap().get(identity.toString()));
        }
        if (HussarUtils.isEmpty((Object)isBackFill) || !((Boolean)isBackFill).booleanValue()) {
            props.put("isBackfill", (Object)true);
        }
        JSONObject processBinding = props.getJSONObject("processBinding");
        Object mainTableName = processBinding.get((Object)"mainTableName");
        Object taskTableName = processBinding.get((Object)"taskTableName");
        Object mainTableBusinessKey = processBinding.get((Object)"mainTableBusinessKey");
        if (HussarUtils.isNotEmpty((Object)mainTableName)) {
            processBinding.put("mainTableName", importMappingDto.getMainTableNameMap().get(mainTableName.toString()));
        }
        if (HussarUtils.isNotEmpty((Object)taskTableName)) {
            processBinding.put("taskTableName", importMappingDto.getTaskTableNameMap().get(taskTableName.toString()));
        }
        if (HussarUtils.isNotEmpty((Object)mainTableBusinessKey)) {
            processBinding.put("mainTableBusinessKey", importMappingDto.getMainTableBusinessKeyMap().get(mainTableBusinessKey.toString()));
        }
        JSONObject slots = jsonObject.getJSONObject("slots");
        JSONArray nodes = slots.getJSONArray("default");
        JSONArray jsonArrayWebMobile = new JSONArray();
        ArrayList<JSONObject> flowAssignmentList = new ArrayList<JSONObject>();
        for (int i = 0; i < nodes.size(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            JSONObject nodeProps = node.getJSONObject("props");
            JSONObject formAddress = nodeProps.getJSONObject("formAddress");
            JSONObject formDetailAddress = nodeProps.getJSONObject("formDetailAddress");
            JSONObject ccFormAddress = nodeProps.getJSONObject("ccFormAddress");
            JSONObject ccFormDetailAddress = nodeProps.getJSONObject("ccFormDetailAddress");
            JSONObject flowAssignment = nodeProps.getJSONObject("flowAssignment");
            if (HussarUtils.isNotEmpty((Object)flowAssignment)) {
                flowAssignmentList.add(flowAssignment);
            }
            JSONArray addressList = new JSONArray();
            if (HussarUtils.isNotEmpty((Object)formAddress)) {
                addressList.add((Object)formAddress);
            }
            if (HussarUtils.isNotEmpty((Object)formDetailAddress)) {
                addressList.add((Object)formDetailAddress);
            }
            if (HussarUtils.isNotEmpty((Object)ccFormAddress)) {
                addressList.add((Object)ccFormAddress);
            }
            if (HussarUtils.isNotEmpty((Object)ccFormDetailAddress)) {
                addressList.add((Object)ccFormDetailAddress);
            }
            if (!HussarUtils.isNotEmpty((Object)addressList)) continue;
            for (int j = 0; j < addressList.size(); ++j) {
                JSONObject address = addressList.getJSONObject(j);
                JSONObject web = address.getJSONObject("web");
                JSONObject mobile = address.getJSONObject("mobile");
                jsonArrayWebMobile.add((Object)web);
                jsonArrayWebMobile.add((Object)mobile);
            }
        }
        JSONArray formAuthJsonArray = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)jsonArrayWebMobile)) {
            for (int k = 0; k < jsonArrayWebMobile.size(); ++k) {
                JSONObject webOrMobile = jsonArrayWebMobile.getJSONObject(k);
                if (!HussarUtils.isNotEmpty((Object)webOrMobile)) continue;
                Object oldFormId = webOrMobile.get((Object)"id");
                webOrMobile.put("id", importMappingDto.getFormIdMap().get(Long.valueOf(oldFormId.toString())));
                if (!HussarUtils.isNotEmpty((Object)subTableNameMap)) continue;
                JSONObject formAuth = webOrMobile.getJSONObject("formAuth");
                JSONArray insShow = formAuth.getJSONArray("insShow");
                JSONArray insHidden = formAuth.getJSONArray("insHidden");
                JSONArray insWrite = formAuth.getJSONArray("insWrite");
                JSONArray insDisabled = formAuth.getJSONArray("insDisabled");
                JSONArray insRequired = formAuth.getJSONArray("insRequired");
                formAuthJsonArray.add((Object)insShow);
                formAuthJsonArray.add((Object)insHidden);
                formAuthJsonArray.add((Object)insWrite);
                formAuthJsonArray.add((Object)insDisabled);
                formAuthJsonArray.add((Object)insRequired);
            }
        }
        for (int i = 0; i < formAuthJsonArray.size(); ++i) {
            JSONArray jsonArray = formAuthJsonArray.getJSONArray(i);
            for (int j = 0; j < jsonArray.size(); ++j) {
                String oldFieldId = jsonArray.getString(j);
                if (!subTableNameMap.containsKey(oldFieldId)) continue;
                jsonArray.remove(j);
                jsonArray.add(j, subTableNameMap.get(oldFieldId));
            }
        }
        Map roleIdMap = importMappingDto.getRoleIdMap();
        if (HussarUtils.isNotEmpty((Object)roleIdMap)) {
            for (JSONObject flowAssignment : flowAssignmentList) {
                String defaultBackCondtion = flowAssignment.getString("defaultBackCondtion");
                if (HussarUtils.isNotEmpty((Object)defaultBackCondtion) && defaultBackCondtion.contains("GRANTED_ROLE")) {
                    for (Long key : roleIdMap.keySet()) {
                        defaultBackCondtion = defaultBackCondtion.replace(String.valueOf(key), String.valueOf(roleIdMap.get(key)));
                    }
                    flowAssignment.put("defaultBackCondtion", (Object)defaultBackCondtion);
                }
                JSONArray participantConfigs = flowAssignment.getJSONArray("participantConfigs");
                JSONObject participantConfig = participantConfigs.getJSONObject(0);
                JSONArray configsEvents = participantConfig.getJSONArray("configsEvent");
                for (int i = 0; i < configsEvents.size(); ++i) {
                    JSONObject configsEvent = configsEvents.getJSONObject(i);
                    if (!configsEvent.getString("variable").contains("GRANTED_ROLE")) continue;
                    configsEvent.put("varLimitId", (Object)String.valueOf(roleIdMap.get(configsEvent.getLong("varLimitId"))));
                }
            }
        }
        wfdFile = JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        return wfdFile;
    }

    private void importAssignee(String assigneeContent, ImportMappingDto importMappingDto, Integer finalVersion) {
        List list = JSON.parseArray((String)assigneeContent, SysActAssignee.class);
        Map roleIdMap = importMappingDto.getRoleIdMap();
        if (HussarUtils.isNotEmpty((Object)list)) {
            String oldProcessKey = ((SysActAssignee)list.get(0)).getProcDefKey();
            String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(oldProcessKey);
            if (HussarUtils.isEmpty((Object)newProcessKey)) {
                return;
            }
            list.forEach(sysActAssignee -> {
                sysActAssignee.setProcDefKey(newProcessKey);
                sysActAssignee.setProcessVersion(finalVersion);
                sysActAssignee.setId(null);
                if (HussarUtils.isNotEmpty((Object)roleIdMap)) {
                    String content;
                    String string = content = HussarUtils.isEmpty((Object)sysActAssignee.getContent()) ? "" : new String(sysActAssignee.getContent(), StandardCharsets.UTF_8);
                    if (HussarUtils.isNotEmpty((Object)content) && content.contains("GRANTED_ROLE")) {
                        for (Long key : roleIdMap.keySet()) {
                            content = content.replace(String.valueOf(key), String.valueOf(roleIdMap.get(key)));
                        }
                        sysActAssignee.setContent(HussarUtils.isEmpty((Object)content) ? "".getBytes(StandardCharsets.UTF_8) : content.getBytes(StandardCharsets.UTF_8));
                    }
                }
            });
            this.sysActAssigneeService.saveBatch((Collection)list);
        }
    }

    private void importFormAuth(String formAuthContent, ImportMappingDto importMappingDto, Integer finalVersion) {
        Map subTableNameMap = importMappingDto.getSubTableNameMap();
        List list = JSON.parseArray((String)formAuthContent, SysActFormAuth.class);
        if (HussarUtils.isNotEmpty((Object)list)) {
            String oldProcessKey = ((SysActFormAuth)list.get(0)).getProcessKey();
            Long oldFormId = ((SysActFormAuth)list.get(0)).getFormId();
            String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(oldProcessKey);
            if (HussarUtils.isEmpty((Object)newProcessKey)) {
                return;
            }
            Long newFormId = (Long)importMappingDto.getFormIdMap().get((long)oldFormId);
            list.forEach(sysActFormAuth -> {
                sysActFormAuth.setFormId(newFormId.longValue());
                sysActFormAuth.setProcessKey(newProcessKey);
                sysActFormAuth.setProcessVersion(finalVersion);
                sysActFormAuth.setId(null);
                if (HussarUtils.isNotEmpty((Object)subTableNameMap)) {
                    String insDisabled = sysActFormAuth.getInsDisabled();
                    String insHidden = sysActFormAuth.getInsHidden();
                    String insShow = sysActFormAuth.getInsShow();
                    String insRequired = sysActFormAuth.getInsRequired();
                    String insWrite = sysActFormAuth.getInsWrite();
                    for (String key : subTableNameMap.keySet()) {
                        insDisabled = insDisabled.replace(key, (CharSequence)subTableNameMap.get(key));
                        insHidden = insHidden.replace(key, (CharSequence)subTableNameMap.get(key));
                        insShow = insShow.replace(key, (CharSequence)subTableNameMap.get(key));
                        insRequired = insRequired.replace(key, (CharSequence)subTableNameMap.get(key));
                        insWrite = insWrite.replace(key, (CharSequence)subTableNameMap.get(key));
                    }
                    sysActFormAuth.setInsDisabled(insDisabled);
                    sysActFormAuth.setInsHidden(insHidden);
                    sysActFormAuth.setInsShow(insShow);
                    sysActFormAuth.setInsRequired(insRequired);
                    sysActFormAuth.setInsWrite(insWrite);
                }
            });
            this.sysActFormAuthService.saveBatch((Collection)list);
        }
    }

    private void importHandleAuth(String handleAuthContent, ImportMappingDto importMappingDto, Integer finalVersion) {
        List list = JSON.parseArray((String)handleAuthContent, SysActHandleAuth.class);
        if (HussarUtils.isNotEmpty((Object)list)) {
            String oldProcessKey = ((SysActHandleAuth)list.get(0)).getProcessKey();
            String newProcessKey = (String)importMappingDto.getProcessKeyMap().get(oldProcessKey);
            if (HussarUtils.isEmpty((Object)newProcessKey)) {
                return;
            }
            list.forEach(sysActHandleAuth -> {
                sysActHandleAuth.setProcessKey(newProcessKey);
                sysActHandleAuth.setProcessVersion(finalVersion);
                sysActHandleAuth.setId(null);
            });
            this.sysActHandleAuthService.saveBatch((Collection)list);
        }
    }

    private Map<String, WorkflowQueryVo> queryProcessKeyVersionMap(Long appId, String processDefinitionKey) {
        List<WorkflowQueryVo> processKeyList = this.godAxeWorkflowMigrationMapper.queryProcessKeyList(appId, processDefinitionKey);
        HashMap<String, WorkflowQueryVo> processKeyVersionMap = new HashMap<String, WorkflowQueryVo>();
        for (WorkflowQueryVo workflowQueryVo : processKeyList) {
            if (processKeyVersionMap.containsKey(workflowQueryVo.getProcessKey())) continue;
            processKeyVersionMap.put(workflowQueryVo.getProcessKey(), workflowQueryVo);
        }
        return processKeyVersionMap;
    }
}

