/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.assignee.service.impl;

import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.config.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.godaxe.assignee.service.INocodeAssigneeDSChooseService;
import com.jxdinfo.hussar.workflow.godaxe.assignee.service.INocodeAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.godaxe.assignee.service.INocodeWorkflowAssigneeChooseService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NocodeAssignModeChooseServiceImpl
implements INocodeAssigneeModeChooseService {
    @Autowired
    private INocodeWorkflowAssigneeChooseService nocodeWorkflowAssigneeChooseService;
    @Autowired
    private INocodeAssigneeDSChooseService nocodeAssigneeDSChooseService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    private final IBpmConfigService bpmConfigService;
    private static final String TABLE_PREFIX = "table_prefix";
    public static final String IMPORT = "import";
    public static final String REMOTE_INTERFACE = "remote-interface";
    public static final String REMOTE_DATA_SOURCE = "remote-datasource";

    public NocodeAssignModeChooseServiceImpl(IBpmConfigService bpmConfigService) {
        this.bpmConfigService = bpmConfigService;
    }

    private String getTablePrefix() {
        return this.bpmConfigService.getStringByKeyUseCache(TABLE_PREFIX);
    }

    private String connName() {
        return this.lcdpBpmProperties.getRemoteDBName();
    }

    private String getAssigneeMode() {
        return this.lcdpBpmProperties.getAssigneeMode();
    }

    private boolean getIdType() {
        String assigneeModel = this.getAssigneeMode();
        if (IMPORT.equals(assigneeModel)) {
            return !"workflow-platform".equals(this.lcdpBpmProperties.getDeploymentModel());
        }
        return this.lcdpBpmProperties.getTenantDBPrimaryKeyIsLong();
    }

    public String dealPath(String path) {
        return this.lcdpBpmProperties.getTenantCallAddress() + path;
    }

    @Override
    public List<BpmTreeModel> roleTreeByAppId(String id, String appId, String tablePrefix) {
        String assigneeModel;
        switch (assigneeModel = this.getAssigneeMode()) {
            case "import": {
                return this.nocodeWorkflowAssigneeChooseService.roleTreeByAppId(id, this.getIdType(), tablePrefix, appId);
            }
            case "remote-interface": {
                return new ArrayList<BpmTreeModel>();
            }
        }
        return this.nocodeAssigneeDSChooseService.roleTreeByAppId(id, this.connName(), this.getIdType(), tablePrefix, appId);
    }
}

