/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSONObject;
import com.inspur.frame.security.JwtFlag;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.api.entity.ProcessInstanceBatchParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.ProcessInstanceDeleteParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.ProcessParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.StartProcessParam;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import io.swagger.annotations.Api;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"EngineInstanceEngine"})
@RequestMapping(value={"/engineInstanceEngine"})
public class EngineInstanceEngineController {
    @PostMapping(value={"/startProcessInstanceById"})
    @JwtFlag(inUse=false)
    public BpmResponseResult startProcessInstanceById(@RequestBody StartProcessParam param) {
        return InstanceEngineService.startProcessInstanceById((String)param.getProcessDefinitionId(), (String)param.getUserId(), (String)param.getBusinessId(), (Map)param.getVariables());
    }

    @PostMapping(value={"/startProcessInstanceByKey"})
    @JwtFlag(inUse=false)
    public BpmResponseResult startProcessInstanceByKey(@RequestBody StartProcessParam param) {
        return InstanceEngineService.startProcessInstanceByKey((String)param.getProcessKey(), (String)param.getUserId(), (String)param.getBusinessId(), (Map)param.getVariables());
    }

    @GetMapping(value={"/checkProcessInstByBusinessKey/{businessId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult checkProcessInstByBusinessKey(@PathVariable(value="businessId") String businessId) {
        return InstanceEngineService.checkProcessInstByBusinessKey((String)businessId);
    }

    @GetMapping(value={"/validateEditAuthority/{businessId}"})
    @JwtFlag(inUse=false)
    public ApiResponse<JSONObject> validateEditAuthority(@PathVariable(value="businessId") String businessId) {
        return InstanceEngineService.validateEditAuthority((String)businessId);
    }

    @GetMapping(value={"/validateDeleteByBusinessKey/{businessId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult validateDeleteByBusinessKey(@PathVariable(value="businessId") String businessId) {
        return InstanceEngineService.validateDeleteByBusinessKey((String)businessId);
    }

    @PostMapping(value={"/suspendProcessInstanceById"})
    @JwtFlag(inUse=false)
    public BpmResponseResult suspendProcessInstanceById(@RequestBody String processInsId) {
        return InstanceEngineService.suspendProcessInstanceById((String)processInsId);
    }

    @PostMapping(value={"/activateProcessInstanceById"})
    @JwtFlag(inUse=false)
    public BpmResponseResult activateProcessInstanceById(@RequestBody String processInsId) {
        return InstanceEngineService.activateProcessInstanceById((String)processInsId);
    }

    @PostMapping(value={"/deleteProcessInstance"})
    @JwtFlag(inUse=false)
    public BpmResponseResult deleteProcessInstance(@RequestBody ProcessInstanceDeleteParam param) {
        return InstanceEngineService.deleteProcessInstance((String)param.getProcessInsId(), (String)param.getReason());
    }

    @PostMapping(value={"/deleteFinishedProcessInstance"})
    @JwtFlag(inUse=false)
    public BpmResponseResult deleteFinishedProcessInstance(@RequestBody String processInsId) {
        return InstanceEngineService.deleteFinishedProcessInstance((String)processInsId);
    }

    @PostMapping(value={"/deleteProcessInstanceByBusinessKey"})
    @JwtFlag(inUse=false)
    public BpmResponseResult deleteProcessInstanceByBusinessKey(@RequestBody String businessId) {
        return InstanceEngineService.deleteProcessInstanceByBusinessKey((String)businessId);
    }

    @PostMapping(value={"/deleteProcessInstanceByBusinessKeyList"})
    @JwtFlag(inUse=false)
    public BpmResponseResult deleteProcessInstanceByBusinessKeyList(@RequestBody ProcessInstanceBatchParam param) {
        return InstanceEngineService.deleteProcessInstanceByBusinessKeyList((String)param.getBusinessId(), (boolean)param.isValidate());
    }

    @GetMapping(value={"/queryFinishedProcessInstance"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryFinishedProcessInstance(@RequestParam String processKey, @RequestParam String businessId, @RequestParam Integer page, @RequestParam Integer size) {
        return InstanceEngineService.queryFinishedProcessInstance((String)processKey, (String)businessId, (int)page, (int)size);
    }

    @GetMapping(value={"/queryProcessInstanceCompleteState/{processInsId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryProcessInstanceCompleteState(@PathVariable(value="processInsId") String processInsId) {
        return InstanceEngineService.queryProcessInstanceCompleteState((String)processInsId);
    }

    @GetMapping(value={"/queryProcessInstanceCompleteStateByBusinessKey/{businessId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(@PathVariable(value="businessId") String businessId) {
        return InstanceEngineService.queryProcessInstanceCompleteStateByBusinessKey((String)businessId);
    }

    @GetMapping(value={"/getProcessTrace/{processInsId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult getProcessTrace(@PathVariable(value="processInsId") String processInsId) {
        return InstanceEngineService.getProcessTrace((String)processInsId);
    }

    @GetMapping(value={"/getAllProcessTrace/{processInsId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult getAllProcessTrace(@PathVariable(value="processInsId") String processInsId) {
        return InstanceEngineService.getAllProcessTrace((String)processInsId);
    }

    @GetMapping(value={"/queryCallActivityTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryCallActivityTask(@RequestParam String businessId, @RequestParam String processInsId) {
        return InstanceEngineService.queryCallActivityTask((String)businessId, (String)processInsId);
    }

    @PostMapping(value={"/queryMainActivityTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryMainActivityTask(@RequestParam String businessId, @RequestParam String processInsId) {
        return InstanceEngineService.queryCallActivityTask((String)businessId, (String)processInsId);
    }

    @GetMapping(value={"/getAllProcessTraceByBusinessKey"})
    @JwtFlag(inUse=false)
    public BpmResponseResult getAllProcessTraceByBusinessKey(@RequestParam String businessId, @RequestParam Integer page, @RequestParam Integer size) {
        return InstanceEngineService.getAllProcessTraceByBusinessKey((String)businessId, (int)page, (int)size);
    }

    @GetMapping(value={"/queryProcessDefinitionByInstanceId/{processInsId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryProcessDefinitionByInstanceId(@PathVariable(value="processInsId") String processInsId) {
        return InstanceEngineService.queryProcessDefinitionByInstanceId((String)processInsId);
    }

    @PostMapping(value={"/endProcess"})
    @JwtFlag(inUse=false)
    public BpmResponseResult endProcess(@RequestBody ProcessParam processModel) {
        return InstanceEngineService.endProcess((String)processModel.getTaskId(), (String)processModel.getUserId(), (String)processModel.getReason());
    }

    @PostMapping(value={"/queryCompletecomment"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryCompletecomment(@RequestParam String businessId, @RequestParam String processInsId, @RequestParam String tenantId) {
        return InstanceEngineService.queryCompletecomment((String)businessId, (String)processInsId, (String)tenantId);
    }
}

