/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.inspur.frame.security.JwtFlag;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.api.entity.AddAssigneesParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.AddCustomNodeParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.ClaimTaskParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.CompleteTaskParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.DelegateTaskParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.FreeJumpParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.MultiInstanceAddAssigneeParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.ReStartProcessParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.ReceiveTaskParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.RejectTaskParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.RevokeTaskParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.SecurityLevelParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.TaskCommentParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.UpdateStarterParam;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"BpmTaskEngine"})
@RequestMapping(value={"/bpmTaskEngine"})
public class BpmTaskEngineController {
    @GetMapping(value={"/queryTask/{taskId}"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryTask(@PathVariable String taskId) {
        return TaskEngineService.queryTask((String)taskId);
    }

    @GetMapping(value={"/queryAllToDoTaskList"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryAllToDoTaskList(@RequestParam String processName, @RequestParam String processKey, @RequestParam String startTime, @RequestParam String endTime, @RequestParam String timeoutState, @RequestParam String suspensionState, @RequestParam String todoConfiguration, @RequestParam Integer page, @RequestParam Integer size) {
        return TaskEngineService.queryAllToDoTaskList((String)processName, (String)processKey, (String)startTime, (String)endTime, (String)timeoutState, (String)suspensionState, (String)todoConfiguration, (Integer)page, (Integer)size);
    }

    @GetMapping(value={"/queryAllToDoTaskListByBusiness"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryAllToDoTaskListByBusiness(@RequestParam String processName, @RequestParam String processKey, @RequestParam String startTime, @RequestParam String endTime, @RequestParam String timeoutState, @RequestParam String suspensionState, @RequestParam String todoConfiguration, @RequestParam List<String> businessList, @RequestParam Integer page, @RequestParam Integer size) {
        return TaskEngineService.queryAllToDoTaskListByBusiness((String)processName, (String)processKey, (String)startTime, (String)endTime, (String)timeoutState, (String)suspensionState, (String)todoConfiguration, businessList, (Integer)page, (Integer)size);
    }

    @GetMapping(value={"/queryToDoTaskList"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryToDoTaskList(@RequestParam String userId, @RequestParam String processKey, @RequestParam String definitionKey) {
        return TaskEngineService.queryToDoTaskList((String)userId, (String)processKey, (String)definitionKey);
    }

    @GetMapping(value={"/queryToDoTaskListPage"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryToDoTaskList(@RequestParam String userId, @RequestParam String processKey, @RequestParam String definitionKey, @RequestParam Integer page, @RequestParam Integer size) {
        return TaskEngineService.queryToDoTaskList((String)userId, (String)processKey, (String)definitionKey, (Integer)page, (Integer)size);
    }

    @GetMapping(value={"/queryToDoTaskListByBusinessIds"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryToDoTaskListByBusinessIds(@RequestParam String userId, @RequestParam List<String> businessIds) {
        return TaskEngineService.queryToDoTaskList((String)userId, businessIds);
    }

    @GetMapping(value={"/queryFinishedTaskList"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryFinishedTaskList(@RequestParam String userId, @RequestParam String processKey, @RequestParam String definitionKey) {
        return TaskEngineService.queryFinishedTaskList((String)userId, (String)processKey, (String)definitionKey);
    }

    @GetMapping(value={"/queryFinishedTaskListPage"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryFinishedTaskListPage(@RequestParam String userId, @RequestParam String processKey, @RequestParam String definitionKey, @RequestParam Integer page, @RequestParam Integer size) {
        return TaskEngineService.queryFinishedTaskList((String)userId, (String)processKey, (String)definitionKey, (Integer)page, (Integer)size);
    }

    @GetMapping(value={"/queryUserTaskCount/{userId}"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryUserTaskCount(@PathVariable String userId) {
        return TaskEngineService.queryUserTaskCount((String)userId);
    }

    @GetMapping(value={"/queryUserTaskCountByNode/{userId}"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryUserTaskCountByNode(@PathVariable String userId) {
        return TaskEngineService.queryUserTaskCountByNode((String)userId);
    }

    @PostMapping(value={"/claimTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult claimTask(@RequestBody ClaimTaskParam param) {
        return TaskEngineService.claimTask((String)param.getTaskId(), (String)param.getUserId());
    }

    @PostMapping(value={"/unClaimTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult unClaimTask(@RequestBody String taskId) {
        return TaskEngineService.unClaimTask((String)taskId);
    }

    @PostMapping(value={"/completeTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeTask(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeTask((String)param.getTaskId(), (String)param.getUserId(), (Map)param.getMap());
    }

    @PostMapping(value={"/completeTaskAssignee"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeTaskAssignee(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeTask((String)param.getTaskId(), (String)param.getUserId(), (Map)param.getAssigneeMap(), (Map)param.getMap());
    }

    @PostMapping(value={"/completeTaskCommentAssignee"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeTaskCommentAssignee(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeTask((String)param.getTaskId(), (String)param.getUserId(), (Map)param.getAssigneeMap(), (String)param.getComment(), (Map)param.getMap());
    }

    @PostMapping(value={"/completeTaskComment"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeTaskComment(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getComment(), (Map)param.getMap());
    }

    @PostMapping(value={"/completeTaskSubProcesses"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeTaskSubProcesses(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getComment(), (String)param.getSubProcesses(), (Map)param.getMap());
    }

    @PostMapping(value={"/completeTaskUsers"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeTaskUsers(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeTask((String)param.getTaskId(), (String)param.getUserId(), (Map)param.getAssigneeMap(), (Set)param.getUsers(), (String)param.getComment(), (Map)param.getMap());
    }

    @PostMapping(value={"/completeTaskNoAuditAuthority"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeTaskNoAuditAuthority(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeTaskNoAuditAuthority((String)param.getTaskId(), (String)param.getUserId(), (Map)param.getAssigneeMap(), (Set)param.getUsers(), (String)param.getComment(), (Map)param.getMap());
    }

    @PostMapping(value={"/completeLeapTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeLeapTask(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeLeapTask((String)param.getTaskId(), (String)param.getUserId(), (Map)param.getAssigneeMap(), (String)param.getComment(), (Map)param.getMap());
    }

    @PostMapping(value={"/completeLeapTaskUsers"})
    @JwtFlag(inUse=false)
    public BpmResponseResult completeLeapTaskUsers(@RequestBody CompleteTaskParam param) {
        return TaskEngineService.completeLeapTask((String)param.getTaskId(), (String)param.getUserId(), (Map)param.getAssigneeMap(), (Set)param.getUsers(), (String)param.getComment(), (Map)param.getMap());
    }

    @PostMapping(value={"/rejectToLastTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult rejectToLastTask(@RequestBody RejectTaskParam param) {
        return TaskEngineService.rejectToLastTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getComment(), (boolean)param.isSubmit(), (Map)param.getMap());
    }

    @PostMapping(value={"/rejectToLastTaskAssignees"})
    @JwtFlag(inUse=false)
    public BpmResponseResult rejectToLastTaskAssignees(@RequestBody RejectTaskParam param) {
        return TaskEngineService.rejectToLastTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getComment(), (String)param.getAssignees(), (boolean)param.isSubmit(), (Map)param.getMap());
    }

    @PostMapping(value={"/rejectToFirstTaskAssignees"})
    @JwtFlag(inUse=false)
    public BpmResponseResult rejectToFirstTaskAssignees(@RequestBody RejectTaskParam param) {
        return TaskEngineService.rejectToFirstTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getComment(), (String)param.getAssignees(), (boolean)param.isSubmit(), (Map)param.getMap());
    }

    @PostMapping(value={"/rejectToFirstTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult rejectToFirstTask(@RequestBody RejectTaskParam param) {
        return TaskEngineService.rejectToFirstTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getComment(), (boolean)param.isSubmit(), (Map)param.getMap());
    }

    @PostMapping(value={"/rejectToAnyTaskAssignees"})
    @JwtFlag(inUse=false)
    public BpmResponseResult rejectToAnyTaskAssignees(@RequestBody RejectTaskParam param) {
        return TaskEngineService.rejectToAnyTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getBackActivityId(), (String)param.getComment(), (String)param.getAssignees(), (boolean)param.isSubmit(), (Map)param.getMap());
    }

    @PostMapping(value={"/rejectToAnyTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult rejectToAnyTask(@RequestBody RejectTaskParam param) {
        return TaskEngineService.rejectToAnyTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getBackActivityId(), (String)param.getComment(), (boolean)param.isSubmit(), (Map)param.getMap());
    }

    @GetMapping(value={"/queryRejectNode/{taskId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryRejectNode(@PathVariable String taskId) {
        return TaskEngineService.queryRejectNode((String)taskId);
    }

    @PostMapping(value={"/delegateTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult delegateTask(@RequestBody DelegateTaskParam param) {
        return TaskEngineService.delegateTask((String)param.getTaskId(), (String)param.getUserId());
    }

    @PostMapping(value={"/entrustTaskUserId"})
    @JwtFlag(inUse=false)
    public BpmResponseResult entrustTaskUserId(@RequestBody DelegateTaskParam param) {
        return TaskEngineService.entrustTask((String)param.getTaskId(), (String)param.getUserId(), (String)param.getMandatary());
    }

    @PostMapping(value={"/entrustTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult entrustTask(@RequestBody DelegateTaskParam param) {
        return TaskEngineService.entrustTask((String)param.getTaskId(), (String)param.getMandatary());
    }

    @PostMapping(value={"/freeJump"})
    @JwtFlag(inUse=false)
    public BpmResponseResult freeJump(@RequestBody FreeJumpParam param) {
        return TaskEngineService.freeJump((String)param.getTaskId(), (String)param.getActivitiId(), (String)param.getUserId(), (String)param.getAssignees(), (boolean)param.isSubmit(), (String)param.getComment(), (Map)param.getMap());
    }

    @PostMapping(value={"/multiInstanceAddAssignee"})
    @JwtFlag(inUse=false)
    public BpmResponseResult multiInstanceAddAssignee(@RequestBody MultiInstanceAddAssigneeParam param) {
        return TaskEngineService.multiInstanceAddAssignee((String)param.getTaskId(), (List)param.getAssigneeList());
    }

    @GetMapping(value={"/queryAssigneeByTaskId/{taskId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryAssigneeByTaskId(@PathVariable String taskId) {
        return TaskEngineService.queryAssigneeByTaskId((String)taskId);
    }

    @PostMapping(value={"/addAssignees"})
    @JwtFlag(inUse=false)
    public BpmResponseResult addAssignees(@RequestBody AddAssigneesParam param) {
        return TaskEngineService.addAssignees((String)param.getTaskId(), (String)param.getBusinessId(), (String)param.getUsers());
    }

    @PostMapping(value={"/taskAddAssignee"})
    @JwtFlag(inUse=false)
    public BpmResponseResult taskAddAssignee(@RequestBody AddAssigneesParam param) {
        return TaskEngineService.taskAddAssignee((String)param.getTaskId(), (String)param.getMandatary());
    }

    @GetMapping(value={"/queryProcessNodeByTaskId/{taskId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryProcessNodeByTaskId(@PathVariable String taskId) {
        return TaskEngineService.queryProcessNodeByTaskId((String)taskId);
    }

    @GetMapping(value={"/queryNextAssigneeByTaskIdAndNodeId"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(@RequestParam String taskId, @RequestParam String nodeId, @RequestParam Map<String, Object> map) {
        return TaskEngineService.queryNextAssigneeByTaskIdAndNodeId((String)taskId, (String)nodeId, map);
    }

    @GetMapping(value={"/queryNextAssigneeUserId"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryNextAssigneeUserId(@RequestParam String processKey, @RequestParam String taskId, @RequestParam String nodeId, @RequestParam String userId, @RequestParam Map<String, Object> map) {
        return TaskEngineService.queryNextAssignee((String)processKey, (String)taskId, (String)nodeId, (String)userId, map);
    }

    @GetMapping(value={"/queryNextAssignee"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryNextAssignee(String processKey, String taskId, String nodeId, Map<String, Object> map) {
        return TaskEngineService.queryNextAssignee((String)processKey, (String)taskId, (String)nodeId, map);
    }

    @GetMapping(value={"/queryAllAssignee/{processKey}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryAllAssignee(@PathVariable String processKey) {
        return TaskEngineService.queryAllAssignee((String)processKey);
    }

    @GetMapping(value={"/queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey/{processKey}/{taskDefinitionKey}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey(@PathVariable String processKey, @PathVariable String taskDefinitionKey) {
        return TaskEngineService.queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey((String)processKey, (String)taskDefinitionKey);
    }

    @GetMapping(value={"/queryHistoryActByTaskId/{taskId}"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> queryHistoryActByTaskId(@PathVariable String taskId) {
        return TaskEngineService.queryHistoryActByTaskId((String)taskId);
    }

    @GetMapping(value={"/getProcessDefinitionIdAndNodeId/{processKey}/{taskId}"})
    @JwtFlag(inUse=false)
    public ApiResponse<?> getProcessDefinitionIdAndNodeId(@PathVariable String processKey, @PathVariable String taskId) {
        return TaskEngineService.getProcessDefinitionIdAndNodeId((String)processKey, (String)taskId);
    }

    @GetMapping(value={"/queryTaskIdByBusinessKey/{businessId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryTaskIdByBusinessKey(@PathVariable String businessId) {
        return TaskEngineService.queryTaskIdByBusinessKey((String)businessId);
    }

    @GetMapping(value={"/queryNextNode/{taskId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryNextNode(@PathVariable String taskId) {
        return TaskEngineService.queryNextNode((String)taskId);
    }

    @GetMapping(value={"/queryNextNodeProcessKey/{processKey}/{taskId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryNextNodeProcessKey(@PathVariable String processKey, @PathVariable String taskId) {
        return TaskEngineService.queryNextNode((String)processKey, (String)taskId);
    }

    @GetMapping(value={"/queryRejectNodeOrNextNode/{processKey}/{taskId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryRejectNodeOrNextNode(String processKey, String taskId) {
        return TaskEngineService.queryRejectNodeOrNextNode((String)processKey, (String)taskId);
    }

    @GetMapping(value={"/queryNextNodeLineCondition"})
    @JwtFlag(inUse=false)
    public BpmResponseResult queryNextNodeLineCondition(@RequestParam String processKey, @RequestParam String taskId, @RequestParam Map<String, Object> lineCondition) {
        return TaskEngineService.queryNextNode((String)processKey, (String)taskId, lineCondition);
    }

    @PostMapping(value={"/withdrawState"})
    @JwtFlag(inUse=false)
    public BpmResponseResult withdrawState(@RequestBody String historicTaskId) {
        return TaskEngineService.withdrawState((String)historicTaskId);
    }

    @PostMapping(value={"/revokeTask"})
    @JwtFlag(inUse=false)
    public BpmResponseResult revokeTask(@RequestBody RevokeTaskParam param) {
        return TaskEngineService.revokeTask((String)param.getHistoricTaskId(), (String)param.getUserId(), (String)param.getComment(), (boolean)param.isSubmit(), (Map)param.getMap());
    }

    @PostMapping(value={"/editTaskComment"})
    @JwtFlag(inUse=false)
    public BpmResponseResult editTaskComment(@RequestBody TaskCommentParam param) {
        return TaskEngineService.editTaskComment((String)param.getTaskId(), (String)param.getComment());
    }

    @PostMapping(value={"/reStartProcess"})
    @JwtFlag(inUse=false)
    public BpmResponseResult reStartProcess(@RequestBody ReStartProcessParam param) {
        return TaskEngineService.reStartProcess((String)param.getProcessInsId(), (String)param.getBusinessId(), (String)param.getTaskDefinitionKey(), (String)param.getUserId(), (String)param.getAssignee(), (boolean)param.isSubmit(), (Map)param.getMap());
    }

    @PostMapping(value={"/addCustomNode"})
    @JwtFlag(inUse=false)
    public ApiResponse<String> addCustomNode(@RequestBody AddCustomNodeParam param) {
        return TaskEngineService.addCustomNode((String)param.getTaskId(), (List)param.getAddList(), (String)param.getParallel());
    }

    @PostMapping(value={"/isAddParallel"})
    @JwtFlag(inUse=false)
    public ApiResponse<String> isAddParallel(@RequestBody String taskId) {
        return TaskEngineService.isAddParallel((String)taskId);
    }

    @PostMapping(value={"/multiInstanceDel"})
    @JwtFlag(inUse=false)
    public BpmResponseResult multiInstanceDel(@RequestBody String taskId) {
        return TaskEngineService.multiInstanceDelAssignee((String)taskId);
    }

    @PostMapping(value={"/multiInstanceDelAssignee"})
    @JwtFlag(inUse=false)
    public BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        return TaskEngineService.multiInstanceDelAssignee((String)taskId, (String)assignees);
    }

    @PostMapping(value={"/updateUserSecurityLevel"})
    @JwtFlag(inUse=false)
    public BpmResponseResult updateUserSecurityLevel(@RequestBody SecurityLevelParam param) {
        return TaskEngineService.updateUserSecurityLevel((String)param.getUserId(), (Integer)param.getLevel());
    }

    @PostMapping(value={"/activeTaskCandidates"})
    @JwtFlag(inUse=false)
    public BpmResponseResult activeTaskCandidates(@RequestBody String taskId) {
        return TaskEngineService.activeTaskCandidates((String)taskId);
    }

    @PostMapping(value={"/updateStarter"})
    @JwtFlag(inUse=false)
    public BpmResponseResult updateStarter(@RequestBody UpdateStarterParam param) {
        return TaskEngineService.updateStarter((String)param.getProcessInsId(), (String)param.getBusinessId(), (String)param.getUserId());
    }

    @GetMapping(value={"/getExecutionByBusinessKey/{businessId}"})
    @JwtFlag(inUse=false)
    public BpmResponseResult getExecutionByBusinessKey(@PathVariable String businessId) {
        return TaskEngineService.getExecutionByBusinessKey((String)businessId);
    }

    @PostMapping(value={"/receiveTaskSignal"})
    @JwtFlag(inUse=false)
    public BpmResponseResult receiveTaskSignal(@RequestBody ReceiveTaskParam param) {
        return TaskEngineService.receiveTaskSignal((String)param.getExecutionId(), (Map)param.getMap());
    }
}

