/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.tenant;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.inspur.frame.security.JwtFlag;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.model.BpmSysTenant;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.IBpmSysTenantService;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.core.util.HussarBpmSM4Util;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u79df\u6237\u914d\u7f6e\u4fe1\u606f\u7ba1\u7406"})
@RequestMapping(value={"/tenant"})
public class TenantController {
    @Autowired
    ITenantConfigService tenantConfigService;
    @Autowired
    private IBpmSysTenantService sysTenantService;
    @Autowired
    ISysUserService sysUserService;

    @GetMapping(value={"/editUserConfig"})
    @ApiOperation(value="\u4fee\u6539\u767b\u5f55\u8d26\u6237\u7684\u9879\u76ee\u914d\u7f6e", notes="\u4fee\u6539\u767b\u5f55\u8d26\u6237\u7684\u9879\u76ee\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="isMqUse", value="\u662f\u5426\u4f7f\u7528mq", required=true, paramType="query"), @ApiImplicitParam(name="address", value="\u9879\u76ee\u5730\u5740", required=true, paramType="query"), @ApiImplicitParam(name="isGodAxe", value="\u662f\u5426\u5929\u65a7", required=true, paramType="query"), @ApiImplicitParam(name="isMultiTenant", value="\u662f\u5426\u5171\u5e93", required=true, paramType="query")})
    @JwtFlag(inUse=false)
    public ApiResponse<?> editUserConfig(String isMqUse, String address, String isGodAxe, String isMultiTenant) {
        try {
            TenantConfig tenantConfig = new TenantConfig();
            tenantConfig.setProjectAddress(address);
            tenantConfig.setIsMultiTenant(isMultiTenant);
            tenantConfig.setIsMqUse(isMqUse);
            tenantConfig.setIsGodAxe(isGodAxe);
            tenantConfig.setId(BaseSecurityUtil.getUser().getStringTenantId());
            this.tenantConfigService.editTenantConfig(tenantConfig);
            return ApiResponse.success((int)BpmEnum.SUCCESS_UPDATE.getCode(), (String)BpmEnum.SUCCESS_UPDATE.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)BpmEnum.ERROR_UPDATE.getCode(), (String)BpmEnum.ERROR_UPDATE.getMessage());
        }
    }

    @GetMapping(value={"/getUserConfig"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u914d\u7f6e\u4fe1\u606f")
    @JwtFlag(inUse=false)
    public ApiResponse<?> getUserConfig() {
        TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(BaseSecurityUtil.getUser().getStringTenantId());
        return ApiResponse.success((Object)tenantConfig);
    }

    @GetMapping(value={"/personalQuery"})
    @ApiOperation(value="\u67e5\u8be2\u767b\u5f55\u8d26\u6237\u7684\u4fe1\u606f", notes="\u67e5\u8be2\u767b\u5f55\u8d26\u6237\u7684\u4fe1\u606f")
    @JwtFlag(inUse=false)
    public ApiResponse<SysUser> getPersonalMsg() {
        if (BaseSecurityUtil.getUser() == null) {
            return ApiResponse.fail((int)BpmEnum.ERROR_LOGIN.getCode(), (String)BpmEnum.ERROR_LOGIN.getMessage());
        }
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        SysUser sysUser = this.sysUserService.querySysUserByUserId(userId);
        String jdbcUrl = sysUser.getJdbcUrl();
        sysUser.setDbType(jdbcUrl.split(":")[1]);
        sysUser.setJdbcUrl(HussarBpmSM4Util.encrypt((String)jdbcUrl, (String)"frontkey"));
        sysUser.setConnectionName(HussarBpmSM4Util.encrypt((String)sysUser.getConnectionName(), (String)"frontkey"));
        sysUser.setConnectionPass(HussarBpmSM4Util.encrypt((String)sysUser.getConnectionPass(), (String)"frontkey"));
        return ApiResponse.success((Object)sysUser);
    }

    @GetMapping(value={"/resetCipher"})
    @ApiOperation(value="\u91cd\u7f6e\u79d8\u94a5", notes="\u91cd\u7f6e\u79d8\u94a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sysTenant", value="\u79df\u6237\u4fe1\u606f", required=true, paramType="query")})
    @JwtFlag(inUse=false)
    public ApiResponse<?> resetCipher(BpmSysTenant sysTenant) {
        if (BaseSecurityUtil.getUser() == null) {
            return ApiResponse.fail((int)BpmEnum.ERROR_LOGIN.getCode(), (String)BpmEnum.ERROR_LOGIN.getMessage());
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        sysTenant.setTenantId(shiroUser.getTenantId() != null ? String.valueOf(shiroUser.getTenantId()) : "000000");
        sysTenant.setTenantCipher(IdWorker.get32UUID());
        this.sysTenantService.saveOrUpdate((Object)sysTenant);
        return ApiResponse.success((int)BpmEnum.SUCCESS_RESET.getCode(), (String)BpmEnum.SUCCESS_RESET.getMessage());
    }
}

