/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.api.entity.ProcessInstanceBatchParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.ProcessInstanceDeleteParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.ProcessParam;
import com.jxdinfo.hussar.workflow.manage.api.entity.StartProcessParam;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import io.swagger.annotations.Api;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"EngineInstanceEngine"})
@RequestMapping(value={"/engineInstanceEngine"})
public class EngineInstanceEngineController {
    @PostMapping(value={"/startProcessInstanceById"})
    public BpmResponseResult startProcessInstanceById(@RequestBody StartProcessParam param) {
        return InstanceEngineService.startProcessInstanceById((String)param.getProcessDefinitionId(), (String)param.getUserId(), (String)param.getBusinessId(), (Map)param.getVariables());
    }

    @PostMapping(value={"/startProcessInstanceByKey"})
    public BpmResponseResult startProcessInstanceByKey(@RequestBody StartProcessParam param) {
        return InstanceEngineService.startProcessInstanceByKey((String)param.getProcessKey(), (String)param.getUserId(), (String)param.getBusinessId(), (Map)param.getVariables());
    }

    @GetMapping(value={"/checkProcessInstByBusinessKey/{businessId}"})
    public BpmResponseResult checkProcessInstByBusinessKey(@PathVariable(value="businessId") String businessId) {
        return InstanceEngineService.checkProcessInstByBusinessKey((String)businessId);
    }

    @GetMapping(value={"/validateEditAuthority/{businessId}"})
    public ApiResponse<JSONObject> validateEditAuthority(@PathVariable(value="businessId") String businessId) {
        return InstanceEngineService.validateEditAuthority((String)businessId);
    }

    @GetMapping(value={"/validateDeleteByBusinessKey/{businessId}"})
    public BpmResponseResult validateDeleteByBusinessKey(@PathVariable(value="businessId") String businessId) {
        return InstanceEngineService.validateDeleteByBusinessKey((String)businessId);
    }

    @PostMapping(value={"/suspendProcessInstanceById"})
    public BpmResponseResult suspendProcessInstanceById(@RequestBody String processInsId) {
        return InstanceEngineService.suspendProcessInstanceById((String)processInsId);
    }

    @PostMapping(value={"/activateProcessInstanceById"})
    public BpmResponseResult activateProcessInstanceById(@RequestBody String processInsId) {
        return InstanceEngineService.activateProcessInstanceById((String)processInsId);
    }

    @PostMapping(value={"/deleteProcessInstance"})
    public BpmResponseResult deleteProcessInstance(@RequestBody ProcessInstanceDeleteParam param) {
        return InstanceEngineService.deleteProcessInstance((String)param.getProcessInsId(), (String)param.getReason());
    }

    @PostMapping(value={"/deleteFinishedProcessInstance"})
    public BpmResponseResult deleteFinishedProcessInstance(@RequestBody String processInsId) {
        return InstanceEngineService.deleteFinishedProcessInstance((String)processInsId);
    }

    @PostMapping(value={"/deleteProcessInstanceByBusinessKey"})
    public BpmResponseResult deleteProcessInstanceByBusinessKey(@RequestBody String businessId) {
        return InstanceEngineService.deleteProcessInstanceByBusinessKey((String)businessId);
    }

    @PostMapping(value={"/deleteProcessInstanceByBusinessKeyList"})
    public BpmResponseResult deleteProcessInstanceByBusinessKeyList(@RequestBody ProcessInstanceBatchParam param) {
        return InstanceEngineService.deleteProcessInstanceByBusinessKeyList((String)param.getBusinessId(), (boolean)param.isValidate());
    }

    @GetMapping(value={"/queryFinishedProcessInstance"})
    public BpmResponseResult queryFinishedProcessInstance(@RequestParam String processKey, @RequestParam String businessId, @RequestParam Integer page, @RequestParam Integer size) {
        return InstanceEngineService.queryFinishedProcessInstance((String)processKey, (String)businessId, (int)page, (int)size);
    }

    @GetMapping(value={"/queryProcessInstanceCompleteState/{processInsId}"})
    public BpmResponseResult queryProcessInstanceCompleteState(@PathVariable(value="processInsId") String processInsId) {
        return InstanceEngineService.queryProcessInstanceCompleteState((String)processInsId);
    }

    @GetMapping(value={"/queryProcessInstanceCompleteStateByBusinessKey/{businessId}"})
    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(@PathVariable(value="businessId") String businessId) {
        return InstanceEngineService.queryProcessInstanceCompleteStateByBusinessKey((String)businessId);
    }

    @GetMapping(value={"/getProcessTrace/{processInsId}"})
    public BpmResponseResult getProcessTrace(@PathVariable(value="processInsId") String processInsId) {
        return InstanceEngineService.getProcessTrace((String)processInsId);
    }

    @GetMapping(value={"/getAllProcessTrace/{processInsId}"})
    public BpmResponseResult getAllProcessTrace(@PathVariable(value="processInsId") String processInsId) {
        return InstanceEngineService.getAllProcessTrace((String)processInsId);
    }

    @GetMapping(value={"/queryCallActivityTask"})
    public BpmResponseResult queryCallActivityTask(@RequestParam String businessId, @RequestParam String processInsId) {
        return InstanceEngineService.queryCallActivityTask((String)businessId, (String)processInsId);
    }

    @PostMapping(value={"/queryMainActivityTask"})
    public BpmResponseResult queryMainActivityTask(@RequestParam String businessId, @RequestParam String processInsId) {
        return InstanceEngineService.queryCallActivityTask((String)businessId, (String)processInsId);
    }

    @GetMapping(value={"/getAllProcessTraceByBusinessKey"})
    public BpmResponseResult getAllProcessTraceByBusinessKey(@RequestParam String businessId, @RequestParam Integer page, @RequestParam Integer size) {
        return InstanceEngineService.getAllProcessTraceByBusinessKey((String)businessId, (int)page, (int)size);
    }

    @GetMapping(value={"/queryProcessDefinitionByInstanceId/{processInsId}"})
    public BpmResponseResult queryProcessDefinitionByInstanceId(@PathVariable(value="processInsId") String processInsId) {
        return InstanceEngineService.queryProcessDefinitionByInstanceId((String)processInsId);
    }

    @PostMapping(value={"/endProcess"})
    public BpmResponseResult endProcess(@RequestBody ProcessParam processModel) {
        return InstanceEngineService.endProcess((String)processModel.getTaskId(), (String)processModel.getUserId(), (String)processModel.getReason());
    }

    @PostMapping(value={"/queryCompletecomment"})
    public BpmResponseResult queryCompletecomment(@RequestParam String businessId, @RequestParam String processInsId, @RequestParam String tenantId) {
        return InstanceEngineService.queryCompletecomment((String)businessId, (String)processInsId, (String)tenantId);
    }
}

