/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bsp.taskmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.manage.bsp.taskmanager.service.TaskManagerSystemService;
import com.jxdinfo.hussar.workflow.manage.bsp.taskmanager.vo.TaskVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskManagerSystemServiceImpl
implements TaskManagerSystemService {
    @Autowired
    private TaskManagerService taskManagerService;
    @Autowired
    ITaskEngineService taskEngineService;
    @Autowired
    private ITenantConfigService tenantConfigService;
    @Autowired
    FlowEventsService flowEventsService;

    public ApiResponse<IPage<TaskManager>> getTaskManager(Page<TaskManager> page, GetTaskManagerDto taskManagerDto) {
        if (BpmTenantInfoUtils.isStartAlone()) {
            TenantConfig tenantConfig = this.tenantConfigService.getTenantConfig(BaseSecurityUtil.getUser().getTenantId());
            if (tenantConfig == null || !"1".equals(tenantConfig.getIsMqUse()) && (tenantConfig.getProjectAddress() == null || "".equals(tenantConfig.getProjectAddress()))) {
                return ApiResponse.success((String)null);
            }
            taskManagerDto.setTenantId(BaseSecurityUtil.getUser().getTenantId());
        }
        List list = this.taskManagerService.getTask(page, taskManagerDto);
        page.setRecords(list);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<TaskVo>> getJumpTasks(String taskId) {
        TaskVo task;
        FlowModel flowModel;
        Map flowModelMessage = this.taskManagerService.getFileByTaskId(taskId);
        ArrayList<TaskVo> tasks = new ArrayList<TaskVo>();
        if (flowModelMessage.get("main") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)((String)flowModelMessage.get("main")), FlowModel.class);
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
                task = new TaskVo();
                task.setId(flowObject.getId());
                task.setValue(flowObject.getProps().getFlowName());
                tasks.add(task);
            }
        }
        if (flowModelMessage.get("call") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)((String)flowModelMessage.get("call")), FlowModel.class);
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                if (!"com.jxdinfo.workflow.User".equals(flowObject.getName()) && !"com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) continue;
                task = new TaskVo();
                task.setId("main_process_" + flowObject.getId());
                task.setValue("\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                tasks.add(task);
            }
        }
        return ApiResponse.success(tasks);
    }
}

