/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.bpm.model.service.GodAxeModelService;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4efb\u52a1\u7ba1\u7406"})
@RequestMapping(value={"/publicProcess"})
public class PublicProcessController {
    @Autowired
    public GodAxeModelService godAxeModelService;
    @Autowired
    private IInstanceEngineService iInstanceEngineService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    @RequestMapping(value={"/queryNextNode"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    public BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        return TaskEngineService.queryNextNode((String)processDefinitionKey, (String)taskId);
    }

    @RequestMapping(value={"/queryRejectNodeOrNextNode"})
    @ApiOperation(value="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9", notes="\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u6216\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    public BpmResponseResult queryRejectNodeOrNextNode(String processDefinitionKey, String taskId) {
        return TaskEngineService.queryRejectNodeOrNextNode((String)processDefinitionKey, (String)taskId);
    }

    @RequestMapping(value={"/queryNextNodeByLineCondition"})
    @ApiOperation(value="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9", notes="\u6839\u636e\u7ebf\u6761\u4ef6\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="lineCondition", value="\u7ebf\u6761\u4ef6", required=true, paramType="query")})
    public BpmResponseResult queryNextNodeByLineCondition(String processDefinitionKey, String taskId, Map<String, Object> lineCondition) {
        return TaskEngineService.queryNextNode((String)processDefinitionKey, (String)taskId, lineCondition);
    }

    @RequestMapping(value={"/queryNextAssigneeByTaskIdAndNodeId"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query")})
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processDefinitionKey, String taskId, String nodeId, String userId) {
        return TaskEngineService.queryNextAssignee((String)processDefinitionKey, (String)taskId, (String)nodeId, (String)userId, null);
    }

    @RequestMapping(value={"/queryAllAssignee"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u6240\u6709\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefinitionKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query")})
    public BpmResponseResult queryAllAssignee(String processDefinitionKey) {
        return TaskEngineService.queryAllAssignee((String)processDefinitionKey);
    }

    @RequestMapping(value={"/getAllProcessTraceByBusinessKey"})
    @ApiOperation(value="\u83b7\u53d6\u529e\u7406\u5386\u53f2", notes="\u83b7\u53d6\u529e\u7406\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessKey", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query")})
    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int size) {
        return InstanceEngineService.getAllProcessTraceByBusinessKey((String)businessKey, (int)page, (int)size);
    }

    @RequestMapping(value={"/addCustomNode"})
    @ApiOperation(value="\u589e\u52a0\u4e34\u65f6\u8282\u70b9", notes="\u589e\u52a0\u4e34\u65f6\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="body")})
    public BpmResponseResult addCustomNode(@RequestBody Map<String, Object> map) {
        return TaskEngineService.addCustomNode((String)String.valueOf(map.get("taskId")), (List)((List)map.get("list")), (String)String.valueOf(map.get("parallel")));
    }

    @RequestMapping(value={"/isAddParallel"})
    @ApiOperation(value="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9", notes="\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u7f51\u5173\u7c7b\u578b\u7684\u8ffd\u52a0\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="body")})
    public BpmResponseResult isAddParallel(@RequestBody Map<String, String> map) {
        return TaskEngineService.isAddParallel((String)map.get("taskId"));
    }

    @RequestMapping(value={"/queryRejectNode"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9", notes="\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    public BpmResponseResult queryRejectNode(String taskId) {
        return TaskEngineService.queryRejectNode((String)taskId);
    }

    @RequestMapping(value={"/updateProcess"})
    @ApiOperation(value="\u6d41\u7a0b\u5fae\u8c03", notes="\u6d41\u7a0b\u5fae\u8c03")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="body")})
    public ApiResponse<?> updateProcess(@RequestBody Map<String, Object> map) {
        String tenantId = BaseSecurityUtil.getUser().getTenantId();
        return this.godAxeModelService.updateProcess((WorkFlow)map.get("workFlow"), tenantId);
    }

    @RequestMapping(value={"/queryCompletecComments"})
    @ApiOperation(value="\u67e5\u8be2\u529e\u7406\u610f\u89c1", notes="\u67e5\u8be2\u529e\u7406\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query"), @ApiImplicitParam(name="businessKey", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query")})
    public BpmResponseResult queryCompleteComments(String processInsId, String businessKey) {
        String tenantId = BaseSecurityUtil.getUser().getTenantId();
        return this.iInstanceEngineService.queryCompletecomment(businessKey, processInsId, tenantId);
    }

    @RequestMapping(value={"/getModifyConfigurationOnline"})
    @ApiOperation(value="\u67e5\u8be2\u529e\u7406\u610f\u89c1", notes="\u67e5\u8be2\u529e\u7406\u610f\u89c1")
    public ApiResponse<?> getModifyConfigurationOnline() {
        return ApiResponse.success((String)String.valueOf(this.lcdpBpmProperties.isModifyConfigurationOnline()));
    }

    @RequestMapping(value={"/isProductionMode"})
    @ApiOperation(value="\u83b7\u53d6\u80fd\u5426\u5728\u7ebf\u7f16\u8f91", notes="\u83b7\u53d6\u80fd\u5426\u5728\u7ebf\u7f16\u8f91")
    public ApiResponse<?> isProductionMode() {
        return ApiResponse.success((String)String.valueOf(this.lcdpBpmProperties.isEditableOnline()));
    }
}

