/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.taskmanage.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.SysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.SaveEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.TaskManageQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.UpdateEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.UpdateStateEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.DefinitionEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u59d4\u6258\u7ba1\u7406"})
@RequestMapping(value={"/entrust"})
public class EntrustListController {
    @Autowired
    IAssigneeChooseService assigneeChooseService;
    @Autowired
    private SysActEntrustService sysActEntrustService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @RequestMapping(value={"/list"})
    @ApiOperation(value="\u59d4\u6258\u67e5\u8be2", notes="\u59d4\u6258\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    public ApiResponse<IPage<SysActEntrust>> initList(Page<SysActEntrust> pages, TaskManageQueryDto taskManageQueryDto) {
        String processKey = taskManageQueryDto.getProcessKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        return this.sysActEntrustService.list(pages, userId, processKey);
    }

    @RequestMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u59d4\u6258", notes="\u6dfb\u52a0\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    public ApiResponse<Tip> saveEntrust(@RequestBody SaveEntrustDto saveEntrustDto) {
        List processKey = saveEntrustDto.getProcessKey();
        String mandator = String.valueOf(BaseSecurityUtil.getUser().getId());
        String mandatary = saveEntrustDto.getMandatary();
        String state = "1";
        String startTime = String.valueOf(saveEntrustDto.getStartTime()).concat(" 00:00:00");
        String endTime = String.valueOf(saveEntrustDto.getEndTime()).concat(" 23:59:59");
        return this.sysActEntrustService.saveEntrust(processKey, mandator, mandatary, state, startTime, endTime);
    }

    @RequestMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u59d4\u6258", notes="\u5220\u9664\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    public ApiResponse<Tip> deleteEntrust(@RequestBody String tEntrustId) {
        this.sysActEntrustService.removeByIds(Arrays.asList(tEntrustId.split(",")));
        return ApiResponse.success((String)this.bpmConstantProperties.getDeleteSuccess());
    }

    @RequestMapping(value={"/detail"})
    @ApiOperation(value="\u67e5\u770b\u59d4\u6258\u8be6\u60c5", notes="\u67e5\u770b\u59d4\u6258\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    public ApiResponse<SysActEntrust> detailEntrust(String tEntrustId) {
        return ApiResponse.success((Object)this.sysActEntrustService.selectById(tEntrustId, BaseSecurityUtil.getUser().getTenantId()));
    }

    @RequestMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u59d4\u6258", notes="\u66f4\u65b0\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    public ApiResponse<Tip> updateEntrust(@RequestBody UpdateEntrustDto updateEntrustDto) {
        if (String.valueOf(updateEntrustDto.getStartTime()).length() < 10) {
            updateEntrustDto.setStartTime(Timestamp.valueOf(String.valueOf(updateEntrustDto.getStartTime()).concat(" 00:00:00")));
        }
        if (String.valueOf(updateEntrustDto.getEndTime()).length() < 10) {
            updateEntrustDto.setEndTime(Timestamp.valueOf(String.valueOf(updateEntrustDto.getEndTime()).concat(" 23:59:59")));
        }
        try {
            this.sysActEntrustService.updateById((Object)updateEntrustDto);
            return ApiResponse.success((String)this.bpmConstantProperties.getSuccessUpdate());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PublicClientException(this.bpmConstantProperties.getErrorUpdate());
        }
    }

    @RequestMapping(value={"/updateState"})
    @ApiOperation(value="\u66f4\u65b0\u59d4\u6258\u72b6\u6001", notes="\u66f4\u65b0\u59d4\u6258\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    public ApiResponse<Tip> updateStateEntrust(@RequestBody UpdateStateEntrustDto updateStateEntrustDto) {
        String tEntrustId = updateStateEntrustDto.getId() == null ? null : updateStateEntrustDto.getId().toString();
        String state = "";
        state = "1".equals(String.valueOf(updateStateEntrustDto.getState())) ? "0" : "1";
        this.sysActEntrustService.updateState(tEntrustId, state);
        if ("1".equals(state)) {
            return ApiResponse.success((String)this.bpmConstantProperties.getSuccessStart());
        }
        return ApiResponse.success((String)this.bpmConstantProperties.getSuccessStop());
    }

    @RequestMapping(value={"/user"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u7528\u6237\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="body", value="\u8bf7\u6c42\u53c2\u6570", required=true, paramType="query")})
    public ApiResponse<List<BpmTreeModel>> userTree(@RequestParam String id) {
        return ApiResponse.success((Object)this.assigneeChooseService.userTree(id, null, false, false));
    }

    @RequestMapping(value={"/queryProcess"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b", notes="\u67e5\u8be2\u6d41\u7a0b")
    public ApiResponse<?> queryProcess() {
        BpmResponseResult bpmResponseResult = DefinitionEngineService.queryProcess();
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((Object)bpmResponseResult);
        }
        return ApiResponse.success((String)"");
    }
}

