/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.model.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.log.api.annotation.BussinessLog;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IDefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.DownloadFilesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u6d41\u7a0b\u7ba1\u7406"})
@RequestMapping(value={"/model"})
public class ModelController {
    @Autowired
    private ModelService modelService;
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private IDefinitionEngineService definitionEngineService;

    @RequestMapping(value={"/modelQuery"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762", notes="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelName", value="\u6a21\u578b\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query")})
    @BussinessLog(key="/model/modelQuery", value="\u67e5\u8be2\u6d41\u7a0b\u7ba1\u7406\u9875\u9762", type="04")
    public ApiResponse<IPage<ModelBuild>> queryModelList(Page<ModelBuild> page, String modelName) {
        try {
            return ApiResponse.success((Object)this.modelService.queryModelList(modelName, page));
        }
        catch (Exception e) {
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    @RequestMapping(value={"/modelDeploy"})
    @ApiOperation(value="\u90e8\u7f72\u6d41\u7a0b", notes="\u90e8\u7f72\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6a21\u578bid", required=true, paramType="query")})
    @BussinessLog(key="/model/modelDeploy", value="\u90e8\u7f72\u6d41\u7a0b", type="01")
    public ApiResponse<Tip> deployModel(@RequestParam(value="modelId") String modelId) {
        try {
            this.modelService.deployModel(modelId, BaseSecurityUtil.getUser().getTenantId());
        }
        catch (Exception e) {
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        return ApiResponse.success((String)BpmEnum.DEPLOY_SUCCESS.getMessage());
    }

    @RequestMapping(value={"/batchImport"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165", notes="\u6279\u91cf\u5bfc\u5165")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u4e0a\u4f20\u7684\u538b\u7f29\u6587\u4ef6", required=true, paramType="query"), @ApiImplicitParam(name="request", value="\u8bf7\u6c42", required=true, paramType="query")})
    @BussinessLog(key="/model/batchImport", value="\u6279\u91cf\u5bfc\u5165", type="01")
    public ApiResponse<Tip> batchImport(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        return this.modelService.importModel(BaseSecurityUtil.getUser().getTenantId(), file, request);
    }

    @RequestMapping(value={"/exportFiles"})
    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6240\u9009\u6d41\u7a0bid", required=true, paramType="query"), @ApiImplicitParam(name="response", value="\u54cd\u5e94", required=true, paramType="query")})
    @BussinessLog(key="/model/exportFiles", value="\u5bfc\u51fa", type="04")
    public void exportAllFile(@RequestBody String modelId, HttpServletResponse response) {
        try {
            this.modelService.exportAllFileModel(BaseSecurityUtil.getUser().getTenantId(), modelId, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/deleteModel"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b", notes="\u5220\u9664\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6a21\u578bid", required=true, paramType="query")})
    @BussinessLog(key="/model/deleteModel", value="\u5220\u9664\u6d41\u7a0b", type="02")
    public ApiResponse<Tip> deleteModel(@RequestBody String modelId) {
        return this.modelService.deleteModel(BaseSecurityUtil.getUser().getTenantId(), modelId);
    }

    @RequestMapping(value={"/deleteModelWithVersion"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b", notes="\u5220\u9664\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processDefId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true, paramType="query")})
    @BussinessLog(key="/model/deleteModelWithVersion", value="\u5220\u9664\u6d41\u7a0b", type="02")
    public ApiResponse<Tip> deleteModelWithVersion(String processDefId) {
        return this.modelService.deleteModelWithVersion(BaseSecurityUtil.getUser().getTenantId(), processDefId);
    }

    @RequestMapping(value={"/getAllModel"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", notes="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b")
    @BussinessLog(key="/model/getAllModel", value="\u67e5\u8be2\u6d41\u7a0b\u6a21\u578b", type="04")
    public ApiResponse<List<ModelBuild>> getAllModel() {
        return ApiResponse.success((Object)this.modelService.getAllModel());
    }

    @RequestMapping(value={"/validationProcess"})
    @ApiOperation(value="\u9a8c\u8bc1\u6d41\u7a0b", notes="\u9a8c\u8bc1\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="variables", value="\u53c2\u6570", required=true, paramType="query")})
    @BussinessLog(key="/model/validationProcess", value="\u9a8c\u8bc1\u6d41\u7a0b", type="03")
    public ApiResponse<Tip> validationProcess(String processKey, String businessId, String userId, String variables) {
        Map body = (Map)JSON.parseObject((String)variables, HashMap.class);
        HashMap map = new HashMap();
        if (body != null) {
            for (Map.Entry vo : body.entrySet()) {
                map.put(vo.getKey(), ((JSONObject)vo.getValue()).get((Object)"checkData"));
            }
        }
        return this.modelService.validationProcess(processKey, businessId, userId, map, BaseSecurityUtil.getUser().getTenantId());
    }

    @RequestMapping(value={"/doneList"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u56fe\u5df2\u529e\u7406\u8282\u70b9\u7684\u4fe1\u606f", notes="\u83b7\u53d6\u6d41\u7a0b\u56fe\u5df2\u529e\u7406\u8282\u70b9\u7684\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query")})
    public ApiResponse<?> doneList(String businessId) {
        return this.modelService.doneList(businessId, BaseSecurityUtil.getUser().getTenantId());
    }

    @RequestMapping(value={"/getProcessAssignee"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005", notes="\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="procDefKey", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="taskDefKey", value="\u8282\u70b9id", required=false, paramType="query")})
    @BussinessLog(key="/model/getProcessAssignee", value="\u83b7\u53d6\u6d41\u7a0b\u6a21\u578b\u914d\u7f6e\u7684\u53c2\u4e0e\u8005", type="04")
    public BpmResponseResult getProcessAssignee(String procDefKey, String taskDefKey) {
        return this.sysActAssigneeService.getAssigneeModel(procDefKey, taskDefKey);
    }

    @RequestMapping(value={"/downloadFiles"})
    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="request", value="\u8bf7\u6c42", required=true, paramType="query"), @ApiImplicitParam(name="response", value="\u54cd\u5e94", required=true, paramType="query")})
    @BussinessLog(key="/model/downloadFiles", value="\u5bfc\u51fa", type="04")
    public void downloadXmlTest(@RequestBody DownloadFilesDto downloadFilesDto, HttpServletResponse response) {
        this.modelService.downloadFiles(downloadFilesDto, response);
    }

    @RequestMapping(value={"/judgeProcessName"})
    @ApiOperation(value="\u5224\u65ad\u6d41\u7a0b\u540d\u662f\u5426\u91cd\u590d", notes="\u5224\u65ad\u6d41\u7a0b\u540d\u662f\u5426\u91cd\u590d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processName", value="\u6d41\u7a0b\u5b9a\u4e49\u540d\u79f0", required=true, paramType="query")})
    @BussinessLog(key="/model/judgeProcessName", value="\u5224\u65ad\u6d41\u7a0b\u540d\u662f\u5426\u91cd\u590d", type="04")
    public BpmResponseResult judgeProcessName(@RequestBody String processName) {
        return this.definitionEngineService.judgeProcessName(processName);
    }
}

