/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bsp.taskmanager.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.bsp.taskmanager.service.TaskManagerSystemService;
import com.jxdinfo.hussar.workflow.manage.bsp.taskmanager.vo.TaskVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4efb\u52a1\u7ba1\u7406"})
@RequestMapping(value={"/taskManager"})
public class TaskManagerController {
    @Autowired
    private TaskManagerService taskManagerService;
    @Autowired
    ITaskEngineService taskEngineService;
    @Autowired
    FlowEventsService flowEventsService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskManagerSystemService taskManagerSystemService;

    @GetMapping(value={"/getTaskManager"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", notes="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="map", value="\u53c2\u6570", required=true, paramType="query")})
    public ApiResponse<IPage<TaskManager>> getTaskManager(Page<TaskManager> page, GetTaskManagerDto taskManagerDto) {
        return this.taskManagerSystemService.getTaskManager(page, taskManagerDto);
    }

    @GetMapping(value={"/suspendTaskById"})
    @ApiOperation(value="\u6302\u8d77\u6d41\u7a0b\u4efb\u52a1", notes="\u6302\u8d77\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query")})
    public ApiResponse<Tip> suspendTaskById(@RequestParam(value="processInsId") String processInsId) {
        return this.taskManagerService.suspendTaskById(processInsId);
    }

    @GetMapping(value={"/activateTaskById"})
    @ApiOperation(value="\u6fc0\u6d3b\u6d41\u7a0b\u4efb\u52a1", notes="\u6fc0\u6d3b\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query")})
    public ApiResponse<Tip> activateTaskById(@RequestParam(value="processInsId") String processInsId) {
        return this.taskManagerService.activateTaskById(processInsId);
    }

    @GetMapping(value={"/completeTask"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u529e\u7406\u4ebaid", required=true, paramType="query")})
    public ApiResponse<Tip> completeTask(String taskId, String userId) {
        BpmResponseResult bpmResponseResult;
        try {
            bpmResponseResult = this.taskEngineService.completeTask(taskId, userId, null);
        }
        catch (Exception e) {
            throw new PublicClientException(e.getMessage());
        }
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        throw new PublicClientException(bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/addUserTask"})
    @ApiOperation(value="\u6dfb\u52a0\u53c2\u4e0e\u8005", notes="\u6dfb\u52a0\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userIds", value="\u53c2\u4e0e\u8005\u7528\u6237ID", required=true, paramType="query")})
    public ApiResponse<Tip> addUserTask(String taskId, String userIds) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        try {
            bpmResponseResult = this.taskEngineService.taskAddAssignee(taskId, userIds);
        }
        catch (Exception e) {
            throw new PublicClientException(bpmResponseResult.getMsg());
        }
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        throw new PublicClientException(bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/entrustTaskByTaskId"})
    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e", notes="\u4efb\u52a1\u8f6c\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="mandatary", value="\u88ab\u59d4\u6258\u4eba\u7528\u6237ID", required=true, paramType="query")})
    public ApiResponse<Tip> entrustTask(String taskId, String mandatary) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        try {
            bpmResponseResult = this.taskEngineService.entrustTask(taskId, mandatary, 1);
        }
        catch (Exception e) {
            throw new PublicClientException(bpmResponseResult.getMsg());
        }
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((String)bpmResponseResult.getMsg());
        }
        if (String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()).equals(bpmResponseResult.getCode())) {
            throw new PublicClientException(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getMessage());
        }
        throw new PublicClientException(bpmResponseResult.getMsg());
    }

    @GetMapping(value={"/getJumpTasks"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u8282\u70b9", notes="\u83b7\u53d6\u4efb\u52a1\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", required=true, paramType="query")})
    public ApiResponse<List<TaskVo>> getJumpTasks(String taskId) {
        return this.taskManagerSystemService.getJumpTasks(taskId);
    }

    @GetMapping(value={"/freeJump"})
    @ApiOperation(value="\u81ea\u7531\u8df3\u8f6c", notes="\u81ea\u7531\u8df3\u8f6c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="activityId", value="\u76ee\u6807\u8282\u70b9", required=true, paramType="query"), @ApiImplicitParam(name="assignees", value="\u53c2\u4e0e\u8005", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u529e\u7406\u4eba", required=true, paramType="query")})
    public ApiResponse<Tip> freeJump(String taskId, String activityId, String assignees, String userId) {
        BpmResponseResult result;
        try {
            result = this.taskEngineService.freeJump(taskId, activityId, userId, assignees, false, null, null);
        }
        catch (PublicClientException e) {
            throw new PublicClientException(e.getReason());
        }
        if ("1".equals(result.getCode())) {
            return ApiResponse.success((String)this.bpmConstantProperties.getFreeJumpSuccess());
        }
        throw new PublicClientException(result.getMsg());
    }

    @GetMapping(value={"/urgeTask"})
    @ApiOperation(value="\u4efb\u52a1\u50ac\u529e", notes="\u4efb\u52a1\u50ac\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="query")})
    public ApiResponse<Tip> userTask(@RequestParam String processInsId) {
        return this.flowEventsService.urgeTask(processInsId, "superadmin");
    }
}

