/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.bpm.model.service.AddCustomNodeService;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskEngineService {
    private static ITaskEngineService taskEngineService = (ITaskEngineService)SpringContextHolder.getBean(ITaskEngineService.class);
    private static AddCustomNodeService addCustomNodeService = (AddCustomNodeService)SpringContextHolder.getBean(AddCustomNodeService.class);

    public static ApiResponse<?> queryTask(String taskId) {
        return taskEngineService.queryTask(taskId, BaseSecurityUtil.getUser().getStringTenantId());
    }

    public static ApiResponse<?> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, Integer page, Integer size) {
        return taskEngineService.queryAllToDoTaskList(processName, processKey, startTime, endTime, timeoutState, suspensionState, todoConfiguration, BaseSecurityUtil.getUser().getStringTenantId(), page, size);
    }

    public static ApiResponse<?> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, Integer page, Integer size) {
        return taskEngineService.queryAllToDoTaskListByBusiness(processName, processKey, startTime, endTime, timeoutState, suspensionState, todoConfiguration, businessList, BaseSecurityUtil.getUser().getStringTenantId(), page, size);
    }

    public static ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey) {
        return taskEngineService.queryToDoTaskList(userId, processKey, definitionKey, BaseSecurityUtil.getUser().getStringTenantId());
    }

    public static ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        return taskEngineService.queryToDoTaskList(userId, processKey, definitionKey, BaseSecurityUtil.getUser().getStringTenantId(), Integer.valueOf(page == null ? 1 : page), Integer.valueOf(rows == null ? 10 : rows));
    }

    public static ApiResponse<?> queryToDoTaskList(String userId, List<String> businessIds) {
        return taskEngineService.queryToDoTaskList(userId, businessIds, BaseSecurityUtil.getUser().getStringTenantId());
    }

    public static ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey) {
        return taskEngineService.queryFinishedTaskList(userId, processKey, definitionKey, BaseSecurityUtil.getUser().getStringTenantId());
    }

    public static ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        return taskEngineService.queryFinishedTaskList(userId, processKey, definitionKey, BaseSecurityUtil.getUser().getStringTenantId(), Integer.valueOf(page == null ? 1 : page), Integer.valueOf(rows == null ? 10 : rows));
    }

    public static ApiResponse<?> queryUserTaskCount(String userId) {
        return taskEngineService.queryUserTaskCount(userId);
    }

    public static ApiResponse<?> queryUserTaskCountByNode(String userId) {
        return taskEngineService.queryUserTaskCountByNode(userId);
    }

    public static BpmResponseResult claimTask(String taskId, String userId) {
        return taskEngineService.claimTask(taskId, userId);
    }

    public static BpmResponseResult unClaimTask(String taskId) {
        return taskEngineService.unClaimTask(taskId);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, assigneeMap, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, assigneeMap, comment, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, comment, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, comment, subProcesses, map);
    }

    public static BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, assigneeMap, users, comment, map);
    }

    public static BpmResponseResult completeTaskNoAuditAuthority(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return taskEngineService.completeTask(taskId, userId, assigneeMap, users, comment, map, false);
    }

    public static BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        return taskEngineService.completeLeapTask(taskId, userId, assigneeMap, comment, map);
    }

    public static BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        return taskEngineService.completeLeapTask(taskId, userId, assigneeMap, users, comment, map);
    }

    public static BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToLastTask(taskId, userId, comment, "", isSubmit, map, null);
    }

    public static BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToLastTask(taskId, userId, comment, assignees, isSubmit, map, null);
    }

    public static BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToFirstTask(taskId, userId, comment, assignees, isSubmit, map);
    }

    public static BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToFirstTask(taskId, userId, comment, "", isSubmit, map);
    }

    public static BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, assignees, isSubmit, map);
    }

    public static BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, "", isSubmit, map);
    }

    public static BpmResponseResult queryRejectNode(String taskId) {
        return taskEngineService.queryRejectNode(taskId);
    }

    public static BpmResponseResult delegateTask(String taskId, String userId) {
        return taskEngineService.delegateTask(taskId, userId);
    }

    public static BpmResponseResult entrustTask(String taskId, String userId, String mandatary) {
        return taskEngineService.entrustTask(taskId, userId, mandatary);
    }

    public static BpmResponseResult entrustTask(String taskId, String mandatary) {
        return taskEngineService.entrustTask(taskId, mandatary, 1);
    }

    public static BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        return taskEngineService.freeJump(taskId, activitiId, userId, assignees, isSubmit, comment, map);
    }

    public static BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        return taskEngineService.multiInstanceAddAssignee(taskId, assigneeList);
    }

    public static BpmResponseResult queryAssigneeByTaskId(String taskId) {
        return taskEngineService.queryAssigneeByTaskId(taskId);
    }

    public static BpmResponseResult addAssignees(String taskId, String businessId, String users) {
        return taskEngineService.addAssignees(taskId, businessId, users);
    }

    public static BpmResponseResult taskAddAssignee(String taskId, String mandatary) {
        return taskEngineService.taskAddAssignee(taskId, mandatary);
    }

    public static BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        return taskEngineService.queryProcessNodeByTaskId(taskId);
    }

    public static BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, Map<String, Object> map) {
        return taskEngineService.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, BaseSecurityUtil.getUser().getStringTenantId(), map);
    }

    public static BpmResponseResult queryNextAssignee(String processKey, String taskId, String nodeId, String userId, Map<String, Object> map) {
        return taskEngineService.queryNextAssigneeByTaskIdAndNodeId(processKey, taskId, nodeId, userId, map);
    }

    public static BpmResponseResult queryNextAssignee(String processKey, String taskId, String nodeId, Map<String, Object> map) {
        return taskEngineService.queryNextAssigneeByTaskIdAndNodeId(processKey, taskId, nodeId, map);
    }

    public static BpmResponseResult queryAllAssignee(String processKey) {
        return taskEngineService.queryAllAssignee(processKey, null);
    }

    public static BpmResponseResult queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey(String processKey, String taskDefinitionKey) {
        return taskEngineService.queryAllAssignee(processKey, taskDefinitionKey);
    }

    public static ApiResponse<?> queryHistoryActByTaskId(String taskId) {
        return taskEngineService.queryHistoryActByTaskId(taskId, null);
    }

    public static ApiResponse<?> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        return taskEngineService.getProcessDefinitionIdAndNodeId(processKey, taskId);
    }

    public static BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        return taskEngineService.queryTaskIdByBusinessId(businessId);
    }

    public static BpmResponseResult queryNextNode(String taskId) {
        return taskEngineService.queryNextNode(taskId, false);
    }

    public static BpmResponseResult queryNextNode(String processKey, String taskId) {
        return taskEngineService.queryNextNode(processKey, taskId, false);
    }

    public static BpmResponseResult queryRejectNodeOrNextNode(String processKey, String taskId) {
        return taskEngineService.queryNextNode(processKey, taskId, true);
    }

    public static BpmResponseResult queryNextNode(String processKey, String taskId, Map<String, Object> lineCondition) {
        return taskEngineService.queryNextNode(processKey, taskId, lineCondition);
    }

    public static BpmResponseResult withdrawState(String historicTaskId) {
        return taskEngineService.withdrawState(historicTaskId);
    }

    public static BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.revokeTask(historicTaskId, userId, comment, isSubmit, map);
    }

    public static BpmResponseResult editTaskComment(String taskId, String comment) {
        return taskEngineService.editTaskComment(taskId, comment);
    }

    public static BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        return taskEngineService.reStartProcess(processInsId, businessId, taskDefinitionKey, userId, assignee, isSubmit, map);
    }

    public static BpmResponseResult addCustomNode(String taskId, List<Map<String, Object>> list, String parallel) {
        return addCustomNodeService.addNode(taskId, JSON.toJSONString(list), BaseSecurityUtil.getUser().getStringTenantId(), parallel);
    }

    public static BpmResponseResult isAddParallel(String taskId) {
        return addCustomNodeService.isAddParallel(taskId, BaseSecurityUtil.getUser().getStringTenantId());
    }

    public static BpmResponseResult multiInstanceDelAssignee(String taskId) {
        return taskEngineService.multiInstanceDelAssignee(taskId, null);
    }

    public static BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        return taskEngineService.multiInstanceDelAssignee(taskId, assignees);
    }

    public static BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        return taskEngineService.updateUserSecurityLevel(userId, level);
    }

    public static BpmResponseResult activeTaskCandidates(String taskId) {
        return taskEngineService.activeTaskCandidates(taskId);
    }

    public static BpmResponseResult updateStarter(String processInsId, String businessId, String userId) {
        return taskEngineService.updateStarter(processInsId, businessId, userId);
    }

    public static BpmResponseResult getExecutionByBusinessKey(String businessId) {
        return taskEngineService.getExecutionByBusinessId(businessId);
    }

    public static BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> map) {
        return taskEngineService.receiveTaskSignal(executionId, map);
    }
}

