/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.Map;

public class InstanceEngineService {
    private static IInstanceEngineService instanceEngineService = (IInstanceEngineService)SpringContextHolder.getBean(IInstanceEngineService.class);
    private static ISysUserService sysUserService = (ISysUserService)SpringContextHolder.getBean(ISysUserService.class);

    public static BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        return instanceEngineService.startProcessInstanceById(processDefinitionId, userId, businessId, BaseSecurityUtil.getUser().getTenantId(), variables);
    }

    public static BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, Map<String, Object> variables) {
        return instanceEngineService.startProcessInstanceByKey(processKey, userId, businessId, BaseSecurityUtil.getUser().getTenantId(), variables);
    }

    public static BpmResponseResult checkProcessInstByBusinessKey(String businessId) {
        return instanceEngineService.checkProcessInstByBusinessId(businessId);
    }

    public static ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        return instanceEngineService.validateEditAuthority(businessId);
    }

    public static BpmResponseResult validateDeleteByBusinessKey(String businessId) {
        return instanceEngineService.validateDeleteByBusinessId(businessId);
    }

    public static BpmResponseResult suspendProcessInstanceById(String processInsId) {
        return instanceEngineService.suspendProcessInstanceById(processInsId);
    }

    public static BpmResponseResult activateProcessInstanceById(String processInsId) {
        return instanceEngineService.activateProcessInstanceById(processInsId);
    }

    public static BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        return instanceEngineService.deleteProcessInstance(processInsId, reason);
    }

    public static BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        return instanceEngineService.deleteFinishedProcessInstance(processInsId);
    }

    public static BpmResponseResult deleteProcessInstanceByBusinessKey(String businessId) {
        return instanceEngineService.deleteProcessInstanceByBusinessId(businessId);
    }

    public static BpmResponseResult deleteProcessInstanceByBusinessKeyList(String businessId, boolean isValidate) {
        return instanceEngineService.deleteProcessInstanceByBusinessIdList(businessId, isValidate);
    }

    public static BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        return instanceEngineService.queryFinishedProcessInstance(processKey, businessId, page, rows);
    }

    public static BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        return instanceEngineService.queryProcessInstanceCompleteState(processInsId);
    }

    public static BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessId) {
        return instanceEngineService.queryProcessInstanceCompleteStateByBusinessId(businessId);
    }

    public static BpmResponseResult getProcessTrace(String processInsId) {
        return instanceEngineService.getProcessTrace(processInsId, BaseSecurityUtil.getUser().getTenantId());
    }

    public static BpmResponseResult getAllProcessTrace(String processInsId) {
        return instanceEngineService.getAllProcessTrace(processInsId, BaseSecurityUtil.getUser().getTenantId());
    }

    public static BpmResponseResult queryCallActivityTask(String businessId, String processInsId) {
        return instanceEngineService.queryCallActivityTask(businessId, processInsId, 0, BaseSecurityUtil.getUser().getTenantId());
    }

    public static BpmResponseResult queryMainActivityTask(String businessId, String processInsId) {
        return instanceEngineService.queryCallActivityTask(businessId, processInsId, 1, BaseSecurityUtil.getUser().getTenantId());
    }

    public static BpmResponseResult getAllProcessTraceByBusinessKey(String businessId, int page, int size) {
        return instanceEngineService.getAllProcessTraceByBusinessId(businessId, BaseSecurityUtil.getUser().getTenantId(), page, size);
    }

    public static BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        return instanceEngineService.queryProcessDefinitionByInstanceId(processInsId);
    }

    public static BpmResponseResult endProcess(String taskId, String userId, String reason) {
        return instanceEngineService.endProcess(taskId, userId, reason);
    }

    public static BpmResponseResult queryCompletecomment(String businessId, String processInsId, String tenantId) {
        return instanceEngineService.queryCompletecomment(businessId, processInsId, tenantId);
    }
}

