/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service.upgrade;

import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveBatchEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.CommissionedQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustAddDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustStatusUpdateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustUpdateDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.upgrade.StandardSysActEntrustApiService;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class StandardBpmEntrustOpenApiService
implements StandardSysActEntrustApiService {
    public BpmResponseResult queryEntrust(EntrustQueryDto entrustQueryDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", entrustQueryDto.getUserId());
        map.put("processKey", entrustQueryDto.getProcessKey());
        map.put("state", entrustQueryDto.getState());
        map.put("startTime", entrustQueryDto.getStartTime());
        map.put("endTime", entrustQueryDto.getEndTime());
        map.put("page", entrustQueryDto.getPage());
        map.put("size", entrustQueryDto.getSize());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/sysActEntrust/list", map);
    }

    public BpmResponseResult addEntrust(EntrustAddDto entrustAddDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mandatary", entrustAddDto.getMandatary());
        map.put("mandator", entrustAddDto.getMandator());
        map.put("processKey", entrustAddDto.getProcessKey());
        map.put("state", entrustAddDto.getState());
        map.put("startTime", entrustAddDto.getStartTime());
        map.put("endTime", entrustAddDto.getEndTime());
        map.put("isTransferTask", entrustAddDto.getIsTransferTask());
        map.put("messageType", entrustAddDto.getMessageType());
        map.put("taskDefinitionKey", entrustAddDto.getTaskDefinitionKey());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/sysActEntrust/add", map);
    }

    public BpmResponseResult addBatchEntrust(SaveBatchEntrustDto entrustBatchAddDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mandatary", entrustBatchAddDto.getMandatary());
        map.put("mandator", entrustBatchAddDto.getMandator());
        map.put("processKey", String.join((CharSequence)",", entrustBatchAddDto.getProcessKey()));
        map.put("state", entrustBatchAddDto.getState());
        map.put("startTime", entrustBatchAddDto.getStartTime());
        map.put("endTime", entrustBatchAddDto.getEndTime());
        map.put("isTransferTask", entrustBatchAddDto.getIsTransferTask());
        map.put("messageType", entrustBatchAddDto.getMessageType());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/sysActEntrust/addBatch", map);
    }

    public BpmResponseResult deleteEntrust(String tEntrustId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tEntrustId", tEntrustId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/sysActEntrust/delete", map);
    }

    public BpmResponseResult updateEntrust(EntrustUpdateDto entrustUpdateDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mandatary", entrustUpdateDto.getMandatary());
        map.put("id", entrustUpdateDto.getId());
        map.put("startTime", entrustUpdateDto.getStartTime());
        map.put("endTime", entrustUpdateDto.getEndTime());
        map.put("messageType", entrustUpdateDto.getMessageType());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/sysActEntrust/update", map);
    }

    public BpmResponseResult detailEntrust(String tEntrustId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tEntrustId", tEntrustId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/sysActEntrust/detail", map);
    }

    public BpmResponseResult updateEntrustState(EntrustStatusUpdateDto entrustStatusUpdateDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tEntrustId", entrustStatusUpdateDto.gettEntrustId());
        map.put("state", entrustStatusUpdateDto.getState());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/sysActEntrust/updateState", map);
    }

    public BpmResponseResult queryCommissionedInfo(CommissionedQueryDto commissionedQueryDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", commissionedQueryDto.getUserId());
        map.put("processKey", commissionedQueryDto.getProcessKey());
        map.put("mandator", commissionedQueryDto.getMandator());
        map.put("startTime", commissionedQueryDto.getStartTime());
        map.put("endTime", commissionedQueryDto.getEndTime());
        map.put("page", commissionedQueryDto.getPage());
        map.put("size", commissionedQueryDto.getSize());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/sysActEntrust/queryCommissionedInfo", map);
    }

    public static final class UpgradeApi {
        public static final String PREFIX = "/bpm/upgrade/sysActEntrust/";
        public static final String ADD = "/bpm/upgrade/sysActEntrust/add";
        public static final String LIST = "/bpm/upgrade/sysActEntrust/list";
        public static final String ADD_BATCH = "/bpm/upgrade/sysActEntrust/addBatch";
        public static final String DELETE = "/bpm/upgrade/sysActEntrust/delete";
        public static final String UPDATE = "/bpm/upgrade/sysActEntrust/update";
        public static final String DETAIL = "/bpm/upgrade/sysActEntrust/detail";
        public static final String UPDATE_STATE = "/bpm/upgrade/sysActEntrust/updateState";
        public static final String QUERY_COMMISSIONED_INFO = "/bpm/upgrade/sysActEntrust/queryCommissionedInfo";
    }
}

