/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service.upgrade;

import com.jxdinfo.hussar.workflow.engine.bpm.processdef.NodeInfQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefActivateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processdef.ProcessDefSuspendDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.upgrade.StandardDefinitionEngineApiService;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class StandardBpmDefinitionEngineOpenApiService
implements StandardDefinitionEngineApiService {
    public static final String PREFIX = "/bpm/upgrade/definition/";

    public BpmResponseResult queryAllNodeFormInfo(NodeInfQueryDto nodeInfQueryDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", nodeInfQueryDto.getProcessKey());
        map.put("version", nodeInfQueryDto.getVersion());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/queryAllNodeFormInfo", map);
    }

    public BpmResponseResult queryProcessMainOrNew(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("organId", null);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/getProcessMainOrNew", map);
    }

    public BpmResponseResult queryProcessMainOrNew(String processKey, String organId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("organId", organId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/getProcessMainOrNew", map);
    }

    public BpmResponseResult queryProcessDefList(ProcessDefQueryDto processDefQueryDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processDefQueryDto.getProcessKey());
        map.put("processName", processDefQueryDto.getProcessName());
        map.put("organId", processDefQueryDto.getOrganId());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/queryProcessDefList", map);
    }

    public BpmResponseResult activateProcessDefinition(ProcessDefActivateDto processDefQueryDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processDefQueryDto.getProcessKey());
        map.put("processDefinitionId", processDefQueryDto.getProcessDefinitionId());
        map.put("version", processDefQueryDto.getVersion());
        map.put("organId", processDefQueryDto.getOrganId());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/activateProcessDefinition", map);
    }

    public BpmResponseResult deleteProcessDefinition(ProcessDefDeleteDto processDefDeleteDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processDefinitionId", processDefDeleteDto.getProcessDefinitionId());
        map.put("processKey", processDefDeleteDto.getProcessKey());
        map.put("version", processDefDeleteDto.getVersion());
        map.put("organId", processDefDeleteDto.getOrganId());
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/upgrade/definition/deleteProcessDefinition", map);
    }

    public BpmResponseResult suspendProcessDefinition(ProcessDefSuspendDto processDefSuspendDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processDefinitionId", processDefSuspendDto.getProcessDefinitionId());
        map.put("processKey", processDefSuspendDto.getProcessKey());
        map.put("version", processDefSuspendDto.getVersion());
        map.put("organId", processDefSuspendDto.getOrganId());
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/upgrade/definition/suspendProcessDefinition", map);
    }

    public BpmResponseResult queryAllProcessDefinitions() {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/queryProcess", null);
    }

    public BpmResponseResult queryNodeInfo(NodeInfQueryDto nodeInfQueryDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", nodeInfQueryDto.getProcessKey());
        map.put("version", nodeInfQueryDto.getVersion());
        map.put("organId", nodeInfQueryDto.getOrganId());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/queryNodeInfoByProcessKeyAndVersion", map);
    }

    public BpmResponseResult queryOrganProcessByProcessKey(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/queryOrganProcessByProcessKey", map);
    }

    public BpmResponseResult queryPublishStatusByProcessKey(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/definition/queryIsPublish", map);
    }

    public static final class UpgradeApi {
        public static final String QUERY_ALL_NODE_FORM_INFO = "/bpm/upgrade/definition/queryAllNodeFormInfo";
        public static final String GET_PROCESS_MAIN_OR_NEW = "/bpm/upgrade/definition/getProcessMainOrNew";
        public static final String QUERY_PROCESS_DEF_LIST = "/bpm/upgrade/definition/queryProcessDefList";
        public static final String ACTIVATE_PROCESS_DEFINITION = "/bpm/upgrade/definition/activateProcessDefinition";
        public static final String DELETE_PROCESS_DEFINITION = "/bpm/upgrade/definition/deleteProcessDefinition";
        public static final String SUSPEND_PROCESS_DEFINITION = "/bpm/upgrade/definition/suspendProcessDefinition";
        public static final String QUERY_PROCESS = "/bpm/upgrade/definition/queryProcess";
        public static final String QUERY_NODE_INFO_BY_PROCESS_KEY_AND_VERSION = "/bpm/upgrade/definition/queryNodeInfoByProcessKeyAndVersion";
        public static final String QUERY_IS_PUBLISH = "/bpm/upgrade/definition/queryIsPublish";
        public static final String QUERY_ORGAN_PROCESS_BY_PROCESS_KEY = "/bpm/upgrade/definition/queryOrganProcessByProcessKey";
    }
}

