/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessInstAllQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.BusinessInfoDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.http.common.ResultUtil;
import com.jxdinfo.hussar.workflow.manage.engine.service.InstanceEngineApiService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BpmInstanceEngineOpenApiService
implements InstanceEngineApiService {
    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        map.put("variables", JSONObject.toJSONString(variables));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/startProcessInstanceById", map);
    }

    public BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, Map<String, Object> variables) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("userId", userId);
        map.put("businessId", businessId);
        map.put("variables", JSONObject.toJSONString(variables));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/startProcessInstanceByKey", map);
    }

    public BpmResponseResult checkProcessInstByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/checkProcessInstByBusinessId", map);
    }

    public ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return ResultUtil.convertApiResponse3((Object)HttpClientUtil.httpGetApiHandler((String)"/bpm/instance/validateEditAuthority", map), (Object)new JSONObject());
    }

    public BpmResponseResult validateDeleteByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/validateDeleteByBusinessId", map);
    }

    public BpmResponseResult queryAllComment(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryAllComment", map);
    }

    public BpmResponseResult suspendProcessInstanceById(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/suspendProcessInstanceById", map);
    }

    public BpmResponseResult suspendProcessInstanceByBusinessId(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/suspendProcessInstanceByBusinessId", map);
    }

    public BpmResponseResult activateProcessInstanceById(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/activateProcessInstanceById", map);
    }

    public BpmResponseResult activateProcessInstanceByBusinessId(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/activateProcessInstanceByBusinessId", map);
    }

    public BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        map.put("reason", reason);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteProcessInstance", map);
    }

    public BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteFinishedProcessInstance", map);
    }

    public BpmResponseResult deleteFinishProcessInstanceByBusinessId(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteFinishProcessInstanceByBusinessId", map);
    }

    public BpmResponseResult activateProcessInstance(String processInsId, String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)processInsId)) {
            map.put("processInsId", processInsId);
            return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/activateProcessInstanceById", map);
        }
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/activateProcessInstanceByBusinessId", map);
    }

    public BpmResponseResult deleteProcessInstance(String businessId, String processInsId, String reason) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)businessId)) {
            map.put("businessId", businessId);
            return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteProcessInstanceByBusinessId", map);
        }
        map.put("processInsId", processInsId);
        map.put("reason", reason);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteProcessInstance", map);
    }

    public BpmResponseResult deleteFinishProcessInstance(String processInsId, String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)processInsId)) {
            map.put("processInsId", processInsId);
            return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteFinishedProcessInstance", map);
        }
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteFinishProcessInstanceByBusinessId", map);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIdList(String businessIdList, boolean isValidate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessId", businessIdList);
        map.put("isValidate", isValidate);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteProcessInstanceByBusinessIdList", map);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteProcessInstanceByBusinessId", map);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessKeyList(String businessId, boolean isValidate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessId", businessId);
        map.put("isValidate", isValidate);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteProcessInstanceByBusinessIdList", map);
    }

    public BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processKey", processKey);
        map.put("businessId", businessId);
        map.put("page", page);
        map.put("rows", rows);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryFinishedProcessInstance", map);
    }

    public BpmResponseResult queryAllProcessInstance(ProcessInstAllQueryDto processInstAllQueryDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/queryAllProcessInstance", (Object)processInstAllQueryDto);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessInstanceCompleteState", map);
    }

    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessInstanceCompleteStateByBusinessId", map);
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/getProcessTrace", map);
    }

    public BpmResponseResult getAllProcessTrace(String processInsId, String subProcessKey, Integer cycleCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processInsId);
        map.put("subProcessKey", subProcessKey);
        map.put("cycleCount", cycleCount);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/getAllProcessTrace", map);
    }

    public BpmResponseResult queryCallActivityTask(String businessId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryCallActivityTask", map);
    }

    public BpmResponseResult queryMainActivityTask(String businessId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryMainActivityTask", map);
    }

    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessId, int page, int size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessKey", businessId);
        map.put("page", page);
        map.put("size", size);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/getAllProcessTraceByBusinessKey", map);
    }

    public BpmResponseResult queryCompletecomment(String businessId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryCompletecomment", map);
    }

    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessDefinitionByInstanceId", map);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("userId", userId);
        map.put("reason", reason);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/endProcess", map);
    }

    public BpmResponseResult endProcessByBusinessIdOrProcessInsId(String businessId, String processInsId, String userId, String comment) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        map.put("userId", userId);
        map.put("reason", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/endProcessByBusinessIdOrProcessInsId", map);
    }

    public BpmResponseResult queryProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        if (page != null) {
            processQueryByStarterDto.setCurrent(page.getCurrent());
            processQueryByStarterDto.setSize(page.getSize());
        }
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/queryProcessByStarter", (Object)processQueryByStarterDto);
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/revokeProcess", (Object)processRevokeDto);
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessInstance", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)processDto)));
    }

    public BpmResponseResult queryAllCountersignNodes(String taskId, String processInsId, String businessId, String processKey, String version) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        map.put("processKey", processKey);
        map.put("taskId", taskId);
        map.put("version", version);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryAllCountersignNodes", map);
    }

    public BpmResponseResult queryCurrentNodes(String processInstanceId, String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInstanceId", processInstanceId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryCurrentNodes", map);
    }

    public BpmResponseResult startProcessInstanceByKey(StartProcessDto startProcessDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/startProcessInstanceByKeyDto", (Object)JSON.parseObject((String)JSONObject.toJSONString((Object)startProcessDto)));
    }

    public BpmResponseResult startAndComplete(StartAndCompleteDto startAndCompleteDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/startAndComplete", (Object)JSON.parseObject((String)JSONObject.toJSONString((Object)startAndCompleteDto)));
    }

    public BpmResponseResult updateBusinessInfo(BusinessInfoDto businessInfoDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/updateBusinessInfo", (Object)JSON.parseObject((String)JSONObject.toJSONString((Object)businessInfoDto)));
    }

    public BpmResponseResult queryFlowHistoryInfo(String businessId, String processInstId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInstanceId", processInstId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryFlowHistoryInfo", map);
    }

    public static final class Api {
        public static final String startProcessInstanceByIdApi = "/bpm/instance/startProcessInstanceById";
        public static final String startProcessInstanceByKeyApi = "/bpm/instance/startProcessInstanceByKey";
        public static final String checkProcessInstByBusinessIdApi = "/bpm/instance/checkProcessInstByBusinessId";
        public static final String validateEditAuthorityApi = "/bpm/instance/validateEditAuthority";
        public static final String validateDeleteByBusinessIdApi = "/bpm/instance/validateDeleteByBusinessId";
        public static final String suspendProcessInstanceByIdApi = "/bpm/instance/suspendProcessInstanceById";
        public static final String suspendProcessInstanceByBusinessId = "/bpm/instance/suspendProcessInstanceByBusinessId";
        public static final String activateProcessInstanceByIdApi = "/bpm/instance/activateProcessInstanceById";
        public static final String activateProcessInstanceByBusinessId = "/bpm/instance/activateProcessInstanceByBusinessId";
        public static final String deleteProcessInstanceApi = "/bpm/instance/deleteProcessInstance";
        public static final String deleteFinishedProcessInstanceApi = "/bpm/instance/deleteFinishedProcessInstance";
        public static final String deleteFinishProcessInstanceByBusinessId = "/bpm/instance/deleteFinishProcessInstanceByBusinessId";
        public static final String deleteProcessInstanceByBusinessIdApi = "/bpm/instance/deleteProcessInstanceByBusinessId";
        public static final String deleteProcessInstanceByBusinessIdListApi = "/bpm/instance/deleteProcessInstanceByBusinessIdList";
        public static final String queryFinishedProcessInstanceApi = "/bpm/instance/queryFinishedProcessInstance";
        public static final String queryAllProcessInstanceApi = "/bpm/instance/queryAllProcessInstance";
        public static final String queryProcessInstanceCompleteStateApi = "/bpm/instance/queryProcessInstanceCompleteState";
        public static final String queryProcessInstanceCompleteStateByBusinessIdApi = "/bpm/instance/queryProcessInstanceCompleteStateByBusinessId";
        public static final String getProcessTraceApi = "/bpm/instance/getProcessTrace";
        public static final String queryCallActivityTaskApi = "/bpm/instance/queryCallActivityTask";
        public static final String queryMainActivityTaskApi = "/bpm/instance/queryMainActivityTask";
        public static final String queryProcessDefinitionByInstanceIdApi = "/bpm/instance/queryProcessDefinitionByInstanceId";
        public static final String endProcessApi = "/bpm/instance/endProcess";
        public static final String endProcessByBusinessIdOrProcessInsId = "/bpm/instance/endProcessByBusinessIdOrProcessInsId";
        public static final String queryCompletecommentApi = "/bpm/instance/queryCompletecomment";
        public static final String getAllProcessTraceApi = "/bpm/instance/getAllProcessTrace";
        public static final String queryProcessByStarterApi = "/bpm/instance/queryProcessByStarter";
        public static final String revokeProcessApi = "/bpm/instance/revokeProcess";
        public static final String queryProcessInstanceApi = "/bpm/instance/queryProcessInstance";
        public static final String queryAllCountersignNodesApi = "/bpm/instance/queryAllCountersignNodes";
        public static final String queryCurrentNodesApi = "/bpm/instance/queryCurrentNodes";
        public static final String queryAllCommentApi = "/bpm/instance/queryAllComment";
        public static final String startProcessInstanceByKeyDtoApi = "/bpm/instance/startProcessInstanceByKeyDto";
        public static final String startAndComplete = "/bpm/instance/startAndComplete";
        public static final String updateBusinessInfoApi = "/bpm/instance/updateBusinessInfo";
        public static final String getAllProcessTraceByBusinessKey = "/bpm/instance/getAllProcessTraceByBusinessKey";
        public static final String queryFlowHistoryInfoApi = "/bpm/instance/queryFlowHistoryInfo";
    }
}

