/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.AddCustomNodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CheckNextNodeAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.PreemptCommonDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.QueryProcessTaskCountDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskFreeJumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskQueryNextNodeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskReceiveDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processtransfer.dto.TransferDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.http.common.ResultUtil;
import com.jxdinfo.hussar.workflow.manage.engine.service.TaskEngineApiService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class BpmTaskEngineOpenApiService
implements TaskEngineApiService {
    private Map<String, Object> objectToMap(Object object) {
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)object));
    }

    public ApiResponse<Map<String, Object>> queryTask(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryTask", map);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, Integer page, Integer size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processName", processName);
        map.put("processKey", processKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("timeoutState", timeoutState);
        map.put("suspensionState", suspensionState);
        map.put("todoConfiguration", todoConfiguration);
        map.put("page", page);
        map.put("size", size);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryAllToDoTaskList", map);
    }

    public ApiResponse<JSONObject> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, Integer page, Integer size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("business", businessList);
        map.put("processName", processName);
        map.put("processKey", processKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("timeoutState", timeoutState);
        map.put("suspensionState", suspensionState);
        map.put("todoConfiguration", todoConfiguration);
        map.put("page", page);
        map.put("size", size);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryAllToDoTaskListByBusiness", map);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("processKey", processKey);
        map.put("definitionKey", definitionKey);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryToDoTaskList", map);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("processKey", processKey);
        map.put("definitionKey", definitionKey);
        map.put("page", page);
        map.put("rows", rows);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryToDoTaskListByPage", map);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(String userId, List<String> businessIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessIds", businessIds);
        map.put("userId", userId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryToDoTaskListByBusinessIds", map);
    }

    private Map<String, Object> getFlowTaskMap(FlowTaskQueryModel flowTaskQueryModel) {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", flowTaskQueryModel.getUserId());
        map.put("processKey", flowTaskQueryModel.getProcessKey());
        map.put("definitionKey", flowTaskQueryModel.getDefinitionKey());
        map.put("processKeys", flowTaskQueryModel.getProcessKeys());
        map.put("businessIds", flowTaskQueryModel.getBusinessIds());
        map.put("todoConfiguration", flowTaskQueryModel.getTodoConfiguration());
        map.put("sendUserId", flowTaskQueryModel.getSendUserId());
        if (HussarUtils.isNotEmpty((Object)flowTaskQueryModel.getStartTime())) {
            map.put("startTime", dataFormat.format(flowTaskQueryModel.getStartTime()));
        }
        if (HussarUtils.isNotEmpty((Object)flowTaskQueryModel.getEndTime())) {
            map.put("endTime", dataFormat.format(flowTaskQueryModel.getEndTime()));
        }
        if (HussarUtils.isNotEmpty((Object)flowTaskQueryModel.getDateTime())) {
            map.put("dateTime", dataFormat.format(flowTaskQueryModel.getDateTime()));
        }
        map.put("timeoutState", flowTaskQueryModel.getTimeoutState());
        map.put("processName", flowTaskQueryModel.getProcessName());
        map.put("suspensionState", flowTaskQueryModel.getSuspensionState());
        map.put("securityLevel", flowTaskQueryModel.getSecurityLevel());
        map.put("mandator", flowTaskQueryModel.getMandator());
        map.put("taskState", flowTaskQueryModel.getTaskState());
        map.put("taskType", flowTaskQueryModel.getTaskType());
        map.put("assistInitiator", flowTaskQueryModel.getAssistInitiator());
        map.put("page", flowTaskQueryModel.getPage());
        map.put("size", flowTaskQueryModel.getSize());
        return map;
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryToDoTaskList(FlowTaskQueryModel flowTaskQueryModel) {
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryToDoTaskList2", this.getFlowTaskMap(flowTaskQueryModel));
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("processKey", processKey);
        map.put("definitionKey", definitionKey);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryFinishedTaskList", map);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishedTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processKey", processKey);
        map.put("userId", userId);
        map.put("definitionKey", definitionKey);
        map.put("page", page);
        map.put("rows", rows);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryFinishedTaskListByPage", map);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> queryFinishTaskList(FlowTaskQueryModel flowTaskQueryModel) {
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryFinishTaskList2", this.getFlowTaskMap(flowTaskQueryModel));
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCount(String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryUserTaskCount", map);
    }

    public ApiResponse<List<Map<String, String>>> queryUserTaskCountByNode(String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/queryUserTaskCountByNode", map);
    }

    private Map<String, Object> getFlowTaskMap(FlowTaskDto flowTaskDto) {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", flowTaskDto.getUserId());
        map.put("processKey", flowTaskDto.getProcessKey());
        map.put("definitionKey", flowTaskDto.getDefinitionKey());
        map.put("processKeys", flowTaskDto.getProcessKeys());
        map.put("businessIds", flowTaskDto.getBusinessIds());
        map.put("todoConfiguration", flowTaskDto.getTodoConfiguration());
        map.put("sendUserId", flowTaskDto.getSendUserId());
        if (HussarUtils.isNotEmpty((Object)flowTaskDto.getStartTime())) {
            map.put("startTime", dataFormat.format(flowTaskDto.getStartTime()));
        }
        if (HussarUtils.isNotEmpty((Object)flowTaskDto.getEndTime())) {
            map.put("endTime", dataFormat.format(flowTaskDto.getEndTime()));
        }
        map.put("page", flowTaskDto.getPage());
        map.put("size", flowTaskDto.getSize());
        map.put("tenantId", flowTaskDto.getTenantId());
        map.put("mandator", flowTaskDto.getMandator());
        map.put("taskState", flowTaskDto.getTaskState());
        map.put("taskType", flowTaskDto.getTaskType());
        map.put("assistInitiator", flowTaskDto.getAssistInitiator());
        return map;
    }

    public BpmResponseResult queryToDoList(FlowTaskDto flowTaskBean) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryToDoList", this.getFlowTaskMap(flowTaskBean));
    }

    public BpmResponseResult queryDoneList(FlowTaskDto flowTaskBean) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryDoneList", this.getFlowTaskMap(flowTaskBean));
    }

    public BpmResponseResult claimTask(String taskId, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("userId", userId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/claimTask", map);
    }

    public BpmResponseResult unClaimTask(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/unClaimTask", map);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("taskId", taskId);
        map1.put("userId", userId);
        map1.put("map", JSONObject.toJSONString(map));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeTask1", map1);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("taskId", taskId);
        map1.put("userId", userId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assigneeMap", JSONObject.toJSONString(assigneeMap));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeTask2", map1);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assigneeMap", JSONObject.toJSONString(assigneeMap));
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeTask3", map1);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("taskId", taskId);
        map1.put("userId", userId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeTask4", map1);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("taskId", taskId);
        map1.put("userId", userId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("comment", comment);
        map1.put("subProcesses", subProcesses);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeTask5", map1);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assigneeMap", JSONObject.toJSONString(assigneeMap));
        map1.put("comment", comment);
        map1.put("users", JSONObject.toJSONString(users));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeTask6", map1);
    }

    public BpmResponseResult completeTaskNoAuditAuthority(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assigneeMap", JSONObject.toJSONString(assigneeMap));
        map1.put("comment", comment);
        map1.put("users", JSONObject.toJSONString(users));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeTask7", map1);
    }

    public BpmResponseResult completeTask(TaskCompleteDto taskCompleteDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/completeTask8", (Object)taskCompleteDto);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assigneeMap", JSONObject.toJSONString(assigneeMap));
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeLeapTask", map1);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isSubmit) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assigneeMap", JSONObject.toJSONString(assigneeMap));
        map1.put("users", JSONObject.toJSONString(users));
        map1.put("comment", comment);
        map1.put("isSubmit", isSubmit);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/completeLeapTask1", map1);
    }

    public BpmResponseResult completeLeapTask(TaskCompleteDto taskCompleteDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/completeLeapTask3", (Object)taskCompleteDto);
    }

    public BpmResponseResult queryRejectComment(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryRejectComment", map);
    }

    public BpmResponseResult rejectToLastTask(TaskRejectDto rejectTaskBean) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/rejectToLastTask5", (Object)rejectTaskBean);
    }

    public BpmResponseResult rejectToFirstTask(TaskRejectDto rejectTaskBean) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/rejectToFirstTask5", (Object)rejectTaskBean);
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, boolean isSubProcessFirst, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("isSubmit", isSubmit);
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/rejectToFirstTask1", map1);
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assignees", assignees);
        map1.put("backActivityId", backActivityId);
        map1.put("isSubmit", isSubmit);
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/rejectToAnyTask2", map1);
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("backActivityId", backActivityId);
        map1.put("isSubmit", isSubmit);
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/rejectToAnyTask1", map1);
    }

    public BpmResponseResult rejectToAnyTask(TaskRejectDto rejectTaskBean) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/rejectToAnyTask5", (Object)rejectTaskBean);
    }

    public BpmResponseResult setTimeoutPeriod(String taskId, Date timeout) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)timeout)) {
            map.put("timeout", simpleDateFormat.format(timeout));
        }
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/setTimeoutPeriod", map);
    }

    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean canRejectToMainProcess, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assignees", assignees);
        map1.put("canRejectToMainProcess", canRejectToMainProcess);
        map1.put("isSubmit", isSubmit);
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/rejectToLastTask3", map1);
    }

    public BpmResponseResult queryRejectNode(String taskId, boolean isGetMainProcess) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isGetMainProcess", isGetMainProcess);
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryRejectNode", map);
    }

    public BpmResponseResult entrustTask(String taskId, String userId, String mandatary) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("userId", userId);
        map.put("mandatary", mandatary);
        map.put("comment", null);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/entrustTask", map);
    }

    public BpmResponseResult entrustTask(String taskId, String mandatary) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("mandatary", mandatary);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/entrustTaskByTaskId", map);
    }

    public BpmResponseResult entrustTask(TaskEntrustDto taskEntrustDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/entrustTask2", this.objectToMap(taskEntrustDto));
    }

    public BpmResponseResult freeJump(String taskId, String targetTaskDefinitionKey, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assignees", assignees);
        map1.put("targetTaskDefinitionKey", targetTaskDefinitionKey);
        map1.put("isSubmit", isSubmit);
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/freeJump", map1);
    }

    public BpmResponseResult getRejectNode(String taskId, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("taskId", taskId);
        map1.put("isSubmit", isSubmit);
        map1.put("map", JSONObject.toJSONString(map));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/getRejectNode", map1);
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubProcessFirst, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", userId);
        map1.put("taskId", taskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("assignees", assignees);
        map1.put("isSubProcessFirst", isSubProcessFirst);
        map1.put("isSubmit", isSubmit);
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/rejectToFirstTask3", map1);
    }

    public BpmResponseResult freeJump(TaskFreeJumpDto taskFreeJumpBean) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/freeJump2", (Object)taskFreeJumpBean);
    }

    public BpmResponseResult queryJumpNode(String taskId, boolean isGetMainProcess) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isGetMainProcess", isGetMainProcess);
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryJumpNode", map);
    }

    public BpmResponseResult delegateTask(String taskId, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("userId", userId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/delegateTask", map);
    }

    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList, boolean isSeqMultiAddLastAssignee) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assigneeList", JSONObject.toJSONString(assigneeList));
        map.put("taskId", taskId);
        map.put("isSeqMultiAddLastAssignee", isSeqMultiAddLastAssignee);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/multiInstanceAddAssignee", map);
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryAssigneeByTaskId", map);
    }

    public BpmResponseResult addAssignees(String taskId, String businessId, String users) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("taskId", taskId);
        map.put("users", users);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/addAssignees", map);
    }

    public BpmResponseResult taskAddAssignee(String taskId, String userIds, boolean isSeqMultiAddLastAssignee) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userIds", userIds);
        map.put("taskId", taskId);
        map.put("isSeqMultiAddLastAssignee", isSeqMultiAddLastAssignee);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/taskAddAssignee", map);
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryProcessNodeByTaskId", map);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, Map<String, Object> map) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("taskId", taskId);
        map1.put("nodeId", nodeId);
        map1.put("map", JSONObject.toJSONString(map));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryNextAssigneeByTaskIdAndNodeId", map1);
    }

    public BpmResponseResult queryNextAssignee(String processKey, String taskId, String nodeId, Map<String, Object> map) {
        NodeAssigneeQueryDto nodeAssigneeQueryDto = new NodeAssigneeQueryDto();
        nodeAssigneeQueryDto.setTaskId(taskId);
        nodeAssigneeQueryDto.setNodeId(nodeId);
        nodeAssigneeQueryDto.setAssigneeVariable(JSONObject.toJSONString(map));
        nodeAssigneeQueryDto.setProcessKey(processKey);
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/queryNextAssigneeWithDto", (Object)nodeAssigneeQueryDto);
    }

    public BpmResponseResult queryAllAssignee(String processKey) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryAllAssignee", map1);
    }

    public BpmResponseResult queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey(String processKey, String taskDefinitionKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("taskDefinitionKey", taskDefinitionKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey", map);
    }

    public BpmResponseResult queryNodeAssigneeAndDept(NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/queryNodeAssigneeAndDeptWithDto", (Object)nodeAssigneeQueryDto);
    }

    public BpmResponseResult queryNodeAssigneeListByPage(NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/queryNodeAssigneeListByPageWithDto", (Object)nodeAssigneeQueryDto);
    }

    public ApiResponse<Map<String, Object>> queryHistoryActByTaskId(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return ResultUtil.convertApiResponse2((Object)HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryHistoryActByTaskId", map), new HashMap());
    }

    public ApiResponse<JSONObject> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("processKey", processKey);
        return ResultUtil.convertApiResponse2((Object)HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/getProcessDefinitionIdAndNodeId", map), (Object)new JSONObject());
    }

    public BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryTaskIdByBusinessId", map);
    }

    public BpmResponseResult queryTaskByBusinessIdAndProcessInsId(String businessId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryTaskByBusinessIdAndProcessInsId", map);
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, boolean isGetRevokeNode, boolean isGetWithGroup, Map<String, Object> lineCondition) {
        TaskQueryNextNodeDto taskQueryNextNodeDto = new TaskQueryNextNodeDto();
        taskQueryNextNodeDto.setTaskId(taskId);
        taskQueryNextNodeDto.setProcessKey(processKey);
        taskQueryNextNodeDto.setIsGetRevokeNode(isGetRevokeNode);
        taskQueryNextNodeDto.setIsGetWithGroup(isGetWithGroup);
        taskQueryNextNodeDto.setLineCondition(JSONObject.toJSONString(lineCondition));
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/queryNextUserTaskWithLineCondition", (Object)taskQueryNextNodeDto);
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("historicTaskId", historicTaskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/withdrawState", map);
    }

    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userId", userId);
        map1.put("historicTaskId", historicTaskId);
        map1.put("map", JSONObject.toJSONString(map));
        map1.put("isSubmit", isSubmit);
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/revokeTask", map1);
    }

    public BpmResponseResult editTaskComment(String taskId, String comment) {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("taskId", taskId);
        map1.put("comment", comment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/editTaskComment", map1);
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("assignees", assignees);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/multiInstanceDelAssignee2", map);
    }

    public ApiResponse<?> isAddParallel(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/isAddParallel", map);
    }

    public ApiResponse<?> isAddCustomNode(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/task/isAddCustomNode", map);
    }

    public BpmResponseResult isTodoTask(String taskId, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("userId", userId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/isTodoTask", map);
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/multiInstanceDelAssignee2", map);
    }

    public BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("processInsId", processInsId);
        map1.put("businessId", businessId);
        map1.put("taskDefinitionKey", taskDefinitionKey);
        map1.put("userId", userId);
        map1.put("assignee", assignee);
        map1.put("isSubmit", isSubmit);
        map1.put("map", JSONObject.toJSONString(map));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/reStartProcess", map1);
    }

    public ApiResponse<?> addCustomNode(String taskId, List<Map<String, Object>> list, String parallel) {
        AddCustomNodeDto addCustomNodeDto = new AddCustomNodeDto();
        addCustomNodeDto.setTaskId(taskId);
        addCustomNodeDto.setList(list);
        addCustomNodeDto.setParallel(parallel);
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/task/addCustomNode", (Object)addCustomNodeDto);
    }

    public BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("level", level);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/updateUserSecurityLevel", map);
    }

    public BpmResponseResult updateStarter(String processInsId, String businessId, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        map.put("userId", userId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/updateStarter", map);
    }

    public BpmResponseResult getExecutionByBusinessKey(String businessId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/getExecutionByBusinessId", params);
    }

    public BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> map) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        params.put("map", JSONObject.toJSONString(map));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/receiveTaskSignal", params);
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/activeTaskCandidates", map);
    }

    public BpmResponseResult receiveTaskSignalByProcessInfo(TaskReceiveDto taskReceiveBean) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/receiveTaskSignalByProcessInfo", (Object)taskReceiveBean);
    }

    public BpmResponseResult preemptTask(PreemptCommonDto preemptCommonBean) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/preemptTask", (Object)preemptCommonBean);
    }

    public BpmResponseResult unPreemptTask(PreemptCommonDto preemptCommonBean) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/unPreemptTask", (Object)preemptCommonBean);
    }

    public BpmResponseResult checkNextNodeAssignee(CheckNextNodeAssigneeDto checkNextNodeAssigneeBean) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/checkNextNodeAssignee", (Object)checkNextNodeAssigneeBean);
    }

    public BpmResponseResult transferTask(TransferDto transferDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/transferTask", (Object)transferDto);
    }

    public BpmResponseResult getTransferProgressInfo(Long transferId) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/getTransferProgressInfo", (Object)transferId);
    }

    public BpmResponseResult queryProcessTaskCount(QueryProcessTaskCountDto queryProcessTaskCountDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/task/queryProcessTaskCount", (Object)queryProcessTaskCountDto);
    }

    public BpmResponseResult getCountAllTotal(String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/getCountAllTotal", map);
    }

    public BpmResponseResult getAllCounts(String userId, String todoConfiguration, String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("todoConfiguration", todoConfiguration);
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/getAllCounts", map);
    }

    public BpmResponseResult delCustomNode(String taskId, String nodeId, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("nodeId", nodeId);
        map.put("userId", userId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/delCustomNode", map);
    }

    public BpmResponseResult queryDelNode(String taskId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/queryDelNode", map);
    }

    public BpmResponseResult taskAvoidSuspicion(String taskId, String userId, String avoidComment) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("taskId", taskId);
        map.put("avoidComment", avoidComment);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/task/taskAvoidSuspicion", map);
    }

    public static final class Api {
        public static final String queryTask = "/bpm/task/queryTask";
        public static final String queryToDoList = "/bpm/task/queryToDoList";
        public static final String queryDoneList = "/bpm/task/queryDoneList";
        public static final String queryAllToDoTaskList = "/bpm/task/queryAllToDoTaskList";
        public static final String queryAllToDoTaskListByBusiness = "/bpm/task/queryAllToDoTaskListByBusiness";
        public static final String queryToDoTaskList = "/bpm/task/queryToDoTaskList";
        public static final String queryToDoTaskListByPage = "/bpm/task/queryToDoTaskListByPage";
        public static final String queryToDoTaskListByBusinessIds = "/bpm/task/queryToDoTaskListByBusinessIds";
        public static final String queryToDoTaskList2 = "/bpm/task/queryToDoTaskList2";
        public static final String queryFinishedTaskList = "/bpm/task/queryFinishedTaskList";
        public static final String queryFinishedTaskListByPage = "/bpm/task/queryFinishedTaskListByPage";
        public static final String queryFinishTaskList2 = "/bpm/task/queryFinishTaskList2";
        public static final String queryUserTaskCount = "/bpm/task/queryUserTaskCount";
        public static final String queryUserTaskCountByNode = "/bpm/task/queryUserTaskCountByNode";
        public static final String claimTask = "/bpm/task/claimTask";
        public static final String unClaimTask = "/bpm/task/unClaimTask";
        public static final String completeTask1 = "/bpm/task/completeTask1";
        public static final String completeTask2 = "/bpm/task/completeTask2";
        public static final String completeTask3 = "/bpm/task/completeTask3";
        public static final String completeTask4 = "/bpm/task/completeTask4";
        public static final String completeTask5 = "/bpm/task/completeTask5";
        public static final String completeTask6 = "/bpm/task/completeTask6";
        public static final String completeTask7 = "/bpm/task/completeTask7";
        public static final String completeTask8 = "/bpm/task/completeTask8";
        public static final String queryRejectComment = "/bpm/task/queryRejectComment";
        public static final String completeLeapTask = "/bpm/task/completeLeapTask";
        public static final String completeLeapTask1 = "/bpm/task/completeLeapTask1";
        public static final String completeLeapTask3 = "/bpm/task/completeLeapTask3";
        public static final String rejectToLastTask3 = "/bpm/task/rejectToLastTask3";
        public static final String rejectToLastTask5 = "/bpm/task/rejectToLastTask5";
        public static final String rejectToFirstTask1 = "/bpm/task/rejectToFirstTask1";
        public static final String rejectToFirstTask3 = "/bpm/task/rejectToFirstTask3";
        public static final String rejectToFirstTask5 = "/bpm/task/rejectToFirstTask5";
        public static final String rejectToAnyTask1 = "/bpm/task/rejectToAnyTask1";
        public static final String rejectToAnyTask2 = "/bpm/task/rejectToAnyTask2";
        public static final String rejectToAnyTask5 = "/bpm/task/rejectToAnyTask5";
        public static final String queryRejectNode = "/bpm/task/queryRejectNode";
        public static final String setTimeoutPeriod = "/bpm/task/setTimeoutPeriod";
        public static final String delegateTask = "/bpm/task/delegateTask";
        public static final String entrustTask = "/bpm/task/entrustTask";
        public static final String entrustTask2 = "/bpm/task/entrustTask2";
        public static final String getRejectNode = "/bpm/task/getRejectNode";
        public static final String entrustTaskByTaskId = "/bpm/task/entrustTaskByTaskId";
        public static final String freeJump = "/bpm/task/freeJump";
        public static final String freeJump2 = "/bpm/task/freeJump2";
        public static final String queryJumpNode = "/bpm/task/queryJumpNode";
        public static final String multiInstanceAddAssignee = "/bpm/task/multiInstanceAddAssignee";
        public static final String queryAssigneeByTaskId = "/bpm/task/queryAssigneeByTaskId";
        public static final String addAssignees = "/bpm/task/addAssignees";
        public static final String taskAddAssignee = "/bpm/task/taskAddAssignee";
        public static final String queryProcessNodeByTaskId = "/bpm/task/queryProcessNodeByTaskId";
        public static final String queryNextAssigneeByTaskIdAndNodeId = "/bpm/task/queryNextAssigneeByTaskIdAndNodeId";
        public static final String queryNextAssigneeWithDto = "/bpm/task/queryNextAssigneeWithDto";
        public static final String queryAllAssignee = "/bpm/task/queryAllAssignee";
        public static final String queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey = "/bpm/task/queryAssigneeByProcessDefinitionKeyAndTaskDefinitionKey";
        public static final String queryHistoryActByTaskId = "/bpm/task/queryHistoryActByTaskId";
        public static final String getProcessDefinitionIdAndNodeId = "/bpm/task/getProcessDefinitionIdAndNodeId";
        public static final String queryTaskIdByBusinessId = "/bpm/task/queryTaskIdByBusinessId";
        public static final String queryTaskByBusinessIdAndProcessInsId = "/bpm/task/queryTaskByBusinessIdAndProcessInsId";
        public static final String queryNextUserTaskWithLineCondition = "/bpm/task/queryNextUserTaskWithLineCondition";
        public static final String withdrawState = "/bpm/task/withdrawState";
        public static final String revokeTask = "/bpm/task/revokeTask";
        public static final String editTaskComment = "/bpm/task/editTaskComment";
        public static final String multiInstanceDelAssignee = "/bpm/task/multiInstanceDelAssignee2";
        public static final String isTodoTask = "/bpm/task/isTodoTask";
        public static final String reStartProcess = "/bpm/task/reStartProcess";
        public static final String updateUserSecurityLevel = "/bpm/task/updateUserSecurityLevel";
        public static final String updateStarter = "/bpm/task/updateStarter";
        public static final String activeTaskCandidates = "/bpm/task/activeTaskCandidates";
        public static final String getExecutionByBusinessId = "/bpm/task/getExecutionByBusinessId";
        public static final String receiveTaskSignalByProcessInfo = "/bpm/task/receiveTaskSignalByProcessInfo";
        public static final String receiveTaskSignal = "/bpm/task/receiveTaskSignal";
        public static final String getComments = "/bpm/task/getComments";
        public static final String preemptTask = "/bpm/task/preemptTask";
        public static final String unPreemptTask = "/bpm/task/unPreemptTask";
        public static final String addCustomNode = "/bpm/task/addCustomNode";
        public static final String isAddParallel = "/bpm/task/isAddParallel";
        public static final String isAddCustomNode = "/bpm/task/isAddCustomNode";
        public static final String checkNextNodeAssignee = "/bpm/task/checkNextNodeAssignee";
        public static final String queryNodeAssigneeAndDeptWithDto = "/bpm/task/queryNodeAssigneeAndDeptWithDto";
        public static final String queryNodeAssigneeListByPageWithDto = "/bpm/task/queryNodeAssigneeListByPageWithDto";
        public static final String transferTask = "/bpm/task/transferTask";
        public static final String getTransferProgressInfo = "/bpm/task/getTransferProgressInfo";
        public static final String queryProcessTaskCount = "/bpm/task/queryProcessTaskCount";
        public static final String getCountAllTotal = "/bpm/task/getCountAllTotal";
        public static final String getAllCounts = "/bpm/task/getAllCounts";
        public static final String delCustomNode = "/bpm/task/delCustomNode";
        public static final String queryDelNode = "/bpm/task/queryDelNode";
        public static final String taskAvoidSuspicion = "/bpm/task/taskAvoidSuspicion";
    }
}

