/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.CountersignNodesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.InstanceGetTraceDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessDefinitionQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessCompleteStatusDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstActivateDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstBatchDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstDeleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstEndDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstFinishedQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessInstSuspendDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStartDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStatusCheckDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.ActivityTaskQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.CommentQueryDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.manage.bpm.flowchart.FlowChartCommonDto;
import com.jxdinfo.hussar.workflow.upgrade.StandardInstanceEngineApiService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class StandardBpmInstanceEngineOpenApiService
implements StandardInstanceEngineApiService {
    public static final String PREFIX = "/bpm/upgrade/instance/";

    public BpmResponseResult startProcessInstance(ProcessStartDto processStartDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", processStartDto.getVersion());
        map.put("userId", processStartDto.getUserId());
        map.put("businessId", processStartDto.getBusinessId());
        map.put("processKey", processStartDto.getProcessKey());
        map.put("variablesJson", JSONObject.toJSONString((Object)processStartDto.getVariables()));
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/startProcessInstance", map);
    }

    public BpmResponseResult endProcess(ProcessInstEndDto processInstEndDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInstEndDto.getProcessInsId());
        map.put("userId", processInstEndDto.getUserId());
        map.put("businessId", processInstEndDto.getBusinessId());
        map.put("taskId", processInstEndDto.getTaskId());
        map.put("reason", processInstEndDto.getReason());
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/upgrade/instance/endProcess", map);
    }

    public BpmResponseResult deleteProcessInstance(ProcessInstDeleteDto processInstDeleteDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processInstDeleteDto.getProcessInsId());
        map.put("businessId", processInstDeleteDto.getBusinessId());
        map.put("isFinish", processInstDeleteDto.getIsFinish());
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/upgrade/instance/deleteProcessInstance", map);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIds(ProcessInstBatchDeleteDto processInstBatchDeleteDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessIdList", processInstBatchDeleteDto.getBusinessIdList());
        map.put("isValidate", processInstBatchDeleteDto.getIsValidate());
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/upgrade/instance/deleteProcessInstanceByBusinessIds", map);
    }

    public BpmResponseResult checkProcessInstByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/checkProcessInstByBusinessId", map);
    }

    public BpmResponseResult queryActivityTask(ActivityTaskQueryDto activityTaskQueryDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessId", activityTaskQueryDto.getBusinessId());
        map.put("processInsId", activityTaskQueryDto.getProcessInsId());
        map.put("type", activityTaskQueryDto.getType());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryActivityTask", map);
    }

    public BpmResponseResult queryAllComment(CommentQueryDto commentQueryDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", commentQueryDto.getBusinessId());
        map.put("processInsId", commentQueryDto.getProcessInsId());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryAllComment", map);
    }

    public BpmResponseResult queryProcessDefinition(ProcessDefinitionQueryDto processDefinitionQueryDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", processDefinitionQueryDto.getBusinessId());
        map.put("processInsId", processDefinitionQueryDto.getProcessInsId());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryProcessDefinition", map);
    }

    public BpmResponseResult queryProcessByStarter(ProcessQueryByStarterDto processQueryByStarterDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryProcessByStarter", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)processQueryByStarterDto)));
    }

    public BpmResponseResult queryRevokeProcessByStarter(ProcessQueryByStarterDto processQueryByStarterDto) {
        processQueryByStarterDto.setIsRevoke(Boolean.TRUE.booleanValue());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryProcessByStarter", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)processQueryByStarterDto)));
    }

    public BpmResponseResult checkProcessStatus(ProcessStatusCheckDto processStatusCheckDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", processStatusCheckDto.getBusinessId());
        map.put("processInsId", processStatusCheckDto.getProcessInsId());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/checkProcessStatus", map);
    }

    public BpmResponseResult queryAllProcessTrace(InstanceGetTraceDto processTraceQueryDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processTraceQueryDto.getProcessInsId());
        map.put("subProcessKey", processTraceQueryDto.getSubProcessKey());
        map.put("cycleCount", processTraceQueryDto.getCycleCount());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/getAllProcessTrace", map);
    }

    public BpmResponseResult suspendProcessInstance(ProcessInstSuspendDto processInstSuspendDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", processInstSuspendDto.getBusinessId());
        map.put("processInsId", processInstSuspendDto.getProcessInsId());
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/upgrade/instance/suspendProcessInstance", map);
    }

    public BpmResponseResult activateProcessInstance(ProcessInstActivateDto processInstActivateDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInstActivateDto.getProcessInsId());
        map.put("businessId", processInstActivateDto.getBusinessId());
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/upgrade/instance/activateProcessInstance", map);
    }

    public BpmResponseResult queryFinishedProcessInstance(ProcessInstFinishedQueryDto processInstFinishedQueryDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processKey", processInstFinishedQueryDto.getProcessKey());
        map.put("businessId", processInstFinishedQueryDto.getBusinessId());
        map.put("page", processInstFinishedQueryDto.getPage());
        map.put("rows", processInstFinishedQueryDto.getRows());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryFinishedProcessInstance", map);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(ProcessCompleteStatusDto processCompleteStatusDto) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processCompleteStatusDto.getProcessInsId());
        map.put("businessId", processCompleteStatusDto.getBusinessId());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryProcessInstanceCompleteState", map);
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryProcessTrace", map);
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/upgrade/instance/revokeProcess", (Object)processRevokeDto);
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryProcessInstance", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)processDto)));
    }

    public BpmResponseResult queryAllCountersignNodes(CountersignNodesDto countersignNodesBean) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/queryAllCountersignNodes", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)countersignNodesBean)));
    }

    public BpmResponseResult getProcessShowMsg(FlowChartCommonDto flowChartCommonDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/getProcessShowMsg", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)flowChartCommonDto)));
    }

    public BpmResponseResult getProcessHistoryMsg(FlowChartCommonDto flowChartCommonDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/upgrade/instance/getProcessHistoryMsg", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)flowChartCommonDto)));
    }

    public static final class UpgradeApi {
        public static final String CHECK_PROCESS_STATUS_API = "/bpm/upgrade/instance/checkProcessStatus";
        public static final String GET_ALL_PROCESS_TRACE_API = "/bpm/upgrade/instance/getAllProcessTrace";
        public static final String START_PROCESS_INSTANCE_API = "/bpm/upgrade/instance/startProcessInstance";
        public static final String END_PROCESS_API = "/bpm/upgrade/instance/endProcess";
        public static final String DELETE_PROCESS_INSTANCE = "/bpm/upgrade/instance/deleteProcessInstance";
        public static final String DELETE_PROCESS_INSTANCE_BY_BUSINESS_IDS = "/bpm/upgrade/instance/deleteProcessInstanceByBusinessIds";
        public static final String CHECK_PROCESS_INST_BY_BUSINESS_ID = "/bpm/upgrade/instance/checkProcessInstByBusinessId";
        public static final String QUERY_ACTIVITY_TASK = "/bpm/upgrade/instance/queryActivityTask";
        public static final String QUERY_All_COMMENT = "/bpm/upgrade/instance/queryAllComment";
        public static final String QUERY_PROCESS_DEFINITION = "/bpm/upgrade/instance/queryProcessDefinition";
        public static final String QUERY_PROCESS_BY_STARTER = "/bpm/upgrade/instance/queryProcessByStarter";
        public static final String SUSPEND_PROCESS_INSTANCE = "/bpm/upgrade/instance/suspendProcessInstance";
        public static final String ACTIVATE_PROCESS_INSTANCE = "/bpm/upgrade/instance/activateProcessInstance";
        public static final String QUERY_FINISHED_PROCESS_INSTANCE = "/bpm/upgrade/instance/queryFinishedProcessInstance";
        public static final String QUERY_PROCESS_INSTANCE_COMPLETE_STATE = "/bpm/upgrade/instance/queryProcessInstanceCompleteState";
        public static final String QUERY_PROCESS_TRACE = "/bpm/upgrade/instance/queryProcessTrace";
        public static final String REVOKE_PROCESS_API = "/bpm/upgrade/instance/revokeProcess";
        public static final String QUERY_PROCESS_INSTANCE_API = "/bpm/upgrade/instance/queryProcessInstance";
        public static final String QUERY_ALL_COUNTER_SIGN_NODES_API = "/bpm/upgrade/instance/queryAllCountersignNodes";
        public static final String GET_PROCESS_SHOW_MSG = "/bpm/upgrade/instance/getProcessShowMsg";
        public static final String GET_PROCESS_HISTORY_MSG = "/bpm/upgrade/instance/getProcessHistoryMsg";
    }
}

