/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service;

import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.http.deprecated.OldBpmProcessService;
import com.jxdinfo.hussar.workflow.manage.engine.service.DefinitionEngineApiService;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmDefinitionEngineOpenApiService
implements DefinitionEngineApiService {
    @Autowired
    private OldBpmProcessService oldBpmProcessService;

    public BpmResponseResult queryProcessName(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/definition/queryProcessName", map);
    }

    public BpmResponseResult queryProcessDefListOfMainVersion(String processName) {
        return this.oldBpmProcessService.queryProcessDefListOfMainVersion(processName);
    }

    public BpmResponseResult getProcessMainOrNew(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/definition/getProcessMainOrNew", map);
    }

    public BpmResponseResult queryProcessDefList(String processName) {
        return this.oldBpmProcessService.queryProcessDefList(processName);
    }

    public BpmResponseResult getProcessDefList(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/definition/getProcessDefList", map);
    }

    public BpmResponseResult activateProcessDefinitionById(String processDefinitionId) {
        return this.oldBpmProcessService.activateProcessDefinitionById(processDefinitionId);
    }

    public BpmResponseResult activateProcessByKeyAndVersion(String processKey, String version) {
        return this.oldBpmProcessService.activateProcessByKeyAndVersion(processKey, version);
    }

    public BpmResponseResult suspendProcessDefinitionById(String processDefinitionId) {
        return this.oldBpmProcessService.suspendProcessDefinitionById(processDefinitionId);
    }

    public BpmResponseResult suspendProcessByKeyAndVersion(String processKey, String version) {
        return this.oldBpmProcessService.suspendProcessByKeyAndVersion(processKey, version);
    }

    public BpmResponseResult deleteProcessDefinition(String processDefinitionId) {
        return this.oldBpmProcessService.deleteProcessDefinition(processDefinitionId);
    }

    public BpmResponseResult deleteProcessDefinitionByKeyAndVersion(String processKey, String version) {
        return this.oldBpmProcessService.deleteProcessDefinitionByKeyAndVersion(processKey, version);
    }

    public BpmResponseResult queryProcess() {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/definition/queryProcess", null);
    }

    public BpmResponseResult queryProcessLink(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/definition/queryProcessLink", map);
    }

    public BpmResponseResult queryStartFormUrl(String processKey) {
        return this.oldBpmProcessService.queryStartFormUrl(processKey);
    }

    public BpmResponseResult queryAllNodeFormKey(String processKey, String version) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("version", version);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/definition/queryAllNodeFormKey", map);
    }

    public BpmResponseResult queryIsPublish(String processKey) {
        return this.oldBpmProcessService.queryIsPublish(processKey);
    }

    public BpmResponseResult queryNodeInfoByProcessKeyAndVersion(String processKey, String version) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("version", version);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/definition/queryNodeInfoByProcessKeyAndVersion", map);
    }

    public BpmResponseResult queryAllProcess(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/definition/queryAllProcess", map);
    }

    public static final class Api {
        public static final String queryProcessNameApi = "/bpm/definition/queryProcessName";
        public static final String queryProcessDefListOfMainVersionApi = "/bpm/definition/queryProcessDefListOfMainVersion";
        public static final String queryProcessDefListApi = "/bpm/definition/queryProcessDefList";
        public static final String activateProcessDefinitionByIdApi = "/bpm/definition/activateProcessDefinitionById";
        public static final String suspendProcessDefinitionByIdApi = "/bpm/definition/suspendProcessDefinitionById";
        public static final String deleteProcessDefinitionApi = "/bpm/definition/deleteProcessDefinition";
        public static final String queryProcessApi = "/bpm/definition/queryProcess";
        public static final String queryProcessLinkApi = "/bpm/definition/queryProcessLink";
        public static final String queryStartFormUrlApi = "/bpm/definition/queryStartFormUrl";
        public static final String queryIsPublishApi = "/bpm/definition/queryIsPublish";
        public static final String getProcessMainOrNew = "/bpm/definition/getProcessMainOrNew";
        public static final String getProcessDefList = "/bpm/definition/getProcessDefList";
        public static final String activateProcessByKeyAndVersion = "/bpm/definition/activateProcessByKeyAndVersion";
        public static final String suspendProcessByKeyAndVersion = "/bpm/definition/suspendProcessByKeyAndVersion";
        public static final String deleteProcessDefinitionByKeyAndVersion = "/bpm/definition/deleteProcessDefinitionByKeyAndVersion";
        public static final String queryAllNodeFormKey = "/bpm/definition/queryAllNodeFormKey";
        public static final String judgeProcDefKey = "/bpm/definition/judgeProcDefKey";
        public static final String queryNodeInfoByProcessKeyAndVersion = "/bpm/definition/queryNodeInfoByProcessKeyAndVersion";
        public static final String queryAllProcess = "/bpm/definition/queryAllProcess";
    }
}

