/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExternalProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.http.common.ResultUtil;
import com.jxdinfo.hussar.workflow.http.deprecated.OldBpmProcessService;
import com.jxdinfo.hussar.workflow.manage.engine.service.InstanceEngineApiService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BpmInstanceEngineOpenApiService
implements InstanceEngineApiService {
    @Autowired
    private OldBpmProcessService oldBpmProcessService;

    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        return this.oldBpmProcessService.startProcessInstanceById(processDefinitionId, userId, businessId, variables);
    }

    public BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, Map<String, Object> variables) {
        return this.oldBpmProcessService.startProcessInstanceByKey(processKey, userId, businessId, variables);
    }

    public BpmResponseResult startAndCompleteProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, Map<String, Object> variables) {
        return this.oldBpmProcessService.startAndCompleteProcessInstanceByKey(processDefinitionKey, userId, businessKey, variables);
    }

    public BpmResponseResult startProcessInstanceByKeyWithProcessCode(String processKey, String userId, String businessId, String version, Map<String, Object> variables, String processCode) {
        return this.oldBpmProcessService.startProcessInstanceByKeyWithProcessCode(processKey, userId, businessId, version, variables, processCode);
    }

    public BpmResponseResult checkProcessInstByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/checkProcessInstByBusinessId", map);
    }

    public ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return ResultUtil.convertApiResponse3((Object)HttpClientUtil.httpGetApiHandler((String)"/bpm/instance/validateEditAuthority", map), (Object)new JSONObject());
    }

    public BpmResponseResult validateDeleteByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/validateDeleteByBusinessId", map);
    }

    public BpmResponseResult queryAllComment(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryAllComment", map);
    }

    public BpmResponseResult externalMultiInstanceAddAssignee(String processInstanceId, Map<String, Object> variable) {
        ExternalProcessDto externalProcessDto = new ExternalProcessDto();
        externalProcessDto.setProcessInstanceId(processInstanceId);
        externalProcessDto.setCallActivityInfoList((List)variable.get("call_activity_info"));
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/externalMultiInstanceAddAssignee", (Object)externalProcessDto);
    }

    public BpmResponseResult externalMultiInstanceAddAssigneeByBussinessId(String bussinessId, Map<String, Object> variable) {
        ExternalProcessDto externalProcessDto = new ExternalProcessDto();
        externalProcessDto.setBussinessId(bussinessId);
        externalProcessDto.setCallActivityInfoList((List)variable.get("call_activity_info"));
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/externalMultiInstanceAddAssigneeByBussinessId", (Object)externalProcessDto);
    }

    public BpmResponseResult externalMultiInstanceDelAssignee(List<String> externalProcessInstanceIds, String instanceId, String userId, String reason) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("externalProcessInstanceId", externalProcessInstanceIds);
        map.put("instanceId", instanceId);
        map.put("userId", userId);
        map.put("reason", reason);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/externalMultiInstanceDelAssignee", map);
    }

    public BpmResponseResult externalMultiInstanceDelAssigneeByBussinessId(List<String> externalBussinessIds, String bussinessId, String userId, String reason) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("externalBussinessIds", externalBussinessIds);
        map.put("bussinessId", bussinessId);
        map.put("userId", userId);
        map.put("reason", reason);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/externalMultiInstanceDelAssigneeByBussinessId", map);
    }

    public BpmResponseResult getSubprocessStarter(List<String> bussinessIds) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bussinessIds", bussinessIds);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/getSubprocessStarter", map);
    }

    public BpmResponseResult suspendProcessInstanceById(String processInsId) {
        return this.oldBpmProcessService.suspendProcessInstanceById(processInsId);
    }

    public BpmResponseResult suspendProcessInstanceByBusinessId(String businessId) {
        return this.oldBpmProcessService.suspendProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult activateProcessInstanceById(String processInsId) {
        return this.oldBpmProcessService.activateProcessInstanceById(processInsId);
    }

    public BpmResponseResult activateProcessInstanceByBusinessId(String businessId) {
        return this.oldBpmProcessService.activateProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        return this.oldBpmProcessService.deleteProcessInstance(processInsId, reason);
    }

    public BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        return this.oldBpmProcessService.deleteFinishedProcessInstance(processInsId);
    }

    public BpmResponseResult deleteFinishProcessInstanceByBusinessId(String businessId) {
        return this.oldBpmProcessService.deleteFinishProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult activateProcessInstance(String processInsId, String businessId) {
        if (!StringUtils.isEmpty((Object)processInsId)) {
            return this.oldBpmProcessService.activateProcessInstanceById(processInsId);
        }
        return this.oldBpmProcessService.activateProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult deleteProcessInstance(String businessId, String processInsId, String reason) {
        if (!StringUtils.isEmpty((Object)businessId)) {
            return this.oldBpmProcessService.deleteProcessInstanceByBusinessId(businessId);
        }
        return this.oldBpmProcessService.deleteProcessInstance(processInsId, reason);
    }

    public BpmResponseResult deleteFinishProcessInstance(String processInsId, String businessId) {
        if (!StringUtils.isEmpty((Object)processInsId)) {
            return this.oldBpmProcessService.deleteFinishedProcessInstance(processInsId);
        }
        return this.oldBpmProcessService.deleteFinishProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIdList(String businessIdList, boolean isValidate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessId", businessIdList);
        map.put("isValidate", isValidate);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteProcessInstanceByBusinessIdList", map);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessId) {
        return this.oldBpmProcessService.deleteProcessInstanceByBusinessId(businessId);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessKeyList(String businessId, boolean isValidate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessId", businessId);
        map.put("isValidate", isValidate);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/deleteProcessInstanceByBusinessIdList", map);
    }

    public BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processKey", processKey);
        map.put("businessId", businessId);
        map.put("page", page);
        map.put("rows", rows);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryFinishedProcessInstance", map);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessInstanceCompleteState", map);
    }

    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessInstanceCompleteStateByBusinessId", map);
    }

    public BpmResponseResult getProcessTrace(String processInsId) {
        return this.oldBpmProcessService.getProcessTrace(processInsId);
    }

    public BpmResponseResult getAllProcessTrace(String processInsId, String subProcessKey, Integer cycleCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processInsId);
        map.put("subProcessKey", subProcessKey);
        map.put("cycleCount", cycleCount);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/getAllProcessTrace", map);
    }

    public BpmResponseResult queryCallActivityTask(String businessId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryCallActivityTask", map);
    }

    public BpmResponseResult queryMainActivityTask(String businessId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryMainActivityTask", map);
    }

    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessId, int page, int size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessKey", businessId);
        map.put("page", page);
        map.put("size", size);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/getAllProcessTraceByBusinessKey", map);
    }

    public BpmResponseResult queryCompletecomment(String businessId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryCompletecomment", map);
    }

    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessDefinitionByInstanceId", map);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        return this.oldBpmProcessService.endProcess(taskId, userId, reason);
    }

    public BpmResponseResult endProcessByBusinessIdOrProcessInsId(String businessId, String processInsId, String userId, String comment) {
        return this.oldBpmProcessService.endProcessByBusinessIdOrProcessInsId(businessId, processInsId, userId, comment);
    }

    public BpmResponseResult queryProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessByStarter", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)processQueryByStarterDto)));
    }

    public BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/instance/revokeProcess", (Object)processRevokeDto);
    }

    public BpmResponseResult queryProcessInstance(ProcessDto processDto) {
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessInstance", (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)processDto)));
    }

    public BpmResponseResult queryAllCountersignNodes(String taskId, String processInsId, String businessId, String processKey, String version) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        map.put("processKey", processKey);
        map.put("taskId", taskId);
        map.put("version", version);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryAllCountersignNodes", map);
    }

    public BpmResponseResult getProcessAllComment(String processInsId, String subProcessKey, Integer cycleCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processInsId);
        map.put("subProcessKey", subProcessKey);
        map.put("cycleCount", cycleCount);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/getProcessAllComment", map);
    }

    public BpmResponseResult queryProcessByRoleId(List<String> roleIds) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("roleIds", roleIds);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryProcessByRoleId", map);
    }

    public BpmResponseResult queryRolesByProcessKey(List<String> processKeys) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("processKeys", processKeys);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/instance/queryRolesByProcessKey", map);
    }

    public static final class Api {
        public static final String startProcessInstanceByIdApi = "/bpm/instance/startProcessInstanceById";
        public static final String startProcessInstanceByKeyApi = "/bpm/instance/startProcessInstanceByKey";
        public static final String startAndCompleteProcessInstanceByKeyApi = "/bpm/instance/startAndCompleteProcessInstanceByKey";
        public static final String startProcessInstanceByKeyWithProcessCodeApi = "/bpm/instance/startProcessInstanceByKeyWithProcessCode";
        public static final String checkProcessInstByBusinessIdApi = "/bpm/instance/checkProcessInstByBusinessId";
        public static final String validateEditAuthorityApi = "/bpm/instance/validateEditAuthority";
        public static final String validateDeleteByBusinessIdApi = "/bpm/instance/validateDeleteByBusinessId";
        public static final String suspendProcessInstanceByIdApi = "/bpm/instance/suspendProcessInstanceById";
        public static final String suspendProcessInstanceByBusinessId = "/bpm/instance/suspendProcessInstanceByBusinessId";
        public static final String activateProcessInstanceByIdApi = "/bpm/instance/activateProcessInstanceById";
        public static final String activateProcessInstanceByBusinessId = "/bpm/instance/activateProcessInstanceByBusinessId";
        public static final String deleteProcessInstanceApi = "/bpm/instance/deleteProcessInstance";
        public static final String deleteFinishedProcessInstanceApi = "/bpm/instance/deleteFinishedProcessInstance";
        public static final String deleteFinishProcessInstanceByBusinessId = "/bpm/instance/deleteFinishProcessInstanceByBusinessId";
        public static final String deleteProcessInstanceByBusinessIdApi = "/bpm/instance/deleteProcessInstanceByBusinessId";
        public static final String deleteProcessInstanceByBusinessIdListApi = "/bpm/instance/deleteProcessInstanceByBusinessIdList";
        public static final String queryFinishedProcessInstanceApi = "/bpm/instance/queryFinishedProcessInstance";
        public static final String queryProcessInstanceCompleteStateApi = "/bpm/instance/queryProcessInstanceCompleteState";
        public static final String queryProcessInstanceCompleteStateByBusinessIdApi = "/bpm/instance/queryProcessInstanceCompleteStateByBusinessId";
        public static final String getProcessTraceApi = "/bpm/instance/getProcessTrace";
        public static final String queryCallActivityTaskApi = "/bpm/instance/queryCallActivityTask";
        public static final String queryMainActivityTaskApi = "/bpm/instance/queryMainActivityTask";
        public static final String getAllProcessTraceByBusinessIdApi = "/bpm/instance/getAllProcessTraceByBusinessId";
        public static final String queryProcessDefinitionByInstanceIdApi = "/bpm/instance/queryProcessDefinitionByInstanceId";
        public static final String getProcessAllCommentApi = "/bpm/instance/getProcessAllComment";
        public static final String queryProcessByRoleIdApi = "/bpm/instance/queryProcessByRoleId";
        public static final String queryRolesByProcessKeyApi = "/bpm/instance/queryRolesByProcessKey";
        public static final String endProcessApi = "/bpm/instance/endProcess";
        public static final String endProcessByBusinessIdOrProcessInsId = "/bpm/instance/endProcessByBusinessIdOrProcessInsId";
        public static final String queryCompletecommentApi = "/bpm/instance/queryCompletecomment";
        public static final String getAllProcessTraceApi = "/bpm/instance/getAllProcessTrace";
        public static final String queryProcessByStarterApi = "/bpm/instance/queryProcessByStarter";
        public static final String revokeProcessApi = "/bpm/instance/revokeProcess";
        public static final String queryProcessInstanceApi = "/bpm/instance/queryProcessInstance";
        public static final String queryAllCountersignNodesApi = "/bpm/instance/queryAllCountersignNodes";
        public static final String queryAllCommentApi = "/bpm/instance/queryAllComment";
        public static final String externalMultiInstanceAddAssigneeApi = "/bpm/instance/externalMultiInstanceAddAssignee";
        public static final String externalMultiInstanceAddAssigneeByBussinessIdApi = "/bpm/instance/externalMultiInstanceAddAssigneeByBussinessId";
        public static final String externalMultiInstanceDelAssigneeApi = "/bpm/instance/externalMultiInstanceDelAssignee";
        public static final String externalMultiInstanceDelAssigneeByBussinessIdApi = "/bpm/instance/externalMultiInstanceDelAssigneeByBussinessId";
        public static final String getSubprocessStarterApi = "/bpm/instance/getSubprocessStarter";
        public static final String getAllProcessTraceByBusinessKey = "/bpm/instance/getAllProcessTraceByBusinessKey";
    }
}

