/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.service;

import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ReTransferTaskDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveBatchEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.SaveEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustAddDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.entrust.EntrustUpdateDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.http.deprecated.OldBpmProcessService;
import com.jxdinfo.hussar.workflow.manage.engine.service.SysActEntrustApiService;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BpmEntrustOpenApiService
implements SysActEntrustApiService {
    @Autowired
    private OldBpmProcessService oldBpmProcessService;

    public BpmResponseResult list(EntrustQueryDto entrustQueryDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", entrustQueryDto.getUserId());
        map.put("processKey", entrustQueryDto.getProcessKey());
        map.put("state", entrustQueryDto.getState());
        map.put("startTime", entrustQueryDto.getStartTime());
        map.put("endTime", entrustQueryDto.getEndTime());
        map.put("page", entrustQueryDto.getPage());
        map.put("size", entrustQueryDto.getSize());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/sysActEntrust/list", map);
    }

    public BpmResponseResult add(EntrustAddDto entrustAddDto) {
        if (StringUtils.isEmpty((Object)entrustAddDto.getTaskDefinitionKey())) {
            return this.oldBpmProcessService.add(entrustAddDto.getProcessKey(), entrustAddDto.getMandator(), entrustAddDto.getMandatary(), entrustAddDto.getState(), entrustAddDto.getStartTime(), entrustAddDto.getEndTime(), entrustAddDto.getIsTransferTask(), entrustAddDto.getMessageType());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mandatary", entrustAddDto.getMandatary());
        map.put("mandator", entrustAddDto.getMandator());
        map.put("processKey", entrustAddDto.getProcessKey());
        map.put("state", entrustAddDto.getState());
        map.put("startTime", entrustAddDto.getStartTime());
        map.put("endTime", entrustAddDto.getEndTime());
        map.put("isTransferTask", entrustAddDto.getIsTransferTask());
        map.put("messageType", entrustAddDto.getMessageType());
        map.put("taskDefinitionKey", entrustAddDto.getTaskDefinitionKey());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/sysActEntrust/addTaskEntrust", map);
    }

    public BpmResponseResult addBatch(SaveBatchEntrustDto entrustBatchAddDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mandatary", entrustBatchAddDto.getMandatary());
        map.put("mandator", entrustBatchAddDto.getMandator());
        map.put("processKey", String.join((CharSequence)",", entrustBatchAddDto.getProcessKey()));
        map.put("state", entrustBatchAddDto.getState());
        map.put("startTime", entrustBatchAddDto.getStartTime());
        map.put("endTime", entrustBatchAddDto.getEndTime());
        map.put("isTransferTask", entrustBatchAddDto.getIsTransferTask());
        map.put("messageType", entrustBatchAddDto.getMessageType());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/sysActEntrust/addBatch", map);
    }

    public BpmResponseResult delete(String tEntrustId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tEntrustId", tEntrustId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/sysActEntrust/delete", map);
    }

    public BpmResponseResult update(EntrustUpdateDto entrustUpdateDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mandatary", entrustUpdateDto.getMandatary());
        map.put("id", entrustUpdateDto.getId());
        map.put("startTime", entrustUpdateDto.getStartTime());
        map.put("endTime", entrustUpdateDto.getEndTime());
        map.put("messageType", entrustUpdateDto.getMessageType());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/sysActEntrust/update", map);
    }

    public BpmResponseResult detail(String tEntrustId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tEntrustId", tEntrustId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/sysActEntrust/detail", map);
    }

    public BpmResponseResult updateState(String tEntrustId, String state) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tEntrustId", tEntrustId);
        map.put("state", state);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/sysActEntrust/updateState", map);
    }

    public BpmResponseResult queryCommissionedInfo(EntrustQueryDto entrustQueryDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", entrustQueryDto.getUserId());
        map.put("processKey", entrustQueryDto.getProcessKey());
        map.put("startTime", entrustQueryDto.getStartTime());
        map.put("endTime", entrustQueryDto.getEndTime());
        map.put("page", entrustQueryDto.getPage());
        map.put("size", entrustQueryDto.getSize());
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/sysActEntrust/queryCommissionedInfo", map);
    }

    public BpmResponseResult reTransferTask(ReTransferTaskDto reTransferTaskDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/sysActEntrust/reTransferTask", (Object)reTransferTaskDto);
    }

    public BpmResponseResult addBatchEntrust(SaveEntrustDto saveEntrustDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/sysActEntrust/addBatchEntrust", (Object)saveEntrustDto);
    }

    public static final class Api {
        public static final String list = "/bpm/sysActEntrust/list";
        public static final String add = "/bpm/sysActEntrust/add";
        public static final String addTaskEntrust = "/bpm/sysActEntrust/addTaskEntrust";
        public static final String addBatch = "/bpm/sysActEntrust/addBatch";
        public static final String delete = "/bpm/sysActEntrust/delete";
        public static final String update = "/bpm/sysActEntrust/update";
        public static final String detail = "/bpm/sysActEntrust/detail";
        public static final String updateState = "/bpm/sysActEntrust/updateState";
        public static final String queryCommissionedInfo = "/bpm/sysActEntrust/queryCommissionedInfo";
        public static final String reTransferTask = "/bpm/sysActEntrust/reTransferTask";
        public static final String addBatchEntrust = "/bpm/sysActEntrust/addBatchEntrust";
    }
}

