/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(GetTokenUtil.class);
    private static final String CLIENT_TOKEN_API = "/oauth2/client_token";
    private static final Properties PROPERTIES = new Properties();
    private static final String T_CODE = "tcode";
    private static final String SERVER = "server";
    private static final ConcurrentHashMap<String, HashMap<String, Object>> TOKEN_CACHE;

    public static void removeTokenCache() {
        TOKEN_CACHE.remove(PROPERTIES.getProperty("scope"));
    }

    private static HashMap<String, Object> buildTokenRequestParams(String scope) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("grant_type", "client_credentials");
        params.put("scope", scope);
        return params;
    }

    public static String getServer() {
        return PROPERTIES.getProperty(SERVER);
    }

    public static String getTCode() {
        return PROPERTIES.getProperty(T_CODE);
    }

    public static String getToken() {
        String server = PROPERTIES.getProperty(SERVER);
        String scope = PROPERTIES.getProperty("scope");
        String clientId = PROPERTIES.getProperty("clientId");
        String clientSecret = PROPERTIES.getProperty("clientSecret");
        String tcode = PROPERTIES.getProperty(T_CODE);
        String token = GetTokenUtil.getIfValidCache(scope);
        return token != null ? token : GetTokenUtil.requestToken(server, scope, clientId, clientSecret, tcode);
    }

    public static int getConnectionTimeOut() {
        String connectionTimeOut = PROPERTIES.getProperty("connectionTimeOut");
        if (HussarUtils.isNotEmpty((Object)connectionTimeOut)) {
            return Integer.parseInt(connectionTimeOut);
        }
        return 50000;
    }

    public static int getReadTimeOut() {
        String readTimeOut = PROPERTIES.getProperty("readTimeOut");
        if (HussarUtils.isNotEmpty((Object)readTimeOut)) {
            return Integer.parseInt(readTimeOut);
        }
        return 50000;
    }

    public static String getClientId() {
        return PROPERTIES.getProperty("clientId");
    }

    private static String getIfValidCache(String cacheKey) {
        String token = null;
        HashMap<String, Object> cacheToken = TOKEN_CACHE.get(cacheKey);
        if (cacheToken != null) {
            String validTime = (String)cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            if (validTime != null && timeInMillis < Long.parseLong(validTime) - 60L) {
                token = (String)cacheToken.get("client-token");
            }
        }
        return token;
    }

    private static synchronized String requestToken(String server, String scope, String clientId, String clientSecret, String tcode) {
        String token = GetTokenUtil.getIfValidCache(scope);
        if (token != null) {
            return token;
        }
        logger.info("requestToken\u65b9\u6cd5\u4e2d\u4e8c\u6b21\u5224\u65ad token\u4e3a\u7a7a\uff0c\u9700\u8981\u91cd\u65b0\u83b7\u53d6");
        HashMap<String, String> headerMap = new HashMap<String, String>(4);
        headerMap.put("client-id", clientId);
        headerMap.put("client-secret", clientSecret);
        headerMap.put(T_CODE, tcode);
        HashMap<String, Object> params = GetTokenUtil.buildTokenRequestParams(scope);
        StringBuilder param = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (param.toString().isEmpty()) {
                    param.append(entry.getKey()).append("=").append(entry.getValue());
                    continue;
                }
                param.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        server = server + CLIENT_TOKEN_API;
        server = param.toString().isEmpty() ? server : server + "?" + param;
        String result = HttpClientUtil.httpPost(server, headerMap);
        if (result == null || "".equals(result)) {
            throw new RuntimeException("\u83b7\u53d6token\u5f02\u5e38: \u54cd\u5e94\u4e3a\u7a7a url: " + server);
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        String data = jsonObject.getString("data");
        HashMap cacheToken = (HashMap)JSON.parseObject((String)data, HashMap.class);
        token = (String)cacheToken.get("client-token");
        if (token == null || "".equals(token)) {
            throw new RuntimeException("\u83b7\u53d6token\u5f02\u5e38: " + jsonObject.getString("msg"));
        }
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(cacheToken.get("expires-in").toString()));
        cacheToken.put("validTime", timeInMillis);
        TOKEN_CACHE.put(scope, cacheToken);
        return token;
    }

    static {
        InputStream is = null;
        try {
            is = GetTokenUtil.class.getResourceAsStream("/bpm_open.setting");
            PROPERTIES.load(is);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        TOKEN_CACHE = new ConcurrentHashMap(16);
    }
}

