/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.http.common.GetTokenUtil;
import io.seata.core.context.RootContext;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Integer MAX_REPEAT = 5;
    private static Integer REPEAT_COUNT = 0;

    public static HashMap<String, String> buildHeaderMap(String clientToken, String tcode) {
        HashMap<String, String> headerMap = new HashMap<String, String>(4);
        headerMap.put("Authorization", clientToken);
        headerMap.put("tcode", tcode);
        headerMap.put("client-id", GetTokenUtil.getClientId());
        headerMap.put("TX_XID", RootContext.getXID());
        return headerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, Map<String, String> headers) {
        String content = null;
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        if (!StringUtils.isEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        CloseableHttpResponse httpResponse = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(50000).setConnectionRequestTimeout(10000).setSocketTimeout(50000).build();
            httpPost.setConfig(requestConfig);
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            logger.error("{}\u8bf7\u6c42\u5931\u8d25\uff01", (Object)url, (Object)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    logger.error("{}\u8bf7\u6c42\u5931\u8d25\uff01", (Object)url, (Object)e);
                }
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, String params, Map<String, String> headers) {
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-type", "application/json");
        if (!StringUtils.isEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (params != null) {
            StringEntity stringEntity = new StringEntity(params, CHARSET);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        String content = null;
        CloseableHttpResponse httpResponse = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(50000).setConnectionRequestTimeout(10000).setSocketTimeout(50000).build();
            httpPost.setConfig(requestConfig);
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            logger.error("{}\u8bf7\u6c42\u5931\u8d25\uff01", (Object)url, (Object)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    logger.error("{}\u8bf7\u6c42\u5931\u8d25\uff01", (Object)url, (Object)e);
                }
            }
        }
        return content;
    }

    public static BpmResponseResult httpGetBpmHandler(String url, Map<String, Object> params) {
        String clientToken = GetTokenUtil.getToken();
        if (StringUtils.isEmpty((Object)clientToken)) {
            return InstallResult.fail((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        String result = HttpClientUtil.httpGet(GetTokenUtil.getServer() + url, params, HttpClientUtil.buildHeaderMap(clientToken, GetTokenUtil.getTCode()));
        if (result == null) {
            REPEAT_COUNT = 0;
            return InstallResult.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        if ("4100".equals(JSONObject.parseObject((String)result).get((Object)"code").toString()) && (REPEAT_COUNT = Integer.valueOf(REPEAT_COUNT + 1)) < MAX_REPEAT) {
            GetTokenUtil.removeTokenCache();
            return HttpClientUtil.httpGetBpmHandler(url, params);
        }
        REPEAT_COUNT = 0;
        return HttpClientUtil.convertResponse(result);
    }

    public static BpmResponseResult httpPostBpmHandler(String url, Object params) {
        String clientToken = GetTokenUtil.getToken();
        if (StringUtils.isEmpty((Object)clientToken)) {
            return InstallResult.fail((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        String result = HttpClientUtil.httpPost(GetTokenUtil.getServer() + url, params == null ? null : (params instanceof String ? (String)params : JSONObject.toJSONString((Object)params)), HttpClientUtil.buildHeaderMap(clientToken, GetTokenUtil.getTCode()));
        if (result == null) {
            REPEAT_COUNT = 0;
            return InstallResult.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        if ("4100".equals(JSONObject.parseObject((String)result).get((Object)"code").toString()) && (REPEAT_COUNT = Integer.valueOf(REPEAT_COUNT + 1)) < MAX_REPEAT) {
            GetTokenUtil.removeTokenCache();
            return HttpClientUtil.httpPostBpmHandler(url, params);
        }
        REPEAT_COUNT = 0;
        return HttpClientUtil.convertResponse(result);
    }

    public static <T> ApiResponse<T> httpGetApiHandler(String url, Map<String, Object> params) {
        String clientToken = GetTokenUtil.getToken();
        if (StringUtils.isEmpty((Object)clientToken)) {
            return ApiResponse.fail((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        String result = HttpClientUtil.httpGet(GetTokenUtil.getServer() + url, params, HttpClientUtil.buildHeaderMap(clientToken, GetTokenUtil.getTCode()));
        if (result == null) {
            REPEAT_COUNT = 0;
            return ApiResponse.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        if (result.startsWith("[")) {
            ApiResponse apiResponse = ApiResponse.success((Object)JSONArray.parseArray((String)result));
            return apiResponse;
        }
        if ("4100".equals(JSONObject.parseObject((String)result).get((Object)"code").toString()) && (REPEAT_COUNT = Integer.valueOf(REPEAT_COUNT + 1)) < MAX_REPEAT) {
            GetTokenUtil.removeTokenCache();
            return HttpClientUtil.httpGetApiHandler(url, params);
        }
        REPEAT_COUNT = 0;
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        return (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
    }

    public static ApiResponse<?> httpPostApiHandler(String url, Object params) {
        String clientToken = GetTokenUtil.getToken();
        if (StringUtils.isEmpty((Object)clientToken)) {
            return ApiResponse.fail((String)"\u83b7\u53d6token\u5931\u8d25");
        }
        String result = HttpClientUtil.httpPost(GetTokenUtil.getServer() + url, params == null ? null : (params instanceof String ? (String)params : JSONObject.toJSONString((Object)params)), HttpClientUtil.buildHeaderMap(clientToken, GetTokenUtil.getTCode()));
        if (result == null) {
            REPEAT_COUNT = 0;
            return ApiResponse.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        if ("4100".equals(JSONObject.parseObject((String)result).get((Object)"code").toString()) && (REPEAT_COUNT = Integer.valueOf(REPEAT_COUNT + 1)) < MAX_REPEAT) {
            GetTokenUtil.removeTokenCache();
            return HttpClientUtil.httpPostApiHandler(url, params);
        }
        REPEAT_COUNT = 0;
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        return (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
    }

    private static BpmResponseResult convertResponse(String result) {
        if (result == null) {
            return InstallResult.fail((String)"\u8bbf\u95ee\u5931\u8d25\uff01");
        }
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        if (JSONObject.parseObject((String)result).containsKey((Object)"result")) {
            return (BpmResponseResult)JSONObject.parseObject((String)result, BpmResponseResult.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        }
        ApiResponse apiResponse = (ApiResponse)JSONObject.parseObject((String)result, ApiResponse.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        if (apiResponse.isSuccess()) {
            JSONArray jsonArray = new JSONArray();
            Object data = apiResponse.getData();
            if (data instanceof Page) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("data", (Object)((Page)data).getRecords());
                jsonObject.put("count", (Object)((Page)data).getTotal());
                jsonArray.add((Object)jsonObject);
            } else {
                jsonArray.add(data);
            }
            return InstallResult.success((JSONArray)jsonArray);
        }
        return InstallResult.fail((String)apiResponse.getMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url, Map<String, Object> params, Map<String, String> headers) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String content = null;
        CloseableHttpResponse response = null;
        try {
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            if (!StringUtils.isEmpty(params) && params.size() > 0) {
                for (Map.Entry<String, Object> obj : params.entrySet()) {
                    BasicNameValuePair nameValuePair = obj.getValue() instanceof Collection ? new BasicNameValuePair(obj.getKey(), ((Collection)obj.getValue()).stream().map(String::valueOf).collect(Collectors.joining(","))) : (obj.getValue() == null ? new BasicNameValuePair(obj.getKey(), null) : new BasicNameValuePair(obj.getKey(), String.valueOf(obj.getValue())));
                    nameValuePairs.add(nameValuePair);
                }
            }
            URI uri = new URIBuilder(url).setParameters(nameValuePairs).build();
            HttpGet httpGet = new HttpGet(uri);
            if (!StringUtils.isEmpty(headers) && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(50000).setConnectionRequestTimeout(10000).setSocketTimeout(50000).build();
            httpGet.setConfig(requestConfig);
            response = httpclient.execute((HttpUriRequest)httpGet);
            content = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)CHARSET);
        }
        catch (Exception e) {
            logger.error("{}\u8bf7\u6c42\u5931\u8d25\uff01", (Object)url, (Object)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("{}\u8bf7\u6c42\u5931\u8d25\uff01", (Object)url, (Object)e);
                }
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostFormMultipart(String url, File file, Map<String, String> headers) {
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        if (!StringUtils.isEmpty(headers) && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.setCharset(CHARSET);
        entityBuilder.addBinaryBody("file", file);
        httpPost.setEntity(entityBuilder.build());
        String content = null;
        CloseableHttpResponse httpResponse = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(50000).setConnectionRequestTimeout(10000).setSocketTimeout(50000).build();
            httpPost.setConfig(requestConfig);
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (Charset)CHARSET);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    logger.error("\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        }
        return content;
    }
}

